#!/usr/bin/env perl

=pod

=head1 NAME

kaplan.t - unit test for ...

=head1 DESCRIPTION



=cut

# MODULE IMPORTS
########################
# Pragmas
#----------------------#
use 5.10.1;
use strict;
use warnings;
use utf8;

# CPAN/Core Imports
#----------------------#
use Capture::Tiny qw(:all);
use Carp qw(verbose carp confess croak);
use Const::Fast;
use DateTime;
use File::HomeDir;
use Path::Tiny;
use Sub::Override;
use Test::Most;
use Try::Tiny;

# VARIABLES/CONSTANTS
########################
const my $DEBUG                 => $ENV{DEBUG} // 1;
const my $TEST                  => $ENV{TEST} // 1;

const my $ROBOTS_TXT            => <<'TXT';
User-agent: *
Allow: /WorkArea/FrameworkUI/js/jQuery/ektron-jquery-1.7.2.js
Allow: /WorkArea/FrameworkUI/js/Ektron/Ektron.js
Allow: /WorkArea/java/webkitFix.js
Allow: /WorkArea/FrameworkUI/css/ektron.stylesheet.ashx*
Disallow: /cmslogin.aspx
Disallow: /utils/
Disallow: /system/
Disallow: /fprep/
Disallow: /Layouts/
Disallow: /UploadedFiles/gao*
Disallow: /UploadedFiles\gao\*
Disallow: \UploadedFiles\gao\*
Disallow: /search-results.aspx*
Disallow: /search/*
Disallow: /virtualadvisor/*
Disallow: /WorkArea/Test Pages/*
Sitemap: http://www.kaplanuniversity.edu/sitemap.xml
TXT

# RUNTIME CONFIGURATION
########################
BEGIN {
    use_ok('CrawlerCommons::RobotRulesParser');
}

# SM Imports
########################

# BODY
########################
# Setup
#----------------------#
try {
    my $parser = CrawlerCommons::RobotRulesParser->new;
    my $robot_rules =
      $parser->parse_content(
      "www.kaplanuniversity.edu", $ROBOTS_TXT, "text/plain", 'SearchmetricsBot'
      );
    is($robot_rules->is_allowed("https://www.kaplanuniversity.edu/UploadedFiles/gar"), 1);
    is($robot_rules->is_allowed("https://www.kaplanuniversity.edu/UploadedFiles/gao"), 0);
    is($robot_rules->is_allowed("https://www.kaplanuniversity.edu/UploadedFiles/gaO"), 1);
}
catch {
    say "Testing ended unexpectedly: $_";
};

done_testing;

# SUBROUTINES
########################
#-----------------------------------------------------------------------------#
#-----------------------------------------------------------------------------#
