=begin comment

Web API Swagger specification

No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)

OpenAPI spec version: 1.0

Generated by: https://github.com/swagger-api/swagger-codegen.git

=end comment

=cut

#
# NOTE: This class is auto generated by the swagger code generator program. 
# Do not edit the class manually.
# Ref: https://github.com/swagger-api/swagger-codegen
#
package AsposeCellsCloud::CellsChartsApi;

require 5.6.0;
use strict;
use warnings;
use utf8; 
use Exporter;
use Carp qw( croak );
use Log::Any qw($log);

use AsposeCellsCloud::ApiClient;

use base "Class::Data::Inheritable";

__PACKAGE__->mk_classdata('method_documentation' => {});

sub new {
    my $class = shift;
    my $api_client;

    if ($_[0] && ref $_[0] && ref $_[0] eq 'AsposeCellsCloud::ApiClient' ) {
        $api_client = $_[0];
    } else {
        $api_client = AsposeCellsCloud::ApiClient->new(@_);
    }

    bless { api_client => $api_client }, $class;

}


#
# cells_charts_delete_worksheet_chart_legend
#
# Hide legend in chart
# 
# @param string $name Workbook name. (required)
# @param string $sheet_name Worksheet name. (required)
# @param int $chart_index The chart index. (required)
# @param string $folder The workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'Worksheet name.',
        required => '1',
    },
    'chart_index' => {
        data_type => 'int',
        description => 'The chart index.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'The workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_charts_delete_worksheet_chart_legend' } = { 
    	summary => 'Hide legend in chart',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_charts_delete_worksheet_chart_legend {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_charts_delete_worksheet_chart_legend");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_charts_delete_worksheet_chart_legend");
    }

    # verify the required parameter 'chart_index' is set
    unless (exists $args{'chart_index'}) {
      croak("Missing the required parameter 'chart_index' when calling cells_charts_delete_worksheet_chart_legend");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/charts/{chartIndex}/legend';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'chart_index'}) {
        my $_base_variable = "{" . "chartIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'chart_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_charts_delete_worksheet_chart_title
#
# Hide title in chart
# 
# @param string $name Workbook name. (required)
# @param string $sheet_name Worksheet name. (required)
# @param int $chart_index The chart index. (required)
# @param string $folder The workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'Worksheet name.',
        required => '1',
    },
    'chart_index' => {
        data_type => 'int',
        description => 'The chart index.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'The workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_charts_delete_worksheet_chart_title' } = { 
    	summary => 'Hide title in chart',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_charts_delete_worksheet_chart_title {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_charts_delete_worksheet_chart_title");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_charts_delete_worksheet_chart_title");
    }

    # verify the required parameter 'chart_index' is set
    unless (exists $args{'chart_index'}) {
      croak("Missing the required parameter 'chart_index' when calling cells_charts_delete_worksheet_chart_title");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/charts/{chartIndex}/title';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'chart_index'}) {
        my $_base_variable = "{" . "chartIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'chart_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_charts_delete_worksheet_clear_charts
#
# Clear the charts.
# 
# @param string $name Workbook name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param string $folder The workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'The workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_charts_delete_worksheet_clear_charts' } = { 
    	summary => 'Clear the charts.',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_charts_delete_worksheet_clear_charts {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_charts_delete_worksheet_clear_charts");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_charts_delete_worksheet_clear_charts");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/charts';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_charts_delete_worksheet_delete_chart
#
# Delete worksheet chart by index.
# 
# @param string $name Workbook name. (required)
# @param string $sheet_name Worksheet name. (required)
# @param int $chart_index The chart index. (required)
# @param string $folder The workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'Worksheet name.',
        required => '1',
    },
    'chart_index' => {
        data_type => 'int',
        description => 'The chart index.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'The workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_charts_delete_worksheet_delete_chart' } = { 
    	summary => 'Delete worksheet chart by index.',
        params => $params,
        returns => 'ChartsResponse',
        };
}
# @return ChartsResponse
#
sub cells_charts_delete_worksheet_delete_chart {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_charts_delete_worksheet_delete_chart");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_charts_delete_worksheet_delete_chart");
    }

    # verify the required parameter 'chart_index' is set
    unless (exists $args{'chart_index'}) {
      croak("Missing the required parameter 'chart_index' when calling cells_charts_delete_worksheet_delete_chart");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/charts/{chartIndex}';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'chart_index'}) {
        my $_base_variable = "{" . "chartIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'chart_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('ChartsResponse', $response);
    return $_response_object;
}

#
# cells_charts_get_worksheet_chart
#
# Get chart info.
# 
# @param string $name Document name. (required)
# @param string $sheet_name Worksheet name. (required)
# @param int $chart_number The chart number. (required)
# @param string $format The exported file format. (optional)
# @param string $folder The document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'Worksheet name.',
        required => '1',
    },
    'chart_number' => {
        data_type => 'int',
        description => 'The chart number.',
        required => '1',
    },
    'format' => {
        data_type => 'string',
        description => 'The exported file format.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'The document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_charts_get_worksheet_chart' } = { 
    	summary => 'Get chart info.',
        params => $params,
        returns => 'string',
        };
}
# @return string
#
sub cells_charts_get_worksheet_chart {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_charts_get_worksheet_chart");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_charts_get_worksheet_chart");
    }

    # verify the required parameter 'chart_number' is set
    unless (exists $args{'chart_number'}) {
      croak("Missing the required parameter 'chart_number' when calling cells_charts_get_worksheet_chart");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/charts/{chartNumber}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'format'}) {
        $query_params->{'format'} = $self->{api_client}->to_query_value($args{'format'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'chart_number'}) {
        my $_base_variable = "{" . "chartNumber" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'chart_number'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('string', $response);
    return $_response_object;
}

#
# cells_charts_get_worksheet_chart_legend
#
# Get chart legend
# 
# @param string $name Workbook name. (required)
# @param string $sheet_name Worksheet name. (required)
# @param int $chart_index The chart index. (required)
# @param string $folder The workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'Worksheet name.',
        required => '1',
    },
    'chart_index' => {
        data_type => 'int',
        description => 'The chart index.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'The workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_charts_get_worksheet_chart_legend' } = { 
    	summary => 'Get chart legend',
        params => $params,
        returns => 'LegendResponse',
        };
}
# @return LegendResponse
#
sub cells_charts_get_worksheet_chart_legend {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_charts_get_worksheet_chart_legend");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_charts_get_worksheet_chart_legend");
    }

    # verify the required parameter 'chart_index' is set
    unless (exists $args{'chart_index'}) {
      croak("Missing the required parameter 'chart_index' when calling cells_charts_get_worksheet_chart_legend");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/charts/{chartIndex}/legend';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'chart_index'}) {
        my $_base_variable = "{" . "chartIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'chart_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('LegendResponse', $response);
    return $_response_object;
}

#
# cells_charts_get_worksheet_chart_title
#
# Get chart title
# 
# @param string $name Workbook name. (required)
# @param string $sheet_name Worksheet name. (required)
# @param int $chart_index The chart index. (required)
# @param string $folder The workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'Worksheet name.',
        required => '1',
    },
    'chart_index' => {
        data_type => 'int',
        description => 'The chart index.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'The workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_charts_get_worksheet_chart_title' } = { 
    	summary => 'Get chart title',
        params => $params,
        returns => 'TitleResponse',
        };
}
# @return TitleResponse
#
sub cells_charts_get_worksheet_chart_title {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_charts_get_worksheet_chart_title");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_charts_get_worksheet_chart_title");
    }

    # verify the required parameter 'chart_index' is set
    unless (exists $args{'chart_index'}) {
      croak("Missing the required parameter 'chart_index' when calling cells_charts_get_worksheet_chart_title");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/charts/{chartIndex}/title';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'chart_index'}) {
        my $_base_variable = "{" . "chartIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'chart_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('TitleResponse', $response);
    return $_response_object;
}

#
# cells_charts_get_worksheet_charts
#
# Get worksheet charts info.
# 
# @param string $name Document name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param string $folder Document&#39;s folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document&#39;s folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_charts_get_worksheet_charts' } = { 
    	summary => 'Get worksheet charts info.',
        params => $params,
        returns => 'ChartsResponse',
        };
}
# @return ChartsResponse
#
sub cells_charts_get_worksheet_charts {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_charts_get_worksheet_charts");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_charts_get_worksheet_charts");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/charts';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('ChartsResponse', $response);
    return $_response_object;
}

#
# cells_charts_post_worksheet_chart
#
# Update chart propreties
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param int $chart_index  (required)
# @param Chart $chart  (optional)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'chart_index' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'chart' => {
        data_type => 'Chart',
        description => '',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_charts_post_worksheet_chart' } = { 
    	summary => 'Update chart propreties',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_charts_post_worksheet_chart {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_charts_post_worksheet_chart");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_charts_post_worksheet_chart");
    }

    # verify the required parameter 'chart_index' is set
    unless (exists $args{'chart_index'}) {
      croak("Missing the required parameter 'chart_index' when calling cells_charts_post_worksheet_chart");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/charts/{chartIndex}';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'chart_index'}) {
        my $_base_variable = "{" . "chartIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'chart_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # body params
    if ( exists $args{'chart'}) {
        $_body_data = $args{'chart'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_charts_post_worksheet_chart_legend
#
# Update chart legend
# 
# @param string $name Workbook name. (required)
# @param string $sheet_name Worksheet name. (required)
# @param int $chart_index The chart index. (required)
# @param Legend $legend  (optional)
# @param string $folder The workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'Worksheet name.',
        required => '1',
    },
    'chart_index' => {
        data_type => 'int',
        description => 'The chart index.',
        required => '1',
    },
    'legend' => {
        data_type => 'Legend',
        description => '',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'The workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_charts_post_worksheet_chart_legend' } = { 
    	summary => 'Update chart legend',
        params => $params,
        returns => 'LegendResponse',
        };
}
# @return LegendResponse
#
sub cells_charts_post_worksheet_chart_legend {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_charts_post_worksheet_chart_legend");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_charts_post_worksheet_chart_legend");
    }

    # verify the required parameter 'chart_index' is set
    unless (exists $args{'chart_index'}) {
      croak("Missing the required parameter 'chart_index' when calling cells_charts_post_worksheet_chart_legend");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/charts/{chartIndex}/legend';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'chart_index'}) {
        my $_base_variable = "{" . "chartIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'chart_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # body params
    if ( exists $args{'legend'}) {
        $_body_data = $args{'legend'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('LegendResponse', $response);
    return $_response_object;
}

#
# cells_charts_post_worksheet_chart_title
#
# Update chart title
# 
# @param string $name Workbook name. (required)
# @param string $sheet_name Worksheet name. (required)
# @param int $chart_index The chart index. (required)
# @param Title $title Chart title (optional)
# @param string $folder The workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'Worksheet name.',
        required => '1',
    },
    'chart_index' => {
        data_type => 'int',
        description => 'The chart index.',
        required => '1',
    },
    'title' => {
        data_type => 'Title',
        description => 'Chart title',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'The workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_charts_post_worksheet_chart_title' } = { 
    	summary => 'Update chart title',
        params => $params,
        returns => 'TitleResponse',
        };
}
# @return TitleResponse
#
sub cells_charts_post_worksheet_chart_title {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_charts_post_worksheet_chart_title");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_charts_post_worksheet_chart_title");
    }

    # verify the required parameter 'chart_index' is set
    unless (exists $args{'chart_index'}) {
      croak("Missing the required parameter 'chart_index' when calling cells_charts_post_worksheet_chart_title");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/charts/{chartIndex}/title';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'chart_index'}) {
        my $_base_variable = "{" . "chartIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'chart_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # body params
    if ( exists $args{'title'}) {
        $_body_data = $args{'title'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('TitleResponse', $response);
    return $_response_object;
}

#
# cells_charts_put_worksheet_add_chart
#
# Add new chart to worksheet.
# 
# @param string $name Workbook name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param string $chart_type Chart type, please refer property Type in chart resource. (required)
# @param int $upper_left_row New chart upper left row. (optional, default to 0)
# @param int $upper_left_column New chart upperleft column. (optional, default to 0)
# @param int $lower_right_row New chart lower right row. (optional, default to 0)
# @param int $lower_right_column New chart lower right column. (optional, default to 0)
# @param string $area Specifies values from which to plot the data series.  (optional)
# @param boolean $is_vertical Specifies whether to plot the series from a range of cell values by row or by column.  (optional, default to true)
# @param string $category_data Gets or sets the range of category Axis values. It can be a range of cells (such as, \&quot;d1:e10\&quot;).  (optional)
# @param boolean $is_auto_get_serial_name Specifies whether auto update serial name.  (optional, default to true)
# @param string $title Specifies chart title name. (optional)
# @param string $folder The workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'chart_type' => {
        data_type => 'string',
        description => 'Chart type, please refer property Type in chart resource.',
        required => '1',
    },
    'upper_left_row' => {
        data_type => 'int',
        description => 'New chart upper left row.',
        required => '0',
    },
    'upper_left_column' => {
        data_type => 'int',
        description => 'New chart upperleft column.',
        required => '0',
    },
    'lower_right_row' => {
        data_type => 'int',
        description => 'New chart lower right row.',
        required => '0',
    },
    'lower_right_column' => {
        data_type => 'int',
        description => 'New chart lower right column.',
        required => '0',
    },
    'area' => {
        data_type => 'string',
        description => 'Specifies values from which to plot the data series. ',
        required => '0',
    },
    'is_vertical' => {
        data_type => 'boolean',
        description => 'Specifies whether to plot the series from a range of cell values by row or by column. ',
        required => '0',
    },
    'category_data' => {
        data_type => 'string',
        description => 'Gets or sets the range of category Axis values. It can be a range of cells (such as, \&quot;d1:e10\&quot;). ',
        required => '0',
    },
    'is_auto_get_serial_name' => {
        data_type => 'boolean',
        description => 'Specifies whether auto update serial name. ',
        required => '0',
    },
    'title' => {
        data_type => 'string',
        description => 'Specifies chart title name.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'The workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_charts_put_worksheet_add_chart' } = { 
    	summary => 'Add new chart to worksheet.',
        params => $params,
        returns => 'ChartsResponse',
        };
}
# @return ChartsResponse
#
sub cells_charts_put_worksheet_add_chart {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_charts_put_worksheet_add_chart");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_charts_put_worksheet_add_chart");
    }

    # verify the required parameter 'chart_type' is set
    unless (exists $args{'chart_type'}) {
      croak("Missing the required parameter 'chart_type' when calling cells_charts_put_worksheet_add_chart");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/charts';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'chart_type'}) {
        $query_params->{'chartType'} = $self->{api_client}->to_query_value($args{'chart_type'});
    }

    # query params
    if ( exists $args{'upper_left_row'}) {
        $query_params->{'upperLeftRow'} = $self->{api_client}->to_query_value($args{'upper_left_row'});
    }

    # query params
    if ( exists $args{'upper_left_column'}) {
        $query_params->{'upperLeftColumn'} = $self->{api_client}->to_query_value($args{'upper_left_column'});
    }

    # query params
    if ( exists $args{'lower_right_row'}) {
        $query_params->{'lowerRightRow'} = $self->{api_client}->to_query_value($args{'lower_right_row'});
    }

    # query params
    if ( exists $args{'lower_right_column'}) {
        $query_params->{'lowerRightColumn'} = $self->{api_client}->to_query_value($args{'lower_right_column'});
    }

    # query params
    if ( exists $args{'area'}) {
        $query_params->{'area'} = $self->{api_client}->to_query_value($args{'area'});
    }

    # query params
    if ( exists $args{'is_vertical'}) {
        $query_params->{'isVertical'} = $self->{api_client}->to_query_value($args{'is_vertical'});
    }

    # query params
    if ( exists $args{'category_data'}) {
        $query_params->{'categoryData'} = $self->{api_client}->to_query_value($args{'category_data'});
    }

    # query params
    if ( exists $args{'is_auto_get_serial_name'}) {
        $query_params->{'isAutoGetSerialName'} = $self->{api_client}->to_query_value($args{'is_auto_get_serial_name'});
    }

    # query params
    if ( exists $args{'title'}) {
        $query_params->{'title'} = $self->{api_client}->to_query_value($args{'title'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('ChartsResponse', $response);
    return $_response_object;
}

#
# cells_charts_put_worksheet_chart_legend
#
# Show legend in chart
# 
# @param string $name Workbook name. (required)
# @param string $sheet_name Worksheet name. (required)
# @param int $chart_index The chart index. (required)
# @param string $folder The workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'Worksheet name.',
        required => '1',
    },
    'chart_index' => {
        data_type => 'int',
        description => 'The chart index.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'The workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_charts_put_worksheet_chart_legend' } = { 
    	summary => 'Show legend in chart',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_charts_put_worksheet_chart_legend {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_charts_put_worksheet_chart_legend");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_charts_put_worksheet_chart_legend");
    }

    # verify the required parameter 'chart_index' is set
    unless (exists $args{'chart_index'}) {
      croak("Missing the required parameter 'chart_index' when calling cells_charts_put_worksheet_chart_legend");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/charts/{chartIndex}/legend';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'chart_index'}) {
        my $_base_variable = "{" . "chartIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'chart_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_charts_put_worksheet_chart_title
#
# Add chart title / Set chart title visible
# 
# @param string $name Workbook name. (required)
# @param string $sheet_name Worksheet name. (required)
# @param int $chart_index The chart index. (required)
# @param Title $title Chart title. (optional)
# @param string $folder The workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'Worksheet name.',
        required => '1',
    },
    'chart_index' => {
        data_type => 'int',
        description => 'The chart index.',
        required => '1',
    },
    'title' => {
        data_type => 'Title',
        description => 'Chart title.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'The workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_charts_put_worksheet_chart_title' } = { 
    	summary => 'Add chart title / Set chart title visible',
        params => $params,
        returns => 'TitleResponse',
        };
}
# @return TitleResponse
#
sub cells_charts_put_worksheet_chart_title {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_charts_put_worksheet_chart_title");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_charts_put_worksheet_chart_title");
    }

    # verify the required parameter 'chart_index' is set
    unless (exists $args{'chart_index'}) {
      croak("Missing the required parameter 'chart_index' when calling cells_charts_put_worksheet_chart_title");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/charts/{chartIndex}/title';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'chart_index'}) {
        my $_base_variable = "{" . "chartIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'chart_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # body params
    if ( exists $args{'title'}) {
        $_body_data = $args{'title'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('TitleResponse', $response);
    return $_response_object;
}

1;
