/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage;

import java.util.Locale;
import org.apache.sis.internal.storage.Resources;
import org.apache.sis.internal.storage.io.IOUtilities;
import org.apache.sis.util.LocalizedException;
import org.opengis.util.InternationalString;

public class DataStoreException
extends Exception
implements LocalizedException {
    private static final long serialVersionUID = -1778987176103191950L;
    private transient short key;
    private transient Object[] parameters;

    public DataStoreException() {
    }

    public DataStoreException(String string) {
        super(string);
    }

    public DataStoreException(Throwable throwable) {
        super(throwable);
    }

    public DataStoreException(String string, Throwable throwable) {
        super(string, throwable);
    }

    public DataStoreException(Locale locale, String string, String string2, Object object) {
        this(locale, IOUtilities.errorMessageParameters(string, string2, object));
    }

    private DataStoreException(Locale locale, Object[] objectArray) {
        this(locale, IOUtilities.errorMessageKey(objectArray), objectArray);
    }

    DataStoreException(Locale locale, short s, Object ... objectArray) {
        super(Resources.forLocale(locale).getString(s, objectArray));
        this.key = s;
        this.parameters = objectArray;
    }

    @Override
    public String getMessage() {
        return this.key != 0 ? Resources.format(this.key, this.parameters) : super.getMessage();
    }

    @Override
    public String getLocalizedMessage() {
        return super.getMessage();
    }

    @Override
    public InternationalString getInternationalMessage() {
        return this.key != 0 ? Resources.formatInternational(this.key, this.parameters) : null;
    }

    @Override
    public DataStoreException initCause(Throwable throwable) {
        return (DataStoreException)super.initCause(throwable);
    }
}

