#if !defined(KERNEL_KERNEL_H)
#define KERNEL_KERNEL_H

/* This contains often-used function prototypes etc */

#ifdef __KERNEL__

#include <stdarg.h>
#include <kernel/linkage.h>

/* Optimization barrier */
/* The "volatile" is due to gcc bugs */
#define barrier() __asm__ __volatile__("": : :"memory")

#define INT_MAX ((int)(~0U>>1))
#define UINT_MAX (~0U)
#define LONG_MAX ((long)(~0UL>>1))
#define ULONG_MAX (~0UL)

#define STACK_MAGIC 0xdeadbeef

/* Important number */
#define HZ 100

#define KERN_EMERG    "<0>"  /* system is unusable */
#define KERN_ALERT    "<1>"  /* action must be taken immediately */
#define KERN_CRIT     "<2>"  /* critical conditions */
#define KERN_ERR      "<3>"  /* error conditions */
#define KERN_WARNING  "<4>"  /* warning conditions */
#define KERN_NOTICE   "<5>"  /* normal but significant condition */
#define KERN_INFO     "<6>"  /* informational */
#define KERN_DEBUG    "<7>"  /* debug-level messages */

extern asmlinkage int printk(const char *fmt, ...)
     __attribute__ ((format (printf, 1, 2)));
extern asmlinkage void panic(const char *fmt, ...)
     __attribute__ ((/* noreturn, */ format (printf, 1, 2)));
extern int vsprintf(char *buf, const char *fmt, va_list args)
     __attribute__ ((format (printf, 2, 0)));
extern int sprintf(char * buf, const char *fmt, ...)
     __attribute__ ((format (printf, 2, 3)));

#endif

#endif /* !defined(KERNEL_KERNEL_H) */
