package Locales::DB::Territory::lv;

use strict;
use warnings;

# Auto generated from CLDR
use if $Locales::_UNICODE_STRINGS, 'utf8';

$Locales::DB::Territory::lv::VERSION = '0.09';

$Locales::DB::Territory::lv::cldr_version = '2.0';

%Locales::DB::Territory::lv::code_to_name = (
    '001' => 'pasaule',
    '002' => 'Āfrika',
    '003' => 'Ziemeļamerika',
    '005' => 'Dienvidamerika',
    '009' => 'Okeānija',
    '011' => 'Rietumāfrika',
    '013' => 'Centrālamerika',
    '014' => 'Austrumāfrika',
    '015' => 'Ziemeļāfrika',
    '017' => 'Vidusāfrika',
    '018' => "Āfrikas\ dienvidi",
    '019' => 'Amerika',
    '021' => "Amerikas\ ziemeļi",
    '029' => "Karību\ jūras\ reģions",
    '030' => 'Austrumāzija',
    '034' => 'Dienvidāzija',
    '035' => 'Centrālaustrumāzija',
    '039' => 'Dienvideiropa',
    '053' => "Austrālija\ un\ Jaunzēlande",
    '054' => 'Melanēzija',
    '057' => "Mikronēzijas\ reģions",
    '061' => 'Polinēzija',
    '062' => 'Centrāldienvidāzija',
    142   => 'Āzija',
    143   => 'Centrālāzija',
    145   => 'Rietumāzija',
    150   => 'Eiropa',
    151   => 'Austrumeiropa',
    154   => 'Ziemeļeiropa',
    155   => 'Rietumeiropa',
    172   => "Neatkarīgo\ Valstu\ Savienība",
    200   => 'Czechoslovakia',
    419   => "Latīņamerika\ un\ Karību\ jūras\ reģions",
    830   => "Channel\ Islands",
    'ac'  => "Debesbraukšanas\ sala",
    'ad'  => 'Andora',
    'ae'  => "Apvienotie\ Arābu\ Emirāti",
    'af'  => 'Afganistāna',
    'ag'  => "Antigva\ un\ Barbuda",
    'ai'  => 'Angilja',
    'al'  => 'Albānija',
    'am'  => 'Armēnija',
    'an'  => "Nīderlandes\ Antiļas",
    'ao'  => 'Angola',
    'aq'  => 'Antarktika',
    'ar'  => 'Argentīna',
    'as'  => "Amerikāņu\ Samoa",
    'at'  => 'Austrija',
    'au'  => 'Austrālija',
    'aw'  => 'Aruba',
    'ax'  => "Olandes\ salas",
    'az'  => 'Azerbaidžāna',
    'ba'  => "Bosnija\ un\ Hercegovina",
    'bb'  => 'Barbadosa',
    'bd'  => 'Bangladeša',
    'be'  => 'Beļģija',
    'bf'  => 'Burkinafaso',
    'bg'  => 'Bulgārija',
    'bh'  => 'Bahreina',
    'bi'  => 'Burundi',
    'bj'  => 'Benina',
    'bl'  => 'Senbartelmī',
    'bm'  => "Bermudu\ salas",
    'bn'  => 'Bruneja',
    'bo'  => 'Bolīvija',
    'bq'  => "British\ Antarctic\ Territory",
    'br'  => 'Brazīlija',
    'bs'  => "Bahamu\ salas",
    'bt'  => 'Butāna',
    'bv'  => "Buvē\ sala",
    'bw'  => 'Botsvāna',
    'by'  => 'Baltkrievija',
    'bz'  => 'Beliza',
    'ca'  => 'Kanāda',
    'cc'  => "Kokosu\ jeb\ Kīlinga\ salas",
    'cd'  => "Kongo\ Demokrātiskā\ Republika",
    'cf'  => "Centrālāfrikas\ Republika",
    'cg'  => "Kongo\ \[Republika\]",
    'ch'  => 'Šveice',
    'ci'  => "Ziloņkaula\ krasts",
    'ck'  => "Kuka\ salas",
    'cl'  => 'Čīle',
    'cm'  => 'Kamerūna',
    'cn'  => 'Ķīna',
    'co'  => 'Kolumbija',
    'cp'  => "Klipertona\ sala",
    'cr'  => 'Kostarika',
    'cs'  => "Serbija\ un\ Melnkalne",
    'ct'  => "Canton\ and\ Enderbury\ Islands",
    'cu'  => 'Kuba',
    'cv'  => 'Kaboverde',
    'cx'  => "Ziemsvētku\ sala",
    'cy'  => 'Kipra',
    'cz'  => 'Čehija',
    'dd'  => "East\ Germany",
    'de'  => 'Vācija',
    'dg'  => "Djego\ Garsijas\ atols",
    'dj'  => 'Džibutija',
    'dk'  => 'Dānija',
    'dm'  => 'Dominika',
    'do'  => "Dominikānas\ Republika",
    'dz'  => 'Alžīrija',
    'ea'  => "Seūta\ un\ Meliļa",
    'ec'  => 'Ekvadora',
    'ee'  => 'Igaunija',
    'eg'  => 'Ēģipte',
    'eh'  => 'Rietumsahāra',
    'er'  => 'Eritreja',
    'es'  => 'Spānija',
    'et'  => 'Etiopija',
    'eu'  => "Eiropas\ Savienība",
    'fi'  => 'Somija',
    'fj'  => 'Fidži',
    'fk'  => "Folklenda\ salas\ \[Malvinu\ salas\]",
    'fm'  => 'Mikronēzija',
    'fo'  => "Fēru\ Salas",
    'fq'  => "French\ Southern\ and\ Antarctic\ Territories",
    'fr'  => 'Francija',
    'fx'  => "Metropolitan\ France",
    'ga'  => 'Gabona',
    'gb'  => 'Lielbritānija',
    'gd'  => 'Grenāda',
    'ge'  => 'Gruzija',
    'gf'  => "Franču\ Gviāna",
    'gg'  => 'Gērnsija',
    'gh'  => 'Gana',
    'gi'  => 'Gibraltārs',
    'gl'  => 'Grenlande',
    'gm'  => 'Gambija',
    'gn'  => 'Gvineja',
    'gp'  => 'Gvadelupa',
    'gq'  => "Ekvatoriālā\ Gvineja",
    'gr'  => 'Grieķija',
    'gs'  => "Dienviddžordžija\ un\ Dienvidsendviču\ salas",
    'gt'  => 'Gvatemala',
    'gu'  => 'Guama',
    'gw'  => "Gvineja\-Bisava",
    'gy'  => 'Gajāna',
    'hk'  => 'Honkonga',
    'hm'  => "Hērda\ un\ Makdonalda\ salas",
    'hn'  => 'Hondurasa',
    'hr'  => 'Horvātija',
    'ht'  => 'Haiti',
    'hu'  => 'Ungārija',
    'ic'  => "Kanāriju\ salas",
    'id'  => 'Indonēzija',
    'ie'  => 'Īrija',
    'il'  => 'Izraēla',
    'im'  => 'Mena',
    'in'  => 'Indija',
    'io'  => "Indijas\ okeāna\ Britu\ teritorija",
    'iq'  => 'Irāka',
    'ir'  => 'Irāna',
    'is'  => 'Īslande',
    'it'  => 'Itālija',
    'je'  => 'Džērsija',
    'jm'  => 'Jamaika',
    'jo'  => 'Jordānija',
    'jp'  => 'Japāna',
    'jt'  => "Johnston\ Island",
    'ke'  => 'Kenija',
    'kg'  => 'Kirgīzija',
    'kh'  => 'Kambodža',
    'ki'  => 'Kiribati',
    'km'  => "Komoru\ salas",
    'kn'  => "Sentkitsa\ un\ Nevisa",
    'kp'  => 'Ziemeļkoreja',
    'kr'  => 'Dienvidkoreja',
    'kw'  => 'Kuveita',
    'ky'  => "Kaimanu\ salas",
    'kz'  => 'Kazahstāna',
    'la'  => 'Laosa',
    'lb'  => 'Libāna',
    'lc'  => 'Sentlūsija',
    'li'  => 'Lihtenšteina',
    'lk'  => 'Šrilanka',
    'lr'  => 'Libērija',
    'ls'  => 'Lesoto',
    'lt'  => 'Lietuva',
    'lu'  => 'Luksemburga',
    'lv'  => 'Latvija',
    'ly'  => 'Lībija',
    'ma'  => 'Maroka',
    'mc'  => 'Monako',
    'md'  => 'Moldova',
    'me'  => 'Melnkalne',
    'mf'  => 'Senmartēna',
    'mg'  => 'Madagaskara',
    'mh'  => "Māršala\ salas",
    'mi'  => "Midway\ Islands",
    'mk'  => "Maķedonija\ \[BDRM\]",
    'ml'  => 'Mali',
    'mm'  => "Mjanma\ \[Birma\]",
    'mn'  => 'Mongolija',
    'mo'  => 'Makao',
    'mp'  => "Ziemeļu\ Marianas\ salas",
    'mq'  => 'Martinika',
    'mr'  => 'Mauritānija',
    'ms'  => 'Montserrata',
    'mt'  => 'Malta',
    'mu'  => 'Maurīcija',
    'mv'  => 'Maldīvija',
    'mw'  => 'Malāvija',
    'mx'  => 'Meksika',
    'my'  => 'Malaizija',
    'mz'  => 'Mozambika',
    'na'  => 'Namībija',
    'nc'  => 'Jaunkaledonija',
    'ne'  => 'Nigēra',
    'nf'  => "Norfolkas\ sala",
    'ng'  => 'Nigērija',
    'ni'  => 'Nikaragva',
    'nl'  => 'Nīderlande',
    'no'  => 'Norvēģija',
    'np'  => 'Nepāla',
    'nq'  => "Dronning\ Maud\ Land",
    'nr'  => 'Nauru',
    'nt'  => "Neutral\ Zone",
    'nu'  => 'Niue',
    'nz'  => 'Jaunzēlande',
    'om'  => 'Omāna',
    'pa'  => 'Panama',
    'pc'  => "Pacific\ Islands\ Trust\ Territory",
    'pe'  => 'Peru',
    'pf'  => "Franču\ Polinēzija",
    'pg'  => "Papua\-Jaungvineja",
    'ph'  => 'Filipīnas',
    'pk'  => 'Pakistāna',
    'pl'  => 'Polija',
    'pm'  => "Senpjēra\ un\ Mikelona",
    'pn'  => 'Pitkērna',
    'pr'  => 'Puertoriko',
    'ps'  => 'Palestīna',
    'pt'  => 'Portugāle',
    'pu'  => "U\.S\.\ Miscellaneous\ Pacific\ Islands",
    'pw'  => 'Palau',
    'py'  => 'Paragvaja',
    'pz'  => "Panama\ Canal\ Zone",
    'qa'  => 'Katara',
    'qo'  => "Okeānijas\ attālās\ salas",
    're'  => 'Reinjona',
    'ro'  => 'Rumānija',
    'rs'  => 'Serbija',
    'ru'  => 'Krievija',
    'rw'  => 'Ruanda',
    'sa'  => "Saūda\ Arābija",
    'sb'  => "Zālamana\ salas",
    'sc'  => "Seišeļu\ salas",
    'sd'  => 'Sudāna',
    'se'  => 'Zviedrija',
    'sg'  => 'Singapūra',
    'sh'  => "Sv\.\ Helēnas\ sala",
    'si'  => 'Slovēnija',
    'sj'  => "Svalbāra\ un\ Jana\ Majena\ sala",
    'sk'  => 'Slovākija',
    'sl'  => 'Sjerraleone',
    'sm'  => 'Sanmarīno',
    'sn'  => 'Senegāla',
    'so'  => 'Somālija',
    'sr'  => 'Surinama',
    'st'  => "Santome\ un\ Prinsipi",
    'su'  => "Union\ of\ Soviet\ Socialist\ Republics",
    'sv'  => 'Salvadora',
    'sy'  => 'Sīrija',
    'sz'  => 'Svazilenda',
    'ta'  => "Tristana\ da\ Kuņas\ salas",
    'tc'  => "Tērksas\ un\ Kaikosas\ salas",
    'td'  => 'Čada',
    'tf'  => "Franču\ dienvidu\ teritorijas",
    'tg'  => 'Togo',
    'th'  => 'Taizeme',
    'tj'  => 'Tadžikistāna',
    'tk'  => 'Tokelau',
    'tl'  => 'Austrumtimora',
    'tm'  => 'Turkmenistāna',
    'tn'  => 'Tunisija',
    'to'  => 'Tonga',
    'tr'  => 'Turcija',
    'tt'  => "Trinidāda\ un\ Tobāgo",
    'tv'  => 'Tuvalu',
    'tw'  => 'Taivāna',
    'tz'  => 'Tanzānija',
    'ua'  => 'Ukraina',
    'ug'  => 'Uganda',
    'um'  => "ASV\ Mazās\ Aizjūras\ salas",
    'us'  => "Amerikas\ Savienotās\ Valstis",
    'uy'  => 'Urugvaja',
    'uz'  => 'Uzbekistāna',
    'va'  => 'Vatikāns',
    'vc'  => "Sentvinsenta\ un\ Grenadīnas",
    'vd'  => "North\ Vietnam",
    've'  => 'Venecuēla',
    'vg'  => "Britu\ Virdžīnas",
    'vi'  => "ASV\ Virdžīnas",
    'vn'  => 'Vjetnama',
    'vu'  => 'Vanuatu',
    'wf'  => "Volisa\ un\ Futuna",
    'wk'  => "Wake\ Island",
    'ws'  => 'Samoa',
    'yd'  => "People\â\\s\ Democratic\ Republic\ of\ Yemen",
    'ye'  => 'Jemena',
    'yt'  => 'Majota',
    'za'  => "Dienvidāfrikas\ Republika",
    'zm'  => 'Zambija',
    'zw'  => 'Zimbabve',
    'zz'  => "nezināms\ vai\ nederīgs\ reģions",
);

%Locales::DB::Territory::lv::name_to_code = (
    'afganistāna'                              => 'af',
    'albānija'                                 => 'al',
    'alžīrija'                                => 'dz',
    'amerika'                                   => '019',
    'amerikassavienotāsvalstis'                => 'us',
    'amerikasziemeļi'                          => '021',
    'amerikāņusamoa'                          => 'as',
    'andora'                                    => 'ad',
    'angilja'                                   => 'ai',
    'angola'                                    => 'ao',
    'antarktika'                                => 'aq',
    'antigvaunbarbuda'                          => 'ag',
    'apvienotiearābuemirāti'                  => 'ae',
    'argentīna'                                => 'ar',
    'armēnija'                                 => 'am',
    'aruba'                                     => 'aw',
    'asvmazāsaizjūrassalas'                   => 'um',
    'asvvirdžīnas'                            => 'vi',
    'austrija'                                  => 'at',
    'austrumeiropa'                             => 151,
    'austrumtimora'                             => 'tl',
    'austrumāfrika'                            => '014',
    'austrumāzija'                             => '030',
    'austrālija'                               => 'au',
    'austrālijaunjaunzēlande'                 => '053',
    'azerbaidžāna'                            => 'az',
    'bahamusalas'                               => 'bs',
    'bahreina'                                  => 'bh',
    'baltkrievija'                              => 'by',
    'bangladeša'                               => 'bd',
    'barbadosa'                                 => 'bb',
    'beliza'                                    => 'bz',
    'benina'                                    => 'bj',
    'bermudusalas'                              => 'bm',
    'beļģija'                                 => 'be',
    'bolīvija'                                 => 'bo',
    'bosnijaunhercegovina'                      => 'ba',
    'botsvāna'                                 => 'bw',
    'brazīlija'                                => 'br',
    'britishantarcticterritory'                 => 'bq',
    'brituvirdžīnas'                          => 'vg',
    'bruneja'                                   => 'bn',
    'bulgārija'                                => 'bg',
    'burkinafaso'                               => 'bf',
    'burundi'                                   => 'bi',
    'butāna'                                   => 'bt',
    'buvēsala'                                 => 'bv',
    'cantonandenderburyislands'                 => 'ct',
    'centrālamerika'                           => '013',
    'centrālaustrumāzija'                     => '035',
    'centrāldienvidāzija'                     => '062',
    'centrālāfrikasrepublika'                 => 'cf',
    'centrālāzija'                            => 143,
    'channelislands'                            => 830,
    'czechoslovakia'                            => 200,
    'debesbraukšanassala'                      => 'ac',
    'dienvidamerika'                            => '005',
    'dienviddžordžijaundienvidsendvičusalas' => 'gs',
    'dienvideiropa'                             => '039',
    'dienvidkoreja'                             => 'kr',
    'dienvidāfrikasrepublika'                  => 'za',
    'dienvidāzija'                             => '034',
    'djegogarsijasatols'                        => 'dg',
    'dominika'                                  => 'dm',
    'dominikānasrepublika'                     => 'do',
    'dronningmaudland'                          => 'nq',
    'dānija'                                   => 'dk',
    'džibutija'                                => 'dj',
    'džērsija'                                => 'je',
    'eastgermany'                               => 'dd',
    'eiropa'                                    => 150,
    'eiropassavienība'                         => 'eu',
    'ekvadora'                                  => 'ec',
    'ekvatoriālāgvineja'                      => 'gq',
    'eritreja'                                  => 'er',
    'etiopija'                                  => 'et',
    'fidži'                                    => 'fj',
    'filipīnas'                                => 'ph',
    'folklendasalasmalvinusalas'                => 'fk',
    'francija'                                  => 'fr',
    'frančudienviduteritorijas'                => 'tf',
    'frančugviāna'                            => 'gf',
    'frančupolinēzija'                        => 'pf',
    'frenchsouthernandantarcticterritories'     => 'fq',
    'fērusalas'                                => 'fo',
    'gabona'                                    => 'ga',
    'gajāna'                                   => 'gy',
    'gambija'                                   => 'gm',
    'gana'                                      => 'gh',
    'gibraltārs'                               => 'gi',
    'grenlande'                                 => 'gl',
    'grenāda'                                  => 'gd',
    'grieķija'                                 => 'gr',
    'gruzija'                                   => 'ge',
    'guama'                                     => 'gu',
    'gvadelupa'                                 => 'gp',
    'gvatemala'                                 => 'gt',
    'gvineja'                                   => 'gn',
    'gvinejabisava'                             => 'gw',
    'gērnsija'                                 => 'gg',
    'haiti'                                     => 'ht',
    'hondurasa'                                 => 'hn',
    'honkonga'                                  => 'hk',
    'horvātija'                                => 'hr',
    'hērdaunmakdonaldasalas'                   => 'hm',
    'igaunija'                                  => 'ee',
    'indija'                                    => 'in',
    'indijasokeānabrituteritorija'             => 'io',
    'indonēzija'                               => 'id',
    'irāka'                                    => 'iq',
    'irāna'                                    => 'ir',
    'itālija'                                  => 'it',
    'izraēla'                                  => 'il',
    'jamaika'                                   => 'jm',
    'japāna'                                   => 'jp',
    'jaunkaledonija'                            => 'nc',
    'jaunzēlande'                              => 'nz',
    'jemena'                                    => 'ye',
    'johnstonisland'                            => 'jt',
    'jordānija'                                => 'jo',
    'kaboverde'                                 => 'cv',
    'kaimanusalas'                              => 'ky',
    'kambodža'                                 => 'kh',
    'kamerūna'                                 => 'cm',
    'kanāda'                                   => 'ca',
    'kanārijusalas'                            => 'ic',
    'karībujūrasreģions'                     => '029',
    'katara'                                    => 'qa',
    'kazahstāna'                               => 'kz',
    'kenija'                                    => 'ke',
    'kipra'                                     => 'cy',
    'kirgīzija'                                => 'kg',
    'kiribati'                                  => 'ki',
    'klipertonasala'                            => 'cp',
    'kokosujebkīlingasalas'                    => 'cc',
    'kolumbija'                                 => 'co',
    'komorusalas'                               => 'km',
    'kongodemokrātiskārepublika'              => 'cd',
    'kongorepublika'                            => 'cg',
    'kostarika'                                 => 'cr',
    'krievija'                                  => 'ru',
    'kuba'                                      => 'cu',
    'kukasalas'                                 => 'ck',
    'kuveita'                                   => 'kw',
    'laosa'                                     => 'la',
    'latvija'                                   => 'lv',
    'latīņamerikaunkarībujūrasreģions'     => 419,
    'lesoto'                                    => 'ls',
    'libāna'                                   => 'lb',
    'libērija'                                 => 'lr',
    'lielbritānija'                            => 'gb',
    'lietuva'                                   => 'lt',
    'lihtenšteina'                             => 'li',
    'luksemburga'                               => 'lu',
    'lībija'                                   => 'ly',
    'madagaskara'                               => 'mg',
    'majota'                                    => 'yt',
    'makao'                                     => 'mo',
    'malaizija'                                 => 'my',
    'maldīvija'                                => 'mv',
    'mali'                                      => 'ml',
    'malta'                                     => 'mt',
    'malāvija'                                 => 'mw',
    'maroka'                                    => 'ma',
    'martinika'                                 => 'mq',
    'mauritānija'                              => 'mr',
    'maurīcija'                                => 'mu',
    'maķedonijabdrm'                           => 'mk',
    'meksika'                                   => 'mx',
    'melanēzija'                               => '054',
    'melnkalne'                                 => 'me',
    'mena'                                      => 'im',
    'metropolitanfrance'                        => 'fx',
    'midwayislands'                             => 'mi',
    'mikronēzija'                              => 'fm',
    'mikronēzijasreģions'                     => '057',
    'mjanmabirma'                               => 'mm',
    'moldova'                                   => 'md',
    'monako'                                    => 'mc',
    'mongolija'                                 => 'mn',
    'montserrata'                               => 'ms',
    'mozambika'                                 => 'mz',
    'māršalasalas'                            => 'mh',
    'namībija'                                 => 'na',
    'nauru'                                     => 'nr',
    'neatkarīgovalstusavienība'               => 172,
    'nepāla'                                   => 'np',
    'neutralzone'                               => 'nt',
    'nezināmsvainederīgsreģions'             => 'zz',
    'nigēra'                                   => 'ne',
    'nigērija'                                 => 'ng',
    'nikaragva'                                 => 'ni',
    'niue'                                      => 'nu',
    'norfolkassala'                             => 'nf',
    'northvietnam'                              => 'vd',
    'norvēģija'                               => 'no',
    'nīderlande'                               => 'nl',
    'nīderlandesantiļas'                      => 'an',
    'okeānija'                                 => '009',
    'okeānijasattālāssalas'                  => 'qo',
    'olandessalas'                              => 'ax',
    'omāna'                                    => 'om',
    'pacificislandstrustterritory'              => 'pc',
    'pakistāna'                                => 'pk',
    'palau'                                     => 'pw',
    'palestīna'                                => 'ps',
    'panama'                                    => 'pa',
    'panamacanalzone'                           => 'pz',
    'papuajaungvineja'                          => 'pg',
    'paragvaja'                                 => 'py',
    'pasaule'                                   => '001',
    "people\â\\sdemocraticrepublicofyemen" => 'yd',
    'peru'                                      => 'pe',
    'pitkērna'                                 => 'pn',
    'polija'                                    => 'pl',
    'polinēzija'                               => '061',
    'portugāle'                                => 'pt',
    'puertoriko'                                => 'pr',
    'reinjona'                                  => 're',
    'rietumeiropa'                              => 155,
    'rietumsahāra'                             => 'eh',
    'rietumāfrika'                             => '011',
    'rietumāzija'                              => 145,
    'ruanda'                                    => 'rw',
    'rumānija'                                 => 'ro',
    'salvadora'                                 => 'sv',
    'samoa'                                     => 'ws',
    'sanmarīno'                                => 'sm',
    'santomeunprinsipi'                         => 'st',
    'saūdaarābija'                            => 'sa',
    'seišeļusalas'                            => 'sc',
    'senbartelmī'                              => 'bl',
    'senegāla'                                 => 'sn',
    'senmartēna'                               => 'mf',
    'senpjēraunmikelona'                       => 'pm',
    'sentkitsaunnevisa'                         => 'kn',
    'sentlūsija'                               => 'lc',
    'sentvinsentaungrenadīnas'                 => 'vc',
    'serbija'                                   => 'rs',
    'serbijaunmelnkalne'                        => 'cs',
    'seūtaunmeliļa'                           => 'ea',
    'singapūra'                                => 'sg',
    'sjerraleone'                               => 'sl',
    'slovākija'                                => 'sk',
    'slovēnija'                                => 'si',
    'somija'                                    => 'fi',
    'somālija'                                 => 'so',
    'spānija'                                  => 'es',
    'sudāna'                                   => 'sd',
    'surinama'                                  => 'sr',
    "sv\.helēnassala"                          => 'sh',
    'svalbāraunjanamajenasala'                 => 'sj',
    'svazilenda'                                => 'sz',
    'sīrija'                                   => 'sy',
    'tadžikistāna'                            => 'tj',
    'taivāna'                                  => 'tw',
    'taizeme'                                   => 'th',
    'tanzānija'                                => 'tz',
    'togo'                                      => 'tg',
    'tokelau'                                   => 'tk',
    'tonga'                                     => 'to',
    'trinidādauntobāgo'                       => 'tt',
    'tristanadakuņassalas'                     => 'ta',
    'tunisija'                                  => 'tn',
    'turcija'                                   => 'tr',
    'turkmenistāna'                            => 'tm',
    'tuvalu'                                    => 'tv',
    'tērksasunkaikosassalas'                   => 'tc',
    "u\.s\.miscellaneouspacificislands"         => 'pu',
    'uganda'                                    => 'ug',
    'ukraina'                                   => 'ua',
    'ungārija'                                 => 'hu',
    'unionofsovietsocialistrepublics'           => 'su',
    'urugvaja'                                  => 'uy',
    'uzbekistāna'                              => 'uz',
    'vanuatu'                                   => 'vu',
    'vatikāns'                                 => 'va',
    'venecuēla'                                => 've',
    'vidusāfrika'                              => '017',
    'vjetnama'                                  => 'vn',
    'volisaunfutuna'                            => 'wf',
    'vācija'                                   => 'de',
    'wakeisland'                                => 'wk',
    'zambija'                                   => 'zm',
    'ziemeļamerika'                            => '003',
    'ziemeļeiropa'                             => 154,
    'ziemeļkoreja'                             => 'kp',
    'ziemeļumarianassalas'                     => 'mp',
    'ziemeļāfrika'                            => '015',
    'ziemsvētkusala'                           => 'cx',
    'ziloņkaulakrasts'                         => 'ci',
    'zimbabve'                                  => 'zw',
    'zviedrija'                                 => 'se',
    'zālamanasalas'                            => 'sb',
    'Āfrika'                                   => '002',
    'Āfrikasdienvidi'                          => '018',
    'Āzija'                                    => 142,
    'Čada'                                     => 'td',
    'Čehija'                                   => 'cz',
    'Čīle'                                    => 'cl',
    'Ēģipte'                                  => 'eg',
    'Īrija'                                    => 'ie',
    'Īslande'                                  => 'is',
    'Ķīna'                                    => 'cn',
    'Šrilanka'                                 => 'lk',
    'Šveice'                                   => 'ch',
);

1;

