package App::Manoc::Controller::Arp;
#ABSTRACT: Arp Catalyst Controller

use Moose;

our $VERSION = '2.99.2'; ##TRIAL VERSION

use namespace::autoclean;

BEGIN { extends 'Catalyst::Controller'; }
with
    'App::Manoc::ControllerRole::ResultSet',
    'App::Manoc::ControllerRole::JQDatatable';

use App::Manoc::Utils::Datetime qw/print_timestamp/;



sub list : Private {
    my ( $self, $c ) = @_;

    $c->require_permission( 'arp', 'view' );

    $c->stash( template => 'arp/list.tt' );
}


sub list_js : Private {
    my ( $self, $c ) = @_;

    $c->require_permission( 'arp', 'view' );

    my $row_callback = sub {
        my ( $ctx, $row ) = @_;
        my $address = App::Manoc::IPAddress::IPv4->new( $row->get_column('ip_address') );
        return [
            "$address",
            print_timestamp( $row->get_column('firstseen') ),
            print_timestamp( $row->get_column('lastseen') ),
        ];
    };

    $c->stash(
        datatable_row_callback   => $row_callback,
        datatable_search_columns => [qw/ipaddr/],
        datatable_columns        => [qw/ipaddr firstseen lastseen/],
    );

    $c->detach('datatable_response');
}

__PACKAGE__->meta->make_immutable;

1;
# Local Variables:
# mode: cperl
# indent-tabs-mode: nil
# cperl-indent-level: 4
# cperl-indent-parens-as-block: t
# End:

__END__

=pod

=head1 NAME

App::Manoc::Controller::Arp - Arp Catalyst Controller

=head1 VERSION

version 2.99.2

=head1 DESCRIPTION

Catalyst Controller.

=head1 ACTIONS

=head2 list

=head2 list_js

=head1 AUTHORS

=over 4

=item *

Gabriele Mambrini <gmambro@cpan.org>

=item *

Enrico Liguori

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
