package App::Manoc::Controller::VTP;
#ABSTRACT: VTP controller

use Moose;

our $VERSION = '2.99.2'; ##TRIAL VERSION

use namespace::autoclean;

BEGIN { extends 'Catalyst::Controller'; }

with
    'App::Manoc::ControllerRole::ResultSet',
    'App::Manoc::ControllerRole::ObjectList';

__PACKAGE__->config(
    # define PathPart
    action => {
        setup => {
            PathPart => 'vtp',
        }
    },
    class                   => 'ManocDB::VlanVtp',
    enable_permission_check => 1,
    view_object_perm        => undef,
    object_list_options     => {
        prefetch => 'vlan'
    }
);


sub list : Chained('object_list') : PathPart('') : Args(0) {
    # just use defaults
}


sub compare : Chained('base') : PathPart('compare') : Args(0) {
    my ( $self, $c ) = @_;

    my $vtp_rs  = $c->stash->{resultset};
    my $vlan_rs = $c->model('ManocDB::Vlan');

    my @diff;

    # search vtp entries with missing or mismatched vlan
    my @vtp_entries = $vtp_rs->search(
        [ { 'vlan.id' => undef }, { 'vlan.name' => { '!=' => { -ident => 'me.name' } } } ],
        {
            prefetch => 'vlan'
        }
    );
    foreach my $vtp (@vtp_entries) {
        push @diff,
            {
            id        => $vtp->id,
            vlan_name => $vtp->vlan ? $vtp->vlan->name : '',
            vtp_name  => $vtp->name,
            };
    }

    # search vlans with missing vtp
    my @vlan_entries = $vlan_rs->search(
        {
            'vtp_entry.id' => undef,
        },
        {
            prefetch => 'vtp_entry',
        }
    );
    foreach my $vlan (@vlan_entries) {
        push @diff,
            {
            id        => $vlan->id,
            vlan_name => $vlan->name,
            vtp_name  => '',
            };
    }

    # sort diff entries by id
    @diff = sort { $a->{id} <=> $a->{id} } @diff;

    $c->stash( diff => \@diff );
}

__PACKAGE__->meta->make_immutable;

1;
# Local Variables:
# mode: cperl
# indent-tabs-mode: nil
# cperl-indent-level: 4
# cperl-indent-parens-as-block: t
# End:

__END__

=pod

=head1 NAME

App::Manoc::Controller::VTP - VTP controller

=head1 VERSION

version 2.99.2

=head1 ACTIONS

=head2 list

=head2 compare

=head1 AUTHORS

=over 4

=item *

Gabriele Mambrini <gmambro@cpan.org>

=item *

Enrico Liguori

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
