package App::Manoc::DB::Helper::NetwalkerPoller;
#ABSTRACT: Role for created column to support netwalker poller status

use strict;
use warnings;

our $VERSION = '2.99.2'; ##TRIAL VERSION

use parent 'DBIx::Class';


sub make_poller_columns {
    my $self = shift;

    $self->add_columns(
        offline => {
            data_type     => 'int',
            size          => 1,
            default_value => '0',
        },

        last_visited => {
            data_type     => 'int',
            default_value => '0',
        },

        scheduled_attempt => {
            data_type     => 'int',
            default_value => '0',
        },

        attempt_backoff => {
            data_type     => 'int',
            default_value => '0',
        },

        netwalker_status => {
            data_type     => 'varchar',
            size          => 255,
            default_value => 'NULL',
            is_nullable   => 1,
        },
    );
}

1;

__END__

=pod

=head1 NAME

App::Manoc::DB::Helper::NetwalkerPoller - Role for created column to support netwalker poller status

=head1 VERSION

version 2.99.2

=head1 METHODS

=head2 make_poller_columns

Add all the columns required for storing netwalker status

=head1 AUTHORS

=over 4

=item *

Gabriele Mambrini <gmambro@cpan.org>

=item *

Enrico Liguori

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
