package    # Hide from CPAN
    App::Manoc::DataDumper::Converter::v1;

use Moose;

our $VERSION = '2.99.2'; ##TRIAL VERSION

extends 'App::Manoc::DataDumper::Converter::Base';

use Data::Dumper;

# check for spurious data
sub upgrade_winlogon {
    my ( $self, $data ) = @_;
    my $count = 0;
    my ( $i, $name );
    return 0 unless ( defined($data) );

    for ( $i = 0; $i < scalar( @{$data} ); $i++ ) {
        $name = $data->[$i]->{'user'};
        if ( $name =~ m/^\W$/ ) {
            $count++;
            splice( @{$data}, $i, 1 );
        }
    }
    return $count;
}

no Moose;    # Clean up the namespace.
__PACKAGE__->meta->make_immutable();
1;

__END__

=pod

=head1 NAME

App::Manoc::DataDumper::Converter::v1

=head1 VERSION

version 2.99.2

=head1 AUTHORS

=over 4

=item *

Gabriele Mambrini <gmambro@cpan.org>

=item *

Enrico Liguori

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
