package App::Manoc::Search::Driver::Arp;

use Moose;

our $VERSION = '2.99.2'; ##TRIAL VERSION

extends 'App::Manoc::Search::Driver';

use App::Manoc::Search::Item::MacAddr;
use App::Manoc::Search::Item::IpAddr;

sub search_ipaddr {
    my ( $self, $query, $result ) = @_;

    my $pattern = $query->sql_pattern;
    my $schema  = $self->engine->schema;

    my $search = { ipaddr => { like => $pattern } };
    $query->limit and
        $search->{lastseen} = { '>' => $query->start_date };

    my $it = $schema->resultset('Arp')->search(
        $search,
        {
            select   => [ 'ipaddr', 'macaddr', { max => 'lastseen' } ],
            as       => [ 'ipaddr', 'macaddr', 'timestamp' ],
            group_by => [qw(ipaddr macaddr)]
        },
    );

    while ( my $e = $it->next ) {
        my $item = App::Manoc::Search::Item::MacAddr->new(
            {
                match     => $e->ipaddr->unpadded,
                addr      => $e->macaddr,
                timestamp => $e->get_column('timestamp'),
            }
        );
        $result->add_item($item);
    }
}

sub search_macaddr {
    my ( $self, $query, $result ) = @_;

    my $pattern = $query->sql_pattern;
    my $schema  = $self->engine->schema;

    my $search = { macaddr => { like => $pattern } };
    $query->limit and
        $search->{lastseen} = { '>' => $query->start_date };

    my $it = $schema->resultset('Arp')->search(
        $search,
        {
            select   => [ 'ipaddr', 'macaddr', { max => 'lastseen' } ],
            as       => [ 'ipaddr', 'macaddr', 'timestamp' ],
            group_by => [qw(ipaddr macaddr)]
        },
    );

    while ( my $e = $it->next ) {
        my $item = App::Manoc::Search::Item::IpAddr->new(
            {
                match     => $e->macaddr,
                addr      => $e->ipaddr->unpadded,
                timestamp => $e->get_column('timestamp'),
            }
        );
        $result->add_item($item);
    }
}

no Moose;
__PACKAGE__->meta->make_immutable;

__END__

=pod

=head1 NAME

App::Manoc::Search::Driver::Arp

=head1 VERSION

version 2.99.2

=head1 AUTHORS

=over 4

=item *

Gabriele Mambrini <gmambro@cpan.org>

=item *

Enrico Liguori

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
