package App::Manoc::DB::Search::Result::Iface;
#ABSTRACT: Device interface search result

use Moose;

our $VERSION = '2.99.3'; ##TRIAL VERSION

extends 'App::Manoc::DB::Search::Result::Item';

has 'interface' => (
    is       => 'ro',
    isa      => 'Object',
    required => 1
);

around BUILDARGS => sub {
    my $orig  = shift;
    my $class = shift;

    if ( @_ == 1 && ref( $_[0] ) eq 'HASH' ) {
        my $args  = $_[0];
        my $iface = $args->{interface};

        my $device = $iface->device;

        if ( $device && $iface ) {
            $args->{match} ||= $device->name . '/' . $iface;
        }
        return $class->$orig($args);
    }

    return $class->$orig(@_);
};

no Moose;
__PACKAGE__->meta->make_immutable;

__END__

=pod

=head1 NAME

App::Manoc::DB::Search::Result::Iface - Device interface search result

=head1 VERSION

version 2.99.3

=head1 AUTHORS

=over 4

=item *

Gabriele Mambrini <gmambro@cpan.org>

=item *

Enrico Liguori

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
