package App::Manoc::DB::Result::VlanVtp;
#ABSTRACT: A model object representing a VTP info

use strict;
use warnings;

our $VERSION = '2.99.4'; ##TRIAL VERSION

use parent 'App::Manoc::DB::Result';

__PACKAGE__->table('vlan_vtp');

__PACKAGE__->add_columns(
    id => {
        data_type   => 'int',
        is_nullable => 0
    },
    vid => {
        data_type   => 'int',
        is_nullable => 0
    },
    vtp_domain => {
        data_type   => 'varchar',
        size        => 64,
        is_nullable => 0
    },
    name => {
        data_type   => 'varchar',
        size        => 255,
        is_nullable => 0
    }
);

__PACKAGE__->set_primary_key('id');
__PACKAGE__->add_unique_constraints( [ 'vtp_domain', 'vid' ] );

1;

__END__

=pod

=head1 NAME

App::Manoc::DB::Result::VlanVtp - A model object representing a VTP info

=head1 VERSION

version 2.99.4

=head1 AUTHORS

=over 4

=item *

Gabriele Mambrini <gmambro@cpan.org>

=item *

Enrico Liguori

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
