package App::Manoc::Logger::CatalystRole;
#ABSTRACT: Catalyst role to enable Log4perl logger

use Moose::Role;

our $VERSION = '2.99.4'; ##TRIAL VERSION

use App::Manoc::Logger;
use Log::Log4perl::Catalyst;


sub setup_log {
    my ( $class, $levels ) = @_;

    return if $class->log;

    $levels ||= '';
    $levels =~ s/^\s+//;
    $levels =~ s/\s+$//;
    my %levels = map { $_ => 1 } split /\s*,\s*/, $levels;

    my $env_debug = Catalyst::Utils::env_value( $class, 'DEBUG' );
    if ( defined $env_debug ) {
        $levels{debug} = 1 if $env_debug;    # Ugly!
        delete( $levels{debug} ) unless $env_debug;
    }

    App::Manoc::Logger->init(
        {
            class => $class,
            debug => $levels{debug}
        }
    );

    # start default screen logger
    $class->log( Log::Log4perl::Catalyst->new() );

    # ovverride debug method
    if ( $levels{debug} ) {
        Class::MOP::get_metaclass_by_name($class)->add_method( 'debug' => sub { 1 } );
        $class->log->debug('Debug messages enabled');
    }
}

1;

# Local Variables:
# mode: cperl
# indent-tabs-mode: nil
# cperl-indent-level: 4
# cperl-indent-parens-as-block: t
# End:

__END__

=pod

=head1 NAME

App::Manoc::Logger::CatalystRole - Catalyst role to enable Log4perl logger

=head1 VERSION

version 2.99.4

=for Pod::Coverage setup_log

=head1 AUTHORS

=over 4

=item *

Gabriele Mambrini <gmambro@cpan.org>

=item *

Enrico Liguori

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
