/*
 * Decompiled with CFR 0.152.
 */
package org.seleniumhq.jetty9.jmx;

import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.seleniumhq.jetty9.jmx.ObjectMBean;
import org.seleniumhq.jetty9.util.annotation.ManagedObject;
import org.seleniumhq.jetty9.util.component.Container;
import org.seleniumhq.jetty9.util.component.ContainerLifeCycle;
import org.seleniumhq.jetty9.util.component.Destroyable;
import org.seleniumhq.jetty9.util.component.Dumpable;
import org.seleniumhq.jetty9.util.log.Log;
import org.seleniumhq.jetty9.util.log.Logger;

@ManagedObject(value="The component that registers beans as MBeans")
public class MBeanContainer
implements Container.InheritedListener,
Dumpable,
Destroyable {
    private static final Logger LOG = Log.getLogger(MBeanContainer.class.getName());
    private static final ConcurrentMap<String, AtomicInteger> __unique = new ConcurrentHashMap<String, AtomicInteger>();
    private static final Container ROOT = new ContainerLifeCycle();
    private final MBeanServer _mbeanServer;
    private final ConcurrentMap<Object, Container> _beans = new ConcurrentHashMap<Object, Container>();
    private final ConcurrentMap<Object, ObjectName> _mbeans = new ConcurrentHashMap<Object, ObjectName>();
    private String _domain = null;

    public ObjectName findMBean(Object object) {
        return (ObjectName)this._mbeans.get(object);
    }

    public Object findBean(ObjectName objectName) {
        for (Map.Entry entry : this._mbeans.entrySet()) {
            if (!((ObjectName)entry.getValue()).equals(objectName)) continue;
            return entry.getKey();
        }
        return null;
    }

    public MBeanContainer(MBeanServer server) {
        this._mbeanServer = server;
    }

    public MBeanServer getMBeanServer() {
        return this._mbeanServer;
    }

    public void setDomain(String domain) {
        this._domain = domain;
    }

    public String getDomain() {
        return this._domain;
    }

    @Override
    public void beanAdded(Container parent, Object obj) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("beanAdded {}->{}", parent, obj);
        }
        if (obj == null) {
            return;
        }
        if (parent == null) {
            parent = ROOT;
        }
        if (this._beans.putIfAbsent(obj, parent) != null) {
            return;
        }
        ObjectName parentObjectName = null;
        if (parent != ROOT && (parentObjectName = this.findMBean(parent)) == null) {
            this.beanAdded(null, parent);
            parentObjectName = this.findMBean(parent);
        }
        try {
            Object mbean = ObjectMBean.mbeanFor(obj);
            if (mbean == null) {
                return;
            }
            ObjectName objectName = null;
            if (mbean instanceof ObjectMBean) {
                ((ObjectMBean)mbean).setMBeanContainer(this);
                objectName = ((ObjectMBean)mbean).getObjectName();
            }
            if (objectName == null) {
                AtomicInteger existing;
                String basis;
                AtomicInteger count;
                String name;
                String context;
                String type;
                int dot;
                String domain = this._domain;
                if (domain == null) {
                    domain = obj.getClass().getPackage().getName();
                }
                if ((dot = (type = obj.getClass().getName().toLowerCase(Locale.ENGLISH)).lastIndexOf(46)) >= 0) {
                    type = type.substring(dot + 1);
                }
                StringBuilder buf = new StringBuilder();
                String string = context = mbean instanceof ObjectMBean ? this.makeName(((ObjectMBean)mbean).getObjectContextBasis()) : null;
                if (context == null && parentObjectName != null) {
                    context = parentObjectName.getKeyProperty("context");
                }
                if (context != null && context.length() > 1) {
                    buf.append("context=").append(context).append(",");
                }
                buf.append("type=").append(type);
                String string2 = name = mbean instanceof ObjectMBean ? this.makeName(((ObjectMBean)mbean).getObjectNameBasis()) : context;
                if (name != null && name.length() > 1) {
                    buf.append(",").append("name=").append(name);
                }
                if ((count = (AtomicInteger)__unique.get(basis = buf.toString())) == null && (existing = __unique.putIfAbsent(basis, count = new AtomicInteger())) != null) {
                    count = existing;
                }
                objectName = ObjectName.getInstance(domain + ":" + basis + ",id=" + count.getAndIncrement());
            }
            this._mbeanServer.registerMBean(mbean, objectName);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Registered {}", objectName);
            }
            this._mbeans.put(obj, objectName);
        }
        catch (Throwable x) {
            LOG.warn("bean: " + obj, x);
        }
    }

    @Override
    public void beanRemoved(Container parent, Object obj) {
        ObjectName objectName;
        if (LOG.isDebugEnabled()) {
            LOG.debug("beanRemoved {}->{}", parent, obj);
        }
        if (parent == null) {
            parent = ROOT;
        }
        if (this._beans.remove(obj, parent) && (objectName = (ObjectName)this._mbeans.remove(obj)) != null) {
            this.unregister(objectName);
        }
    }

    public String makeName(String basis) {
        if (basis == null) {
            return null;
        }
        return basis.replace(':', '_').replace('*', '_').replace('?', '_').replace('=', '_').replace(',', '_').replace(' ', '_');
    }

    @Override
    public void dump(Appendable out, String indent) throws IOException {
        ContainerLifeCycle.dumpObject(out, this);
        ContainerLifeCycle.dump(out, indent, this._mbeans.entrySet());
    }

    @Override
    public String dump() {
        return ContainerLifeCycle.dump(this);
    }

    @Override
    public void destroy() {
        this._mbeans.values().stream().filter(Objects::nonNull).forEach(this::unregister);
        this._mbeans.clear();
        this._beans.clear();
    }

    private void unregister(ObjectName objectName) {
        try {
            this.getMBeanServer().unregisterMBean(objectName);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Unregistered {}", objectName);
            }
        }
        catch (InstanceNotFoundException | MBeanRegistrationException x) {
            LOG.ignore(x);
        }
        catch (Throwable x) {
            LOG.warn(x);
        }
    }
}

