/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.sdk.tools;

import com.javonet.sdk.Javonet;
import com.javonet.sdk.tools.SdkMessageHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Objects;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;

public class BinariesUnloader {
    private static Dictionary<String, Boolean> binariesUnloaded = new Hashtable<String, Boolean>();

    public static Boolean extractBinariesFromJar(String runtimeName) {
        if (BinariesUnloader.isAndroid()) {
            return false;
        }
        if (binariesUnloaded.get(runtimeName) != null && binariesUnloaded.get(runtimeName).booleanValue()) {
            return binariesUnloaded.get(runtimeName) == false;
        }
        try {
            String binariesRuntimePath = BinariesUnloader.getBinariesSpecificPath(runtimeName);
            String currentVersion = BinariesUnloader.getManifestProperty("Version");
            String dir = BinariesUnloader.getJarPath(Javonet.class);
            String destDir = System.getProperty("user.dir");
            Path binariesPath = Paths.get(destDir, binariesRuntimePath);
            if (!Files.isDirectory(Paths.get(binariesRuntimePath, new String[0]), new LinkOption[0]) || BinariesUnloader.shouldUpdateBinaries(binariesPath, currentVersion)) {
                if (dir.contains("!")) {
                    try (JarInputStream jarStream = BinariesUnloader.getJarInputStream(dir);){
                        BinariesUnloader.extractFolderFromJar(jarStream, destDir, binariesRuntimePath);
                    }
                }
                try (JarFile jarFile = new JarFile(dir);){
                    BinariesUnloader.extractFolderFromJar(jarFile, destDir, binariesRuntimePath);
                }
            }
            binariesUnloaded.put(runtimeName, true);
        }
        catch (IOException e) {
            SdkMessageHelper.GetInstance().sendMessageToAppInsights("SdkException", "BinariesUnloader exception: " + e.getMessage());
            binariesUnloaded.put(runtimeName, false);
        }
        return binariesUnloaded.get(runtimeName) == false;
    }

    private static JarInputStream getJarInputStream(String jarFilePath) throws IOException {
        URL jarUrl = new URL(jarFilePath);
        JarURLConnection jarConnection = (JarURLConnection)jarUrl.openConnection();
        return new JarInputStream(jarConnection.getInputStream());
    }

    private static void extractFolderFromJar(Object jar, String destDir, String folderPath) throws IOException {
        if (jar instanceof JarFile) {
            JarFile jarFile = (JarFile)jar;
            Enumeration<JarEntry> enumEntries = jarFile.entries();
            while (enumEntries.hasMoreElements()) {
                JarEntry file = enumEntries.nextElement();
                BinariesUnloader.extractFileFromJarEntry(jarFile, file, destDir, folderPath);
            }
        } else {
            JarEntry entry;
            JarInputStream jarStream = (JarInputStream)jar;
            while ((entry = jarStream.getNextJarEntry()) != null) {
                BinariesUnloader.extractFileFromJarEntry(jarStream, entry, destDir, folderPath);
            }
        }
    }

    private static void extractFileFromJarEntry(Object jar, JarEntry file, String destDir, String folderPath) throws IOException {
        File f = new File(destDir + File.separator + file.getName());
        if (file.isDirectory() && file.getName().startsWith(folderPath)) {
            f.mkdirs();
            return;
        }
        if (file.getName().startsWith(folderPath)) {
            InputStream in = jar instanceof JarFile ? ((JarFile)jar).getInputStream(file) : (JarInputStream)jar;
            try (FileOutputStream out = new FileOutputStream(f);){
                int len;
                byte[] buf = new byte[1024];
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
            }
        }
    }

    private static String getBinariesSpecificPath(String runtimeName) {
        String osArch = BinariesUnloader.getOsArch();
        String osName = BinariesUnloader.getOsName();
        String binariesPath = Objects.equals(runtimeName, "Native") || Objects.equals(runtimeName, "Perl") ? "Binaries/" + runtimeName + "/" + osName + "/" + osArch + "/" : "Binaries/" + runtimeName + "/";
        return binariesPath;
    }

    private static boolean isAndroid() {
        return System.getProperty("os.version").toLowerCase(Locale.US).contains("android");
    }

    private static String getJarPath(Class<?> aclass) {
        String suffix;
        URL url;
        try {
            url = aclass.getProtectionDomain().getCodeSource().getLocation();
        }
        catch (SecurityException ex) {
            url = aclass.getResource(aclass.getSimpleName() + ".class");
        }
        String extURL = url.toExternalForm();
        if (extURL.contains(".jar!")) {
            return extURL;
        }
        if (!extURL.endsWith(".jar") && (extURL = extURL.replace(suffix = "/" + aclass.getName().replace(".", "/") + ".class", "")).startsWith("jar:") && extURL.endsWith(".jar!")) {
            extURL = extURL.substring(4);
        }
        try {
            return new File(new URL(extURL).toURI()).getAbsolutePath();
        }
        catch (MalformedURLException | URISyntaxException ex) {
            return new File(url.getPath()).getAbsolutePath();
        }
    }

    public static String getManifestProperty(String propertyName) throws IOException {
        Enumeration<URL> resources = BinariesUnloader.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
        while (resources.hasMoreElements()) {
            InputStream input = resources.nextElement().openStream();
            Throwable throwable = null;
            try {
                Manifest manifest = new Manifest(input);
                Attributes mainAttributes = manifest.getMainAttributes();
                String value = mainAttributes.getValue(propertyName);
                if (value == null) continue;
                String string = value;
                return string;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (input == null) continue;
                if (throwable != null) {
                    try {
                        input.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                input.close();
            }
        }
        return null;
    }

    private static boolean shouldUpdateBinaries(Path binariesPath, String currentVersion) throws IOException {
        Path versionFile = Paths.get(binariesPath.toString(), "version.txt");
        if (Files.exists(versionFile, new LinkOption[0])) {
            String oldVersion = new String(Files.readAllBytes(versionFile), StandardCharsets.UTF_8);
            return !(oldVersion = oldVersion.replace("'", "")).equals(currentVersion);
        }
        return true;
    }

    private static String getOsArch() {
        String osArch = System.getProperty("os.arch").contains("64") ? "X64" : "X86";
        return osArch;
    }

    private static String getOsName() {
        String osName = System.getProperty("os.name").toLowerCase(Locale.ROOT);
        if (osName.contains("win")) {
            return "Windows";
        }
        if (osName.contains("mac")) {
            return "MacOs";
        }
        return "Linux";
    }
}

