/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.utils;

public class HandlerUtils {
    public static Class<?>[] getArgumentTypesAsBoxed(Object[] arguments) {
        return HandlerUtils.mapArgumentTypes(arguments, false);
    }

    public static Class<?>[] getArgumentTypesAsPrimitives(Object[] arguments) {
        return HandlerUtils.mapArgumentTypes(arguments, true);
    }

    private static Class<?>[] mapArgumentTypes(Object[] arguments, boolean toPrimitive) {
        Class[] argumentTypes = new Class[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            if (arguments[i] == null) {
                argumentTypes[i] = Object.class;
                continue;
            }
            Class<?> classType = arguments[i].getClass();
            argumentTypes[i] = HandlerUtils.mapType(classType, toPrimitive);
        }
        return argumentTypes;
    }

    private static Class<?> mapType(Class<?> classType, boolean toPrimitive) {
        if (classType == Integer.class) {
            return toPrimitive ? Integer.TYPE : Integer.class;
        }
        if (classType == Double.class) {
            return toPrimitive ? Double.TYPE : Double.class;
        }
        if (classType == Float.class) {
            return toPrimitive ? Float.TYPE : Float.class;
        }
        if (classType == Short.class) {
            return toPrimitive ? Short.TYPE : Short.class;
        }
        if (classType == Long.class) {
            return toPrimitive ? Long.TYPE : Long.class;
        }
        if (classType == Boolean.class) {
            return toPrimitive ? Boolean.TYPE : Boolean.class;
        }
        if (classType == Byte.class) {
            return toPrimitive ? Byte.TYPE : Byte.class;
        }
        if (classType == Character.class) {
            return toPrimitive ? Character.TYPE : Character.class;
        }
        return classType;
    }
}

