package Business::EDI::CodeList::EquipmentSizeAndTypeDescriptionCode;

use base 'Business::EDI::CodeList';
my $VERSION     = 0.01;
my $list_number = 8155;
my $usage       = 'B';

# 8155  Equipment size and type description code                [B]
# Desc: Code specifying the size and type of equipment.
# Repr: an..10

my %code_hash = (
'1' => [ 'Dime coated tank',
    'A tank coated with dime.' ],
'2' => [ 'Epoxy coated tank',
    'A tank coated with epoxy.' ],
'6' => [ 'Pressurized tank',
    'A tank capable of holding pressurized goods.' ],
'7' => [ 'Refrigerated tank',
    'A tank capable of keeping goods refrigerated.' ],
'9' => [ 'Stainless steel tank',
    'A tank made of stainless steel.' ],
'10' => [ 'Nonworking reefer container 40 ft',
    'A 40 foot refrigerated container that is not actively controlling temperature of the product.' ],
'12' => [ 'Europallet',
    '80 x 120 cm.' ],
'13' => [ 'Scandinavian pallet',
    '100 x 120 cm.' ],
'14' => [ 'Trailer',
    'Non self-propelled vehicle designed for the carriage of cargo so that it can be towed by a motor vehicle.' ],
'15' => [ 'Nonworking reefer container 20 ft',
    'A 20 foot refrigerated container that is not actively controlling temperature of the product.' ],
'16' => [ 'Exchangeable pallet',
    'Standard pallet exchangeable following international convention.' ],
'17' => [ 'Semi-trailer',
    'Non self propelled vehicle without front wheels designed for the carriage of cargo and provided with a kingpin.' ],
'18' => [ 'Tank container 20 feet',
    'A tank container with a length of 20 feet.' ],
'19' => [ 'Tank container 30 feet',
    'A tank container with a length of 30 feet.' ],
'20' => [ 'Tank container 40 feet',
    'A tank container with a length of 40 feet.' ],
'21' => [ 'Container IC 20 feet',
    'A container owned by InterContainer, a European railway subsidiary, with a length of 20 feet.' ],
'22' => [ 'Container IC 30 feet',
    'A container owned by InterContainer, a European railway subsidiary, with a length of 30 feet.' ],
'23' => [ 'Container IC 40 feet',
    'A container owned by InterContainer, a European railway subsidiary, with a length of 40 feet.' ],
'24' => [ 'Refrigerated tank 20 feet',
    'A refrigerated tank with a length of 20 feet.' ],
'25' => [ 'Refrigerated tank 30 feet',
    'A refrigerated tank with a length of 30 feet.' ],
'26' => [ 'Refrigerated tank 40 feet',
    'A refrigerated tank with a length of 40 feet.' ],
'27' => [ 'Tank container IC 20 feet',
    'A tank container owned by InterContainer, a European railway subsidiary, with a length of 20 feet.' ],
'28' => [ 'Tank container IC 30 feet',
    'A tank container owned by InterContainer, a European railway subsidiary, with a length of 30 feet.' ],
'29' => [ 'Tank container IC 40 feet',
    'A tank container, owned by InterContainer, a European railway subsidiary, with a length of 40 feet.' ],
'30' => [ 'Refrigerated tank IC 20 feet',
    'A refrigerated tank owned by InterContainer, a European railway subsidiary, with a length of 20 feet.' ],
'31' => [ 'Temperature controlled container 30 ft.',
    'Temperature controlled container measuring 30 feet.' ],
'32' => [ 'Refrigerated tank IC 40 feet',
    'A refrigerated tank owned by InterContainer, a European railway subsidiary, with a length of 40 feet.' ],
'33' => [ 'Movable case: L < 6,15m',
    'A movable case with a length less than 6,15 metres.' ],
'34' => [ 'Movable case: 6,15m < L < 7,82m',
    'A movable case with a length between 6,15 metres and 7,82 metres.' ],
'35' => [ 'Movable case: 7,82m < L < 9,15m',
    'A movable case with a length between 7,82 metres and 9,15 metres.' ],
'36' => [ 'Movable case: 9,15m < L < 10,90m',
    'A movable case with a length between 9,15 metres and 10,90 metres.' ],
'37' => [ 'Movable case: 10,90m < L < 13,75m',
    'A movable case with a length between 10,90 metres and 13,75 metres.' ],
'38' => [ 'Totebin',
    'A steel open top unit of about 1,5 * 1,5 * 2,5 meters for road transport of bulk cargo.' ],
'39' => [ 'Temperature controlled container 20 ft',
    'Temperature controlled container measuring 20 feet.' ],
'40' => [ 'Temperature controlled container 40 ft',
    'A temperature controlled container measuring 40 feet.' ],
'41' => [ 'Non working refrigerated (reefer) container 30ft.',
    'A 30 foot refrigerated (reefer) container that is not actively cooling the product.' ],
'42' => [ 'Dual trailers',
    'Two trailers linked together one behind another and pulled by one tractor.' ],
'43' => [ '20 ft IL container (open top)',
    'An open top container that is 20 feet in internal length.' ],
'44' => [ '20 ft IL container (closed top)',
    'A closed top container that is 20 feet in internal length.' ],
'45' => [ '40 ft IL container (closed top)',
    'A closed top container that is 40 feet in internal length.' ],
);
sub get_codes { return \%code_hash; }

1;
