package Business::EDI::CodeList::DocumentNameCode;

use base 'Business::EDI::CodeList';
my $VERSION     = 0.02;
sub list_number {1001;}
my $usage       = 'C';

# *    1001  Document name code                                      [C]
# Desc: Code specifying the document name.
# Repr: an..3

my %code_hash = (
'1' => [ 'Certificate of analysis',
    'Certificate providing the values of an analysis.' ],
'2' => [ 'Certificate of conformity',
    'Certificate certifying the conformity to predefined definitions.' ],
'3' => [ 'Certificate of quality',
    'Certificate certifying the quality of goods, services etc.' ],
'4' => [ 'Test report',
    'Report providing the results of a test session.' ],
'5' => [ 'Product performance report',
    'Report specifying the performance values of products.' ],
'6' => [ 'Product specification report',
    'Report providing specification values of products.' ],
'7' => [ 'Process data report',
    'Reports on events during production process.' ],
'8' => [ 'First sample test report',
    'Document/message describes the test report of the first sample.' ],
'9' => [ 'Price/sales catalogue',
    'A document/message to enable the transmission of information regarding pricing and catalogue details for goods and services offered by a seller to a buyer.' ],
'10' => [ 'Party information',
    'Document/message providing basic data concerning a party.' ],
'11' => [ 'Federal label approval',
    'A pre-approved document relating to federal label approval requirements.' ],
'12' => [ 'Mill certificate',
    'Certificate certifying a specific quality of agricultural products.' ],
'13' => [ 'Post receipt',
    'Document/message which evidences the transport of goods by post (e.g. mail, parcel, etc.).' ],
'14' => [ 'Weight certificate',
    'Certificate certifying the weight of goods.' ],
'15' => [ 'Weight list',
    'Document/message specifying the weight of goods.' ],
'16' => [ 'Certificate',
    'Document by means of which the documentary credit applicant specifies the conditions for the certificate and by whom the certificate is to be issued.' ],
'17' => [ 'Combined certificate of value and origin',
    'Document identifying goods in which the issuing authority expressly certifies that the goods originate in a specific country or part of, or group of countries. It also states the price and/or cost of the goods with the purpose of determining the customs origin.' ],
'18' => [ 'Movement certificate A.TR.1',
    'Specific form of transit declaration issued by the exporter (movement certificate).' ],
'19' => [ 'Certificate of quantity',
    'Certificate certifying the quantity of goods, services etc.' ],
'20' => [ 'Quality data message',
    'Usage of QALITY-message.' ],
'21' => [ 'Query',
    'Request information based on defined criteria.' ],
'22' => [ 'Response to query',
    'Document/message returned as an answer to a question.' ],
'23' => [ 'Status information',
    'Information regarding the status of a related message.' ],
'24' => [ 'Restow',
    'Message/document identifying containers that have been unloaded and then reloaded onto the same means of transport.' ],
'25' => [ 'Container discharge list',
    'Message/document itemising containers to be discharged from vessel.' ],
'26' => [ 'Corporate superannuation contributions advice',
    'Document/message providing contributions advice used for corporate superannuation schemes.' ],
'27' => [ 'Industry superannuation contributions advice',
    'Document/message providing contributions advice used for superannuation schemes which are industry wide.' ],
'28' => [ 'Corporate superannuation member maintenance message',
    'Member maintenance message used for corporate superannuation schemes.' ],
'29' => [ 'Industry superannuation member maintenance message',
    'Member maintenance message used for industry wide superannuation schemes.' ],
'30' => [ 'Life insurance payroll deductions advice',
    'Payroll deductions advice used in the life insurance industry.' ],
'31' => [ 'Underbond request',
    'A Message/document requesting to move cargo from one Customs control point to another.' ],
'32' => [ 'Underbond approval',
    'A message/document issuing Customs approval to move cargo from one Customs control point to another.' ],
'33' => [ 'Certificate of sealing of export meat lockers',
    'Document / message issued by the authority in the exporting country evidencing the sealing of export meat lockers.' ],
'34' => [ 'Cargo status',
    'Message identifying the status of cargo.' ],
'35' => [ 'Inventory report',
    'A message specifying information relating to held inventories.' ],
'36' => [ 'Identity card',
    'Official document to identify a person.' ],
'37' => [ 'Response to a trade statistics message',
    'Document/message in which the competent national authorities provide a declarant with an acceptance or a rejection about a received declaration for European statistical purposes.' ],
'38' => [ 'Vaccination certificate',
    'Official document proving immunisation against certain diseases.' ],
'39' => [ 'Passport',
    'An official document giving permission to travel in foreign countries.' ],
'40' => [ 'Driving licence (national)',
    'An official document giving permission to drive a car in a given country.' ],
'41' => [ 'Driving licence (international)',
    'An official document giving a native of one country permission to drive a vehicle in certain other countries.' ],
'42' => [ 'Free pass',
    'A document giving free access to a service.' ],
'43' => [ 'Season ticket',
    'A document giving access to a service for a determined period of time.' ],
'44' => [ 'Transport status report',
    '(1125) A message to report the transport status and/or change in the transport status (i.e. event) between agreed parties.' ],
'45' => [ 'Transport status request',
    '(1127) A message to request a transport status report (e.g. through the national multimodal status report message IFSTA).' ],
'46' => [ 'Banking status',
    'A banking status document and/or message.' ],
'47' => [ 'Extra-Community trade statistical declaration',
    'Document/message in which a declarant provides information about extra-Community trade of goods required by the body responsible for the collection of trade statistics. Trade by a country in the European Union with a country outside the European Union.' ],
'48' => [ 'Written instructions in conformance with ADR article number',
    '10385 Written instructions relating to dangerous goods and defined in the European Agreement of Dangerous Transport by Road known as ADR (Accord europeen relatif au transport international des marchandises Dangereuses par Route).' ],
'49' => [ 'Damage certification',
    'Official certification that damages to the goods to be transported have been discovered.' ],
'50' => [ 'Validated priced tender',
    'A validated priced tender.' ],
'51' => [ 'Price/sales catalogue response',
    'A document providing a response to a previously sent price/sales catalogue.' ],
'52' => [ 'Price negotiation result',
    'A document providing the result of price negotiations.' ],
'53' => [ 'Safety and hazard data sheet',
    'Document or message to supply advice on a dangerous or hazardous material to industrial customers so as to enable them to take measures to protect their employees and the environment from any potential harmful effects from these material.' ],
'54' => [ 'Legal statement of an account',
    'A statement of an account containing the booked items as in the ledger of the account servicing financial institution.' ],
'55' => [ 'Listing statement of an account',
    'A statement from the account servicing financial institution containing items pending to be booked.' ],
'56' => [ 'Closing statement of an account',
    'Last statement of a period containing the interest calculation and the final balance of the last entry date.' ],
'57' => [ 'Transport equipment on-hire report',
    'Report on the movement of containers or other items of transport equipment to record physical movement activity and establish the beginning of a rental period.' ],
'58' => [ 'Transport equipment off-hire report',
    'Report on the movement of containers or other items of transport equipment to record physical movement activity and establish the end of a rental period.' ],
'59' => [ 'Treatment - nil outturn',
    'No shortage, surplus or damaged outturn resulting from container vessel unpacking.' ],
'60' => [ 'Treatment - time-up underbond',
    'Movement type indicator: goods are moved under customs control for warehousing due to being time-up.' ],
'61' => [ 'Treatment - underbond by sea',
    'Movement type indicator: goods are to move by sea under customs control to a customs office where formalities will be completed.' ],
'62' => [ 'Treatment - personal effect',
    'Cargo consists of personal effects.' ],
'63' => [ 'Treatment - timber',
    'Cargo consists of timber.' ],
'64' => [ 'Preliminary credit assessment',
    "Document/message issued either by a factor to indicate his preliminary credit assessment on a buyer, or by a seller to request a factor's preliminary credit assessment on a buyer." ],
'65' => [ 'Credit cover',
    "Document/message issued either by a factor to give a credit cover on a buyer, or by a seller to request a factor's credit cover." ],
'66' => [ 'Current account',
    "Document/message issued by a factor to indicate the money movements of a seller's or another factor's account with him." ],
'67' => [ 'Commercial dispute',
    'Document/message issued by a party (usually the buyer) to indicate that one or more invoices or one or more credit notes are disputed for payment.' ],
'68' => [ 'Chargeback',
    'Document/message issued by a factor to a seller or to another factor to indicate that the rest of the amounts of one or more invoices uncollectable from buyers are charged back to clear the invoice(s) off the ledger.' ],
'69' => [ 'Reassignment',
    'Document/message issued by a factor to a seller or to another factor to reassign an invoice or credit note previously assigned to him.' ],
'70' => [ 'Collateral account',
    "Document message issued by a factor to indicate the movements of invoices, credit notes and payments of a seller's account." ],
'71' => [ 'Request for payment',
    'Document/message issued by a creditor to a debtor to request payment of one or more invoices past due.' ],
'72' => [ 'Unship permit',
    'A message or document issuing permission to unship cargo.' ],
'73' => [ 'Statistical definitions',
    'Transmission of one or more statistical definitions.' ],
'74' => [ 'Statistical data',
    'Transmission of one or more items of data or data sets.' ],
'75' => [ 'Request for statistical data',
    'Request for one or more items or data sets of statistical data.' ],
'76' => [ 'Call-off delivery',
    'Document/message to provide split quantities and delivery dates referring to a previous delivery instruction.' ],
'77' => [ 'Consignment status report',
    'Message covers information about the consignment status.' ],
'78' => [ 'Inventory movement advice',
    'Advice of inventory movements.' ],
'79' => [ 'Inventory status advice',
    'Advice of stock on hand.' ],
'80' => [ 'Debit note related to goods or services',
    'Debit information related to a transaction for goods or services to the relevant party.' ],
'81' => [ 'Credit note related to goods or services',
    'Document message used to provide credit information related to a transaction for goods or services to the relevant party.' ],
'82' => [ 'Metered services invoice',
    'Document/message claiming payment for the supply of metered services (e.g., gas, electricity, etc.) supplied to a fixed meter whose consumption is measured over a period of time.' ],
'83' => [ 'Credit note related to financial adjustments',
    'Document message for providing credit information related to financial adjustments to the relevant party, e.g., bonuses.' ],
'84' => [ 'Debit note related to financial adjustments',
    'Document/message for providing debit information related to financial adjustments to the relevant party.' ],
'85' => [ 'Customs manifest',
    'Message/document identifying a customs manifest. The document itemises a list of cargo prepared by shipping companies from bills of landing and presented to customs for formal report of cargo.' ],
'86' => [ 'Vessel unpack report',
    'A document code to indicate that the message being transmitted identifies all short and surplus cargoes off-loaded from a vessel at a specified discharging port.' ],
'87' => [ 'General cargo summary manifest report',
    'A document code to indicate that the message being transmitted is summary manifest information for general cargo.' ],
'88' => [ 'Consignment unpack report',
    'A document code to indicate that the message being transmitted is a consignment unpack report only.' ],
'89' => [ 'Meat and meat by-products sanitary certificate',
    'Document or message issued by the competent authority in the exporting country evidencing that meat or meat by- products comply with the requirements set by the importing country.' ],
'90' => [ 'Meat food products sanitary certificate',
    'Document or message issued by the competent authority in the exporting country evidencing that meat food products comply with the requirements set by the importing country.' ],
'91' => [ 'Poultry sanitary certificate',
    'Document or message issued by the competent authority in the exporting country evidencing that poultry products comply with the requirements set by the importing country.' ],
'92' => [ 'Horsemeat sanitary certificate',
    'Document or message issued by the competent authority in the exporting country evidencing that horsemeat products comply with the requirements set by the importing country.' ],
'93' => [ 'Casing sanitary certificate',
    'Document or message issued by the competent authority in the exporting country evidencing that casing products comply with the requirements set by the importing country.' ],
'94' => [ 'Pharmaceutical sanitary certificate',
    'Document or message issued by the competent authority in the exporting country evidencing that pharmaceutical products comply with the requirements set by the importing country.' ],
'95' => [ 'Inedible sanitary certificate',
    'Document or message issued by the competent authority in the exporting country evidencing that inedible products comply with the requirements set by the importing country.' ],
'96' => [ 'Impending arrival',
    'Notification of impending arrival details for vessel.' ],
'97' => [ 'Means of transport advice',
    'Message reporting the means of transport used to carry goods or cargo.' ],
'98' => [ 'Arrival information',
    'Message reporting the arrival details of goods or cargo.' ],
'99' => [ 'Cargo release notification',
    'Message/document sent by the cargo handler indicating that the cargo has moved from a Customs controlled premise.' ],
'100' => [ 'Excise certificate',
    'Certificate asserting that the goods have been submitted to the excise authorities before departure from the exporting country or before delivery in case of import traffic.' ],
'101' => [ 'Registration document',
    'An official document providing registration details.' ],
'102' => [ 'Tax notification',
    'Used to specify that the message is a tax notification.' ],
'103' => [ 'Transport equipment direct interchange report',
    'Report on the movement of containers or other items of transport equipment being exchanged, establishing relevant rental periods.' ],
'104' => [ 'Transport equipment impending arrival advice',
    'Advice that containers or other items of transport equipment may be expected to be delivered to a certain location.' ],
'105' => [ 'Purchase order',
    'Document/message issued within an enterprise to initiate the purchase of articles, materials or services required for the production or manufacture of goods to be offered for sale or otherwise supplied to customers.' ],
'106' => [ 'Transport equipment damage report',
    'Report of damaged items of transport equipment that have been returned.' ],
'107' => [ 'Transport equipment maintenance and repair work estimate',
    'advice Advice providing estimates of transport equipment maintenance and repair costs.' ],
'108' => [ 'Transport equipment empty release instruction',
    'Instruction to release an item of empty transport equipment to a specified party or parties.' ],
'109' => [ 'Transport movement gate in report',
    'Report on the inward movement of cargo, containers or other items of transport equipment which have been delivered to a facility by an inland carrier.' ],
'110' => [ 'Manufacturing instructions',
    'Document/message issued within an enterprise to initiate the manufacture of goods to be offered for sale.' ],
'111' => [ 'Transport movement gate out report',
    'Report on the outward movement of cargo, containers or other items of transport equipment (either full or empty) which have been picked up by an inland carrier.' ],
'112' => [ 'Transport equipment unpacking instruction',
    'Instruction to unpack specified cargo from specified containers or other items of transport equipment.' ],
'113' => [ 'Transport equipment unpacking report',
    'Report on the completion of unpacking specified containers or other items of transport equipment.' ],
'114' => [ 'Transport equipment pick-up availability request',
    'Request for confirmation that an item of transport equipment will be available for collection.' ],
'115' => [ 'Transport equipment pick-up availability confirmation',
    'Confirmation that an item of transport equipment is available for collection.' ],
'116' => [ 'Transport equipment pick-up report',
    'Report that an item of transport equipment has been collected.' ],
'117' => [ 'Transport equipment shift report',
    'Report on the movement of containers or other items of transport within a facility.' ],
'118' => [ 'Transport discharge instruction',
    'Instruction to unload specified cargo, containers or transport equipment from a means of transport.' ],
'119' => [ 'Transport discharge report',
    'Report on cargo, containers or transport equipment unloaded from a particular means of transport.' ],
'120' => [ 'Stores requisition',
    'Document/message issued within an enterprise ordering the taking out of stock of goods.' ],
'121' => [ 'Transport loading instruction',
    'Instruction to load cargo, containers or transport equipment onto a means of transport.' ],
'122' => [ 'Transport loading report',
    'Report on completion of loading cargo, containers or other transport equipment onto a means of transport.' ],
'123' => [ 'Transport equipment maintenance and repair work',
    'authorisation Authorisation to have transport equipment repaired or to have maintenance performed.' ],
'124' => [ 'Transport departure report',
    'Report of the departure of a means of transport from a particular facility.' ],
'125' => [ 'Transport empty equipment advice',
    'Advice that an item or items of empty transport equipment are available for return.' ],
'126' => [ 'Transport equipment acceptance order',
    'Order to accept items of transport equipment which are to be delivered by an inland carrier (rail, road or barge) to a specified facility.' ],
'127' => [ 'Transport equipment special service instruction',
    'Instruction to perform a specified service or services on an item or items of transport equipment.' ],
'128' => [ 'Transport equipment stock report',
    'Report on the number of items of transport equipment stored at one or more locations.' ],
'129' => [ 'Transport cargo release order',
    'Order to release cargo or items of transport equipment to a specified party.' ],
'130' => [ 'Invoicing data sheet',
    'Document/message issued within an enterprise containing data about goods sold, to be used as the basis for the preparation of an invoice.' ],
'131' => [ 'Transport equipment packing instruction',
    'Instruction to pack cargo into a container or other item of transport equipment.' ],
'132' => [ 'Customs clearance notice',
    'Notification of customs clearance of cargo or items of transport equipment.' ],
'133' => [ 'Customs documents expiration notice',
    'Notice specifying expiration of Customs documents relating to cargo or items of transport equipment.' ],
'134' => [ 'Transport equipment on-hire request',
    'Request for transport equipment to be made available for hire.' ],
'135' => [ 'Transport equipment on-hire order',
    'Order to release empty items of transport equipment for on-hire to a lessee, and authorising collection by or on behalf of a specified party.' ],
'136' => [ 'Transport equipment off-hire request',
    'Request to terminate the lease on an item of transport equipment at a specified time.' ],
'137' => [ 'Transport equipment survey order',
    'Order to perform a survey on specified items of transport equipment.' ],
'138' => [ 'Transport equipment survey order response',
    'Response to an order to conduct a survey of transport equipment.' ],
'139' => [ 'Transport equipment survey report',
    'Survey report of specified items of transport equipment.' ],
'140' => [ 'Packing instructions',
    'Document/message within an enterprise giving instructions on how goods are to be packed.' ],
'141' => [ 'Advising items to be booked to a financial account',
    'A document and/or message advising of items which have to be booked to a financial account.' ],
'142' => [ 'Transport equipment maintenance and repair work estimate',
    'order Order to draw up an estimate of the costs of maintenance or repair of transport equipment.' ],
'143' => [ 'Transport equipment maintenance and repair notice',
    'Report of transport equipment which has been repaired or has had maintenance performed.' ],
'144' => [ 'Empty container disposition order',
    'Order to make available empty containers.' ],
'145' => [ 'Cargo vessel discharge order',
    'Order that the containers or cargo specified are to be discharged from a vessel.' ],
'146' => [ 'Cargo vessel loading order',
    'Order that specified cargo, containers or groups of containers are to be loaded in or on a vessel.' ],
'147' => [ 'Multidrop order',
    'One purchase order that contains the orders of two or more vendors and the associated delivery points for each.' ],
'148' => [ 'Bailment contract',
    'A document authorizing the bailing of goods.' ],
'149' => [ 'Basic agreement',
    'A document indicating an agreement containing basic terms and conditions applicable to future contracts between two parties.' ],
'150' => [ 'Internal transport order',
    'Document/message giving instructions about the transport of goods within an enterprise.' ],
'151' => [ 'Grant',
    'A document indicating the granting of funds.' ],
'152' => [ 'Indefinite delivery indefinite quantity contract',
    'A document indicating a contract calling for the indefinite deliveries of indefinite quantities of goods.' ],
'153' => [ 'Indefinite delivery definite quantity contract',
    'A document indicating a contract calling for indefinite deliveries of definite quantities.' ],
'154' => [ 'Requirements contract',
    'A document indicating a requirements contract that authorizes the filling of all purchase requirements during a specified contract period.' ],
'155' => [ 'Task order',
    'A document indicating an order that tasks a contractor to perform a specified function.' ],
'156' => [ 'Make or buy plan',
    'A document indicating a plan that identifies which items will be made and which items will be bought.' ],
'157' => [ 'Subcontractor plan',
    "A document indicating a plan that identifies the manufacturer's subcontracting strategy for a specific contract." ],
'158' => [ 'Cost data summary',
    'A document indicating a summary of cost data.' ],
'159' => [ 'Certified cost and price data',
    'A document indicating cost and price data whose accuracy has been certified.' ],
'160' => [ 'Wage determination',
    'A document indicating a determination of the wages to be paid.' ],
'161' => [ 'Contract Funds Status Report (CFSR)',
    'A report to provide the status of funds applicable to the contract.' ],
'162' => [ 'Certified inspection and test results',
    'A certification as to the accuracy of inspection and test results.' ],
'163' => [ 'Material inspection and receiving report',
    'A report that is both an inspection report for materials and a receiving document.' ],
'164' => [ 'Purchasing specification',
    'A document indicating a specification used to purchase an item.' ],
'165' => [ 'Payment or performance bond',
    'A document indicating a bond that guarantees the payment of monies or a performance.' ],
'166' => [ 'Contract security classification specification',
    'A document that indicates the specification contains the security and classification requirements for a contract.' ],
'167' => [ 'Manufacturing specification',
    'A document indicating the specification of how an item is to be manufactured.' ],
'168' => [ 'Buy America certificate of compliance',
    'A document certifying that more than 50 percent of the cost of an item is attributed to US origin.' ],
'169' => [ 'Container off-hire notice',
    'Notice to return leased containers.' ],
'170' => [ 'Cargo acceptance order',
    'Order to accept cargo to be delivered by a carrier.' ],
'171' => [ 'Pick-up notice',
    'Notice specifying the pick-up of released cargo or containers from a certain address.' ],
'172' => [ 'Authorisation to plan and suggest orders',
    'Document or message that authorises receiver to plan orders, based on information in this message, and send these orders as suggestions to the sender.' ],
'173' => [ 'Authorisation to plan and ship orders',
    'Document or message that authorises receiver to plan and ship orders based on information in this message.' ],
'174' => [ 'Drawing',
    'The document or message is a drawing.' ],
'175' => [ 'Cost Performance Report (CPR) format 2',
    'A report identifying the cost performance on a contract at specified levels of the work breakdown structure (format 2 - organizational categories).' ],
'176' => [ 'Cost Schedule Status Report (CSSR)',
    'A report providing the status of the cost and schedule applicable to a contract.' ],
'177' => [ 'Cost Performance Report (CPR) format 1',
    "A report identifying the cost performance on a contract including the current month's values at specified levels of the work breakdown structure (format 1 - work breakdown structure)." ],
'178' => [ 'Cost Performance Report (CPR) format 3',
    'A report identifying the cost performance on a contract that summarizes changes to a contract over a given reporting period with beginning and ending values (format 3 - baseline).' ],
'179' => [ 'Cost Performance Report (CPR) format 4',
    'A report identifying the cost performance on a contract including forecasts of labour requirements for the remaining portion of the contract (format 4 - staffing).' ],
'180' => [ 'Cost Performance Report (CPR) format 5',
    'A report identifying the cost performance on a contract that summarizes cost or schedule variances (format 5 - explanations and problem analysis).' ],
'181' => [ 'Progressive discharge report',
    'Document or message progressively issued by the container terminal operator in charge of discharging a vessel identifying containers that have been discharged from a specific vessel at that point in time.' ],
'182' => [ 'Balance confirmation',
    'Confirmation of a balance at an entry date.' ],
'183' => [ 'Container stripping order',
    'Order to unload goods from a container.' ],
'184' => [ 'Container stuffing order',
    'Order to stuff specified goods or consignments in a container.' ],
'185' => [ 'Conveyance declaration (arrival)',
    'Declaration to the public authority upon arrival of the conveyance.' ],
'186' => [ 'Conveyance declaration (departure)',
    'Declaration to the public authority upon departure of the conveyance.' ],
'187' => [ 'Conveyance declaration (combined)',
    'Combined declaration of arrival and departure to the public authority.' ],
'188' => [ 'Project recovery plan',
    'A project plan for recovery after a delay or problem resolution.' ],
'189' => [ 'Project production plan',
    'A project plan for the production of goods.' ],
'190' => [ 'Statistical and other administrative internal documents',
    'Documents/messages issued within an enterprise for the for the purpose of collection of production and other internal statistics, and for other administration purposes.' ],
'191' => [ 'Project master schedule',
    'A high level, all encompassing master schedule of activities to complete a project.' ],
'192' => [ 'Priced alternate tender bill of quantity',
    'A priced tender based upon an alternate specification.' ],
'193' => [ 'Estimated priced bill of quantity',
    'An estimate based upon a detailed, quantity based specification (bill of quantity).' ],
'194' => [ 'Draft bill of quantity',
    'Document/message providing a draft bill of quantity, issued in an unpriced form.' ],
'195' => [ 'Documentary credit collection instruction',
    'Instruction for the collection of the documentary credit.' ],
'196' => [ 'Request for an amendment of a documentary credit',
    'Request for an amendment of a documentary credit.' ],
'197' => [ 'Documentary credit amendment information',
    'Documentary credit amendment information.' ],
'198' => [ 'Advice of an amendment of a documentary credit',
    'Advice of an amendment of a documentary credit.' ],
'199' => [ 'Response to an amendment of a documentary credit',
    'Response to an amendment of a documentary credit.' ],
'200' => [ 'Documentary credit issuance information',
    'Provides information on documentary credit issuance.' ],
'201' => [ 'Direct payment valuation request',
    'Request to establish a direct payment valuation.' ],
'202' => [ 'Direct payment valuation',
    'Document/message addressed, for instance, by a general contractor to the owner, in order that a direct payment be made to a subcontractor.' ],
'203' => [ 'Provisional payment valuation',
    'Document/message establishing a provisional payment valuation.' ],
'204' => [ 'Payment valuation',
    'Document/message establishing the financial elements of a situation of works.' ],
'205' => [ 'Quantity valuation',
    'Document/message providing a confirmed assessment, by quantity, of the completed work for a construction contract.' ],
'206' => [ 'Quantity valuation request',
    'Document/message providing an initial assessment, by quantity, of the completed work for a construction contract.' ],
'207' => [ 'Contract bill of quantities - BOQ',
    'Document/message providing a formal specification identifying quantities and prices that are the basis of a contract for a construction project. BOQ means: Bill of quantity.' ],
'208' => [ 'Unpriced bill of quantity',
    'Document/message providing a detailed, quantity based specification, issued in an unpriced form to invite tender prices.' ],
'209' => [ 'Priced tender BOQ',
    'Document/message providing a detailed, quantity based specification, updated with prices to form a tender submission for a construction contract. BOQ means: Bill of quantity.' ],
'210' => [ 'Enquiry',
    'Document/message issued by a party interested in the purchase of goods specified therein and indicating particular, desirable conditions regarding delivery terms, etc., addressed to a prospective supplier with a view to obtaining an offer.' ],
'211' => [ 'Interim application for payment',
    'Document/message containing a provisional assessment in support of a request for payment for completed work for a construction contract.' ],
'212' => [ 'Agreement to pay',
    'Document/message in which the debtor expresses the intention to pay.' ],
'213' => [ 'Request for financial cancellation',
    'The message is a request for financial cancellation.' ],
'214' => [ 'Pre-authorised direct debit(s)',
    'The message contains pre-authorised direct debit(s).' ],
'215' => [ 'Letter of intent',
    'Document/message by means of which a buyer informs a seller that the buyer intends to enter into contractual negotiations.' ],
'216' => [ 'Approved unpriced bill of quantity',
    'Document/message providing an approved detailed, quantity based specification (bill of quantity), in an unpriced form.' ],
'217' => [ 'Payment valuation for unscheduled items',
    'A payment valuation for unscheduled items.' ],
'218' => [ 'Final payment request based on completion of work',
    'The final payment request of a series of payment requests submitted upon completion of all the work.' ],
'219' => [ 'Payment request for completed units',
    'A request for payment for completed units.' ],
'220' => [ 'Order',
    'Document/message by means of which a buyer initiates a transaction with a seller involving the supply of goods or services as specified, according to conditions set out in an offer, or otherwise known to the buyer.' ],
'221' => [ 'Blanket order',
    'Usage of document/message for general order purposes with later split into quantities and delivery dates and maybe delivery locations.' ],
'222' => [ 'Spot order',
    "Document/message ordering the remainder of a production's batch." ],
'223' => [ 'Lease order',
    'Document/message for goods in leasing contracts.' ],
'224' => [ 'Rush order',
    'Document/message for urgent ordering.' ],
'225' => [ 'Repair order',
    'Document/message to order repair of goods.' ],
'226' => [ 'Call off order',
    'Document/message to provide split quantities and delivery dates referring to a previous blanket order.' ],
'227' => [ 'Consignment order',
    'Order to deliver goods into stock with agreement on payment when goods are sold out of this stock.' ],
'228' => [ 'Sample order',
    'Document/message to order samples.' ],
'229' => [ 'Swap order',
    'Document/message informing buyer or seller of the replacement of goods previously ordered.' ],
'230' => [ 'Purchase order change request',
    'Change to an purchase order already sent.' ],
'231' => [ 'Purchase order response',
    'Response to an purchase order already received.' ],
'232' => [ 'Hire order',
    'Document/message for hiring human resources or renting goods or equipment.' ],
'233' => [ 'Spare parts order',
    'Document/message to order spare parts.' ],
'234' => [ 'Campaign price/sales catalogue',
    'A price/sales catalogue containing special prices which are valid only for a specified period or under specified conditions.' ],
'235' => [ 'Container list',
    'Document or message issued by party identifying the containers for which they are responsible.' ],
'236' => [ 'Delivery forecast',
    'A message which enables the transmission of delivery or product forecasting requirements.' ],
'237' => [ 'Cross docking services order',
    'A document or message to order cross docking services.' ],
'238' => [ 'Non-pre-authorised direct debit(s)',
    'The message contains non-pre-authorised direct debit(s).' ],
'239' => [ 'Rejected direct debit(s)',
    'The message contains rejected direct debit(s).' ],
'240' => [ 'Delivery instructions',
    '(1174) Document/message giving instruction regarding the delivery of goods.' ],
'241' => [ 'Delivery schedule',
    'Usage of DELFOR-message.' ],
'242' => [ 'Delivery just-in-time',
    'Usage of DELJIT-message.' ],
'243' => [ 'Pre-authorised direct debit request(s)',
    'The message contains pre-authorised direct debit request(s).' ],
'244' => [ 'Non-pre-authorised direct debit request(s)',
    'The message contains non-pre-authorised direct debit request(s).' ],
'245' => [ 'Delivery release',
    'Document/message issued by a buyer releasing the despatch of goods after receipt of the Ready for despatch advice from the seller.' ],
'246' => [ 'Settlement of a letter of credit',
    'Settlement of a letter of credit.' ],
'247' => [ 'Bank to bank funds transfer',
    'The message is a bank to bank funds transfer.' ],
'248' => [ 'Customer payment order(s)',
    'The message contains customer payment order(s).' ],
'249' => [ 'Low value payment order(s)',
    'The message contains low value payment order(s) only.' ],
'250' => [ 'Crew list declaration',
    'Declaration regarding crew members aboard the conveyance.' ],
'251' => [ 'Inquiry',
    'This is a request for information.' ],
'252' => [ 'Response to previous banking status message',
    'A response to a previously sent banking status message.' ],
'253' => [ 'Project master plan',
    'A high level, all encompassing master plan to complete a project.' ],
'254' => [ 'Project plan',
    'A plan for project work to be completed.' ],
'255' => [ 'Project schedule',
    'A schedule of project activities to be completed.' ],
'256' => [ 'Project planning available resources',
    'Available resources for project planning purposes.' ],
'257' => [ 'Project planning calendar',
    'Work calendar information for project planning purposes.' ],
'258' => [ 'Standing order',
    'An order to supply fixed quantities of products at fixed regular intervals.' ],
'259' => [ 'Cargo movement event log',
    'A document detailing times and dates of events pertaining to a cargo movement.' ],
'260' => [ 'Cargo analysis voyage report',
    'An analysis of the cargo for a voyage.' ],
'261' => [ 'Self billed credit note',
    'A document which indicates that the customer is claiming credit in a self billing environment.' ],
'262' => [ 'Consolidated credit note - goods and services',
    'Credit note for goods and services that covers multiple transactions involving more than one invoice.' ],
'263' => [ 'Inventory adjustment status report',
    'A message detailing statuses related to the adjustment of inventory.' ],
'264' => [ 'Transport equipment movement instruction',
    'Instruction to perform one or more different movements of transport equipment.' ],
'265' => [ 'Transport equipment movement report',
    'Report on one or more different movements of transport equipment.' ],
'266' => [ 'Transport equipment status change report',
    'Report on one or more changes of status associated with an item or items of transport equipment.' ],
'267' => [ 'Fumigation certificate',
    'Certificate attesting that fumigation has been performed.' ],
'268' => [ 'Wine certificate',
    'Certificate attesting to the quality, origin or appellation of wine.' ],
'269' => [ 'Wool health certificate',
    'Certificate attesting that wool is free from specified risks to human or animal health.' ],
'270' => [ 'Delivery note',
    'Paper document attached to a consignment informing the receiving party about contents of this consignment.' ],
'271' => [ 'Packing list',
    'Document/message specifying the distribution of goods in individual packages (in trade environment the despatch advice message is used for the packing list).' ],
'272' => [ 'New code request',
    'Requesting a new code.' ],
'273' => [ 'Code change request',
    'Request a change to an existing code.' ],
'274' => [ 'Simple data element request',
    'Requesting a new simple data element.' ],
'275' => [ 'Simple data element change request',
    'Request a change to an existing simple data element.' ],
'276' => [ 'Composite data element request',
    'Requesting a new composite data element.' ],
'277' => [ 'Composite data element change request',
    'Request a change to an existing composite data element.' ],
'278' => [ 'Segment request',
    'Request a new segment.' ],
'279' => [ 'Segment change request',
    'Requesting a change to an existing segment.' ],
'280' => [ 'New message request',
    'Request for a new message (NMR).' ],
'281' => [ 'Message in development request',
    'Requesting a Message in Development (MiD).' ],
'282' => [ 'Modification of existing message',
    'Requesting a change to an existing message.' ],
'283' => [ 'Tracking number assignment report',
    'Report of assigned tracking numbers.' ],
'284' => [ 'User directory definition',
    'Document/message defining the contents of a user directory set or parts thereof.' ],
'285' => [ 'United Nations standard message request',
    'Requesting a United Nations Standard Message (UNSM).' ],
'286' => [ 'Service directory definition',
    'Document/message defining the contents of a service directory set or parts thereof.' ],
'287' => [ 'Status report',
    'Message covers information about the status.' ],
'288' => [ 'Kanban schedule',
    'Message to describe a Kanban schedule.' ],
'289' => [ 'Product data message',
    'A message to submit master data, a set of data that is rarely changed, to identify and describe products a supplier offers to their (potential) customer or buyer.' ],
'290' => [ 'A claim for parts and/or labour charges',
    'A claim for parts and/or labour charges incurred .' ],
'291' => [ 'Delivery schedule response',
    'A message providing a response to a previously transmitted delivery schedule.' ],
'292' => [ 'Inspection request',
    'A message requesting a party to inspect items.' ],
'293' => [ 'Inspection report',
    'A message informing a party of the results of an inspection.' ],
'294' => [ 'Application acknowledgement and error report',
    'A message used by an application to acknowledge reception of a message and/or to report any errors.' ],
'295' => [ 'Price variation invoice',
    'An invoice which requests payment for the difference in price between an original invoice and the result of the application of a price variation formula.' ],
'296' => [ 'Credit note for price variation',
    'A credit note which is issued against a price variation invoice.' ],
'297' => [ 'Instruction to collect',
    'A message instructing a party to collect goods.' ],
'298' => [ 'Dangerous goods list',
    'Listing of all details of dangerous goods carried.' ],
'299' => [ 'Registration renewal',
    'Code specifying the continued validity of previously submitted registration information.' ],
'300' => [ 'Registration change',
    'Code specifying the modification of previously submitted registration information.' ],
'301' => [ 'Response to registration',
    'Code specifying a response to an occurrence of a registration message.' ],
'302' => [ 'Implementation guideline',
    'A document specifying the criterion and format for exchanging information in an electronic data interchange syntax.' ],
'303' => [ 'Request for transfer',
    'Document/message is a request for transfer.' ],
'304' => [ 'Cost performance report',
    'A report to convey cost performance data for a project or contract.' ],
'305' => [ 'Application error and acknowledgement',
    "A message to inform a message issuer that a previously sent message has been received by the addressee's application, or that a previously sent message has been rejected by the addressee's application." ],
'306' => [ 'Cash pool financial statement',
    'A financial statement for a cash pool.' ],
'307' => [ 'Sequenced delivery schedule',
    'Message to describe a sequence of product delivery.' ],
'308' => [ 'Delcredere credit note',
    'A credit note sent to the party paying on behalf of a number of buyers.' ],
'309' => [ 'Healthcare discharge report, final',
    'Final discharge report by healthcare provider.' ],
'310' => [ 'Offer / quotation',
    '(1332) Document/message which, with a view to concluding a contract, sets out the conditions under which the goods are offered.' ],
'311' => [ 'Request for quote',
    'Document/message requesting a quote on specified goods or services.' ],
'312' => [ 'Acknowledgement message',
    'Message providing acknowledgement information at the business application level concerning the processing of a message.' ],
'313' => [ 'Application error message',
    'Message indicating that a message was rejected due to errors encountered at the application level.' ],
'314' => [ 'Cargo movement voyage summary',
    'A consolidated voyage summary which contains the information in a certificate of analysis, a voyage analysis and a cargo movement time log for a voyage.' ],
'315' => [ 'Contract',
    '(1296) Document/message evidencing an agreement between the seller and the buyer for the supply of goods or services; its effects are equivalent to those of an order followed by an acknowledgement of order.' ],
'316' => [ 'Application for usage of berth or mooring facilities',
    'Document to apply for usage of berth or mooring facilities.' ],
'317' => [ 'Application for designation of berthing places',
    'Document to apply for designation of berthing places.' ],
'318' => [ 'Application for shifting from the designated place in port',
    'Document to apply for shifting from the designated place in port.' ],
'319' => [ 'Supplementary document for application for cargo operation',
    'of dangerous goods Supplementary document to apply for cargo operation of dangerous goods.' ],
'320' => [ 'Acknowledgement of order',
    'Document/message acknowledging an undertaking to fulfil an order and confirming conditions or acceptance of conditions.' ],
'321' => [ 'Supplementary document for application for transport of',
    'dangerous goods Supplementary document to apply for transport of dangerous goods.' ],
'322' => [ 'Optical Character Reading (OCR) payment',
    'Payment effected by an Optical Character Reading (OCR) document.' ],
'323' => [ 'Preliminary sales report',
    'Preliminary sales report sent before all the information is available.' ],
'324' => [ 'Transport emergency card',
    'Official document specifying, for a given dangerous goods item, information such as nature of hazard, protective devices, actions to be taken in case of accident, spillage or fire and first aid to be given.' ],
'325' => [ 'Proforma invoice',
    'Document/message serving as a preliminary invoice, containing - on the whole - the same information as the final invoice, but not actually claiming payment.' ],
'326' => [ 'Partial invoice',
    'Document/message specifying details of an incomplete invoice.' ],
'327' => [ 'Operating instructions',
    'Document/message describing instructions for operation.' ],
'328' => [ 'Name/product plate',
    'Plates on goods identifying and describing an article.' ],
'329' => [ 'Co-insurance ceding bordereau',
    'The document or message contains a bordereau describing co-insurance ceding information.' ],
'330' => [ 'Request for delivery instructions',
    'Document/message issued by a supplier requesting instructions from the buyer regarding the details of the delivery of goods ordered.' ],
'331' => [ 'Commercial invoice which includes a packing list',
    'Commercial transaction (invoice) will include a packing list.' ],
'332' => [ 'Trade data',
    'Document/message is for trade data.' ],
'333' => [ 'Customs declaration for cargo examination',
    'Declaration provided to customs for cargo examination.' ],
'334' => [ 'Customs declaration for cargo examination, alternate',
    'Alternate declaration provided to customs for cargo examination.' ],
'335' => [ 'Booking request',
    'Document/message issued by a supplier to a carrier requesting space to be reserved for a specified consignment, indicating desirable conveyance, despatch time, etc.' ],
'336' => [ 'Customs crew and conveyance',
    'Document/message contains information regarding the crew list and conveyance.' ],
'337' => [ 'Customs summary declaration with commercial detail,',
    'alternate Alternate Customs declaration summary with commercial transaction details.' ],
'338' => [ 'Items booked to a financial account report',
    'A message reporting items which have been booked to a financial account.' ],
'339' => [ 'Report of transactions which need further information from',
    'the receiver A message reporting transactions which need further information from the receiver.' ],
'340' => [ 'Shipping instructions',
    "(1121) Document/message advising details of cargo and exporter's requirements for its physical movement." ],
'341' => [ "Shipper's letter of instructions (air)",
    'Document/message issued by a consignor in which he gives details of a consignment of goods that enables an airline or its agent to prepare an air waybill.' ],
'342' => [ 'Report of transactions for information only',
    'A message reporting transactions for information only.' ],
'343' => [ 'Cartage order (local transport)',
    'Document/message giving instructions regarding local transport of goods, e.g. from the premises of an enterprise to those of a carrier undertaking further transport.' ],
'344' => [ 'EDI associated object administration message',
    'A message giving additional information about the exchange of an EDI associated object.' ],
'345' => [ 'Ready for despatch advice',
    'Document/message issued by a supplier informing a buyer that goods ordered are ready for despatch.' ],
'346' => [ 'Summary sales report',
    'Sales report containing summaries for several earlier sent sales reports.' ],
'347' => [ 'Order status enquiry',
    'A message enquiring the status of previously sent orders.' ],
'348' => [ 'Order status report',
    'A message reporting the status of previously sent orders.' ],
'349' => [ 'Declaration regarding the inward and outward movement of',
    'vessel Document to declare inward and outward movement of a vessel.' ],
'350' => [ 'Despatch order',
    'Document/message issued by a supplier initiating the despatch of goods to a buyer (consignee).' ],
'351' => [ 'Despatch advice',
    'Document/message by means of which the seller or consignor informs the consignee about the despatch of goods.' ],
'352' => [ 'Notification of usage of berth or mooring facilities',
    'Document to notify usage of berth or mooring facilities.' ],
'353' => [ "Application for vessel's entering into port area in night-",
    "time Document to apply for vessel's entering into port area in night-time." ],
'354' => [ 'Notification of emergency shifting from the designated',
    'place in port Document to notify shifting from designated place in port once secured at the designated place.' ],
'355' => [ 'Customs summary declaration without commercial detail,',
    'alternate Alternate Customs declaration summary without any commercial transaction details.' ],
'356' => [ 'Performance bond',
    'A document that guarantees performance.' ],
'357' => [ 'Payment bond',
    'A document that guarantees the payment of monies.' ],
'358' => [ 'Healthcare discharge report, preliminary',
    'Preliminary discharge report by healthcare provider.' ],
'359' => [ 'Request for provision of a health service',
    'Document containing request for provision of a health service.' ],
'360' => [ 'Request for price quote',
    'Document/message requesting price conditions under which goods are offered.' ],
'361' => [ 'Price quote',
    'Document/message confirming price conditions under which goods are offered.' ],
'362' => [ 'Delivery quote',
    'Document/message confirming delivery conditions under which goods are offered.' ],
'363' => [ 'Price and delivery quote',
    'Document/message confirming price and delivery conditions under which goods are offered.' ],
'364' => [ 'Contract price quote',
    'Document/message confirming contractual price conditions under which goods are offered.' ],
'365' => [ 'Contract price and delivery quote',
    'Document/message confirming contractual price conditions and contractual delivery conditions under which goods are offered.' ],
'366' => [ 'Price quote, specified end-customer',
    'Document/message confirming price conditions under which goods are offered, provided that they are sold to the end-customer specified on the quote.' ],
'367' => [ 'Price and delivery quote, specified end-customer',
    'Document/message confirming price conditions and delivery conditions under which goods are offered, provided that they are sold to the end-customer specified on the quote.' ],
'368' => [ 'Price quote, ship and debit',
    'Document/message from a supplier to a distributor confirming price conditions under which goods can be sold by a distributor to the end-customer specified on the quote with compensation for loss of inventory value.' ],
'369' => [ 'Price and delivery quote, ship and debit',
    'Document/message from a supplier to a distributor confirming price conditions and delivery conditions under which goods can be sold by a distributor to the end-customer specified on the quote with compensation for loss of inventory value.' ],
'370' => [ 'Advice of distribution of documents',
    'Document/message in which the party responsible for the issue of a set of trade documents specifies the various recipients of originals and copies of these documents, with an indication of the number of copies distributed to each of them.' ],
'371' => [ 'Plan for provision of health service',
    'Document containing a plan for provision of health service.' ],
'372' => [ 'Prescription',
    'Instructions for the dispensing and use of medicine or remedy.' ],
'373' => [ 'Prescription request',
    'Request to issue a prescription for medicine or remedy.' ],
'374' => [ 'Prescription dispensing report',
    'Document containing information of products dispensed according to a prescription.' ],
'375' => [ 'Certificate of shipment',
    '(1109) Certificate providing confirmation that a consignment has been shipped.' ],
'376' => [ 'Standing inquiry on product information',
    'A product inquiry which stands until it is cancelled.' ],
'377' => [ 'Party credit information',
    'Document/message providing data concerning the credit information of a party.' ],
'378' => [ 'Party payment behaviour information',
    'Document/message providing data concerning the payment behaviour of a party.' ],
'379' => [ 'Request for metering point information',
    'Message to request information about a metering point.' ],
'380' => [ 'Commercial invoice',
    '(1334) Document/message claiming payment for goods or services supplied under conditions agreed between seller and buyer.' ],
'381' => [ 'Credit note',
    '(1113) Document/message for providing credit information to the relevant party.' ],
'382' => [ 'Commission note',
    '(1111) Document/message in which a seller specifies the amount of commission, the percentage of the invoice amount, or some other basis for the calculation of the commission to which a sales agent is entitled.' ],
'383' => [ 'Debit note',
    'Document/message for providing debit information to the relevant party.' ],
'384' => [ 'Corrected invoice',
    'Commercial invoice that includes revised information differing from an earlier submission of the same invoice.' ],
'385' => [ 'Consolidated invoice',
    'Commercial invoice that covers multiple transactions involving more than one vendor.' ],
'386' => [ 'Prepayment invoice',
    'An invoice to pay amounts for goods and services in advance; these amounts will be subtracted from the final invoice.' ],
'387' => [ 'Hire invoice',
    'Document/message for invoicing the hiring of human resources or renting goods or equipment.' ],
'388' => [ 'Tax invoice',
    'An invoice for tax purposes.' ],
'389' => [ 'Self-billed invoice',
    'An invoice the invoicee is producing instead of the seller.' ],
'390' => [ 'Delcredere invoice',
    'An invoice sent to the party paying for a number of buyers.' ],
'391' => [ 'Metering point information response',
    'Response to a request for information about a metering point.' ],
'392' => [ 'Notification of change of supplier',
    'A notification of a change of supplier.' ],
'393' => [ 'Factored invoice',
    'Invoice assigned to a third party for collection.' ],
'394' => [ 'Lease invoice',
    'Usage of INVOIC-message for goods in leasing contracts.' ],
'395' => [ 'Consignment invoice',
    'Commercial invoice that covers a transaction other than one involving a sale.' ],
'396' => [ 'Factored credit note',
    'Credit note related to assigned invoice(s).' ],
'397' => [ 'Commercial account summary response',
    'A document providing a response to a previously sent commercial account summary message.' ],
'398' => [ 'Cross docking despatch advice',
    'Document by means of which the supplier or consignor informs the buyer, consignee or the distribution centre about the despatch of goods for cross docking.' ],
'399' => [ 'Transshipment despatch advice',
    'Document by means of which the supplier or consignor informs the buyer, consignee or the distribution centre about the despatch of goods for transshipment.' ],
'400' => [ 'Exceptional order',
    'An order which falls outside the framework of an agreement.' ],
'401' => [ 'Pre-packed cross docking order',
    'An order requesting the supply of products packed according to the final delivery point which will be moved across a dock in a distribution centre without further handling.' ],
'402' => [ 'Intermediate handling cross docking order',
    'An order requesting the supply of products which will be moved across a dock, de-consolidated and re-consolidated according to the final delivery location requirements.' ],
'403' => [ 'Means of transportation availability information',
    'Information giving the various availabilities of a means of transportation.' ],
'404' => [ 'Means of transportation schedule information',
    'Information giving the various schedules of a means of transportation.' ],
'405' => [ 'Transport equipment delivery notice',
    'Notification regarding the delivery of transport equipment.' ],
'406' => [ 'Notification to supplier of contract termination',
    'Notification to the supplier regarding the termination of a contract.' ],
'407' => [ 'Notification to supplier of metering point changes',
    'Notification to the supplier about changes regarding a metering point.' ],
'408' => [ 'Notification of meter change',
    'Notification about the change of a meter.' ],
'409' => [ 'Instructions for bank transfer',
    'Document/message containing instructions from a customer to his bank to pay an amount in a specified currency to a nominated party in another country by a method either specified (e.g. teletransmission, air mail) or left to the discretion of the bank.' ],
'410' => [ 'Notification of metering point identification change',
    'Notification of the change of metering point identification.' ],
'411' => [ 'Utilities time series message',
    'The Utilities time series message is sent between responsible parties in a utilities infrastructure for the purpose of reporting time series and connected technical and/or administrative information.' ],
'412' => [ "Application for banker's draft",
    "Application by a customer to his bank to issue a banker's draft stating the amount and currency of the draft, the name of the payee and the place and country of payment." ],
'413' => [ 'Infrastructure condition',
    'Information about components in an infrastructure.' ],
'414' => [ 'Acknowledgement of change of supplier',
    'Acknowledgement of the change of supplier.' ],
'415' => [ 'Data Plot Sheet',
    'Document/Message providing technical description and information of the crop production.' ],
'416' => [ 'Soil analysis',
    'Soil analysis document.' ],
'417' => [ 'Farmyard manure analysis',
    'Farmyard manure analysis document.' ],
'418' => [ 'WCO Cargo Report Export, Rail or Road',
    'Declaration, in accordance with the WCO Customs Data Model, to Customs concerning the export of cargo carried by commercial means of transport over land, e.g. truck or train.' ],
'419' => [ 'WCO Cargo Report Export, Air or Maritime',
    'Declaration, in accordance with the WCO Customs Data Model, to Customs concerning the export of cargo carried by commercial means of transport over water or through the air, e.g. vessel or aircraft.' ],
'420' => [ 'Optical Character Reading (OCR) payment credit note',
    'Payment credit note effected by an Optical Character Reading (OCR) document.' ],
'421' => [ 'WCO Cargo Report Import, Rail or Road',
    'Declaration, in accordance with the WCO Customs Data Model, to Customs concerning the import of cargo carried by commercial means of transport over land, e.g. truck or train.' ],
'422' => [ 'WCO Cargo Report Import, Air or Maritime',
    'Declaration, in accordance with the WCO Customs Data Model, to Customs concerning the import of cargo carried by commercial means of transport over water or through the air, e.g. vessel or aircraft.' ],
'423' => [ 'WCO one-step export declaration',
    'Single step declaration, in accordance with the WCO Customs Data Model, to Customs by which goods are declared for a Customs export procedure based on the 1999 Kyoto Convention.' ],
'424' => [ 'WCO first step of two-step export declaration',
    'First part of a simplified declaration, in accordance with the WCO Customs Data Model, to Customs by which goods are declared for Customs export procedure based on the 1999 Kyoto Convention.' ],
'425' => [ 'Collection payment advice',
    'Document/message whereby a bank advises that a collection has been paid, giving details and methods of funds disposal.' ],
'426' => [ 'Documentary credit payment advice',
    'Document/message whereby a bank advises payment under a documentary credit.' ],
'427' => [ 'Documentary credit acceptance advice',
    'Document/message whereby a bank advises acceptance under a documentary credit.' ],
'428' => [ 'Documentary credit negotiation advice',
    'Document/message whereby a bank advises negotiation under a documentary credit.' ],
'429' => [ "Application for banker's guarantee",
    'Document/message whereby a customer requests his bank to issue a guarantee in favour of a nominated party in another country, stating the amount and currency and the specific conditions of the guarantee.' ],
'430' => [ "Banker's guarantee",
    'Document/message in which a bank undertakes to pay out a limited amount of money to a designated party, on conditions stated therein (other than those laid down in the Uniform Customs Practice).' ],
'431' => [ 'Documentary credit letter of indemnity',
    'Document/message in which a beneficiary of a documentary credit accepts responsibility for non-compliance with the terms and conditions of the credit, and undertakes to refund the money received under the credit, with interest and charges accrued.' ],
'432' => [ 'Notification to grid operator of contract termination',
    'Notification to the grid operator regarding the termination of a contract.' ],
'433' => [ 'Notification to grid operator of metering point changes',
    'Notification to the grid operator about changes regarding a metering point.' ],
'434' => [ 'Notification of balance responsible entity change',
    'Notification of a change of balance responsible entity.' ],
'435' => [ 'Preadvice of a credit',
    'Preadvice indicating a credit to happen in the future.' ],
'436' => [ 'Transport equipment profile report',
    'Report on the profile of transport equipment.' ],
'437' => [ 'Request for price and delivery quote, specified end-user',
    'Document/message requesting price conditions and delivery conditions under which goods are offered, provided that they are sold to the end-customer specified on the request for quote.' ],
'438' => [ 'Request for price quote, ship and debit',
    'Document/message from a distributor to a supplier requesting price conditions under which goods can be sold by the distributor to the end-customer specified on the request for quote with compensation for loss of inventory value.' ],
'439' => [ 'Request for price and delivery quote, ship and debit',
    'Document/message from a distributor to a supplier requesting price conditions and delivery conditions under which goods can be sold by the distributor to the end-customer specified on the request for quote with compensation for loss of inventory value.' ],
'440' => [ 'Delivery point list.',
    'A list of delivery point addresses.' ],
'441' => [ 'Transport routing information',
    'Document specifying the routes for transport between locations.' ],
'442' => [ 'Request for delivery quote',
    'Document/message requesting delivery conditions under which goods are offered.' ],
'443' => [ 'Request for price and delivery quote',
    'Document/message requesting price and delivery conditions under which goods are offered.' ],
'444' => [ 'Request for contract price quote',
    'Document/message requesting contractual price conditions under which goods are offered.' ],
'445' => [ 'Request for contract price and delivery quote',
    'Document/message requesting contractual price conditions and contractual delivery conditions under which goods are offered.' ],
'446' => [ 'Request for price quote, specified end-customer',
    'Document/message requesting price conditions under which goods are offered, provided that they are sold to the end-customer specified on the request for quote.' ],
'447' => [ 'Collection order',
    'Document/message whereby a bank is instructed (or requested) to handle financial and/or commercial documents in order to obtain acceptance and/or payment, or to deliver documents on such other terms and conditions as may be specified.' ],
'448' => [ 'Documents presentation form',
    'Document/message whereby a draft or similar instrument and/or commercial documents are presented to a bank for acceptance, discounting, negotiation, payment or collection, whether or not against a documentary credit.' ],
'449' => [ 'Identification match',
    'Message related to conducting a search for an identification match.' ],
'450' => [ 'Payment order',
    'Document/message containing information needed to initiate the payment. It may cover the financial settlement for one or more commercial trade transactions. A payment order is an instruction to the ordered bank to arrange for the payment of one specified amount to the beneficiary.' ],
'451' => [ 'Extended payment order',
    'Document/message containing information needed to initiate the payment. It may cover the financial settlement for several commercial trade transactions, which it is possible to specify in a special payments detail part. It is an instruction to the ordered bank to arrange for the payment of one specified amount to the beneficiary.' ],
'452' => [ 'Multiple payment order',
    'Document/message containing a payment order to debit one or more accounts and to credit one or more beneficiaries.' ],
'453' => [ 'Notice that circumstances prevent payment of delivered',
    'goods Message used to inform a supplier that delivered goods cannot be paid due to circumstances which prevent payment.' ],
'454' => [ 'Credit advice',
    'Document/message sent by an account servicing institution to one of its account owners, to inform the account owner of an entry which has been or will be credited to its account for a specified amount on the date indicated.' ],
'455' => [ 'Extended credit advice',
    'Document/message sent by an account servicing institution to one of its account owners, to inform the account owner of an entry that has been or will be credited to its account for a specified amount on the date indicated. It provides extended commercial information concerning the relevant remittance advice.' ],
'456' => [ 'Debit advice',
    'Advice on a debit.' ],
'457' => [ 'Reversal of debit',
    'Reversal of debit accounting entry by bank.' ],
'458' => [ 'Reversal of credit',
    'Reversal of credit accounting entry by bank.' ],
'459' => [ 'Travel ticket',
    'The document is a ticket giving access to a travel service.' ],
'460' => [ 'Documentary credit application',
    'Document/message whereby a bank is requested to issue a documentary credit on the conditions specified therein.' ],
'461' => [ 'Payment card',
    'The document is a credit, guarantee or charge card.' ],
'462' => [ 'Ready for transshipment despatch advice',
    'Document to advise that the goods ordered are ready for transshipment.' ],
'463' => [ 'Pre-packed cross docking despatch advice',
    'Document by means of which the supplier or consignor informs the buyer, consignee or distribution centre about the despatch of products packed according to the final delivery point requirements which will be moved across a dock in a distribution centre without further handling.' ],
'464' => [ 'Intermediate handling cross docking despatch advice',
    'Document by means of which the supplier or consignor informs the buyer, consignee or the distribution centre about the despatch of products which will be moved across a dock, de-consolidated and re-consolidated according to final delivery location requirements.' ],
'465' => [ 'Documentary credit',
    'Document/message in which a bank states that it has issued a documentary credit under which the beneficiary is to obtain payment, acceptance or negotiation on compliance with certain terms and conditions and against presentation of stipulated documents and such drafts as may be specified. The credit may or may not be confirmed by another bank.' ],
'466' => [ 'Documentary credit notification',
    'Document/message issued by an advising bank in order to transmit a documentary credit to a beneficiary, or to another advising bank.' ],
'467' => [ 'Documentary credit transfer advice',
    'Document/message whereby a bank advises that (part of) a documentary credit is being or has been transferred in favour of a second beneficiary.' ],
'468' => [ 'Documentary credit amendment notification',
    'Document/message whereby a bank advises that the terms and conditions of a documentary credit have been amended.' ],
'469' => [ 'Documentary credit amendment',
    'Document/message whereby a bank notifies a beneficiary of the details of an amendment to the terms and conditions of a documentary credit.' ],
'470' => [ 'Waste disposal report',
    'Document/message sent by a shipping agent to an authority for reporting information on waste disposal.' ],
'481' => [ 'Remittance advice',
    'Document/message advising of the remittance of payment.' ],
'482' => [ 'Port authority waste disposal report',
    'Document/message sent by a port authority to another port authority for reporting information on waste disposal.' ],
'483' => [ 'Visa',
    'An endorsement on a passport or any other recognised travel document indicating that it has been examined and found correct, especially as permitting the holder to enter or leave a country.' ],
'484' => [ 'Multiple direct debit request',
    'Document/message containing a direct debit request to credit one or more accounts and to debit one or more debtors.' ],
'485' => [ "Banker's draft",
    'Draft drawn in favour of a third party either by one bank on another bank, or by a branch of a bank on its head office (or vice versa) or upon another branch of the same bank. In either case, the draft should comply with the specifications laid down for cheques in the country in which it is to be payable.' ],
'486' => [ 'Multiple direct debit',
    'Document/message containing a direct debit to credit one or more accounts and to debit one or more debtors.' ],
'487' => [ 'Certificate of disembarkation permission',
    'Document or message issuing permission to disembark.' ],
'488' => [ 'Deratting exemption certificate',
    'Document certifying that the object was free of rats when inspected and that it is exempt from a deratting statement.' ],
'489' => [ 'Reefer connection order',
    'Order to connect a reefer container to a reefer point.' ],
'490' => [ 'Bill of exchange',
    'Document/message, issued and signed in conformity with the applicable legislation, which contains an unconditional order whereby the drawer directs the drawee to pay a definite sum of money to the payee or to his order, on demand or at a definite time, against the surrender of the document itself.' ],
'491' => [ 'Promissory note',
    'Document/message, issued and signed in conformity with the applicable legislation, which contains an unconditional promise whereby the maker undertakes to pay a definite sum of money to the payee or to his order, on demand or at a definite time, against the surrender of the document itself.' ],
'493' => [ 'Statement of account message',
    'Usage of STATAC-message.' ],
'494' => [ 'Direct delivery (transport)',
    'Document/message ordering the direct delivery of goods/consignment from one means of transport into another means of transport in one movement.' ],
'495' => [ 'WCO second step of two-step export declaration',
    'Second part of a simplified declaration, in accordance with the WCO Customs Data Model, to Customs by which goods are declared for Customs export procedure based on the 1999 Kyoto Convention.' ],
'496' => [ 'WCO one-step import declaration',
    'Single step declaration, in accordance with the WCO Customs Data Model, to Customs by which goods are declared for Customs import procedure based on the 1999 Kyoto Convention.' ],
'497' => [ 'WCO first step of two-step import declaration',
    'First part of a simplified declaration, in accordance with the WCO Customs Data Model, to Customs by which goods are declared for Customs import procedure based on the 1999 Kyoto Convention.' ],
'498' => [ 'WCO second step of two-step import declaration',
    'Second part of a simplified declaration, in accordance with the WCO Customs Data Model, to Customs by which goods are declared for Customs import procedure based on the 1999 Kyoto Convention.' ],
'499' => [ 'Previous transport document',
    'Identification of the previous transport document.' ],
'520' => [ 'Insurance certificate',
    'Document/message issued to the insured certifying that insurance has been effected and that a policy has been issued. Such a certificate for a particular cargo is primarily used when good are insured under the terms of a floating or an open policy; at the request of the insured it can be exchanged for a policy.' ],
'521' => [ 'Special requirements permit related to the transport of',
    'cargo A permit related to a transport document granting the transport of cargo under the conditions as specifically required.' ],
'522' => [ 'Dangerous Goods Notification for Tanker vessel',
    'Dangerous Goods Notification for a vessel carrying liquid cargo in bulk.' ],
'523' => [ 'Dangerous Goods Notification for non-tanker vessel',
    'Dangerous Goods Notification for a vessel carrying cargo other than bulk liquid cargo.' ],
'524' => [ 'WCO Conveyance Arrival Report',
    'Declaration, in accordance with the WCO Customs Data Model, to Customs regarding the conveyance arriving in a Customs territory.' ],
'525' => [ 'WCO Conveyance Departure Report',
    'Declaration, in accordance with the WCO Customs Data Model, to Customs regarding the conveyance departing a Customs territory.' ],
'526' => [ 'Accounting voucher',
    'A document/message justifying an accounting entry.' ],
'527' => [ 'Self billed debit note',
    'A document which indicates that the customer is claiming debit in a self billing environment.' ],
'528' => [ 'Military Identification Card',
    'The official document used for military personnel on travel orders, substituting a passport.' ],
'529' => [ 'Re-Entry Permit',
    'A permit to re-enter a country.' ],
'530' => [ 'Insurance policy',
    'Document/message issued by the insurer evidencing an agreement to insure and containing the conditions of the agreement concluded whereby the insurer undertakes for a specific fee to indemnify the insured for the losses arising out of the perils and accidents specified in the contract.' ],
'531' => [ 'Refugee Permit',
    'Document identifying a refugee recognized by a country.' ],
'532' => [ 'Forwarders credit note',
    'Document/message for providing credit information to the relevant party.' ],
'533' => [ 'Original accounting voucher',
    'To indicate that the document/message justifying an accounting entry is original.' ],
'534' => [ 'Copy accounting voucher',
    'To indicate that the document/message justifying an accounting entry is a copy.' ],
'535' => [ 'Pro-forma accounting voucher',
    'To indicate that the document/message justifying an accounting entry is pro-forma.' ],
'536' => [ 'International Ship Security Certificate',
    'A certificate on ship security issued based on the International code for the Security of Ships and of Port facilities (ISPS code).' ],
'537' => [ 'Interim International Ship Security Certificate',
    'An interim certificate on ship security issued basis under the International code for the Security of Ships and of Port facilities (ISPS code).' ],
'538' => [ 'Good Manufacturing Practice (GMP) Certificate',
    'Certificate that guarantees quality manufacturing and processing of food products, medications, cosmetics, etc.' ],
'539' => [ 'Framework Agreement',
    'An agreement between one or more contracting authorities and one or more economic operators, the purpose of which is to establish the terms governing contracts to be awarded during a given period, in particular with regard to price and, where appropriate, the quantity envisaged.' ],
'550' => [ 'Insurance declaration sheet (bordereau)',
    'A document/message used when an insured reports to his insurer details of individual shipments which are covered by an insurance contract - an open cover or a floating policy - between the parties.' ],
'552' => [ 'Ship Security Plan',
    'Ship Security Plan (SSP) is a document prepared in terms of the ISPS Code to contribute to the prevention of illegal acts against the ship and its crew.' ],
'553' => [ 'Forwarders invoice discrepancy report',
    'Document/message reporting invoice discrepancies indentified by the forwarder.' ],
'575' => [ "Insurer's invoice",
    'Document/message issued by an insurer specifying the cost of an insurance which has been effected and claiming payment therefore.' ],
'580' => [ 'Cover note',
    'Document/message issued by an insurer (insurance broker, agent, etc.) to notify the insured that his insurance have been carried out.' ],
'610' => [ 'Forwarding instructions',
    'Document/message issued to a freight forwarder, giving instructions regarding the action to be taken by the forwarder for the forwarding of goods described therein.' ],
'621' => [ "Forwarder's advice to import agent",
    'Document/message issued by a freight forwarder in an exporting country advising his counterpart in an importing country about the forwarding of goods described therein.' ],
'622' => [ "Forwarder's advice to exporter",
    'Document/message issued by a freight forwarder informing an exporter of the action taken in fulfillment of instructions received.' ],
'623' => [ "Forwarder's invoice",
    'Invoice issued by a freight forwarder specifying services rendered and costs incurred and claiming payment therefore.' ],
'624' => [ "Forwarder's certificate of receipt",
    'Non-negotiable document issued by a forwarder to certify that he has assumed control of a specified consignment, with irrevocable instructions to send it to the consignee indicated in the document or to hold it at his disposal. E.g. FIATA-FCR.' ],
'630' => [ 'Shipping note',
    '(1123) Document/message provided by the shipper or his agent to the carrier, multimodal transport operator, terminal or other receiving authority, giving information about export consignments offered for transport, and providing for the necessary receipts and declarations of liability. Sometimes a multipurpose cargo handling document also fulfilling the functions of document 632, 633, 650 and 655.' ],
'631' => [ "Forwarder's warehouse receipt",
    'Document/message issued by a forwarder acting as Warehouse Keeper acknowledging receipt of goods placed in a warehouse, and stating or referring to the conditions which govern the warehousing and the release of goods. The document contains detailed provisions regarding the rights of holders-by-endorsement, transfer of ownership, etc. E.g. FIATA-FWR.' ],
'632' => [ 'Goods receipt',
    'Document/message to acknowledge the receipt of goods and in addition may indicate receiving conditions.' ],
'633' => [ 'Port charges documents',
    'Documents/messages specifying services rendered, storage and handling costs, demurrage and other charges due to the owner of goods described therein.' ],
'635' => [ 'Warehouse warrant',
    'Negotiable receipt document, issued by a Warehouse Keeper to a person placing goods in a warehouse and conferring title to the goods stored.' ],
'640' => [ 'Delivery order',
    'Document/message issued by a party entitled to authorize the release of goods specified therein to a named consignee, to be retained by the custodian of the goods.' ],
'650' => [ 'Handling order',
    'Document/message issued by a cargo handling organization (port administration, terminal operator, etc.) for the removal or other handling of goods under their care.' ],
'655' => [ 'Gate pass',
    'Document/message authorizing goods specified therein to be brought out of a fenced-in port or terminal area.' ],
'700' => [ 'Waybill',
    'Non-negotiable document evidencing the contract for the transport of cargo.' ],
'701' => [ 'Universal (multipurpose) transport document',
    'Document/message evidencing a contract of carriage covering the movement of goods by any mode of transport, or combination of modes, for national as well as international transport, under any applicable international convention or national law and under the conditions of carriage of any carrier or transport operator undertaking or arranging the transport referred to in the document.' ],
'702' => [ 'Goods receipt, carriage',
    "Document/message issued by a carrier or a carrier's agent, acknowledging receipt for carriage of goods specified therein on conditions stated or referred to in the document, enabling the carrier to issue a transport document." ],
'703' => [ 'House waybill',
    'The document made out by an agent/consolidator which evidences the contract between the shipper and the agent/consolidator for the arrangement of carriage of goods.' ],
'704' => [ 'Master bill of lading',
    'A bill of lading issued by the master of a vessel (in actuality the owner or charterer of the vessel). It could cover a number of house bills.' ],
'705' => [ 'Bill of lading',
    'Negotiable document/message which evidences a contract of carriage by sea and the taking over or loading of goods by carrier, and by which carrier undertakes to deliver goods against surrender of the document. A provision in the document that goods are to be delivered to the order of a named person, or to order, or to bearer, constitutes such an undertaking.' ],
'706' => [ 'Bill of lading original',
    'The original of the bill of lading issued by a transport company. When issued by the maritime industry it could signify ownership of the cargo.' ],
'707' => [ 'Bill of lading copy',
    'A copy of the bill of lading issued by a transport company.' ],
'708' => [ 'Empty container bill',
    'Bill of lading indicating an empty container.' ],
'709' => [ 'Tanker bill of lading',
    'Document which evidences a transport of liquid bulk cargo.' ],
'710' => [ 'Sea waybill',
    'Non-negotiable document which evidences a contract for the carriage of goods by sea and the taking over of the goods by the carrier, and by which the carrier undertakes to deliver the goods to the consignee named in the document.' ],
'711' => [ 'Inland waterway bill of lading',
    'Negotiable transport document made out to a named person, to order or to bearer, signed by the carrier and handed to the sender after receipt of the goods.' ],
'712' => [ 'Non-negotiable maritime transport document (generic)',
    'Non-negotiable document which evidences a contract for the carriage of goods by sea and the taking over or loading of the goods by the carrier, and by which the carrier undertakes to deliver the goods to the consignee named in the document. E.g. Sea waybill. Remark: Synonymous with "straight" or "non-negotiable Bill of lading" used in certain countries, e.g. Canada.' ],
'713' => [ "Mate's receipt",
    "Document/message issued by a ship's officer to acknowledge that a specified consignment has been received on board a vessel, and the apparent condition of the goods; enabling the carrier to issue a Bill of lading." ],
'714' => [ 'House bill of lading',
    'The bill of lading issued not by the carrier but by the freight forwarder/consolidator known by the carrier.' ],
'715' => [ 'Letter of indemnity for non-surrender of bill of lading',
    'Document/message issued by a commercial party or a bank of an insurance company accepting responsibility to the beneficiary of the indemnity in accordance with the terms thereof.' ],
'716' => [ "Forwarder's bill of lading",
    'Non-negotiable document issued by a freight forwarder evidencing a contract for the carriage of goods by sea and the taking over or loading of the goods by the freight forwarder, and by which the freight forwarder undertakes to deliver the goods to the consignee named in the document.' ],
'720' => [ 'Rail consignment note (generic term)',
    'Transport document constituting a contract for the carriage of goods between the sender and the carrier (the railway). For international rail traffic, this document must conform to the model prescribed by the international conventions concerning carriage of goods by rail, e.g. CIM Convention, SMGS Convention.' ],
'722' => [ 'Road list-SMGS',
    'Accounting document, one copy of which is drawn up for each consignment note; it accompanies the consignment over the whole route and is a rail transport document.' ],
'723' => [ 'Escort official recognition',
    'Document/message which gives right to the owner to exert all functions normally transferred to a guard in a train by which an escorted consignment is transported.' ],
'724' => [ 'Recharging document',
    "Fictitious transport document regarding a previous transport, enabling a carrier's agent to give to another carrier's agent (in a different country) the possibility to collect charges relating to the original transport (rail environment)." ],
'730' => [ 'Road consignment note',
    'Transport document/message which evidences a contract between a carrier and a sender for the carriage of goods by road (generic term). Remark: For international road traffic, this document must contain at least the particulars prescribed by the convention on the contract for the international carriage of goods by road (CMR).' ],
'740' => [ 'Air waybill',
    'Document/message made out by or on behalf of the shipper which evidences the contract between the shipper and carrier(s) for carriage of goods over routes of the carrier(s) and which is identified by the airline prefix issuing the document plus a serial (IATA).' ],
'741' => [ 'Master air waybill',
    'Document/message made out by or on behalf of the agent/consolidator which evidences the contract between the agent/consolidator and carrier(s) for carriage of goods over routes of the carrier(s) for a consignment consisting of goods originated by more than one shipper (IATA).' ],
'743' => [ 'Substitute air waybill',
    'A temporary air waybill which contains only limited information because of the absence of the original.' ],
'744' => [ "Crew's effects declaration",
    'Declaration to Customs regarding the personal effects of crew members aboard the conveyance; equivalent to IMO FAL 4.' ],
'745' => [ 'Passenger list',
    'Declaration to Customs regarding passengers aboard the conveyance; equivalent to IMO FAL 6.' ],
'746' => [ 'Delivery notice (rail transport)',
    'Document/message created by the consignor or by the departure station, joined to the transport or sent to the consignee, giving the possibility to the consignee or the arrival station to attest the delivery of the goods. The document must be returned to the consignor or to the departure station.' ],
'750' => [ 'Despatch note (post parcels)',
    'Document/message which, according to Article 106 of the "Agreement concerning Postal Parcels" under the UPU convention, is to accompany post parcels.' ],
'760' => [ 'Multimodal/combined transport document (generic)',
    'A transport document used when more than one mode of transportation is involved in the movement of cargo. It is a contract of carriage and receipt of the cargo for a multimodal transport. It indicates the place where the responsible transport company in the move takes responsibility for the cargo, the place where the responsibility of this transport company in the move ends and the conveyances involved.' ],
'761' => [ 'Through bill of lading',
    'Bill of lading which evidences a contract of carriage from one place to another in separate stages of which at least one stage is a sea transit, and by which the issuing carrier accepts responsibility for the carriage as set forth in the through bill of lading.' ],
'763' => [ "Forwarder's certificate of transport",
    "Negotiable document/message issued by a forwarder to certify that he has taken charge of a specified consignment for despatch and delivery in accordance with the consignor's instructions, as indicated in the document, and that he accepts responsibility for delivery of the goods to the holder of the document through the intermediary of a delivery agent of his choice. E.g. FIATA-FCT." ],
'764' => [ 'Combined transport document (generic)',
    'Negotiable or non-negotiable document evidencing a contract for the performance and/or procurement of performance of combined transport of goods and bearing on its face either the heading "Negotiable combined transport document issued subject to Uniform Rules for a Combined Transport Document (ICC Brochure No. 298)" or the heading "Non-negotiable Combined Transport Document issued subject to Uniform Rules for a Combined Transport Document (ICC Brochure No. 298)".' ],
'765' => [ 'Multimodal transport document (generic)',
    'Document/message which evidences a multimodal transport contract, the taking in charge of the goods by the multimodal transport operator, and an undertaking by him to deliver the goods in accordance with the terms of the contract. (International Convention on Multimodal Transport of Goods).' ],
'766' => [ 'Combined transport bill of lading/multimodal bill of lading',
    'Document which evidences a multimodal transport contract, the taking in charge of the goods by the multimodal transport operator, and an undertaking by him to deliver the goods in accordance with the terms of the contract.' ],
'770' => [ 'Booking confirmation',
    'Document/message issued by a carrier to confirm that space has been reserved for a consignment in means of transport.' ],
'775' => [ 'Calling forward notice',
    'Instructions for release or delivery of goods.' ],
'780' => [ 'Freight invoice',
    'Document/message issued by a transport operation specifying freight costs and charges incurred for a transport operation and stating conditions of payment.' ],
'781' => [ 'Arrival notice (goods)',
    'Notification from the carrier to the consignee in writing, by telephone or by any other means (express letter, message, telegram, etc.) informing him that a consignment addressed to him is being or will shortly be held at his disposal at a specified point in the place of destination.' ],
'782' => [ 'Notice of circumstances preventing delivery (goods)',
    'Request made by the carrier to the sender, or, as the case may be, the consignee, for instructions as to the disposal of the consignment when circumstances prevent delivery and the return of the goods has not been requested by the consignor in the transport document.' ],
'783' => [ 'Notice of circumstances preventing transport (goods)',
    'Request made by the carrier to the sender, or, the consignee as the case may be, for instructions as to the disposal of the goods when circumstances prevent transport before departure or en route, after acceptance of the consignment concerned.' ],
'784' => [ 'Delivery notice (goods)',
    'Notification in writing, sent by the carrier to the sender, to inform him at his request of the actual date of delivery of the goods.' ],
'785' => [ 'Cargo manifest',
    'Listing of goods comprising the cargo carried in a means of transport or in a transport-unit. The cargo manifest gives the commercial particulars of the goods, such as transport document numbers, consignors, consignees, shipping marks, number and kind of packages and descriptions and quantities of the goods.' ],
'786' => [ 'Freight manifest',
    'Document/message containing the same information as a cargo manifest, and additional details on freight amounts, charges, etc.' ],
'787' => [ 'Bordereau',
    'Document/message used in road transport, listing the cargo carried on a road vehicle, often referring to appended copies of Road consignment note.' ],
'788' => [ 'Container manifest (unit packing list)',
    'Document/message specifying the contents of particular freight containers or other transport units, prepared by the party responsible for their loading into the container or unit.' ],
'789' => [ 'Charges note',
    'Document used by the rail organization to indicate freight charges or additional charges in each case where the departure station is not able to calculate the charges for the total voyage (e.g. tariff not yet updated, part of voyage not covered by the tariff). This document must be considered as joined to the transport.' ],
'790' => [ 'Advice of collection',
    '(1030) Document that is joined to the transport or sent by separate means, giving to the departure rail organization the proof that the cash-on delivery amount has been encashed by the arrival rail organization before reimbursement of the consignor.' ],
'791' => [ 'Safety of ship certificate',
    "Document certifying a ship's safety to a specified date." ],
'792' => [ 'Safety of radio certificate',
    "Document certifying the safety of a ship's radio facilities to a specified date." ],
'793' => [ 'Safety of equipment certificate',
    "Document certifying the safety of a ship's equipment to a specified date." ],
'794' => [ 'Civil liability for oil certificate',
    "Document declaring a ship owner's liability for oil propelling or carried on a vessel." ],
'795' => [ 'Loadline document',
    "Document specifying the limit of a ship's legal submersion under various conditions." ],
'796' => [ 'Derat document',
    'Document certifying that a ship is free of rats, valid to a specified date.' ],
'797' => [ 'Maritime declaration of health',
    'Document certifying the health condition on board a vessel, valid to a specified date.' ],
'798' => [ 'Certificate of registry',
    "Official certificate stating the vessel's registry." ],
'799' => [ "Ship's stores declaration",
    "Declaration to Customs regarding the contents of the ship's stores (equivalent to IMO FAL 3) i.e. goods intended for consumption by passengers/crew on board vessels, aircraft or trains, whether or not sold or landed; goods necessary for operation/maintenance of conveyance, including fuel/lubricants, excluding spare parts/equipment (IMO)." ],
'810' => [ 'Export licence, application for',
    'Application for a permit issued by a government authority permitting exportation of a specified commodity subject to specified conditions as quantity, country of destination, etc.' ],
'811' => [ 'Export licence',
    'Permit issued by a government authority permitting exportation of a specified commodity subject to specified conditions as quantity, country of destination, etc. Synonym: Embargo permit.' ],
'812' => [ 'Exchange control declaration, export',
    'Document/message completed by an exporter/seller as a means whereby the competent body may control that the amount of foreign exchange accrued from a trade transaction is repatriated in accordance with the conditions of payment and exchange control regulations in force.' ],
'820' => [ 'Despatch note model T',
    'European community transit declaration.' ],
'821' => [ 'Despatch note model T1',
    'Transit declaration for goods circulating under internal community transit procedures (between European Union (EU) countries).' ],
'822' => [ 'Despatch note model T2',
    'Ascertainment that the declared goods were originally produced in an European Union (EU) country.' ],
'823' => [ 'Control document T5',
    'Control document (export declaration) used particularly in case of re-sending without use with only VAT collection, refusal, unconformity with contract etc.' ],
'824' => [ 'Re-sending consignment note',
    'Rail consignment note prepared by the consignor for the facilitation of an eventual return to the origin of the goods.' ],
'825' => [ 'Despatch note model T2L',
    'Ascertainment that the declared goods were originally produced in an European Union (EU) country. May only be used for goods that are loaded on one single means of transport in one single departure point for one single delivery point.' ],
'830' => [ 'Goods declaration for exportation',
    'Document/message by which goods are declared for export Customs clearance, conforming to the layout key set out at Appendix I to Annex C.1 concerning outright exportation to the Kyoto convention (CCC). Within a Customs union, "for despatch" may have the same meaning as "for exportation".' ],
'833' => [ 'Cargo declaration (departure)',
    'Generic term, sometimes referred to as Freight declaration, applied to the documents providing the particulars required by the Customs concerning the cargo (freight) carried by commercial means of transport (CCC).' ],
'840' => [ 'Application for goods control certificate',
    'Document/message submitted to a competent body by party requesting a Goods control certificate to be issued in accordance with national or international standards, or conforming to legislation in the importing country, or as specified in the contract.' ],
'841' => [ 'Goods control certificate',
    'Document/message issued by a competent body evidencing the quality of the goods described therein, in accordance with national or international standards, or conforming to legislation in the importing country, or as specified in the contract.' ],
'850' => [ 'Application for phytosanitary certificate',
    'Document/message submitted to a competent body by party requesting a Phytosanitary certificate to be issued.' ],
'851' => [ 'Phytosanitary certificate',
    'Document/message issued by the competent body in the exporting country evidencing that plants, fruit, or vegetables are free from disease and fit for consumption and giving details on fumigation or other treatment to which they may have been subjected.' ],
'852' => [ 'Sanitary certificate',
    'Document/message issued by the competent authority in the exporting country evidencing that alimentary and animal products, including dead animals, are fit for human consumption, and giving details, when relevant, of controls undertaken.' ],
'853' => [ 'Veterinary certificate',
    'Document/message issued by the competent authority in the exporting country evidencing that live animals or birds are not infested or infected with disease, and giving details regarding their provenance, and of vaccinations and other treatment to which they have been subjected.' ],
'855' => [ 'Application for inspection certificate',
    'Document/message submitted to a competent body by a party requesting an Inspection certificate to be issued in accordance with national or international standards, or conforming to legislation in the country in which it is required, or as specified in the contract.' ],
'856' => [ 'Inspection certificate',
    'Document/message issued by a competent body evidencing that the goods described therein have been inspected in accordance with national or international standards, in conformity with legislation in the country in which the inspection is required, or as specified in the contract.' ],
'860' => [ 'Certificate of origin, application for',
    'Document/message submitted to a competent body by an interested party requesting a Certificate of origin to be issued in accordance with relevant criteria, and on the basis of evidence of the origin of the goods.' ],
'861' => [ 'Certificate of origin',
    'Document/message identifying goods, in which the authority or body authorized to issue it certifies expressly that the goods to which the certificate relates originate in a specific country. The word "country" may include a group of countries, a region or a part of a country. This certificate may also include a declaration by the manufacturer, producer, supplier, exporter or other competent person.' ],
'862' => [ 'Declaration of origin',
    'Appropriate statement as to the origin of the goods, made in connection with their exportation by the manufacturer, producer, supplier, exporter or other competent person on the Commercial invoice or any other document relating to the goods (CCC).' ],
'863' => [ 'Regional appellation certificate',
    'Certificate drawn up in accordance with the rules laid down by an authority or approved body, certifying that the goods described therein qualify for a designation specific to the given region (e.g. champagne, port wine, Parmesan cheese).' ],
'864' => [ 'Preference certificate of origin',
    'Document/message describing a certificate of origin meeting the requirements for preferential treatment.' ],
'865' => [ 'Certificate of origin form GSP',
    'Specific form of certificate of origin for goods qualifying for preferential treatment under the generalized system of preferences (includes a combined declaration of origin and certificate, form A).' ],
'870' => [ 'Consular invoice',
    'Document/message to be prepared by an exporter in his country and presented to a diplomatic representation of the importing country for endorsement and subsequently to be presented by the importer in connection with the import of the goods described therein.' ],
'890' => [ 'Dangerous goods declaration',
    '(1115) Document/message issued by a consignor in accordance with applicable conventions or regulations, describing hazardous goods or materials for transport purposes, and stating that the latter have been packed and labelled in accordance with the provisions of the relevant conventions or regulations.' ],
'895' => [ 'Statistical document, export',
    'Document/message in which an exporter provides information about exported goods required by the body responsible for the collection of international trade statistics.' ],
'896' => [ 'INTRASTAT declaration',
    'Document/message in which a declarant provides information about goods required by the body responsible for the collection of trade statistics.' ],
'901' => [ 'Delivery verification certificate',
    'Document/message whereby an official authority (Customs or governmental) certifies that goods have been delivered.' ],
'910' => [ 'Import licence, application for',
    'Document/message in which an interested party applies to the competent body for authorization to import either a limited quantity of articles subject to import restrictions, or an unlimited quantity of such articles during a limited period, and specifies the kind of articles, their origin and value, etc.' ],
'911' => [ 'Import licence',
    'Document/message issued by the competent body in accordance with import regulations in force, by which authorization is granted to a named party to import either a limited quantity of designated articles or an unlimited quantity of such articles during a limited period, under conditions specified in the document.' ],
'913' => [ 'Customs declaration without commercial detail',
    'CUSDEC transmission that does not include data from the commercial detail section of the message.' ],
'914' => [ 'Customs declaration with commercial and item detail',
    'CUSDEC transmission that includes data from both the commercial detail and item detail sections of the message.' ],
'915' => [ 'Customs declaration without item detail',
    'CUSDEC transmission that does not include data from the item detail section of the message.' ],
'916' => [ 'Related document',
    'Document that has a relationship with the stated document/message.' ],
'917' => [ 'Receipt (Customs)',
    'Receipt for Customs duty/tax/fee paid.' ],
'925' => [ 'Application for exchange allocation',
    'Document/message whereby an importer/buyer requests the competent body to allocate an amount of foreign exchange to be transferred to an exporter/seller in payment for goods.' ],
'926' => [ 'Foreign exchange permit',
    'Document/message issued by the competent body authorizing an importer/buyer to transfer an amount of foreign exchange to an exporter/seller in payment for goods.' ],
'927' => [ 'Exchange control declaration (import)',
    'Document/message completed by an importer/buyer as a means for the competent body to control that a trade transaction for which foreign exchange has been allocated has been executed and that money has been transferred in accordance with the conditions of payment and the exchange control regulations in force.' ],
'929' => [ 'Goods declaration for importation',
    'Document/message by which goods are declared for import Customs clearance [sister entry of 830].' ],
'930' => [ 'Goods declaration for home use',
    'Document/message by which goods are declared for import Customs clearance according to Annex B.1 (concerning clearance for home use) to the Kyoto convention (CCC).' ],
'931' => [ 'Customs immediate release declaration',
    "Document/message issued by an importer notifying Customs that goods have been removed from an importing means of transport to the importer's premises under a Customs- approved arrangement for immediate release, or requesting authorization to do so." ],
'932' => [ 'Customs delivery note',
    'Document/message whereby a Customs authority releases goods under its control to be placed at the disposal of the party concerned. Synonym: Customs release note.' ],
'933' => [ 'Cargo declaration (arrival)',
    'Generic term, sometimes referred to as Freight declaration, applied to the documents providing the particulars required by the Customs concerning the cargo (freight) carried by commercial means of transport (CCC).' ],
'934' => [ 'Value declaration',
    'Document/message in which a declarant (importer) states the invoice or other price (e.g. selling price, price of identical goods), and specifies costs for freight, insurance and packing, etc., terms of delivery and payment, any relationship with the trading partner, etc., for the purpose of determining the Customs value of goods imported.' ],
'935' => [ 'Customs invoice',
    'Document/message required by the Customs in an importing country in which an exporter states the invoice or other price (e.g. selling price, price of identical goods), and specifies costs for freight, insurance and packing, etc., terms of delivery and payment, for the purpose of determining the Customs value in the importing country of goods consigned to that country.' ],
'936' => [ 'Customs declaration (post parcels)',
    'Document/message which, according to Article 106 of the "Agreement concerning Postal Parcels" under the UPU Convention, must accompany post parcels and in which the contents of such parcels are specified.' ],
'937' => [ 'Tax declaration (value added tax)',
    'Document/message in which an importer states the pertinent information required by the competent body for assessment of value-added tax.' ],
'938' => [ 'Tax declaration (general)',
    'Document/message containing a general tax declaration.' ],
'940' => [ 'Tax demand',
    'Document/message containing the demand of tax.' ],
'941' => [ 'Embargo permit',
    'Document/message giving the permission to export specified goods.' ],
'950' => [ 'Goods declaration for Customs transit',
    'Document/message by which the sender declares goods for Customs transit according to Annex E.1 (concerning Customs transit) to the Kyoto convention (CCC).' ],
'951' => [ 'TIF form',
    'International Customs transit document by which the sender declares goods for carriage by rail in accordance with the provisions of the 1952 International Convention to facilitate the crossing of frontiers for goods carried by rail (TIF Convention of UIC).' ],
'952' => [ 'TIR carnet',
    'International Customs document (International Transit by Road), issued by a guaranteeing association approved by the Customs authorities, under the cover of which goods are carried, in most cases under Customs seal, in road vehicles and/or containers in compliance with the requirements of the Customs TIR Convention of the International Transport of Goods under cover of TIR Carnets (UN/ECE).' ],
'953' => [ 'EC carnet',
    'EC customs transit document issued by EC customs authorities for transit and/or temporary user of goods within the EC.' ],
'954' => [ 'EUR 1 certificate of origin',
    'Customs certificate used in preferential goods interchanges between EC countries and EC external countries.' ],
'955' => [ 'ATA carnet',
    'International Customs document (Admission Temporaire / Temporary Admission) which, issued under the terms of the ATA Convention (1961), incorporates an internationally valid guarantee and may be used, in lieu of national Customs documents and as security for import duties and taxes, to cover the temporary admission of goods and, where appropriate, the transit of goods. If accepted for controlling the temporary export and reimport of goods, international guarantee does not apply (CCC).' ],
'960' => [ 'Single administrative document',
    'A set of documents, replacing the various (national) forms for Customs declaration within the EC, implemented on 01-01-1988.' ],
'961' => [ 'General response (Customs)',
    'General response message to permit the transfer of data from Customs to the transmitter of the previous message.' ],
'962' => [ 'Document response (Customs)',
    'Document response message to permit the transfer of data from Customs to the transmitter of the previous message.' ],
'963' => [ 'Error response (Customs)',
    'Error response message to permit the transfer of data from Customs to the transmitter of the previous message.' ],
'964' => [ 'Package response (Customs)',
    'Package response message to permit the transfer of data from Customs to the transmitter of the previous message.' ],
'965' => [ 'Tax calculation/confirmation response (Customs)',
    'Tax calculation/confirmation response message to permit the transfer of data from Customs to the transmitter of the previous message.' ],
'966' => [ 'Quota prior allocation certificate',
    'Document/message issued by the competent body for prior allocation of a quota.' ],
'970' => [ 'Wagon report',
    'Document which contains consignment information concerning the wagons and their lading in a case of a multiple wagon consignment.' ],
'971' => [ 'Transit Conveyor Document',
    'Document for a course of transit used for a carrier who is neither the carrier at the beginning nor the arrival. The transit carrier can directly invoice the expenses for its part of the transport.' ],
'972' => [ 'Rail consignment note forwarder copy',
    'Document which is a copy of the rail consignment note printed especially for the need of the forwarder.' ],
'974' => [ 'Duty suspended goods',
    'Document giving details for the carriage of excisable goods on a duty-suspended basis.' ],
'975' => [ 'Proof of transit declaration',
    'A document providing proof that a transit declaration has been accepted.' ],
'976' => [ 'Container transfer note',
    'Document for the carriage of containers. Syn: transfer note.' ],
'977' => [ 'NATO transit document',
    'Customs transit document for the carriage of shipments of the NATO armed forces under Customs supervision.' ],
'978' => [ 'Transfrontier waste shipment authorization',
    'Document containing the authorization from the relevant authority for the international carriage of waste. Syn: Transfrontier waste shipment permit.' ],
'979' => [ 'Transfrontier waste shipment movement document',
    'Document certified by the carriers and the consignee to be used for the international carriage of waste.' ],
'990' => [ 'End use authorization',
    'Document issued by Customs granting the end-use Customs procedure.' ],
'991' => [ 'Government contract',
    'Document/message describing a contract with a government authority.' ],
'995' => [ 'Statistical document, import',
    'Document/message describing an import document that is used for statistical purposes.' ],
'996' => [ 'Application for documentary credit',
    'Message with application for opening of a documentary credit.' ],
'998' => [ 'Previous Customs document/message',
    'Indication of the previous Customs document/message concerning the same transaction.' ],
);
sub get_codes { return \%code_hash; }

1;
