/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ling.tokensregex;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.tokensregex.Env;
import edu.stanford.nlp.ling.tokensregex.EnvLookup;
import edu.stanford.nlp.ling.tokensregex.NodePattern;
import edu.stanford.nlp.ling.tokensregex.SequenceMatcher;
import edu.stanford.nlp.ling.tokensregex.SequencePattern;
import edu.stanford.nlp.util.ArrayMap;
import edu.stanford.nlp.util.CollectionUtils;
import edu.stanford.nlp.util.CoreMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CoreMapNodePattern
extends NodePattern<CoreMap> {
    private Map<Class, NodePattern> annotationPatterns;
    public static AttributesEqualMatchChecker TEXT_ATTR_EQUAL_CHECKER = new AttributesEqualMatchChecker(CoreAnnotations.TextAnnotation.class);

    public CoreMapNodePattern() {
    }

    public CoreMapNodePattern(Map<Class, NodePattern> annotationPatterns) {
        this.annotationPatterns = annotationPatterns;
    }

    public static CoreMapNodePattern valueOf(String textAnnotationPattern) {
        return CoreMapNodePattern.valueOf(null, textAnnotationPattern);
    }

    public static CoreMapNodePattern valueOf(Env env, String textAnnotationPattern) {
        CoreMapNodePattern p = new CoreMapNodePattern();
        p.annotationPatterns = new ArrayMap<Class, NodePattern>(1);
        p.annotationPatterns.put(CoreAnnotations.TextAnnotation.class, new StringAnnotationRegexPattern(textAnnotationPattern, env != null ? env.defaultStringPatternFlags : 0));
        return p;
    }

    public static CoreMapNodePattern valueOf(Map<String, String> attributes) {
        return CoreMapNodePattern.valueOf(null, attributes);
    }

    public static CoreMapNodePattern valueOf(Env env, Map<String, String> attributes) {
        CoreMapNodePattern p = new CoreMapNodePattern();
        p.annotationPatterns = new ArrayMap<Class, NodePattern>(attributes.size());
        for (String attr : attributes.keySet()) {
            String value = attributes.get(attr);
            Class c = EnvLookup.lookupAnnotationKey(env, attr);
            if (c != null) {
                if (value.startsWith("\"") && value.endsWith("\"")) {
                    value = value.substring(1, value.length() - 1);
                    value = value.replaceAll("\\\\\"", "\"");
                    p.annotationPatterns.put(c, new StringAnnotationPattern(value));
                    continue;
                }
                if (value.startsWith("/") && value.endsWith("/")) {
                    value = value.substring(1, value.length() - 1);
                    value = value.replaceAll("\\\\/", "/");
                    p.annotationPatterns.put(c, new StringAnnotationRegexPattern(env != null ? env.getStringPattern(value) : Pattern.compile(value)));
                    continue;
                }
                if (value.startsWith("::")) {
                    Object custom;
                    if (value.equals("::IS_NIL") || value.equals("::NOT_EXISTS")) {
                        p.annotationPatterns.put(c, new NilAnnotationPattern());
                        continue;
                    }
                    if (value.equals("::EXISTS") || value.equals("::NOT_NIL")) {
                        p.annotationPatterns.put(c, new NotNilAnnotationPattern());
                        continue;
                    }
                    if (value.equals("::IS_NUM")) {
                        p.annotationPatterns.put(c, new NumericAnnotationPattern(0.0, NumericAnnotationPattern.CmpType.IS_NUM));
                        continue;
                    }
                    boolean ok = false;
                    if (env != null && (custom = env.get(value)) != null) {
                        p.annotationPatterns.put(c, (NodePattern)custom);
                        ok = true;
                    }
                    if (ok) continue;
                    throw new IllegalArgumentException("Invalid value " + value + " for key: " + attr);
                }
                if (value.startsWith("<=")) {
                    Double v = Double.parseDouble(value.substring(2));
                    p.annotationPatterns.put(c, new NumericAnnotationPattern(v, NumericAnnotationPattern.CmpType.LE));
                    continue;
                }
                if (value.startsWith(">=")) {
                    Double v = Double.parseDouble(value.substring(2));
                    p.annotationPatterns.put(c, new NumericAnnotationPattern(v, NumericAnnotationPattern.CmpType.GE));
                    continue;
                }
                if (value.startsWith("==")) {
                    Double v = Double.parseDouble(value.substring(2));
                    p.annotationPatterns.put(c, new NumericAnnotationPattern(v, NumericAnnotationPattern.CmpType.EQ));
                    continue;
                }
                if (value.startsWith("!=")) {
                    Double v = Double.parseDouble(value.substring(2));
                    p.annotationPatterns.put(c, new NumericAnnotationPattern(v, NumericAnnotationPattern.CmpType.NE));
                    continue;
                }
                if (value.startsWith(">")) {
                    Double v = Double.parseDouble(value.substring(1));
                    p.annotationPatterns.put(c, new NumericAnnotationPattern(v, NumericAnnotationPattern.CmpType.GT));
                    continue;
                }
                if (value.startsWith("<")) {
                    Double v = Double.parseDouble(value.substring(1));
                    p.annotationPatterns.put(c, new NumericAnnotationPattern(v, NumericAnnotationPattern.CmpType.LT));
                    continue;
                }
                if (value.matches("[A-Za-z0-9_]+")) {
                    p.annotationPatterns.put(c, new StringAnnotationPattern(value));
                    continue;
                }
                throw new IllegalArgumentException("Invalid value " + value + " for key: " + attr);
            }
            throw new IllegalArgumentException("Unknown annotation key: " + attr);
        }
        return p;
    }

    @Override
    public boolean match(CoreMap token) {
        boolean matched = true;
        for (Map.Entry<Class, NodePattern> entry : this.annotationPatterns.entrySet()) {
            Object anno;
            NodePattern annoPattern = entry.getValue();
            if (annoPattern.match(anno = token.get(entry.getKey()))) continue;
            matched = false;
            break;
        }
        return matched;
    }

    @Override
    public Object matchWithResult(CoreMap token) {
        HashMap<Class, Object> matchResults = new HashMap<Class, Object>();
        if (this.match(token, matchResults)) {
            return matchResults;
        }
        return null;
    }

    protected boolean match(CoreMap token, Map<Class, Object> matchResults) {
        boolean matched = true;
        for (Map.Entry<Class, NodePattern> entry : this.annotationPatterns.entrySet()) {
            Object anno;
            NodePattern annoPattern = entry.getValue();
            Object matchResult = annoPattern.matchWithResult(anno = token.get(entry.getKey()));
            if (matchResult != null) {
                matchResults.put(entry.getKey(), matchResult);
                continue;
            }
            matched = false;
            break;
        }
        return matched;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Class k : this.annotationPatterns.keySet()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(k).append(this.annotationPatterns.get(k));
        }
        return sb.toString();
    }

    public static class AttributesEqualMatchChecker
    implements SequencePattern.NodesMatchChecker<CoreMap> {
        Collection<Class> keys;

        public AttributesEqualMatchChecker(Class ... classes) {
            this.keys = CollectionUtils.asSet(classes);
        }

        @Override
        public boolean matches(CoreMap o1, CoreMap o2) {
            for (Class key : this.keys) {
                Object v1 = o1.get(key);
                Object v2 = o2.get(key);
                if (!(v1 != null ? !v1.equals(v2) : v2 != null)) continue;
                return false;
            }
            return true;
        }
    }

    public static class NumericAnnotationPattern
    extends NodePattern<Object> {
        CmpType cmpType;
        double value;

        public NumericAnnotationPattern(double value, CmpType cmpType) {
            this.value = value;
            this.cmpType = cmpType;
        }

        @Override
        public boolean match(Object node) {
            if (node instanceof String) {
                return this.match((String)node);
            }
            if (node instanceof Number) {
                return this.match((Number)node);
            }
            return false;
        }

        @Override
        public boolean match(Number number) {
            if (number != null) {
                return this.cmpType.accept(number.doubleValue(), this.value);
            }
            return false;
        }

        @Override
        public boolean match(String str) {
            if (str != null) {
                try {
                    double v = Double.parseDouble(str);
                    return this.cmpType.accept(v, this.value);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return false;
        }

        public String toString() {
            return " " + (Object)((Object)this.cmpType) + " " + this.value;
        }

        static enum CmpType {
            IS_NUM{

                @Override
                boolean accept(double v1, double v2) {
                    return true;
                }
            }
            ,
            EQ{

                @Override
                boolean accept(double v1, double v2) {
                    return v1 == v2;
                }
            }
            ,
            NE{

                @Override
                boolean accept(double v1, double v2) {
                    return v1 != v2;
                }
            }
            ,
            GT{

                @Override
                boolean accept(double v1, double v2) {
                    return v1 > v2;
                }
            }
            ,
            GE{

                @Override
                boolean accept(double v1, double v2) {
                    return v1 >= v2;
                }
            }
            ,
            LT{

                @Override
                boolean accept(double v1, double v2) {
                    return v1 < v2;
                }
            }
            ,
            LE{

                @Override
                boolean accept(double v1, double v2) {
                    return v1 <= v2;
                }
            };


            boolean accept(double v1, double v2) {
                return false;
            }
        }
    }

    public static class StringAnnotationPattern
    extends NodePattern<String> {
        String target;
        boolean ignoreCase;

        public StringAnnotationPattern(String str, boolean ignoreCase) {
            this.target = str;
            this.ignoreCase = ignoreCase;
        }

        public StringAnnotationPattern(String str) {
            this.target = str;
        }

        public String getString() {
            return this.target;
        }

        @Override
        public boolean match(String str) {
            if (this.ignoreCase) {
                return this.target.equalsIgnoreCase(str);
            }
            return this.target.equals(str);
        }

        public String toString() {
            return ":" + this.target;
        }
    }

    public static class StringAnnotationRegexPattern
    extends NodePattern<String> {
        Pattern pattern;

        public StringAnnotationRegexPattern(Pattern pattern) {
            this.pattern = pattern;
        }

        public StringAnnotationRegexPattern(String regex, int flags) {
            this.pattern = Pattern.compile(regex, flags);
        }

        public Pattern getPattern() {
            return this.pattern;
        }

        public Matcher matcher(String str) {
            return this.pattern.matcher(str);
        }

        @Override
        public boolean match(String str) {
            if (str == null) {
                return false;
            }
            return this.pattern.matcher(str).matches();
        }

        @Override
        public Object matchWithResult(String str) {
            Matcher m = this.pattern.matcher(str);
            if (m.matches()) {
                return m.toMatchResult();
            }
            return null;
        }

        public String toString() {
            return ":/" + this.pattern.pattern() + "/";
        }
    }

    public static class SequenceRegexPattern<T>
    extends NodePattern<List<T>> {
        SequencePattern<T> pattern;

        public SequenceRegexPattern(SequencePattern<T> pattern) {
            this.pattern = pattern;
        }

        public SequencePattern<T> getPattern() {
            return this.pattern;
        }

        public SequenceMatcher<T> matcher(List<T> list) {
            return this.pattern.getMatcher(list);
        }

        @Override
        public boolean match(List<T> list) {
            return this.pattern.getMatcher(list).matches();
        }

        @Override
        public Object matchWithResult(List<T> list) {
            SequenceMatcher<T> m = this.pattern.getMatcher(list);
            if (m.matches()) {
                return m.toBasicSequenceMatchResult();
            }
            return null;
        }

        public String toString() {
            return ":" + this.pattern.toString();
        }
    }

    public static class NotNilAnnotationPattern
    extends NodePattern<Object> {
        @Override
        public boolean match(Object obj) {
            return obj != null;
        }

        public String toString() {
            return "::NOT_NIL";
        }
    }

    public static class NilAnnotationPattern
    extends NodePattern<Object> {
        @Override
        public boolean match(Object obj) {
            return obj == null;
        }

        public String toString() {
            return "::IS_NIL";
        }
    }
}

