package Monitoring::GLPlugin::SNMP::MibsAndOids::CISCOIPSECFLOWMONITORMIB;

$Monitoring::GLPlugin::SNMP::MibsAndOids::origin->{'CISCO-IPSEC-FLOW-MONITOR-MIB'} = {
  url => '',
  name => 'CISCO-IPSEC-FLOW-MONITOR-MIB',
};

$Monitoring::GLPlugin::SNMP::MibsAndOids::mibs_and_oids->{'CISCO-IPSEC-FLOW-MONITOR-MIB'} = {
  'enterprises' => '1.3.6.1.4.1',
  'cisco' => '1.3.6.1.4.1.9',
  'ciscoMgmt' => '1.3.6.1.4.1.9.9',
  'ciscoIpSecFlowMonitorMIB' => '1.3.6.1.4.1.9.9.171',
  'ciscoIpSecFlowMonitorMIBDefinition' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'cipSecMIBObjects' => '1.3.6.1.4.1.9.9.171.1',
  'cipSecLevels' => '1.3.6.1.4.1.9.9.171.1.1',
  'cipSecMibLevel' => '1.3.6.1.4.1.9.9.171.1.1.1',
  'cipSecPhaseOne' => '1.3.6.1.4.1.9.9.171.1.2',
  'cikeGlobalStats' => '1.3.6.1.4.1.9.9.171.1.2.1',
  'cikeGlobalActiveTunnels' => '1.3.6.1.4.1.9.9.171.1.2.1.1',
  'cikeGlobalPreviousTunnels' => '1.3.6.1.4.1.9.9.171.1.2.1.2',
  'cikeGlobalInOctets' => '1.3.6.1.4.1.9.9.171.1.2.1.3',
  'cikeGlobalInPkts' => '1.3.6.1.4.1.9.9.171.1.2.1.4',
  'cikeGlobalInDropPkts' => '1.3.6.1.4.1.9.9.171.1.2.1.5',
  'cikeGlobalInNotifys' => '1.3.6.1.4.1.9.9.171.1.2.1.6',
  'cikeGlobalInP2Exchgs' => '1.3.6.1.4.1.9.9.171.1.2.1.7',
  'cikeGlobalInP2ExchgInvalids' => '1.3.6.1.4.1.9.9.171.1.2.1.8',
  'cikeGlobalInP2ExchgRejects' => '1.3.6.1.4.1.9.9.171.1.2.1.9',
  'cikeGlobalInP2SaDelRequests' => '1.3.6.1.4.1.9.9.171.1.2.1.10',
  'cikeGlobalOutOctets' => '1.3.6.1.4.1.9.9.171.1.2.1.11',
  'cikeGlobalOutPkts' => '1.3.6.1.4.1.9.9.171.1.2.1.12',
  'cikeGlobalOutDropPkts' => '1.3.6.1.4.1.9.9.171.1.2.1.13',
  'cikeGlobalOutNotifys' => '1.3.6.1.4.1.9.9.171.1.2.1.14',
  'cikeGlobalOutP2Exchgs' => '1.3.6.1.4.1.9.9.171.1.2.1.15',
  'cikeGlobalOutP2ExchgInvalids' => '1.3.6.1.4.1.9.9.171.1.2.1.16',
  'cikeGlobalOutP2ExchgRejects' => '1.3.6.1.4.1.9.9.171.1.2.1.17',
  'cikeGlobalOutP2SaDelRequests' => '1.3.6.1.4.1.9.9.171.1.2.1.18',
  'cikeGlobalInitTunnels' => '1.3.6.1.4.1.9.9.171.1.2.1.19',
  'cikeGlobalInitTunnelFails' => '1.3.6.1.4.1.9.9.171.1.2.1.20',
  'cikeGlobalRespTunnelFails' => '1.3.6.1.4.1.9.9.171.1.2.1.21',
  'cikeGlobalSysCapFails' => '1.3.6.1.4.1.9.9.171.1.2.1.22',
  'cikeGlobalAuthFails' => '1.3.6.1.4.1.9.9.171.1.2.1.23',
  'cikeGlobalDecryptFails' => '1.3.6.1.4.1.9.9.171.1.2.1.24',
  'cikeGlobalHashValidFails' => '1.3.6.1.4.1.9.9.171.1.2.1.25',
  'cikeGlobalNoSaFails' => '1.3.6.1.4.1.9.9.171.1.2.1.26',
  'cikePeerTable' => '1.3.6.1.4.1.9.9.171.1.2.2',
  'cikePeerEntry' => '1.3.6.1.4.1.9.9.171.1.2.2.1',
  'cikePeerLocalType' => '1.3.6.1.4.1.9.9.171.1.2.2.1.1',
  'cikePeerLocalTypeDefinition' => 'CISCO-IPSEC-FLOW-MONITOR-MIB::IkePeerType',
  'cikePeerLocalValue' => '1.3.6.1.4.1.9.9.171.1.2.2.1.2',
  'cikePeerRemoteType' => '1.3.6.1.4.1.9.9.171.1.2.2.1.3',
  'cikePeerRemoteTypeDefinition' => 'CISCO-IPSEC-FLOW-MONITOR-MIB::IkePeerType',
  'cikePeerRemoteValue' => '1.3.6.1.4.1.9.9.171.1.2.2.1.4',
  'cikePeerIntIndex' => '1.3.6.1.4.1.9.9.171.1.2.2.1.5',
  'cikePeerLocalAddr' => '1.3.6.1.4.1.9.9.171.1.2.2.1.6',
  'cikePeerRemoteAddr' => '1.3.6.1.4.1.9.9.171.1.2.2.1.7',
  'cikePeerActiveTime' => '1.3.6.1.4.1.9.9.171.1.2.2.1.8',
  'cikePeerActiveTunnelIndex' => '1.3.6.1.4.1.9.9.171.1.2.2.1.9',
  'cikeTunnelTable' => '1.3.6.1.4.1.9.9.171.1.2.3',
  'cikeTunnelEntry' => '1.3.6.1.4.1.9.9.171.1.2.3.1',
  'cikeTunIndex' => '1.3.6.1.4.1.9.9.171.1.2.3.1.1',
  'cikeTunLocalType' => '1.3.6.1.4.1.9.9.171.1.2.3.1.2',
  'cikeTunLocalTypeDefinition' => 'CISCO-IPSEC-FLOW-MONITOR-MIB::IkePeerType',
  'cikeTunLocalValue' => '1.3.6.1.4.1.9.9.171.1.2.3.1.3',
  'cikeTunLocalAddr' => '1.3.6.1.4.1.9.9.171.1.2.3.1.4',
  'cikeTunLocalName' => '1.3.6.1.4.1.9.9.171.1.2.3.1.5',
  'cikeTunRemoteType' => '1.3.6.1.4.1.9.9.171.1.2.3.1.6',
  'cikeTunRemoteTypeDefinition' => 'CISCO-IPSEC-FLOW-MONITOR-MIB::IkePeerType',
  'cikeTunRemoteValue' => '1.3.6.1.4.1.9.9.171.1.2.3.1.7',
  'cikeTunRemoteAddr' => '1.3.6.1.4.1.9.9.171.1.2.3.1.8',
  'cikeTunRemoteName' => '1.3.6.1.4.1.9.9.171.1.2.3.1.9',
  'cikeTunNegoMode' => '1.3.6.1.4.1.9.9.171.1.2.3.1.10',
  'cikeTunNegoModeDefinition' => 'CISCO-IPSEC-FLOW-MONITOR-MIB::IkeNegoMode',
  'cikeTunDiffHellmanGrp' => '1.3.6.1.4.1.9.9.171.1.2.3.1.11',
  'cikeTunDiffHellmanGrpDefinition' => 'CISCO-IPSEC-FLOW-MONITOR-MIB::DiffHellmanGrp',
  'cikeTunEncryptAlgo' => '1.3.6.1.4.1.9.9.171.1.2.3.1.12',
  'cikeTunEncryptAlgoDefinition' => 'CISCO-IPSEC-FLOW-MONITOR-MIB::EncryptAlgo',
  'cikeTunHashAlgo' => '1.3.6.1.4.1.9.9.171.1.2.3.1.13',
  'cikeTunHashAlgoDefinition' => 'CISCO-IPSEC-FLOW-MONITOR-MIB::IkeHashAlgo',
  'cikeTunAuthMethod' => '1.3.6.1.4.1.9.9.171.1.2.3.1.14',
  'cikeTunAuthMethodDefinition' => 'CISCO-IPSEC-FLOW-MONITOR-MIB::IkeAuthMethod',
  'cikeTunLifeTime' => '1.3.6.1.4.1.9.9.171.1.2.3.1.15',
  'cikeTunActiveTime' => '1.3.6.1.4.1.9.9.171.1.2.3.1.16',
  'cikeTunSaRefreshThreshold' => '1.3.6.1.4.1.9.9.171.1.2.3.1.17',
  'cikeTunTotalRefreshes' => '1.3.6.1.4.1.9.9.171.1.2.3.1.18',
  'cikeTunInOctets' => '1.3.6.1.4.1.9.9.171.1.2.3.1.19',
  'cikeTunInPkts' => '1.3.6.1.4.1.9.9.171.1.2.3.1.20',
  'cikeTunInDropPkts' => '1.3.6.1.4.1.9.9.171.1.2.3.1.21',
  'cikeTunInNotifys' => '1.3.6.1.4.1.9.9.171.1.2.3.1.22',
  'cikeTunInP2Exchgs' => '1.3.6.1.4.1.9.9.171.1.2.3.1.23',
  'cikeTunInP2ExchgInvalids' => '1.3.6.1.4.1.9.9.171.1.2.3.1.24',
  'cikeTunInP2ExchgRejects' => '1.3.6.1.4.1.9.9.171.1.2.3.1.25',
  'cikeTunInP2SaDelRequests' => '1.3.6.1.4.1.9.9.171.1.2.3.1.26',
  'cikeTunOutOctets' => '1.3.6.1.4.1.9.9.171.1.2.3.1.27',
  'cikeTunOutPkts' => '1.3.6.1.4.1.9.9.171.1.2.3.1.28',
  'cikeTunOutDropPkts' => '1.3.6.1.4.1.9.9.171.1.2.3.1.29',
  'cikeTunOutNotifys' => '1.3.6.1.4.1.9.9.171.1.2.3.1.30',
  'cikeTunOutP2Exchgs' => '1.3.6.1.4.1.9.9.171.1.2.3.1.31',
  'cikeTunOutP2ExchgInvalids' => '1.3.6.1.4.1.9.9.171.1.2.3.1.32',
  'cikeTunOutP2ExchgRejects' => '1.3.6.1.4.1.9.9.171.1.2.3.1.33',
  'cikeTunOutP2SaDelRequests' => '1.3.6.1.4.1.9.9.171.1.2.3.1.34',
  'cikeTunStatus' => '1.3.6.1.4.1.9.9.171.1.2.3.1.35',
  'cikeTunStatusDefinition' => 'CISCO-IPSEC-FLOW-MONITOR-MIB::TunnelStatus',
  'cikePeerCorrTable' => '1.3.6.1.4.1.9.9.171.1.2.4',
  'cikePeerCorrEntry' => '1.3.6.1.4.1.9.9.171.1.2.4.1',
  'cikePeerCorrLocalType' => '1.3.6.1.4.1.9.9.171.1.2.4.1.1',
  'cikePeerCorrLocalTypeDefinition' => 'CISCO-IPSEC-FLOW-MONITOR-MIB::IkePeerType',
  'cikePeerCorrLocalValue' => '1.3.6.1.4.1.9.9.171.1.2.4.1.2',
  'cikePeerCorrRemoteType' => '1.3.6.1.4.1.9.9.171.1.2.4.1.3',
  'cikePeerCorrRemoteTypeDefinition' => 'CISCO-IPSEC-FLOW-MONITOR-MIB::IkePeerType',
  'cikePeerCorrRemoteValue' => '1.3.6.1.4.1.9.9.171.1.2.4.1.4',
  'cikePeerCorrIntIndex' => '1.3.6.1.4.1.9.9.171.1.2.4.1.5',
  'cikePeerCorrSeqNum' => '1.3.6.1.4.1.9.9.171.1.2.4.1.6',
  'cikePeerCorrIpSecTunIndex' => '1.3.6.1.4.1.9.9.171.1.2.4.1.7',
  'cikePhase1GWStatsTable' => '1.3.6.1.4.1.9.9.171.1.2.5',
  'cikePhase1GWStatsEntry' => '1.3.6.1.4.1.9.9.171.1.2.5.1',
  'cikePhase1GWActiveTunnels' => '1.3.6.1.4.1.9.9.171.1.2.5.1.1',
  'cikePhase1GWPreviousTunnels' => '1.3.6.1.4.1.9.9.171.1.2.5.1.2',
  'cikePhase1GWInOctets' => '1.3.6.1.4.1.9.9.171.1.2.5.1.3',
  'cikePhase1GWInPkts' => '1.3.6.1.4.1.9.9.171.1.2.5.1.4',
  'cikePhase1GWInDropPkts' => '1.3.6.1.4.1.9.9.171.1.2.5.1.5',
  'cikePhase1GWInNotifys' => '1.3.6.1.4.1.9.9.171.1.2.5.1.6',
  'cikePhase1GWInP2Exchgs' => '1.3.6.1.4.1.9.9.171.1.2.5.1.7',
  'cikePhase1GWInP2ExchgInvalids' => '1.3.6.1.4.1.9.9.171.1.2.5.1.8',
  'cikePhase1GWInP2ExchgRejects' => '1.3.6.1.4.1.9.9.171.1.2.5.1.9',
  'cikePhase1GWInP2SaDelRequests' => '1.3.6.1.4.1.9.9.171.1.2.5.1.10',
  'cikePhase1GWOutOctets' => '1.3.6.1.4.1.9.9.171.1.2.5.1.11',
  'cikePhase1GWOutPkts' => '1.3.6.1.4.1.9.9.171.1.2.5.1.12',
  'cikePhase1GWOutDropPkts' => '1.3.6.1.4.1.9.9.171.1.2.5.1.13',
  'cikePhase1GWOutNotifys' => '1.3.6.1.4.1.9.9.171.1.2.5.1.14',
  'cikePhase1GWOutP2Exchgs' => '1.3.6.1.4.1.9.9.171.1.2.5.1.15',
  'cikePhase1GWOutP2ExchgInvalids' => '1.3.6.1.4.1.9.9.171.1.2.5.1.16',
  'cikePhase1GWOutP2ExchgRejects' => '1.3.6.1.4.1.9.9.171.1.2.5.1.17',
  'cikePhase1GWOutP2SaDelRequests' => '1.3.6.1.4.1.9.9.171.1.2.5.1.18',
  'cikePhase1GWInitTunnels' => '1.3.6.1.4.1.9.9.171.1.2.5.1.19',
  'cikePhase1GWInitTunnelFails' => '1.3.6.1.4.1.9.9.171.1.2.5.1.20',
  'cikePhase1GWRespTunnelFails' => '1.3.6.1.4.1.9.9.171.1.2.5.1.21',
  'cikePhase1GWSysCapFails' => '1.3.6.1.4.1.9.9.171.1.2.5.1.22',
  'cikePhase1GWAuthFails' => '1.3.6.1.4.1.9.9.171.1.2.5.1.23',
  'cikePhase1GWDecryptFails' => '1.3.6.1.4.1.9.9.171.1.2.5.1.24',
  'cikePhase1GWHashValidFails' => '1.3.6.1.4.1.9.9.171.1.2.5.1.25',
  'cikePhase1GWNoSaFails' => '1.3.6.1.4.1.9.9.171.1.2.5.1.26',
  'cipSecPhaseTwo' => '1.3.6.1.4.1.9.9.171.1.3',
  'cipSecGlobalStats' => '1.3.6.1.4.1.9.9.171.1.3.1',
  'cipSecGlobalActiveTunnels' => '1.3.6.1.4.1.9.9.171.1.3.1.1',
  'cipSecGlobalPreviousTunnels' => '1.3.6.1.4.1.9.9.171.1.3.1.2',
  'cipSecGlobalInOctets' => '1.3.6.1.4.1.9.9.171.1.3.1.3',
  'cipSecGlobalHcInOctets' => '1.3.6.1.4.1.9.9.171.1.3.1.4',
  'cipSecGlobalInOctWraps' => '1.3.6.1.4.1.9.9.171.1.3.1.5',
  'cipSecGlobalInDecompOctets' => '1.3.6.1.4.1.9.9.171.1.3.1.6',
  'cipSecGlobalHcInDecompOctets' => '1.3.6.1.4.1.9.9.171.1.3.1.7',
  'cipSecGlobalInDecompOctWraps' => '1.3.6.1.4.1.9.9.171.1.3.1.8',
  'cipSecGlobalInPkts' => '1.3.6.1.4.1.9.9.171.1.3.1.9',
  'cipSecGlobalInDrops' => '1.3.6.1.4.1.9.9.171.1.3.1.10',
  'cipSecGlobalInReplayDrops' => '1.3.6.1.4.1.9.9.171.1.3.1.11',
  'cipSecGlobalInAuths' => '1.3.6.1.4.1.9.9.171.1.3.1.12',
  'cipSecGlobalInAuthFails' => '1.3.6.1.4.1.9.9.171.1.3.1.13',
  'cipSecGlobalInDecrypts' => '1.3.6.1.4.1.9.9.171.1.3.1.14',
  'cipSecGlobalInDecryptFails' => '1.3.6.1.4.1.9.9.171.1.3.1.15',
  'cipSecGlobalOutOctets' => '1.3.6.1.4.1.9.9.171.1.3.1.16',
  'cipSecGlobalHcOutOctets' => '1.3.6.1.4.1.9.9.171.1.3.1.17',
  'cipSecGlobalOutOctWraps' => '1.3.6.1.4.1.9.9.171.1.3.1.18',
  'cipSecGlobalOutUncompOctets' => '1.3.6.1.4.1.9.9.171.1.3.1.19',
  'cipSecGlobalHcOutUncompOctets' => '1.3.6.1.4.1.9.9.171.1.3.1.20',
  'cipSecGlobalOutUncompOctWraps' => '1.3.6.1.4.1.9.9.171.1.3.1.21',
  'cipSecGlobalOutPkts' => '1.3.6.1.4.1.9.9.171.1.3.1.22',
  'cipSecGlobalOutDrops' => '1.3.6.1.4.1.9.9.171.1.3.1.23',
  'cipSecGlobalOutAuths' => '1.3.6.1.4.1.9.9.171.1.3.1.24',
  'cipSecGlobalOutAuthFails' => '1.3.6.1.4.1.9.9.171.1.3.1.25',
  'cipSecGlobalOutEncrypts' => '1.3.6.1.4.1.9.9.171.1.3.1.26',
  'cipSecGlobalOutEncryptFails' => '1.3.6.1.4.1.9.9.171.1.3.1.27',
  'cipSecGlobalProtocolUseFails' => '1.3.6.1.4.1.9.9.171.1.3.1.28',
  'cipSecGlobalNoSaFails' => '1.3.6.1.4.1.9.9.171.1.3.1.29',
  'cipSecGlobalSysCapFails' => '1.3.6.1.4.1.9.9.171.1.3.1.30',
  'cipSecTunnelTable' => '1.3.6.1.4.1.9.9.171.1.3.2',
  'cipSecTunnelEntry' => '1.3.6.1.4.1.9.9.171.1.3.2.1',
  'cipSecTunIndex' => '1.3.6.1.4.1.9.9.171.1.3.2.1.1',
  'cipSecTunIkeTunnelIndex' => '1.3.6.1.4.1.9.9.171.1.3.2.1.2',
  'cipSecTunIkeTunnelAlive' => '1.3.6.1.4.1.9.9.171.1.3.2.1.3',
  'cipSecTunLocalAddr' => '1.3.6.1.4.1.9.9.171.1.3.2.1.4',
  'cipSecTunRemoteAddr' => '1.3.6.1.4.1.9.9.171.1.3.2.1.5',
  'cipSecTunKeyType' => '1.3.6.1.4.1.9.9.171.1.3.2.1.6',
  'cipSecTunKeyTypeDefinition' => 'CISCO-IPSEC-FLOW-MONITOR-MIB::KeyType',
  'cipSecTunEncapMode' => '1.3.6.1.4.1.9.9.171.1.3.2.1.7',
  'cipSecTunEncapModeDefinition' => 'CISCO-IPSEC-FLOW-MONITOR-MIB::EncapMode',
  'cipSecTunLifeSize' => '1.3.6.1.4.1.9.9.171.1.3.2.1.8',
  'cipSecTunLifeTime' => '1.3.6.1.4.1.9.9.171.1.3.2.1.9',
  'cipSecTunActiveTime' => '1.3.6.1.4.1.9.9.171.1.3.2.1.10',
  'cipSecTunSaLifeSizeThreshold' => '1.3.6.1.4.1.9.9.171.1.3.2.1.11',
  'cipSecTunSaLifeTimeThreshold' => '1.3.6.1.4.1.9.9.171.1.3.2.1.12',
  'cipSecTunTotalRefreshes' => '1.3.6.1.4.1.9.9.171.1.3.2.1.13',
  'cipSecTunExpiredSaInstances' => '1.3.6.1.4.1.9.9.171.1.3.2.1.14',
  'cipSecTunCurrentSaInstances' => '1.3.6.1.4.1.9.9.171.1.3.2.1.15',
  'cipSecTunInSaDiffHellmanGrp' => '1.3.6.1.4.1.9.9.171.1.3.2.1.16',
  'cipSecTunInSaDiffHellmanGrpDefinition' => 'CISCO-IPSEC-FLOW-MONITOR-MIB::DiffHellmanGrp',
  'cipSecTunInSaEncryptAlgo' => '1.3.6.1.4.1.9.9.171.1.3.2.1.17',
  'cipSecTunInSaEncryptAlgoDefinition' => 'CISCO-IPSEC-FLOW-MONITOR-MIB::EncryptAlgo',
  'cipSecTunInSaAhAuthAlgo' => '1.3.6.1.4.1.9.9.171.1.3.2.1.18',
  'cipSecTunInSaAhAuthAlgoDefinition' => 'CISCO-IPSEC-FLOW-MONITOR-MIB::AuthAlgo',
  'cipSecTunInSaEspAuthAlgo' => '1.3.6.1.4.1.9.9.171.1.3.2.1.19',
  'cipSecTunInSaEspAuthAlgoDefinition' => 'CISCO-IPSEC-FLOW-MONITOR-MIB::AuthAlgo',
  'cipSecTunInSaDecompAlgo' => '1.3.6.1.4.1.9.9.171.1.3.2.1.20',
  'cipSecTunInSaDecompAlgoDefinition' => 'CISCO-IPSEC-FLOW-MONITOR-MIB::CompAlgo',
  'cipSecTunOutSaDiffHellmanGrp' => '1.3.6.1.4.1.9.9.171.1.3.2.1.21',
  'cipSecTunOutSaDiffHellmanGrpDefinition' => 'CISCO-IPSEC-FLOW-MONITOR-MIB::DiffHellmanGrp',
  'cipSecTunOutSaEncryptAlgo' => '1.3.6.1.4.1.9.9.171.1.3.2.1.22',
  'cipSecTunOutSaEncryptAlgoDefinition' => 'CISCO-IPSEC-FLOW-MONITOR-MIB::EncryptAlgo',
  'cipSecTunOutSaAhAuthAlgo' => '1.3.6.1.4.1.9.9.171.1.3.2.1.23',
  'cipSecTunOutSaAhAuthAlgoDefinition' => 'CISCO-IPSEC-FLOW-MONITOR-MIB::AuthAlgo',
  'cipSecTunOutSaEspAuthAlgo' => '1.3.6.1.4.1.9.9.171.1.3.2.1.24',
  'cipSecTunOutSaEspAuthAlgoDefinition' => 'CISCO-IPSEC-FLOW-MONITOR-MIB::AuthAlgo',
  'cipSecTunOutSaCompAlgo' => '1.3.6.1.4.1.9.9.171.1.3.2.1.25',
  'cipSecTunOutSaCompAlgoDefinition' => 'CISCO-IPSEC-FLOW-MONITOR-MIB::CompAlgo',
  'cipSecTunInOctets' => '1.3.6.1.4.1.9.9.171.1.3.2.1.26',
  'cipSecTunHcInOctets' => '1.3.6.1.4.1.9.9.171.1.3.2.1.27',
  'cipSecTunInOctWraps' => '1.3.6.1.4.1.9.9.171.1.3.2.1.28',
  'cipSecTunInDecompOctets' => '1.3.6.1.4.1.9.9.171.1.3.2.1.29',
  'cipSecTunHcInDecompOctets' => '1.3.6.1.4.1.9.9.171.1.3.2.1.30',
  'cipSecTunInDecompOctWraps' => '1.3.6.1.4.1.9.9.171.1.3.2.1.31',
  'cipSecTunInPkts' => '1.3.6.1.4.1.9.9.171.1.3.2.1.32',
  'cipSecTunInDropPkts' => '1.3.6.1.4.1.9.9.171.1.3.2.1.33',
  'cipSecTunInReplayDropPkts' => '1.3.6.1.4.1.9.9.171.1.3.2.1.34',
  'cipSecTunInAuths' => '1.3.6.1.4.1.9.9.171.1.3.2.1.35',
  'cipSecTunInAuthFails' => '1.3.6.1.4.1.9.9.171.1.3.2.1.36',
  'cipSecTunInDecrypts' => '1.3.6.1.4.1.9.9.171.1.3.2.1.37',
  'cipSecTunInDecryptFails' => '1.3.6.1.4.1.9.9.171.1.3.2.1.38',
  'cipSecTunOutOctets' => '1.3.6.1.4.1.9.9.171.1.3.2.1.39',
  'cipSecTunHcOutOctets' => '1.3.6.1.4.1.9.9.171.1.3.2.1.40',
  'cipSecTunOutOctWraps' => '1.3.6.1.4.1.9.9.171.1.3.2.1.41',
  'cipSecTunOutUncompOctets' => '1.3.6.1.4.1.9.9.171.1.3.2.1.42',
  'cipSecTunHcOutUncompOctets' => '1.3.6.1.4.1.9.9.171.1.3.2.1.43',
  'cipSecTunOutUncompOctWraps' => '1.3.6.1.4.1.9.9.171.1.3.2.1.44',
  'cipSecTunOutPkts' => '1.3.6.1.4.1.9.9.171.1.3.2.1.45',
  'cipSecTunOutDropPkts' => '1.3.6.1.4.1.9.9.171.1.3.2.1.46',
  'cipSecTunOutAuths' => '1.3.6.1.4.1.9.9.171.1.3.2.1.47',
  'cipSecTunOutAuthFails' => '1.3.6.1.4.1.9.9.171.1.3.2.1.48',
  'cipSecTunOutEncrypts' => '1.3.6.1.4.1.9.9.171.1.3.2.1.49',
  'cipSecTunOutEncryptFails' => '1.3.6.1.4.1.9.9.171.1.3.2.1.50',
  'cipSecTunStatus' => '1.3.6.1.4.1.9.9.171.1.3.2.1.51',
  'cipSecTunStatusDefinition' => 'CISCO-IPSEC-FLOW-MONITOR-MIB::TunnelStatus',
  'cipSecEndPtTable' => '1.3.6.1.4.1.9.9.171.1.3.3',
  'cipSecEndPtEntry' => '1.3.6.1.4.1.9.9.171.1.3.3.1',
  'cipSecEndPtIndex' => '1.3.6.1.4.1.9.9.171.1.3.3.1.1',
  'cipSecEndPtLocalName' => '1.3.6.1.4.1.9.9.171.1.3.3.1.2',
  'cipSecEndPtLocalType' => '1.3.6.1.4.1.9.9.171.1.3.3.1.3',
  'cipSecEndPtLocalTypeDefinition' => 'CISCO-IPSEC-FLOW-MONITOR-MIB::EndPtType',
  'cipSecEndPtLocalAddr1' => '1.3.6.1.4.1.9.9.171.1.3.3.1.4',
  'cipSecEndPtLocalAddr2' => '1.3.6.1.4.1.9.9.171.1.3.3.1.5',
  'cipSecEndPtLocalProtocol' => '1.3.6.1.4.1.9.9.171.1.3.3.1.6',
  'cipSecEndPtLocalPort' => '1.3.6.1.4.1.9.9.171.1.3.3.1.7',
  'cipSecEndPtRemoteName' => '1.3.6.1.4.1.9.9.171.1.3.3.1.8',
  'cipSecEndPtRemoteType' => '1.3.6.1.4.1.9.9.171.1.3.3.1.9',
  'cipSecEndPtRemoteTypeDefinition' => 'CISCO-IPSEC-FLOW-MONITOR-MIB::EndPtType',
  'cipSecEndPtRemoteAddr1' => '1.3.6.1.4.1.9.9.171.1.3.3.1.10',
  'cipSecEndPtRemoteAddr2' => '1.3.6.1.4.1.9.9.171.1.3.3.1.11',
  'cipSecEndPtRemoteProtocol' => '1.3.6.1.4.1.9.9.171.1.3.3.1.12',
  'cipSecEndPtRemotePort' => '1.3.6.1.4.1.9.9.171.1.3.3.1.13',
  'cipSecSpiTable' => '1.3.6.1.4.1.9.9.171.1.3.4',
  'cipSecSpiEntry' => '1.3.6.1.4.1.9.9.171.1.3.4.1',
  'cipSecSpiIndex' => '1.3.6.1.4.1.9.9.171.1.3.4.1.1',
  'cipSecSpiDirection' => '1.3.6.1.4.1.9.9.171.1.3.4.1.2',
  'cipSecSpiDirectionDefinition' => {
    '1' => 'in',
    '2' => 'out',
  },
  'cipSecSpiValue' => '1.3.6.1.4.1.9.9.171.1.3.4.1.3',
  'cipSecSpiProtocol' => '1.3.6.1.4.1.9.9.171.1.3.4.1.4',
  'cipSecSpiProtocolDefinition' => {
    '1' => 'ah',
    '2' => 'esp',
    '3' => 'ipcomp',
  },
  'cipSecSpiStatus' => '1.3.6.1.4.1.9.9.171.1.3.4.1.5',
  'cipSecSpiStatusDefinition' => {
    '1' => 'active',
    '2' => 'expiring',
  },
  'cipSecPhase2GWStatsTable' => '1.3.6.1.4.1.9.9.171.1.3.5',
  'cipSecPhase2GWStatsEntry' => '1.3.6.1.4.1.9.9.171.1.3.5.1',
  'cipSecPhase2GWActiveTunnels' => '1.3.6.1.4.1.9.9.171.1.3.5.1.1',
  'cipSecPhase2GWPreviousTunnels' => '1.3.6.1.4.1.9.9.171.1.3.5.1.2',
  'cipSecPhase2GWInOctets' => '1.3.6.1.4.1.9.9.171.1.3.5.1.3',
  'cipSecPhase2GWInOctWraps' => '1.3.6.1.4.1.9.9.171.1.3.5.1.4',
  'cipSecPhase2GWInDecompOctets' => '1.3.6.1.4.1.9.9.171.1.3.5.1.5',
  'cipSecPhase2GWInDecompOctWraps' => '1.3.6.1.4.1.9.9.171.1.3.5.1.6',
  'cipSecPhase2GWInPkts' => '1.3.6.1.4.1.9.9.171.1.3.5.1.7',
  'cipSecPhase2GWInDrops' => '1.3.6.1.4.1.9.9.171.1.3.5.1.8',
  'cipSecPhase2GWInReplayDrops' => '1.3.6.1.4.1.9.9.171.1.3.5.1.9',
  'cipSecPhase2GWInAuths' => '1.3.6.1.4.1.9.9.171.1.3.5.1.10',
  'cipSecPhase2GWInAuthFails' => '1.3.6.1.4.1.9.9.171.1.3.5.1.11',
  'cipSecPhase2GWInDecrypts' => '1.3.6.1.4.1.9.9.171.1.3.5.1.12',
  'cipSecPhase2GWInDecryptFails' => '1.3.6.1.4.1.9.9.171.1.3.5.1.13',
  'cipSecPhase2GWOutOctets' => '1.3.6.1.4.1.9.9.171.1.3.5.1.14',
  'cipSecPhase2GWOutOctWraps' => '1.3.6.1.4.1.9.9.171.1.3.5.1.15',
  'cipSecPhase2GWOutUncompOctets' => '1.3.6.1.4.1.9.9.171.1.3.5.1.16',
  'cipSecPhase2GWOutUncompOctWraps' => '1.3.6.1.4.1.9.9.171.1.3.5.1.17',
  'cipSecPhase2GWOutPkts' => '1.3.6.1.4.1.9.9.171.1.3.5.1.18',
  'cipSecPhase2GWOutDrops' => '1.3.6.1.4.1.9.9.171.1.3.5.1.19',
  'cipSecPhase2GWOutAuths' => '1.3.6.1.4.1.9.9.171.1.3.5.1.20',
  'cipSecPhase2GWOutAuthFails' => '1.3.6.1.4.1.9.9.171.1.3.5.1.21',
  'cipSecPhase2GWOutEncrypts' => '1.3.6.1.4.1.9.9.171.1.3.5.1.22',
  'cipSecPhase2GWOutEncryptFails' => '1.3.6.1.4.1.9.9.171.1.3.5.1.23',
  'cipSecPhase2GWProtocolUseFails' => '1.3.6.1.4.1.9.9.171.1.3.5.1.24',
  'cipSecPhase2GWNoSaFails' => '1.3.6.1.4.1.9.9.171.1.3.5.1.25',
  'cipSecPhase2GWSysCapFails' => '1.3.6.1.4.1.9.9.171.1.3.5.1.26',
  'cipSecHistory' => '1.3.6.1.4.1.9.9.171.1.4',
  'cipSecHistGlobal' => '1.3.6.1.4.1.9.9.171.1.4.1',
  'cipSecHistGlobalCntl' => '1.3.6.1.4.1.9.9.171.1.4.1.1',
  'cipSecHistTableSize' => '1.3.6.1.4.1.9.9.171.1.4.1.1.1',
  'cipSecHistCheckPoint' => '1.3.6.1.4.1.9.9.171.1.4.1.1.2',
  'cipSecHistCheckPointDefinition' => {
    '1' => 'ready',
    '2' => 'checkPoint',
  },
  'cipSecHistPhaseOne' => '1.3.6.1.4.1.9.9.171.1.4.2',
  'cikeTunnelHistTable' => '1.3.6.1.4.1.9.9.171.1.4.2.1',
  'cikeTunnelHistEntry' => '1.3.6.1.4.1.9.9.171.1.4.2.1.1',
  'cikeTunHistIndex' => '1.3.6.1.4.1.9.9.171.1.4.2.1.1.1',
  'cikeTunHistTermReason' => '1.3.6.1.4.1.9.9.171.1.4.2.1.1.2',
  'cikeTunHistTermReasonDefinition' => {
    '1' => 'other',
    '2' => 'normal',
    '3' => 'operRequest',
    '4' => 'peerDelRequest',
    '5' => 'peerLost',
    '6' => 'localFailure',
    '7' => 'checkPointReg',
  },
  'cikeTunHistActiveIndex' => '1.3.6.1.4.1.9.9.171.1.4.2.1.1.3',
  'cikeTunHistPeerLocalType' => '1.3.6.1.4.1.9.9.171.1.4.2.1.1.4',
  'cikeTunHistPeerLocalTypeDefinition' => 'CISCO-IPSEC-FLOW-MONITOR-MIB::IkePeerType',
  'cikeTunHistPeerLocalValue' => '1.3.6.1.4.1.9.9.171.1.4.2.1.1.5',
  'cikeTunHistPeerIntIndex' => '1.3.6.1.4.1.9.9.171.1.4.2.1.1.6',
  'cikeTunHistPeerRemoteType' => '1.3.6.1.4.1.9.9.171.1.4.2.1.1.7',
  'cikeTunHistPeerRemoteTypeDefinition' => 'CISCO-IPSEC-FLOW-MONITOR-MIB::IkePeerType',
  'cikeTunHistPeerRemoteValue' => '1.3.6.1.4.1.9.9.171.1.4.2.1.1.8',
  'cikeTunHistLocalAddr' => '1.3.6.1.4.1.9.9.171.1.4.2.1.1.9',
  'cikeTunHistLocalName' => '1.3.6.1.4.1.9.9.171.1.4.2.1.1.10',
  'cikeTunHistRemoteAddr' => '1.3.6.1.4.1.9.9.171.1.4.2.1.1.11',
  'cikeTunHistRemoteName' => '1.3.6.1.4.1.9.9.171.1.4.2.1.1.12',
  'cikeTunHistNegoMode' => '1.3.6.1.4.1.9.9.171.1.4.2.1.1.13',
  'cikeTunHistNegoModeDefinition' => 'CISCO-IPSEC-FLOW-MONITOR-MIB::IkeNegoMode',
  'cikeTunHistDiffHellmanGrp' => '1.3.6.1.4.1.9.9.171.1.4.2.1.1.14',
  'cikeTunHistDiffHellmanGrpDefinition' => 'CISCO-IPSEC-FLOW-MONITOR-MIB::DiffHellmanGrp',
  'cikeTunHistEncryptAlgo' => '1.3.6.1.4.1.9.9.171.1.4.2.1.1.15',
  'cikeTunHistEncryptAlgoDefinition' => 'CISCO-IPSEC-FLOW-MONITOR-MIB::EncryptAlgo',
  'cikeTunHistHashAlgo' => '1.3.6.1.4.1.9.9.171.1.4.2.1.1.16',
  'cikeTunHistHashAlgoDefinition' => 'CISCO-IPSEC-FLOW-MONITOR-MIB::IkeHashAlgo',
  'cikeTunHistAuthMethod' => '1.3.6.1.4.1.9.9.171.1.4.2.1.1.17',
  'cikeTunHistAuthMethodDefinition' => 'CISCO-IPSEC-FLOW-MONITOR-MIB::IkeAuthMethod',
  'cikeTunHistLifeTime' => '1.3.6.1.4.1.9.9.171.1.4.2.1.1.18',
  'cikeTunHistStartTime' => '1.3.6.1.4.1.9.9.171.1.4.2.1.1.19',
  'cikeTunHistActiveTime' => '1.3.6.1.4.1.9.9.171.1.4.2.1.1.20',
  'cikeTunHistTotalRefreshes' => '1.3.6.1.4.1.9.9.171.1.4.2.1.1.21',
  'cikeTunHistTotalSas' => '1.3.6.1.4.1.9.9.171.1.4.2.1.1.22',
  'cikeTunHistInOctets' => '1.3.6.1.4.1.9.9.171.1.4.2.1.1.23',
  'cikeTunHistInPkts' => '1.3.6.1.4.1.9.9.171.1.4.2.1.1.24',
  'cikeTunHistInDropPkts' => '1.3.6.1.4.1.9.9.171.1.4.2.1.1.25',
  'cikeTunHistInNotifys' => '1.3.6.1.4.1.9.9.171.1.4.2.1.1.26',
  'cikeTunHistInP2Exchgs' => '1.3.6.1.4.1.9.9.171.1.4.2.1.1.27',
  'cikeTunHistInP2ExchgInvalids' => '1.3.6.1.4.1.9.9.171.1.4.2.1.1.28',
  'cikeTunHistInP2ExchgRejects' => '1.3.6.1.4.1.9.9.171.1.4.2.1.1.29',
  'cikeTunHistInP2SaDelRequests' => '1.3.6.1.4.1.9.9.171.1.4.2.1.1.30',
  'cikeTunHistOutOctets' => '1.3.6.1.4.1.9.9.171.1.4.2.1.1.31',
  'cikeTunHistOutPkts' => '1.3.6.1.4.1.9.9.171.1.4.2.1.1.32',
  'cikeTunHistOutDropPkts' => '1.3.6.1.4.1.9.9.171.1.4.2.1.1.33',
  'cikeTunHistOutNotifys' => '1.3.6.1.4.1.9.9.171.1.4.2.1.1.34',
  'cikeTunHistOutP2Exchgs' => '1.3.6.1.4.1.9.9.171.1.4.2.1.1.35',
  'cikeTunHistOutP2ExchgInvalids' => '1.3.6.1.4.1.9.9.171.1.4.2.1.1.36',
  'cikeTunHistOutP2ExchgRejects' => '1.3.6.1.4.1.9.9.171.1.4.2.1.1.37',
  'cikeTunHistOutP2SaDelRequests' => '1.3.6.1.4.1.9.9.171.1.4.2.1.1.38',
  'cipSecHistPhaseTwo' => '1.3.6.1.4.1.9.9.171.1.4.3',
  'cipSecTunnelHistTable' => '1.3.6.1.4.1.9.9.171.1.4.3.1',
  'cipSecTunnelHistEntry' => '1.3.6.1.4.1.9.9.171.1.4.3.1.1',
  'cipSecTunHistIndex' => '1.3.6.1.4.1.9.9.171.1.4.3.1.1.1',
  'cipSecTunHistTermReason' => '1.3.6.1.4.1.9.9.171.1.4.3.1.1.2',
  'cipSecTunHistTermReasonDefinition' => {
    '1' => 'other',
    '2' => 'normal',
    '3' => 'operRequest',
    '4' => 'peerDelRequest',
    '5' => 'peerLost',
    '6' => 'seqNumRollOver',
    '7' => 'checkPointReq',
  },
  'cipSecTunHistActiveIndex' => '1.3.6.1.4.1.9.9.171.1.4.3.1.1.3',
  'cipSecTunHistLocalAddr' => '1.3.6.1.4.1.9.9.171.1.4.3.1.1.5',
  'cipSecTunHistRemoteAddr' => '1.3.6.1.4.1.9.9.171.1.4.3.1.1.6',
  'cipSecTunHistKeyType' => '1.3.6.1.4.1.9.9.171.1.4.3.1.1.7',
  'cipSecTunHistKeyTypeDefinition' => 'CISCO-IPSEC-FLOW-MONITOR-MIB::KeyType',
  'cipSecTunHistEncapMode' => '1.3.6.1.4.1.9.9.171.1.4.3.1.1.8',
  'cipSecTunHistEncapModeDefinition' => 'CISCO-IPSEC-FLOW-MONITOR-MIB::EncapMode',
  'cipSecTunHistLifeSize' => '1.3.6.1.4.1.9.9.171.1.4.3.1.1.9',
  'cipSecTunHistLifeTime' => '1.3.6.1.4.1.9.9.171.1.4.3.1.1.10',
  'cipSecTunHistStartTime' => '1.3.6.1.4.1.9.9.171.1.4.3.1.1.11',
  'cipSecTunHistActiveTime' => '1.3.6.1.4.1.9.9.171.1.4.3.1.1.12',
  'cipSecTunHistTotalRefreshes' => '1.3.6.1.4.1.9.9.171.1.4.3.1.1.13',
  'cipSecTunHistTotalSas' => '1.3.6.1.4.1.9.9.171.1.4.3.1.1.14',
  'cipSecTunHistInSaDiffHellmanGrp' => '1.3.6.1.4.1.9.9.171.1.4.3.1.1.15',
  'cipSecTunHistInSaDiffHellmanGrpDefinition' => 'CISCO-IPSEC-FLOW-MONITOR-MIB::DiffHellmanGrp',
  'cipSecTunHistInSaEncryptAlgo' => '1.3.6.1.4.1.9.9.171.1.4.3.1.1.16',
  'cipSecTunHistInSaEncryptAlgoDefinition' => 'CISCO-IPSEC-FLOW-MONITOR-MIB::EncryptAlgo',
  'cipSecTunHistInSaAhAuthAlgo' => '1.3.6.1.4.1.9.9.171.1.4.3.1.1.17',
  'cipSecTunHistInSaAhAuthAlgoDefinition' => 'CISCO-IPSEC-FLOW-MONITOR-MIB::AuthAlgo',
  'cipSecTunHistInSaEspAuthAlgo' => '1.3.6.1.4.1.9.9.171.1.4.3.1.1.18',
  'cipSecTunHistInSaEspAuthAlgoDefinition' => 'CISCO-IPSEC-FLOW-MONITOR-MIB::AuthAlgo',
  'cipSecTunHistInSaDecompAlgo' => '1.3.6.1.4.1.9.9.171.1.4.3.1.1.19',
  'cipSecTunHistInSaDecompAlgoDefinition' => 'CISCO-IPSEC-FLOW-MONITOR-MIB::CompAlgo',
  'cipSecTunHistOutSaDiffHellmanGrp' => '1.3.6.1.4.1.9.9.171.1.4.3.1.1.20',
  'cipSecTunHistOutSaDiffHellmanGrpDefinition' => 'CISCO-IPSEC-FLOW-MONITOR-MIB::DiffHellmanGrp',
  'cipSecTunHistOutSaEncryptAlgo' => '1.3.6.1.4.1.9.9.171.1.4.3.1.1.21',
  'cipSecTunHistOutSaEncryptAlgoDefinition' => 'CISCO-IPSEC-FLOW-MONITOR-MIB::EncryptAlgo',
  'cipSecTunHistOutSaAhAuthAlgo' => '1.3.6.1.4.1.9.9.171.1.4.3.1.1.22',
  'cipSecTunHistOutSaAhAuthAlgoDefinition' => 'CISCO-IPSEC-FLOW-MONITOR-MIB::AuthAlgo',
  'cipSecTunHistOutSaEspAuthAlgo' => '1.3.6.1.4.1.9.9.171.1.4.3.1.1.23',
  'cipSecTunHistOutSaEspAuthAlgoDefinition' => 'CISCO-IPSEC-FLOW-MONITOR-MIB::AuthAlgo',
  'cipSecTunHistOutSaCompAlgo' => '1.3.6.1.4.1.9.9.171.1.4.3.1.1.24',
  'cipSecTunHistOutSaCompAlgoDefinition' => 'CISCO-IPSEC-FLOW-MONITOR-MIB::CompAlgo',
  'cipSecTunHistInOctets' => '1.3.6.1.4.1.9.9.171.1.4.3.1.1.25',
  'cipSecTunHistHcInOctets' => '1.3.6.1.4.1.9.9.171.1.4.3.1.1.26',
  'cipSecTunHistInOctWraps' => '1.3.6.1.4.1.9.9.171.1.4.3.1.1.27',
  'cipSecTunHistInDecompOctets' => '1.3.6.1.4.1.9.9.171.1.4.3.1.1.28',
  'cipSecTunHistHcInDecompOctets' => '1.3.6.1.4.1.9.9.171.1.4.3.1.1.29',
  'cipSecTunHistInDecompOctWraps' => '1.3.6.1.4.1.9.9.171.1.4.3.1.1.30',
  'cipSecTunHistInPkts' => '1.3.6.1.4.1.9.9.171.1.4.3.1.1.31',
  'cipSecTunHistInDropPkts' => '1.3.6.1.4.1.9.9.171.1.4.3.1.1.32',
  'cipSecTunHistInReplayDropPkts' => '1.3.6.1.4.1.9.9.171.1.4.3.1.1.33',
  'cipSecTunHistInAuths' => '1.3.6.1.4.1.9.9.171.1.4.3.1.1.34',
  'cipSecTunHistInAuthFails' => '1.3.6.1.4.1.9.9.171.1.4.3.1.1.35',
  'cipSecTunHistInDecrypts' => '1.3.6.1.4.1.9.9.171.1.4.3.1.1.36',
  'cipSecTunHistInDecryptFails' => '1.3.6.1.4.1.9.9.171.1.4.3.1.1.37',
  'cipSecTunHistOutOctets' => '1.3.6.1.4.1.9.9.171.1.4.3.1.1.38',
  'cipSecTunHistHcOutOctets' => '1.3.6.1.4.1.9.9.171.1.4.3.1.1.39',
  'cipSecTunHistOutOctWraps' => '1.3.6.1.4.1.9.9.171.1.4.3.1.1.40',
  'cipSecTunHistOutUncompOctets' => '1.3.6.1.4.1.9.9.171.1.4.3.1.1.41',
  'cipSecTunHistHcOutUncompOctets' => '1.3.6.1.4.1.9.9.171.1.4.3.1.1.42',
  'cipSecTunHistOutUncompOctWraps' => '1.3.6.1.4.1.9.9.171.1.4.3.1.1.43',
  'cipSecTunHistOutPkts' => '1.3.6.1.4.1.9.9.171.1.4.3.1.1.44',
  'cipSecTunHistOutDropPkts' => '1.3.6.1.4.1.9.9.171.1.4.3.1.1.45',
  'cipSecTunHistOutAuths' => '1.3.6.1.4.1.9.9.171.1.4.3.1.1.46',
  'cipSecTunHistOutAuthFails' => '1.3.6.1.4.1.9.9.171.1.4.3.1.1.47',
  'cipSecTunHistOutEncrypts' => '1.3.6.1.4.1.9.9.171.1.4.3.1.1.48',
  'cipSecTunHistOutEncryptFails' => '1.3.6.1.4.1.9.9.171.1.4.3.1.1.49',
  'cipSecEndPtHistTable' => '1.3.6.1.4.1.9.9.171.1.4.3.2',
  'cipSecEndPtHistEntry' => '1.3.6.1.4.1.9.9.171.1.4.3.2.1',
  'cipSecEndPtHistIndex' => '1.3.6.1.4.1.9.9.171.1.4.3.2.1.1',
  'cipSecEndPtHistTunIndex' => '1.3.6.1.4.1.9.9.171.1.4.3.2.1.2',
  'cipSecEndPtHistActiveIndex' => '1.3.6.1.4.1.9.9.171.1.4.3.2.1.3',
  'cipSecEndPtHistLocalName' => '1.3.6.1.4.1.9.9.171.1.4.3.2.1.4',
  'cipSecEndPtHistLocalType' => '1.3.6.1.4.1.9.9.171.1.4.3.2.1.5',
  'cipSecEndPtHistLocalTypeDefinition' => 'CISCO-IPSEC-FLOW-MONITOR-MIB::EndPtType',
  'cipSecEndPtHistLocalAddr1' => '1.3.6.1.4.1.9.9.171.1.4.3.2.1.6',
  'cipSecEndPtHistLocalAddr2' => '1.3.6.1.4.1.9.9.171.1.4.3.2.1.7',
  'cipSecEndPtHistLocalProtocol' => '1.3.6.1.4.1.9.9.171.1.4.3.2.1.8',
  'cipSecEndPtHistLocalPort' => '1.3.6.1.4.1.9.9.171.1.4.3.2.1.9',
  'cipSecEndPtHistRemoteName' => '1.3.6.1.4.1.9.9.171.1.4.3.2.1.10',
  'cipSecEndPtHistRemoteType' => '1.3.6.1.4.1.9.9.171.1.4.3.2.1.11',
  'cipSecEndPtHistRemoteTypeDefinition' => 'CISCO-IPSEC-FLOW-MONITOR-MIB::EndPtType',
  'cipSecEndPtHistRemoteAddr1' => '1.3.6.1.4.1.9.9.171.1.4.3.2.1.12',
  'cipSecEndPtHistRemoteAddr2' => '1.3.6.1.4.1.9.9.171.1.4.3.2.1.13',
  'cipSecEndPtHistRemoteProtocol' => '1.3.6.1.4.1.9.9.171.1.4.3.2.1.14',
  'cipSecEndPtHistRemotePort' => '1.3.6.1.4.1.9.9.171.1.4.3.2.1.15',
  'cipSecFailures' => '1.3.6.1.4.1.9.9.171.1.5',
  'cipSecFailGlobal' => '1.3.6.1.4.1.9.9.171.1.5.1',
  'cipSecFailGlobalCntl' => '1.3.6.1.4.1.9.9.171.1.5.1.1',
  'cipSecFailTableSize' => '1.3.6.1.4.1.9.9.171.1.5.1.1.1',
  'cipSecFailPhaseOne' => '1.3.6.1.4.1.9.9.171.1.5.2',
  'cikeFailTable' => '1.3.6.1.4.1.9.9.171.1.5.2.1',
  'cikeFailEntry' => '1.3.6.1.4.1.9.9.171.1.5.2.1.1',
  'cikeFailIndex' => '1.3.6.1.4.1.9.9.171.1.5.2.1.1.1',
  'cikeFailReason' => '1.3.6.1.4.1.9.9.171.1.5.2.1.1.2',
  'cikeFailReasonDefinition' => {
    '1' => 'other',
    '2' => 'peerDelRequest',
    '3' => 'peerLost',
    '4' => 'localFailure',
    '5' => 'authFailure',
    '6' => 'hashValidation',
    '7' => 'encryptFailure',
    '8' => 'internalError',
    '9' => 'sysCapExceeded',
    '10' => 'proposalFailure',
    '11' => 'peerCertUnavailable',
    '12' => 'peerCertNotValid',
    '13' => 'localCertExpired',
    '14' => 'crlFailure',
    '15' => 'peerEncodingError',
    '16' => 'nonExistentSa',
    '17' => 'operRequest',
  },
  'cikeFailTime' => '1.3.6.1.4.1.9.9.171.1.5.2.1.1.3',
  'cikeFailLocalType' => '1.3.6.1.4.1.9.9.171.1.5.2.1.1.4',
  'cikeFailLocalTypeDefinition' => 'CISCO-IPSEC-FLOW-MONITOR-MIB::IkePeerType',
  'cikeFailLocalValue' => '1.3.6.1.4.1.9.9.171.1.5.2.1.1.5',
  'cikeFailRemoteType' => '1.3.6.1.4.1.9.9.171.1.5.2.1.1.6',
  'cikeFailRemoteTypeDefinition' => 'CISCO-IPSEC-FLOW-MONITOR-MIB::IkePeerType',
  'cikeFailRemoteValue' => '1.3.6.1.4.1.9.9.171.1.5.2.1.1.7',
  'cikeFailLocalAddr' => '1.3.6.1.4.1.9.9.171.1.5.2.1.1.8',
  'cikeFailRemoteAddr' => '1.3.6.1.4.1.9.9.171.1.5.2.1.1.9',
  'cipSecFailPhaseTwo' => '1.3.6.1.4.1.9.9.171.1.5.3',
  'cipSecFailTable' => '1.3.6.1.4.1.9.9.171.1.5.3.1',
  'cipSecFailEntry' => '1.3.6.1.4.1.9.9.171.1.5.3.1.1',
  'cipSecFailIndex' => '1.3.6.1.4.1.9.9.171.1.5.3.1.1.1',
  'cipSecFailReason' => '1.3.6.1.4.1.9.9.171.1.5.3.1.1.2',
  'cipSecFailReasonDefinition' => {
    '1' => 'other',
    '2' => 'internalError',
    '3' => 'peerEncodingError',
    '4' => 'proposalFailure',
    '5' => 'protocolUseFail',
    '6' => 'nonExistentSa',
    '7' => 'decryptFailure',
    '8' => 'encryptFailure',
    '9' => 'inAuthFailure',
    '10' => 'outAuthFailure',
    '11' => 'compression',
    '12' => 'sysCapExceeded',
    '13' => 'peerDelRequest',
    '14' => 'peerLost',
    '15' => 'seqNumRollOver',
    '16' => 'operRequest',
  },
  'cipSecFailTime' => '1.3.6.1.4.1.9.9.171.1.5.3.1.1.3',
  'cipSecFailTunnelIndex' => '1.3.6.1.4.1.9.9.171.1.5.3.1.1.4',
  'cipSecFailSaSpi' => '1.3.6.1.4.1.9.9.171.1.5.3.1.1.5',
  'cipSecFailPktSrcAddr' => '1.3.6.1.4.1.9.9.171.1.5.3.1.1.6',
  'cipSecFailPktDstAddr' => '1.3.6.1.4.1.9.9.171.1.5.3.1.1.7',
  'cipSecTrapCntl' => '1.3.6.1.4.1.9.9.171.1.6',
  'cipSecTrapCntlIkeTunnelStart' => '1.3.6.1.4.1.9.9.171.1.6.1',
  'cipSecTrapCntlIkeTunnelStartDefinition' => 'CISCO-IPSEC-FLOW-MONITOR-MIB::TrapStatus',
  'cipSecTrapCntlIkeTunnelStop' => '1.3.6.1.4.1.9.9.171.1.6.2',
  'cipSecTrapCntlIkeTunnelStopDefinition' => 'CISCO-IPSEC-FLOW-MONITOR-MIB::TrapStatus',
  'cipSecTrapCntlIkeSysFailure' => '1.3.6.1.4.1.9.9.171.1.6.3',
  'cipSecTrapCntlIkeSysFailureDefinition' => 'CISCO-IPSEC-FLOW-MONITOR-MIB::TrapStatus',
  'cipSecTrapCntlIkeCertCrlFailure' => '1.3.6.1.4.1.9.9.171.1.6.4',
  'cipSecTrapCntlIkeCertCrlFailureDefinition' => 'CISCO-IPSEC-FLOW-MONITOR-MIB::TrapStatus',
  'cipSecTrapCntlIkeProtocolFail' => '1.3.6.1.4.1.9.9.171.1.6.5',
  'cipSecTrapCntlIkeProtocolFailDefinition' => 'CISCO-IPSEC-FLOW-MONITOR-MIB::TrapStatus',
  'cipSecTrapCntlIkeNoSa' => '1.3.6.1.4.1.9.9.171.1.6.6',
  'cipSecTrapCntlIkeNoSaDefinition' => 'CISCO-IPSEC-FLOW-MONITOR-MIB::TrapStatus',
  'cipSecTrapCntlIpSecTunnelStart' => '1.3.6.1.4.1.9.9.171.1.6.7',
  'cipSecTrapCntlIpSecTunnelStartDefinition' => 'CISCO-IPSEC-FLOW-MONITOR-MIB::TrapStatus',
  'cipSecTrapCntlIpSecTunnelStop' => '1.3.6.1.4.1.9.9.171.1.6.8',
  'cipSecTrapCntlIpSecTunnelStopDefinition' => 'CISCO-IPSEC-FLOW-MONITOR-MIB::TrapStatus',
  'cipSecTrapCntlIpSecSysFailure' => '1.3.6.1.4.1.9.9.171.1.6.9',
  'cipSecTrapCntlIpSecSysFailureDefinition' => 'CISCO-IPSEC-FLOW-MONITOR-MIB::TrapStatus',
  'cipSecTrapCntlIpSecSetUpFailure' => '1.3.6.1.4.1.9.9.171.1.6.10',
  'cipSecTrapCntlIpSecSetUpFailureDefinition' => 'CISCO-IPSEC-FLOW-MONITOR-MIB::TrapStatus',
  'cipSecTrapCntlIpSecEarlyTunTerm' => '1.3.6.1.4.1.9.9.171.1.6.11',
  'cipSecTrapCntlIpSecEarlyTunTermDefinition' => 'CISCO-IPSEC-FLOW-MONITOR-MIB::TrapStatus',
  'cipSecTrapCntlIpSecProtocolFail' => '1.3.6.1.4.1.9.9.171.1.6.12',
  'cipSecTrapCntlIpSecProtocolFailDefinition' => 'CISCO-IPSEC-FLOW-MONITOR-MIB::TrapStatus',
  'cipSecTrapCntlIpSecNoSa' => '1.3.6.1.4.1.9.9.171.1.6.13',
  'cipSecTrapCntlIpSecNoSaDefinition' => 'CISCO-IPSEC-FLOW-MONITOR-MIB::TrapStatus',
  'cipSecMIBNotificationPrefix' => '1.3.6.1.4.1.9.9.171.2',
  'cipSecMIBNotifications' => '1.3.6.1.4.1.9.9.171.2.0.1.2.3.4.5.6.7.8.9.10.11.12.13',
  'cipSecMIBConformance' => '1.3.6.1.4.1.9.9.171.3',
  'cipSecMIBGroups' => '1.3.6.1.4.1.9.9.171.3.1',
  'cipSecMIBCompliances' => '1.3.6.1.4.1.9.9.171.3.1.8',
  'hardware' => '1.3.6.1.4.1.3764.1.1.200',
};

$Monitoring::GLPlugin::SNMP::MibsAndOids::definitions->{'CISCO-IPSEC-FLOW-MONITOR-MIB'} = {
  'IkeNegoMode' => {
    '1' => 'main',
    '2' => 'aggressive',
  },
  'DiffHellmanGrp' => {
    '1' => 'none',
    '2' => 'dhGroup1',
    '3' => 'dhGroup2',
  },
  'cipSecHistCheckPoint' => {
    '1' => 'ready',
    '2' => 'checkPoint',
  },
  'AuthAlgo' => {
    '1' => 'none',
    '2' => 'hmacMd5',
    '3' => 'hmacSha',
  },
  'EncryptAlgo' => {
    '1' => 'none',
    '2' => 'des',
    '3' => 'des3',
  },
  'CompAlgo' => {
    '1' => 'none',
    '2' => 'ldf',
  },
  'cipSecSpiStatus' => {
    '1' => 'active',
    '2' => 'expiring',
  },
  'cipSecTunHistTermReason' => {
    '1' => 'other',
    '2' => 'normal',
    '3' => 'operRequest',
    '4' => 'peerDelRequest',
    '5' => 'peerLost',
    '6' => 'seqNumRollOver',
    '7' => 'checkPointReq',
  },
  'cikeTunHistTermReason' => {
    '1' => 'other',
    '2' => 'normal',
    '3' => 'operRequest',
    '4' => 'peerDelRequest',
    '5' => 'peerLost',
    '6' => 'localFailure',
    '7' => 'checkPointReg',
  },
  'TunnelStatus' => {
    '1' => 'active',
    '2' => 'destroy',
  },
  'EndPtType' => {
    '1' => 'singleIpAddr',
    '2' => 'ipAddrRange',
    '3' => 'ipSubnet',
  },
  'IkePeerType' => {
    '1' => 'ipAddrPeer',
    '2' => 'namePeer',
  },
  'IkeAuthMethod' => {
    '1' => 'none',
    '2' => 'preSharedKey',
    '3' => 'rsaSig',
    '4' => 'rsaEncrypt',
    '5' => 'revPublicKey',
  },
  'EncapMode' => {
    '1' => 'tunnel',
    '2' => 'transport',
  },
  'cipSecSpiProtocol' => {
    '1' => 'ah',
    '2' => 'esp',
    '3' => 'ipcomp',
  },
  'IkeHashAlgo' => {
    '1' => 'none',
    '2' => 'md5',
    '3' => 'sha',
  },
  'cipSecSpiDirection' => {
    '1' => 'in',
    '2' => 'out',
  },
  'KeyType' => {
    '1' => 'ike',
    '2' => 'manual',
  },
  'cikeFailReason' => {
    '1' => 'other',
    '2' => 'peerDelRequest',
    '3' => 'peerLost',
    '4' => 'localFailure',
    '5' => 'authFailure',
    '6' => 'hashValidation',
    '7' => 'encryptFailure',
    '8' => 'internalError',
    '9' => 'sysCapExceeded',
    '10' => 'proposalFailure',
    '11' => 'peerCertUnavailable',
    '12' => 'peerCertNotValid',
    '13' => 'localCertExpired',
    '14' => 'crlFailure',
    '15' => 'peerEncodingError',
    '16' => 'nonExistentSa',
    '17' => 'operRequest',
  },
  'TrapStatus' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'cipSecFailReason' => {
    '1' => 'other',
    '2' => 'internalError',
    '3' => 'peerEncodingError',
    '4' => 'proposalFailure',
    '5' => 'protocolUseFail',
    '6' => 'nonExistentSa',
    '7' => 'decryptFailure',
    '8' => 'encryptFailure',
    '9' => 'inAuthFailure',
    '10' => 'outAuthFailure',
    '11' => 'compression',
    '12' => 'sysCapExceeded',
    '13' => 'peerDelRequest',
    '14' => 'peerLost',
    '15' => 'seqNumRollOver',
    '16' => 'operRequest',
  },
};

1;

__END__
