use v6.d;

unit module Test::Diehard::Craps;

use Terminal::ANSIColor;


our sub test (UInt $number_of_games, $die1, $die2, Bool :$log = False --> Array) {
    $die1.init(1240582);
    $die2.init(2435903);

    my @craps;

    say colored(' ⬤', 'red'), ' Playing Craps!' if $log;

    for 1..$number_of_games {
	my $won = False;
	my $throws = 0;
	my $point = 0;

	if $log {
	    if $_ == 1 and $number_of_games != 1 {
		say "\r  ",colored('✘', 'red')," Game (",colored("$_",'red'),"\|",colored("$number_of_games",'green'),')';

	    } elsif $_ == 1 and $number_of_games == 1 {
		say "\e\[1A \r ", colored('⬤', 'green'), ' Playing Craps!';
		say "\r  ",colored('✔', 'green')," Game (",colored("$_",'green'),"\|",colored("$number_of_games",'green'),')';

	    } elsif $_ == $number_of_games {
		say "\e\[2A \r ", colored('⬤', 'green'), ' Playing Craps!';
		say "\r  ",colored('✔', 'green')," Game (",colored("$_",'green'),"\|",colored("$number_of_games",'green'),')';

	    } else {
		say "\e\[1A \r  ",colored('✘', 'red')," Game (",colored("$_",'red'),"\|",colored("$number_of_games",'green'),')';
	    }
	}


	my Bool $playing = True;
	while $playing {
	    my UInt $eyes = $die1.rand_range(1,6) + $die2.rand_range(1,6);
	    $throws++;

	    # First round
	    if $throws == 1 {
		if $eyes == 2 || $eyes == 3 || $eyes == 12 {
		    $won = False;
		    $playing = False;

		} elsif $eyes == 7 || $eyes == 11 {
		    $won = True;
		    $playing = False;

		} else {
		    $point = $eyes;
		}


	    # Other rounds
	    } elsif $throws > 1 {
		if $eyes == $point {
		    $won = True;
		    $playing = False;

		} elsif $eyes == 7 {
		    $won = False;
		    $playing = False;
		}
	    }
	}

	@craps[$_-1] = ($throws, $won.Int);
    }

    return @craps;
}
