use v6.d;

unit module Test::Diehard::Runs;

use Terminal::ANSIColor;

our sub test ($prng, UInt $sequence_length = 100_000, Real :$significance_level = 0.05, Bool :$log = False --> Bool) {

    $sequence_length >= 10
    or die 'Runs Test is not suitable for short sequences(|x| < 10)!';

    say colored(' ⬤', 'red'), ' Counting Runs!' if $log;

    $prng.init(2452834952);

    my UInt $runs = 0;
    my UInt $positive_values = 0;
    my UInt $negative_values = 0;
    my Str $current_run_type = '';

    for 1..$sequence_length {
	my $current_number = $prng.rand_float();

	if $current_number < 0.5 {
	    $negative_values++;

	    if $current_run_type eq 'positive' {
		$runs++;
		$current_run_type = 'negative';

	    } elsif $current_run_type eq '' {
		$runs++;
		$current_run_type = 'negative';
	    }

	} elsif $current_number > 0.5 {
	    $positive_values++;

	    if $current_run_type eq 'negative' {
		$runs++;
		$current_run_type = 'positive';

	    } elsif $current_run_type eq '' {
		$runs++;
		$current_run_type = 'positive';
	    }
	}

	if $log {
	    if $_ == 1 and $sequence_length != 1 {
		say "\r  ", colored('✘', 'red'), ' Position (', colored("$_", 'red'),'|',colored("$sequence_length", 'green'), ')';
		my $scaled_number_of_values = floor($positive_values / $sequence_length * 10);
		say "\r    ", 'Positive values: ', colored("-" x $scaled_number_of_values, 'cyan');
		$scaled_number_of_values = floor($negative_values / $sequence_length * 10);
		say "\r    ", 'Negative values: ', colored("-" x $scaled_number_of_values, 'cyan');

	    } elsif $_ == 1 and $sequence_length == 1 {
		say "\e\[1A \r ", colored('⬤', 'green'), ' Counting runs!';
		say "\r  ", colored('✔', 'green'), ' Position (', colored("$_", 'green'),'|',colored("$sequence_length", 'green'), ')';
		my $scaled_number_of_values = floor($positive_values / $sequence_length * 10);
		say "\r    ", 'Positive values: ', colored("-" x $scaled_number_of_values, 'cyan');
		$scaled_number_of_values = floor($negative_values / $sequence_length * 10);
		say "\r    ", 'Negative runs: ', colored("-" x $scaled_number_of_values, 'cyan');

	    } elsif $_ == $sequence_length {
		say "\e\[3A \r  ", colored('✔', 'green'), ' Position (', colored("$_", 'green'),'|',colored("$sequence_length", 'green'), ')';
		my $scaled_number_of_values = floor($positive_values / $sequence_length * 10);
		say "\r    ", 'Positive values: ', colored("-" x $scaled_number_of_values, 'cyan');
		$scaled_number_of_values = floor($negative_values / $sequence_length * 10);
		say "\r    ", 'Negative values: ', colored("-" x $scaled_number_of_values, 'cyan');

	    } else {
		say "\e\[3A \r  ", colored('✘', 'red'), ' Position (', colored("$_", 'red'),'|',colored("$sequence_length", 'green'), ')';
		my $scaled_number_of_values = $positive_values / $sequence_length * 10;
		say "\r    ", 'Positive values: ', colored("-" x $scaled_number_of_values, 'cyan');
		$scaled_number_of_values = $negative_values / $sequence_length * 10;
		say "\r    ", 'Negative values: ', colored("-" x $scaled_number_of_values, 'cyan');
	    }
	}
    }

    my Real $expected_runs = (2 * $positive_values * $negative_values) / $sequence_length + 1;
    my Real $s_runs = sqrt((2 * $positive_values * $negative_values * (2 * $positive_values * $negative_values - $sequence_length)) / ($sequence_length**2 * ($sequence_length - 1)));
    my Real $Z = Nil;

    my $success = False;
    if $s_runs != 0 {
	$Z = ($runs - $expected_runs) / $s_runs;
	$success = $Z.abs <= 1.96;

    } elsif $s_runs == 0 {
	warn 'Standard Deviation is zero, your data is not random at all';
	$success = False;
    }

    print "\e\[4A \r ", colored('⬤', 'green'), ' Counting runs!', "\e\[3B\n" if $log and $success;
    if $log and not $success {
	say colored('   ⛔ ⛔ ⛔ TEST FAILED ⛔ ⛔ ⛔', 'red bold');
	say "   |Z| = {$Z.abs}" if $Z;
    }

    return $success;
}
