Gnome::Cairo::Path
==================

Creating paths and manipulating path data

Description
===========

Paths are the most basic drawing tools and are primarily used to implicitly generate simple masks.

Synopsis
========

Declaration
-----------

    unit class Gnome::Cairo::Path;
    also is Gnome::N::TopLevelClassSupport;

Example
-------

    my Gnome::Cairo $context;
    my Gnome::Cairo::ImageSurface $surface;
    my Gnome::Cairo::Path $path;

    $surface .= new(
      :format(CAIRO_FORMAT_RGB24), :width(128), :height(128)
    );
    $context .= new(:$surface);

    $path .= new(:native-object($context.copy-path));

Methods
=======

new
---

### :native-object

There is only one way to create a Path object and that is by importing a native object.

    multi method new ( N-GObject :$native-object! )

length
------

Return the length of the data array in the `cairo_path_t` structure.

    method length ( --> UInt )

status
------

Return status from the path structure `cairo_path_t`.

    method status ( --> cairo_status_t )

walk-path
---------

A convenience method to walk over the set of parts in a path. The method will go through the elements of he path and calls user methods in an object given by the user to let the user process specific parts in the path.

    method walk-path (
      Any:D $user-object, Str:D $move-to, Str:D $line-to,
      Str:D $curve-to, Str:D $close-path
    }

`$move-to`, `$line-to`, `$curve-to` and `$close-path` are the names of the methods defined in `$user-object`.

