#!/usr/bin/env perl
# pml2base.pl     pajas@ufal.ms.mff.cuni.cz     2008/06/05 10:42:56

use FindBin;
use lib $FindBin::RealBin;
use constant LIBS => $FindBin::RealBin.'/libs/';
use lib map LIBS.$_, qw( fslib pml-base pmltq );
use PML2BASE;

use Treex::PML;

use File::Spec;

use strict;
use warnings;

use Getopt::Long;
use Pod::Usage;
Getopt::Long::Configure ("bundling");

my %opts;
our $VERSION = '0.7';

GetOptions(\%opts,
	'debug|D',
	'quiet|q',
	'schema|S',
	'list-ref|l',
	'related-schema|R=s@',
	'syntax|s=s',
        'path|P=s@',
	'incremental|I',
	'init-idx|i=i',
	'init-node-idx|n=i',
	'max-idx=i',
	'max-node-idx=i',
	'prefix|p=s',
	'data-dir|d=s',
        'no-schema',
        'dump-idx=s',
        'load-idx=s',
        'dump-rename-map=s',
        'dump-col-info=s',
        'load-rename-map=s',
	'enforce-col-info',
        'load-col-info=s',
	'rename-type|t=s%',
	'ref|r=s%',
	'default=s%',
	'help|h',
	'usage|u',
        'version|V',
	'man',
       ) or $opts{usage}=1;

if ($opts{usage}) {
  pod2usage(-msg => '(pml2base.pl)');
}
if ($opts{help}) {
  pod2usage(-exitstatus => 0, -verbose => 1);
}
if ($opts{man}) {
  pod2usage(-exitstatus => 0, -verbose => 2);
}
if ($opts{version}) {
  print "$VERSION\n";
  exit;
}

Treex::PML::AddResourcePathAsFirst(@{$opts{path}}) if $opts{path};
print STDERR "Resource paths:",join(",",Treex::PML::ResourcePath()),"\n" if $opts{debug};

Treex::PML::UseBackends(qw(Storable PMLBackend PMLTransformBackend));

$opts{syntax}||='oracle'; $PML2BASE::opts{$_} = $opts{$_} for grep
  defined($opts{$_}), qw{

  syntax ref data-dir default prefix related-schema rename-type debug
  init-idx init-node-idx dump-col-info dump-rename-map load-col-info
  load-rename-map no-schema schema max-node-idx max-idx incremental
  enforce-col-info dump-idx load-idx

 };

PML2BASE::init();

my $no_finish;
for my $f (@ARGV) {
  print STDERR "$f\n" unless $opts{'quiet'};
  if ($opts{schema}) {
    my $schema = Treex::PML::Factory->createPMLSchema({filename=>$f});
    if ($opts{'list-ref'}) {
      $no_finish=1;
      my $ref=PML2BASE::complete_schema_pmlref_list($schema);
      print $schema->get_root_name,"=(\n";
      for (sort keys %{$ref}) {
	print "  -r $_=$ref->{$_} \n";
      }
      print ")\n";
    } else {
      PML2BASE::convert_schema($schema,\%opts);
      PML2BASE::dump_typemap();
    }
  } else {
      PML2BASE::fs2base(Treex::PML::Factory->createDocumentFromFile($f));
  }
}
PML2BASE::finish() unless $no_finish;


__END__

=head1 NAME

pml2base.pl - convert PML files to SQL for PML-TQ

=head1 SYNOPSIS

pml2base.pl [--syntax|-s oracle|postgres]
            [--path|-P resource_path ]*
            [--data-dir|-d data-dir ]
            [--rename-type|-t from=to ]
            [--ref|-r path=[root:]node_type ]
            *.pml

or

pml2base.pl [--help|-h | --usage|-u | --man | --version|-V]

=head1 DESCRIPTION

Converts PML instances to SQL for use with PML-TQ.

The data dumps and SQL scripts are generated in the current directory.

=head1 AUTHOR

Petr Pajas, E<lt>pajas@stain.ms.mff.cuni.czE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2008 by Petr Pajas

This program is free software; you can redistribute it and/or modify
it under the same terms as Perl itself, either Perl version 5.8.2 or,
at your option, any later version of Perl 5 you may have available.

=head1 BUGS

None reported... yet.

=cut
