# This Makefile.PL for Shout was generated by
# Dist::Zilla::Plugin::MakeMaker::Awesome 0.48.
# Don't edit it but the dist.ini and plugins used to construct it.

use strict;
use warnings;

use 5.008005;
use ExtUtils::MakeMaker;

my %WriteMakefileArgs = (
  "ABSTRACT" => "Perl glue for libshout MP3 streaming source library",
  "AUTHOR" => "Jack Moffitt <jack\@icecast.org>",
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::MakeMaker" => 0
  },
  "DISTNAME" => "Shout",
  "LICENSE" => "perl",
  "MIN_PERL_VERSION" => "5.008005",
  "NAME" => "Shout",
  "PREREQ_PM" => {},
  "TEST_REQUIRES" => {
    "HTTP::Response" => 0,
    "Test::Fake::HTTPD" => 0,
    "Test::More" => "0.96",
    "Test::Pod" => 0
  },
  "VERSION" => "2.1.2",
  "test" => {
    "TESTS" => "t/*.t"
  }
);

%WriteMakefileArgs = (
    %WriteMakefileArgs,
    CCFLAGS => `PKG_CONFIG_PATH=\${PKG_CONFIG_PATH:-/usr/local/lib/pkgconfig} pkg-config --cflags shout`,
    LIBS => `PKG_CONFIG_PATH=\${PKG_CONFIG_PATH:-/usr/local/lib/pkgconfig} pkg-config --libs shout`,
);

my %FallbackPrereqs = (
  "HTTP::Response" => 0,
  "Test::Fake::HTTPD" => 0,
  "Test::More" => "0.96",
  "Test::Pod" => 0
);

unless ( eval { ExtUtils::MakeMaker->VERSION('6.63_03') } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);

if  (eval {require ExtUtils::Constant; 1}) {
  # If you edit these definitions to change the constants used by this module,
  # you will need to use the generated const-c.inc and const-xs.inc
  # files to replace their "fallback" counterparts before distributing your
  # changes.
  my @names = (qw(SHOUTERR_BUSY SHOUTERR_CONNECTED SHOUTERR_INSANE
       SHOUTERR_MALLOC SHOUTERR_METADATA SHOUTERR_NOCONNECT
       SHOUTERR_NOLOGIN SHOUTERR_SOCKET SHOUTERR_SUCCESS
       SHOUTERR_UNCONNECTED SHOUTERR_UNSUPPORTED SHOUT_FORMAT_MP3
       SHOUT_FORMAT_OGG SHOUT_FORMAT_VORBIS SHOUT_PROTOCOL_HTTP
       SHOUT_PROTOCOL_ICY SHOUT_PROTOCOL_XAUDIOCAST SHOUT_THREADSAFE));
  ExtUtils::Constant::WriteConstants(
                                     NAME         => 'Shout',
                                     NAMES        => \@names,
                                     DEFAULT_TYPE => 'IV',
                                     C_FILE       => 'const-c.inc',
                                     XS_FILE      => 'const-xs.inc',
                                  );
}
else {
  use File::Copy;
  use File::Spec;
  foreach my $file ('const-c.inc', 'const-xs.inc') {
    my $fallback = File::Spec->catfile('fallback', $file);
    copy ($fallback, $file) or die "Can't copy $fallback to $file: $!";
  }
}
