use strict;
use warnings;
use utf8;
use autodie;
use Encode qw/encode_utf8 decode_utf8/;

use Apporo;

use Test::More tests => 10;

my $index_path = "/tmp/p5_apporo_index_05.tsv";
my $out_index;
open ($out_index, "> $index_path");

my $data = << "__DATA__";
逢沢一郎	あいざわいちろう	自民党	岡山01区	衆1-405号室	電話03-3508-7105	FAX03-3508-0319
相原しの	あいはらしの	民主党	南関東比例	衆1-305	号室	電話03-3508-7305	FAX03-3508-3305
青木愛	あおきあい	民主党	東京12	衆1-608号室	電話03-3508-7178	FAX03-3508-3608
赤澤亮正	あかざわりょうせい	自民党	鳥取02区	衆2-740号室	電話03-3508-7490	FAX03-3508-3370
赤松広隆	あかまつひろたか	民主党	愛知05区	衆2-403号室	電話03-3508-7403	FAX03-3593-7240
赤松正雄	あかまつまさお	公明党	近畿比例	衆1-412号室	電話03-3508-7112	FAX03-3508-3412
赤嶺政賢	あかみねせいけん	共産党	九州比例	衆1-626号室	電話03-3508-7196	FAX03-3508-3626
秋葉賢也	あきばけんや	自民党	東北比例	衆1-632号室	電話03-3508-7392	FAX03-3508-3632
阿久津幸彦	あくつゆきひこ	民主党	東京24区	衆1-322号室	電話03-3508-7322	FAX03-3508-3322
浅尾慶一郎	あさおけいいちろう	みんなの党	南関東比例	衆1-521号室	電話03-3508-7251	FAX03-3508-7251
東祥三	あずましょうぞう	民主党	東京15区	衆2-405号室	電話03-3508-7406	FAX03-3508-3886
安住淳	あずみじゅん	民主党	宮城05区	衆1-503号室	電話03-3508-7293	FAX03-3508-3503
麻生太郎	あそうたろう	自民党	福岡08区	衆1-210号室	電話03-3508-7703	FAX03-3501-7528
阿知波吉信	あちはよしのぶ	民主党	岐阜05区	衆1-512号室	電話03-3508-7382	FAX03-3508-3512
安倍晋三	あべしんぞう	自民党	山口04区	衆1-602号室	電話03-3508-7172	FAX03-3508-3602
阿部俊子	あべとしこ	自民党	中国比例	衆1-436号室	電話03-3508-7136	FAX03-3508-3436
阿部知子	あべともこ	社民党	南関東比例	衆1-303号室	電話03-3508-7303	FAX03-3508-3303
甘利明	あまりあきら	自民党	南関東比例	衆2-528号室	電話03-3508-7528	FAX03-3502-5087
網屋信介	あみやしんすけ	民主党	九州比例	衆2-307号室	電話03-3508-7057	FAX03-3508-3857
荒井聡	あらいさとし	民主党	北海道03区	衆1-225号室	電話03-3508-7114	FAX03-3508-3225
五十嵐文彦	いがらしふみひこ	民主党	埼玉09区	衆2-313号室	電話03-3508-7317	FAX03-3508-3317
池田元久	いけだもとひさ	民主党	神奈川06区	衆1-631号室	電話03-3508-7391	FAX03-3508-3631
池坊保子	いけのぼうやすこ	公明党	近畿比例	衆2-340号室	電話03-3508-7090	FAX03-3508-3870
石井章	いしいあきら	民主党	北関東比例	衆2-436号室	電話03-3508-7436	FAX03-3508-3916
石井啓一	いしいけいいち	公明党	北関東比例	衆1-229号室	電話03-3508-7110	FAX03-3508-3229
石井登志郎	いしいとしろう	民主党	兵庫07区	衆1-220号室	電話03-3508-7220	FAX03-3508-3220
石川知裕	いしかわともひろ	民主党	北海道11区	衆1-233号室	電話03-3508-7233	FAX03-3508-3233
石毛えい子	いしげえいこ	民主党	東京比例	衆2-435号室	電話03-3508-7300	FAX03-3508-3373
石関貴史	いしぜきたかし	民主党	群馬02区	衆1-736号室	電話03-3508-7286	FAX03-3508-3736
石田勝之	いしだかつゆき	民主党	埼玉02区	衆1-601号室	電話03-3508-7601	FAX03-3508-3981
石田祝稔	いしだのりとし	公明党	四国比例	衆2-722号室	電話03-3508-7472	FAX03-3508-3352
石田真敏	いしだまさとし	自民党	近畿比例	衆2-322号室	電話03-3508-7072	FAX03-3581-6992
石田三示	いしだみつじ	民主党	南関東比例	衆2-720号室	電話03-3508-7470	FAX03-3508-3350
石田芳弘	いしだよしひろ	民主党	愛知06区	衆2-423号室	電話03-3508-7423	FAX03-3508-3903
石津政雄	いしづまさお	民主党	茨城02区	衆2-727号室	電話03-3508-7477	FAX03-3508-3357
石破茂	いしばしげる	自民党	鳥取01区	衆2-525号室	電話03-3508-7525	FAX03-3502-5174
石原伸晃	いしはらのぶてる	自民党	東京08区	衆1-743号室	電話03-3508-7904	FAX03-3593-7101
石原洋三郎	いしはらようざぶろう	民主党	福島01区	衆2-316号室	電話03-3508-7066	FAX03-3508-3846
石森久嗣	いしもりひさつぐ	民主党	栃木01区	衆2-508号室	電話03-3508-7508	FAX03-3508-7530
石山敬貴	いしやまけいき	民主党	宮城04区	衆1-514号室	電話03-3508-7244	FAX03-3508-3514
泉健太	いずみけんた	民主党	京都03区	衆2-205号室	電話03-3508-7005	FAX03-3508-3805
磯谷香代子	いそがいかよこ	民主党	東海比例	衆1-715号室	電話03-3508-7165	FAX03-3508-3715
市村浩一郎	いちむらこういちろう	民主党	兵庫06区	衆1-502号室	電話03-3508-7292	FAX03-3508-3502
井戸正枝	いどまさえ	民主党	兵庫01区	衆2-313号室	電話03-3508-7063	FAX03-3508-3383
伊東良孝	いとうよしたか	自民党	北海道07区	衆1-720号室	電話03-3508-7170	FAX03-3508-7177
糸川正晃	いとかわまさあき	民主党	北陸信越比例	衆2-239	電話03-3508-7039	FAX03-3508-3839
稲田朋美	いなだともみ	自民党	福井01区	衆2-235号室	電話03-3508-7035	FAX03-3508-3835
稲津ひさし	いなつひさし	公明党	北海道比例	衆2-339号室	電話03-3508-7089	FAX03-3508-3869
稲富修二	いなとみしゅうじ	民主党	福岡02区	衆1-439号室	電話03-3508-7139	FAX03-3508-3439
稲見哲男	いなみてつお	民主党	大阪05区	衆2-623号室	電話03-3508-7623	FAX03-3508-3253
井上信治	いのうえしんじ	自民党	東京25区	衆1-328号室	電話03-3508-7328	FAX03-3508-3328
井上義久	いのうえよしひさ	公明党	東北比例	衆2-724号室	電話03-3508-7474	FAX03-3508-3354
伊吹文明	いぶきぶんめい	自民党	近畿比例	衆2-615号室	電話03-3508-7615	FAX03-3502-5382
今井雅人	いまいまさと	民主党	東海比例	衆2-336号室	電話03-3508-7086	FAX03-3508-3866
今村雅弘	いまむらまさひろ	自民党	九州比例	衆2-610号室	電話03-3508-7610	FAX03-3597-2723
岩屋毅	いわやたけし	自民党	九州比例	衆2-510号室	電話03-3508-7510	FAX03-3509-7610
打越明司	うちこしあかし	民主党	九州比例	衆1-727号室	電話03-3508-7277	FAX03-3508-3727
内山晃	うちやまあきら	民主党	千葉07区	衆2-717号室	電話03-3508-7467	FAX03-3508-3297
生方幸夫	うぶかたゆきお	民主党	千葉06区	衆2-514号室	電話03-3508-7514	FAX03-3508-3944
漆原良夫	うるしばらよしお	公明党	北陸信越比例	衆1-639号室	電話03-3508-7149	FAX03-3508-3939
江田憲司	えだけんじ	みんなの党	神奈川08区	衆2-712号室	電話03-3508-7462	FAX03-3508-3292
江田康幸	えだやすゆき	公明党	九州比例	衆1-339号室	電話03-3508-7339	FAX03-3508-3339
枝野幸男	えだのゆきお	民主党	埼玉05区	衆2-538号室	電話03-3508-7448	FAX03-3591-2249
江渡聡徳	えとあきのり	自民党	青森02区	衆2-531号室	電話03-3508-7096	FAX03-3508-3961
衛藤征士郎	えとうせいしろう	自民党	九州比例	衆2-618号室	電話03-3508-7618	FAX03-3595-0003
江藤拓	えとうたく	自民党	宮崎02区	衆2-718号室	電話03-3508-7468	FAX03-3591-3063
江端貴子	えばたたかこ	民主党	東京10区	衆2-333号室	電話03-3508-7043	FAX03-3508-3863
遠藤乙彦	えんどうおとひこ	公明党	北関東比例	衆1-415号室	電話03-3508-7224	FAX03-3508-3415
遠藤利明	えんどうとしあき	自民党	東北比例	衆1-708号室	電話03-3508-7158	FAX03-3592-7660
大泉博子	おおいずみひろこ	民主党	茨城06区	衆2-509号室	電話03-3508-7509	FAX03-3508-3939
大串博志	おおぐしひろし	民主党	佐賀02区	衆1-335号室	電話03-3508-7335	FAX03-3508-3335
大口善徳	おおぐちよしのり	公明党	東海比例	衆2-217号室	電話03-3508-7017	FAX03-3508-8552
逢坂誠二	おおさかせいじ	民主党	北海道08区	衆1-740号室	電話03-3508-7290	FAX03-3508-3740
大島敦	おおしまあつし	民主党	埼玉06区	衆2-310号室	電話03-3508-7093	FAX03-3508-3380
大島理森	おおしまただもり	自民党	青森03区	衆2-502号室	電話03-3508-7502	FAX03-3502-5082
太田和美	おおたかずみ	民主党	福島02区	衆1-318号室	電話03-3508-7318	FAX03-3508-3318
大谷啓	おおたにけい	民主党	大阪15区	衆2-231号室	電話03-3508-7031	FAX03-3508-3831
大谷信盛	おおたにのぶもり	民主党	大阪09区	衆1-333号室	電話03-3508-7333	FAX03-3508-3333
大西健介	おおにしけんすけ	民主党	愛知13区	衆1-408号室	電話03-3508-7108	FAX03-3508-3408
大西孝典	おおにしたかのり	民主党	近畿比例	衆1-219号室	電話03-3508-7635	FAX03-3508-3023
大野功統	おおのよしのり	自民党	香川03区	衆1-432号室	電話03-3508-7132	FAX03-3502-5870
大畠章宏	おおはたあきひろ	民主党	茨城05区	衆1-231号室	電話03-3508-7231	FAX03-3502-5953
大村秀章	おおむらひであき	自民党	東海比例	衆1-243号室	電話03-3508-3243	FAX03-3508-7709
大山昌宏	おおやままさひろ	民主党	東海比例	衆1-410号室	電話03-3508-7100	FAX03-3508-6410
岡島一正	おかじまかずまさ	民主党	千葉03区	衆1-535号室	電話03-3508-7265	FAX03-3508-3535
岡田克也	おかだかつや	民主党	三重03区	衆1-443号室	電話03-3508-7109	FAX03-3502-5047
岡田康裕	おかだやすひろ	民主党	兵庫10区	衆1-216号室	電話03-3508-7216	FAX03-3508-3216
緒方林太郎	おがたりんたろう	民主党	福岡09区	衆2-511号室	電話03-3508-7511	FAX03-3508-3941
岡本英子	おかもとえいこ	民主党	神奈川03区	衆1-615号室	電話03-3508-7185	FAX03-3508-3615
岡本充功	おかもとみつのり	民主党	愛知09区	衆1-622号室	電話03-3508-7192	FAX03-3508-3622
小川淳也	おがわじゅんや	民主党	香川01区	衆2-621号室	電話03-3508-7621	FAX03-3508-3251
奥田建	おくだけん	民主党	石川01区	衆2-606号室	電話03-3508-7606	FAX03-3508-7666
奥野総一郎	おくのそういちろう	民主党	千葉09区	衆1-526号室	電話03-3508-7256	FAX03-3508-3526
奥村展三	おくむらてんぞう	民主党	滋賀04区	衆2-515号室	電話03-3508-7515	FAX03-3508-3945
小里泰弘	おざとやすひろ	自民党	鹿児島04区	衆1-517号室	電話03-3508-7247	FAX03-3502-5017
小沢一郎	おざわいちろう	民主党	岩手04区	衆1-605号室	電話03-3508-7175	FAX03-
小沢鋭仁	おざわさきひと	民主党	山梨01区	衆2-641号室	電話03-3508-7641	FAX03-3591-2735
小野塚勝俊	おのづかまさとし	民主党	埼玉08区	衆2-433号室	電話03-3508-7076	FAX03-3508-3766
小野寺五典	おのでらいつのり	自民党	宮城06区	衆2-432号室	電話03-3508-7432	FAX03-3508-3912
小原舞	おはらまい	民主党	近畿比例	衆2-204号室	電話03-3508-7004	FAX03-3508-3804
小渕優子	おぶちゆうこ	自民党	群馬05区	衆2-424号室	電話03-3508-7424	FAX03-3592-1754
海江田万里	かいえだばんり	民主党	東京01区	衆2-316号室	電話03-3508-7316	FAX03-3508-3316
柿沢未途	かきざわみと	みんなの党	東京比例	衆2-427号室	電話03-3508-7427	FAX03-3508-8807
柿沼正明	かきぬままさあき	民主党	群馬03区	衆2-522号室	電話03-3508-7522	FAX03-3508-3952
笠井亮	かさいあきら	共産党	東京比例	衆2-439号室	電話03-3508-7439	FAX03-3508-3919
笠原多見子	かさはらたみこ	民主党	東海比例	衆1-413号室	電話03-3508-7073	FAX03-3508-3033
梶山弘志	かじやまひろし	自民党	茨城04区	衆2-529号室	電話03-3508-7529	FAX03-3508-7714
梶原康弘	かじわらやすひろ	民主党	兵庫05区	衆2-216号室	電話03-3508-7016	FAX03-3508-3816
勝又恒一郎	かつまたこういちろう	民主党	南関東比例	衆1-202号室	電話03-3508-7202	FAX03-3508-3202
加藤学	かとうがく	民主党	長野05区	衆2-609号室	電話03-3508-7609	FAX03-3508-3989
加藤勝信	かとうかつのぶ	自民党	岡山05区	衆2-709号室	電話03-3508-7459	FAX03-3508-3289
加藤公一	かとうこういち	民主党	東京20区	衆2-707号室	電話03-3508-7457	FAX03-3508-3287
加藤紘一	かとうこういち	自民党	山形03区	衆2-711号室	電話03-3508-7461	FAX03-3508-4111
金森正	かなもりただし	民主党	東海比例	衆1-402号室	電話03-3508-7102	FAX03-3508-3402
金子一義	かねこかずよし	自民党	岐阜04区	衆2-541号室	電話03-3508-7060	FAX03-3502-5853
金子健一	かねこけんいち	民主党	南関東比例	衆1-524号室	電話03-3508-7254	FAX03-3508-3524
金子恭之	かねこやすし	自民党	熊本05区	衆2-410号室	電話03-3508-7410	FAX03-3504-8776
金田	勝年	かねだ	かつとし	自民党	東北比例	衆2-303号室	電話03-3508-7053	FAX03-3508-8815
鹿野道彦	かのみちひこ	民主党	山形01区	衆1-205号室	電話03-3508-7205	FAX03-3508-3205
神山洋介	かみやまようすけ	民主党	神奈川17区	衆1-320号室	電話03-3508-7493	FAX03-3508-3320
亀井静香	かめいしずか	国民新党	広島06区	衆1-635号室	電話03-3508-7145	FAX03-0848-22-2221
鴨下一郎	かもしたいちろう	自民党	東京比例	衆1-429号室	電話03-3508-7129	FAX03-3591-3227
河井克行	かわいかつゆき	自民党	中国比例	衆2-518号室	電話03-3508-7518	FAX03-3508-3948
川内博史	かわうちひろし	民主党	鹿児島01区	衆2-637号室	電話03-3508-7637	FAX03-3597-2716
河上満栄	かわかみみつえ	民主党	近畿比例	衆2-225号室	電話03-3508-7025	FAX03-3508-3825
川口博	かわぐちひろし	無所属	秋田02区	衆1-728号室	電話03-3508-7278	FAX03-3508-3728
川口浩	かわぐちひろし	民主党	北関東比例	衆2-526号室	電話03-3508-7526	FAX03-3508-3956
川越孝洋	かわごえたかひろ	民主党	九州比例	衆1-516号室	電話03-3508-7246	FAX03-3508-3516
川崎二郎	かわさきじろう	自民党	東海比例	衆1-702号室	電話03-3508-7152	FAX03-3502-5173
川島智太郎	かわしまともたろう	民主党	東京比例	衆1-539号室	電話03-3508-7269	FAX03-3508-3539
川端達夫	かわばたたつお	民主党	滋賀01区	衆2-421号室	電話03-3508-7421	FAX03-3502-5813
河村建夫	かわむらたけお	自民党	山口03区	衆2-209号室	電話03-3508-7009	FAX03-3502-5085
川村秀三郎	かわむらひでさぶろう	民主党	宮崎01区	衆1-725号室	電話03-3508-7275	FAX03-3508-7375
菅直人	かんなおと	民主党	東京18区	衆1-323号室	電話03-3508-7323	FAX03-3595-0090
神崎武法	かんざきたけのり	公明党	九州ｈ	衆1-414号室	電話03-3508-7225	FAX03-3503-2388
城井崇	きいたかし	民主党	福岡10区	衆1-438号室	電話03-3508-7138	FAX03-3508-3438
木内孝胤	きうちたかたね	民主党	東京09区	衆2-412号室	電話03-3508-7412	FAX03-3508-3892
城内実	きうちみのる	無所属	静岡07区	衆2-441号室	電話03-3508-7441	FAX03-3508-3921
黄川田徹	きかわだとおる	民主党	岩手03区	衆2-520号室	電話03-3508-7520	FAX03-5251-3683
菊田真紀子	きくたまきこ	民主党	新潟04区	衆2-524号室	電話03-3508-7524	FAX03-3508-3954
菊池長右エ門	きくちちょううえもん	民主党	東北比例	衆2-315号室	電話03-3508-7065	FAX03-3508-3845
岸田文雄	きしだふみお	自民党	広島01区	衆1-729号室	電話03-3508-7279	FAX03-3591-3118
岸本周平	きしもとしゅうへい	民主党	和歌山01区	衆1-211号室	電話03-3508-7701	FAX03-3508-3451
北神圭朗	きたがみけいろう	民主党	京都04区	衆2-638号室	電話03-3508-7638	FAX03-3508-3268
北村茂男	きたむらしげお	自民党	北陸信越比例	衆1-710号室	電話03-3508-7160	FAX03-3508-3710
北村誠吾	きたむらせいご	自民党	九州比例	衆2-627号室	電話03-3508-7627	FAX03-3508-3257
木村剛司	きむらたけつか	民主党	東京14区	衆2-413号室	電話03-3508-7413	FAX03-3508-3893
木村太郎	きむらたろう	自民党	青森04区	衆2-407号室	電話03-3508-7407	FAX03-3597-2700
京野公子	きょうのきみこ	民主党	秋田03区	衆1-637号室	電話03-3508-7147	FAX03-3508-3637
吉良州司	きらしゅうじ	民主党	大分01区	衆2-734号室	電話03-3508-7484	FAX03-3508-3364
櫛渕万里	くしぶちまり	民主党	東京23区	衆2-527号室	電話03-3508-7908	FAX03-3508-3957
楠田大蔵	くすだだいぞう	民主党	福岡05区	衆1-511号室	電話03-3508-7241	FAX03-3597-2773
沓掛哲男	くつかけてつお	民主党	北陸信越比例	衆2-611号室	電話03-3508-7611	FAX03-3508-3991
工藤仁美	くどうひとみ	民主党	北海道比例	衆2-517号室	電話03-3508-7517	FAX03-3508-3947
熊谷貞俊	くまがいさだとし	民主党	近畿比例	衆2-329号室	電話03-3508-7079	FAX03-3508-3769
熊田篤嗣	くまだあつし	民主党	大阪01区	衆2-208号室	電話03-3508-7008	FAX03-3508-3808
黒岩宇洋	くろいわたかひろ	民主党	新潟03区	衆2-530号室	電話03-3508-7050	FAX03-3508-3960
黒田雄	くろだゆう	民主党	千葉02区	衆1-534号室	電話03-3508-7264	FAX03-3508-7534
桑原功	くわばらいさお	民主党	北関東比例	衆1-230号室	電話03-3508-7230	FAX03-3508-3230
玄葉光一郎	げんばこういちろう	民主党	福島03区	衆1-522号室	電話03-3508-7252	FAX03-3591-2635
小池百合子	こいけゆりこ	自民党	東京比例	衆1-343号室	電話03-3508-7710	FAX03-3503-6775
小泉	進次郎	こいずみ	しんじろう	自民党	神奈川11区	衆1-327号室	電話03-3581-7327	FAX03-3508-3166
小泉俊明	こいずみとしあき	民主党	茨城03区	衆2-241号室	電話03-3508-7041	FAX03-3508-3841
小泉龍司	こいずみりゅうじ	無所属	埼玉11区	衆2-731号室	電話03-3508-7121	FAX03-3508-3351
河野太郎	こうのたろう	自民党	神奈川15区	衆2-206号室	電話03-3508-7006	FAX03-3500-5360
高村正彦	こうむらまさひこ	自民党	山口01区	衆1-226号室	電話03-3508-7113	FAX03-3502-5044
郡和子	こおりかずこ	民主党	宮城01区	衆2-512号室	電話03-3508-7512	FAX03-3508-3942
古賀一成	こがいっせい	民主党	九州比例	衆1-330号室	電話03-3508-7330	FAX03-3508-3330
古賀敬章	こがたかあき	民主党	福岡04区	衆1-703号室	電話03-3508-7153	FAX03-3508-3703
古賀誠	こがまこと	自民党	福岡07区	衆2-431号室	電話03-3508-7431	FAX03-3597-0483
穀田恵二	こくたけいじ	共産党	近畿比例	衆2-438号室	電話03-3508-7438	FAX03-3508-3918
小平忠正	こだいらただまさ	民主党	北海道10区	衆1-531号室	電話03-3508-7261	FAX03-3597-2930
後藤英友	ごとうひでとも	民主党	九州比例	衆1-722号室	電話03-3508-7272	FAX03-3508-3722
後藤斎	ごとうひとし	民主党	山梨03区	衆1-737号室	電話03-3508-7287	FAX03-3508-3737
後藤祐一	ごとうゆういち	民主党	神奈川16区	衆2-532号室	電話03-3508-7092	FAX03-3508-3962
後藤田正純	ごとうだまさずみ	自民党	徳島03区	衆1-315号室	電話03-3508-7315	FAX03-3508-3315
小林興起	こばやしこうき	民主党	東京比例	衆1-508号室	電話03-3508-3508	FAX03-3508-7298
小林千代美	こばやしちよみ	民主党	北海道05区	衆2-308号室	電話03-3508-7058	FAX03-3508-3858
小林正枝	こばやしまさえ	民主党	東海比例	衆1-424号室	電話03-3508-7124	FAX03-3508-3424
小宮山泰子	こみやまやすこ	民主党	埼玉07区	衆1-607号室	電話03-3508-7184	FAX03-3508-3614
小宮山洋子	こみやまようこ	民主党	東京06区	衆1-319号室	電話03-3508-7319	FAX03-3508-3319
小室寿明	こむろひさあき	民主党	中国比例	衆2-540号室	電話03-3508-7450	FAX03-3508-3970
小山展弘	こやまのぶひろ	民主党	静岡03区	衆1-640号室	電話03-3508-7150	FAX03-3508-3640
近藤和也	こんどうかずや	民主党	石川03区	衆2-607号室	電話03-3508-7607	FAX03-3508-3987
近藤昭一	こんどうしょういち	民主党	愛知03区	衆2-402号室	電話03-3508-7402	FAX03-3508-3882
近藤三津枝	こんどうみつえ	自民党	近畿比例	衆2-730号室	電話03-3508-7480	FAX03-3508-3360
近藤洋介	こんどうようすけ	民主党	山形02区	衆2-605号室	電話03-3508-7605	FAX03-3508-3985
斉木武志	さいきたけし	民主党	東海比例	衆2-603号室	電話03-3508-7603	FAX03-3508-3983
斎藤健	さいとう	けん	自民党	南関東比例	衆1-221号室	電話03-3508-7221	FAX03-3508-3221
斉藤進	さいとうすすむ	民主党	静岡08区	衆1-404号室	電話03-3508-7104	FAX03-3508-3404
齋藤勁	さいとうつよし	民主党	南関東比例	衆1-321号室	電話03-3508-7706	FAX03-3508-3321
斉藤鉄夫	さいとうてつお	公明党	中国比例	衆1-308号室	電話03-3508-7308	FAX03-3501-5524
斉藤恭紀	さいとうやすのり	民主党	宮城02区	衆1-513号室	電話03-3508-7243	FAX03-3508-3513
坂口岳洋	さかぐちたけひろ	民主党	山梨02区	衆2-719号室	電話03-3508-7469	FAX03-3508-7557
坂口力	さかぐちちから	公明党	東海比例	衆1-617号室	電話03-3508-7187	FAX03-3508-3617
阪口直人	さかぐちなおと	民主党	和歌山02区	衆1-212号室	電話03-3508－7212	FAX03-3508－3212
坂本哲志	さかもとてつし	自民党	熊本03区	衆2-234号室	電話03-3508-7034	FAX03-3508-3834
佐々木憲昭	ささきけんしょう	共産党	東海比例	衆1-730号室	電話03-3508-3730	FAX03-3508-7280
佐々木隆博	ささきたかひろ	民主党	北海道06区	衆2-325号室	電話03-3508-7075	FAX03-3508-3765
笹木竜三	ささきりゅうぞう	民主党	北陸信越比例	衆1-341号室	電話03-3508-7341	FAX03-3508-3062
佐田玄一郎	さたげんいちろう	自民党	北関東比例	衆2-201号室	電話03-3508-7001	FAX03-3593-7277
佐藤茂樹	さとうしげき	公明党	近畿比例	衆1-510号室	電話03-3508-7200	FAX03-3508-3510
佐藤勉	さとうつとむ	自民党	北関東比例	衆2-408号室	電話03-3508-7408	FAX03-3597-2740
佐藤夕子	さとうゆうこ	民主党	愛知01区	衆1-537号室	電話03-3508-7902	FAX03-3508-3537
志位和夫	しいかずお	共産党	南関東比例	衆1-735号室	電話03-3508-7285	FAX03-3508-3735
塩川鉄也	しおかわてつや	共産党	北関東比例	衆2-507号室	電話03-3508-7507	FAX03-3508-3937
塩崎恭久	しおざきやすひさ	自民党	愛媛01区	衆1-619号室	電話03-3508-7189	FAX03-3508-3619
塩谷立	しおのやりゅう	自民党	東海比例	衆2-632号室	電話03-3508-7632	FAX03-3508-3262
重野安正	しげのやすまさ	社民党	大分02区	衆1-419号室	電話03-3508-7126	FAX03-3508-3419
階猛	しなたけし	民主党	岩手01区	衆2-224号室	電話03-3508-7024	FAX03-3508-3824
篠原孝	しのはらたかし	民主党	長野01区	衆1-538号室	電話03-3508-7268	FAX03-3508-3538
柴橋正直	しばはしまさなお	民主党	岐阜01区	衆2-604号室	電話03-3508-7604	FAX03-3508-3984
柴山昌彦	しばやままさひこ	自民党	北関東比例	衆2-624号室	電話03-3508-7624	FAX03-3508-7715
下地幹郎	しもじみきお	国民新党	沖縄01区	衆1-629号室	電話03-3508-7380	FAX03-3508-3629
下条みつ	しもじょうみつ	民主党	長野02区	衆1-336号室	電話03-3508-7336	FAX03-3508-3336
下村博文	しもむらはくぶん	自民党	東京11区	衆2-334号室	電話03-3508-7084	FAX03-3597-2772
城島光力	じょうじまこうりき	民主党	神奈川10区	衆1-241号室	電話03-3508-7712	FAX03-3508-3241
白石洋一	しらいしよういち	民主党	愛媛03区	衆2-207号室	電話03-3508-7007	FAX03-3508-3807
新藤義孝	しんどうよしたか	自民党	北関東比例	衆1-313号室	電話03-3508-7313	FAX03-3508-3313
神風英男	じんぷうひでお	民主党	埼玉04区	衆2-227号室	電話03-3508-7027	FAX03-3508-3827
末松義規	すえまつよしのり	民主党	東京19区	衆2-713号室	電話03-3508-7463	FAX03-3508-3293
菅義偉	すがよしひで	自民党	神奈川02区	衆2-536号室	電話03-3508-7446	FAX03-3597-2707
菅原一秀	すがわらいっしゅう	自民党	東京比例	衆2-634号室	電話03-3508-7634	FAX03-3508-3264
杉本和己	すぎもとかずみ	民主党	愛知10区	衆1-406号室	電話03-3508-7106	FAX03-3508-3406
菅川洋	すげかわひろし	民主党	中国比例	衆1-426号室	電話03-3508-7119	FAX03-3508-3426
瑞慶覧長敏	ずけらんちょうびん	民主党	沖縄04区	衆1-515号室	電話03-3508-7245	FAX03-3508-3515
鈴木克昌	すずきかつまさ	民主党	愛知14区	衆1-620号室	電話03-3508-7190	FAX03-3508-3620
鈴木宗男	すずきむねお	新党大地	北海道比例	衆1-224号室	電話03-3508-7115	FAX03-3502-5036
首藤信彦	すとうのぶひこ	民主党	神奈川07区	衆1-223号室	電話03-3508-7135	FAX03-3508-3435
仙谷由人	せんごくよしと	民主党	徳島01区	衆1-235号室	電話03-3508-7235	FAX03-3508-3235
園田博之	そのだひろゆき	自民党	熊本04区	衆2-213号室	電話03-3508-7013	FAX03-3502-5142
園田康博	そのだやすひろ	民主党	岐阜03区	衆1-623号室	電話03-3508-7193	FAX03-3508-3623
空本誠喜	そらもとせいき	民主党	広島04区	衆1-431号室	電話03-3508-7131	FAX03-3508-3431
平智之	たいらともゆき	民主党	京都01区	衆2-614号室	電話03-3508-7614	FAX03-3508-8814
平将明	たいらまさあき	自民党	東京比例	衆1-507号室	電話03-3508-7297	FAX03-3508-3507
高井崇志	たかいたかし	民主党	中国比例	衆1-228号室	電話03-3508-7228	FAX03-3508-3228
高井美穂	たかいみほ	民主党	徳島02区	衆1-234号室	電話03-3508-7234	FAX03-3508-3234
高市早苗	たかいちさなえ	自民党	近畿比例	衆1-628号室	電話03-3508-7198	FAX03-3508-7199
高木毅	たかぎつよし	自民党	福井03区	衆1-506号室	電話03-3508-7296	FAX03-3508-3506
高木美智代	たかぎみちよ	公明党	東京比例	衆2-630号室	電話03-3508-7630	FAX03-3508-3260
高木陽介	たかぎようすけ	公明党	東京比例	衆2-721号室	電話03-3508-7481	FAX03-5251-3685
高木義明	たかきよしあき	民主党	長崎01区	衆2-420号室	電話03-3508-7420	FAX03-3503-5757
高野守	たかのまもる	民主党	北関東比例	衆-503号室	電話03-3508-7503	FAX03-3508-3933
高橋昭一	たかはししょういち	民主党	兵庫04区	衆2-219号室	電話03-3508-7019	FAX03-3508-7719
高橋千鶴子	たかはしちづこ	共産党	東北比例	衆2-506号室	電話03-3508-7506	FAX03-3508-3936
高橋英行	たかはしひでゆき	民主党	四国比例	衆1-706号室	電話03-3508-7156	FAX03-3508-3706
高松和夫	たかまつかずお	民主党	東北比例	衆2-318号室	電話03-3508-7068	FAX03-3508-3848
高邑勉	たかむらつとむ	民主党	中国比例	衆2-620号室	電話03-3508-7620	FAX03-3508-3250
高山智司	たかやまさとし	民主党	埼玉15区	衆2-236号室	電話03-3508-7036	FAX03-3508-3836
滝実	たきまこと	民主党	奈良02区	衆2-331号室	電話03-3508-7081	FAX03-3508-3861
竹内譲	たけうちゆずる	公明党	近畿比例	衆2-723号室	電話03-3508-7473	FAX03-3508-3353
竹下亘	たけしたわたる	自民党	島根02区	衆2-619号室	電話03-3508-7619	FAX03-3504-2842
竹田光明	たけだみつあき	民主党	東京比例	衆2-625号室	電話03-3508-7625	FAX03-3508-3255
武田良太	たけだりょうた	自民党	福岡11区	衆1-610号室	電話03-3508-7180	FAX03-3508-3610
武部勤	たけべつとむ	自民党	北海道比例	衆2-425号室	電話03-3508-7425	FAX03-3502-5190
武正公一	たけまさこういち	民主党	埼玉01区	衆2-312号室	電話03-3508-7062	FAX03-3519-7715
竹本直一	たけもとなおかず	自民党	近畿比例	衆2-539号室	電話03-3508-7449	FAX03-3597-2804
田島一成	たじまいっせい	民主党	滋賀02区	衆2-418号室	電話03-3508-7418	FAX03-3508-3898
田嶋要	たじまかなめ	民主党	千葉01区	衆1-411号室	電話03-3508-7229	FAX03-3508-3411
橘慶一郎	たちばなけいいちろう	自民党	富山03区	衆1-227号室	電話03-3508-7227	FAX03-3508-3227
橘秀徳	たちばなひでのり	民主党	神奈川13区	衆2-626号室	電話03-3508-7626	FAX03-3508-3256
田中和徳	たなかかずのり	自民党	南関東比例	衆1-504号室	電話03-3508-7294	FAX03-3508-3504
田中慶秋	たなかけいしゅう	民主党	神奈川05区	衆2-422号室	電話03-3508-7422	FAX03-3508-8822
田中眞紀子	たなかまきこ	民主党	新潟05区	衆1-302号室	電話03-3508-7302	FAX03-3508-3302
田中美絵子	たなかみえこ	民主党	北陸信越比例	衆1-603号室	電話03-3508-7173	FAX03-3508-3603
田中康夫	たなかやすお	新党日本	兵庫08区	衆2-628号室	電話03-3508-7628	FAX03-3508-7658
棚橋泰文	たなはしやすふみ	自民党	岐阜02区	衆2-429号室	電話03-3508-7429	FAX03-3508-3909
田名部匡代	たなぶまさよ	民主党	東北比例	衆2-617号室	電話03-3508-7617	FAX03-3508-3245
谷公一	たにこういち	自民党	近畿比	衆2-210号室	電話03-3508-7010	FAX03-3502-5048
谷垣禎一	たにがきさだかず	自民党	京都05区	衆2-212号室	電話03-3508-7012	FAX03-3597-0895
谷川弥一	たにがわやいち	自民党	九州比例	衆2-214号室	電話03-3508-7014	FAX03-3506-0557
谷畑孝	たにはたたかし	自民党	近畿比例	衆1-726号室	電話03-3508-7276	FAX03-3508-3726
田野瀬良太郎	たのせりょうたろう	自民党	奈良04区	衆2-321号室	電話03-3508-7071	FAX03-3591-6569
玉置公良	たまききみよし	民主党	近畿比例	衆1-218号室	電話03-3508-7218	FAX03-3508-3218
玉城デニー	たまきでにー	民主党	沖縄03区	衆1-734号室	電話03-3508-7284	FAX03-3508-3734
玉木朝子	たまきともこ	民主党	北関東比例	衆2-631号室	電話03-3508-7631	FAX03-3508-3261
玉木雄一郎	たまきゆういちろう	民主党	香川02区	衆1-213号室	電話03-3508-7213	FAX03-3508-3213
田村謙治	たむらけんじ	民主党	静岡04区	衆2-317号室	電話03-3508-7067	FAX03-3508-3847
田村憲久	たむらのりひさ	自民党	東海比例	衆1-713号室	電話03-3508-7163	FAX03-3502-5066
樽床伸二	たるとこしんじ	民主党	大阪12区	衆1-201号室	電話03-3508-7201	FAX03-3508-3201
中後淳	ちゅうごあつし	民主党	南関東比区	衆1-518室	電話03-33508-7248	FAX03-3508-3518
津川祥吾	つがわしょうご	民主党	静岡02区	衆2-701号室	電話03-3508-7451	FAX03-3508-3281
辻恵	つじめぐむ	民主党	大阪17区	衆2-215号室	電話03-3508-7015	FAX03-3508-3815
津島恭一	つしまきょういち	民主党	東北比例	衆1-543号室	電話03-3508-7267	FAX03-3508-3543
辻元清美	つじもときよみ	社民党	大阪10区	衆2-305号室	電話03-3508-7055	FAX03-3508-3855
筒井信隆	つついのぶたか	民主党	新潟06区	衆2-505号室	電話03-3508-7505	FAX03-3508-4530
津村啓介	つむらけいすけ	民主党	岡山02区	衆2-338号室	電話03-3508-7088	FAX03-3508-3868
手塚仁雄	てづかよしお	民主党	東京05区	衆1-440号室	電話03-3508-3440	FAX03-3508-7140
寺田学	てらたまなぶ	民主党	秋田01区	衆1-704号室	電話03-3508-7154	FAX03-3508-3704
照屋寛徳	てるやかんとく	社民党	沖縄02区	衆2-319号室	電話03-3508-7069	FAX03-3508-3849
土肥隆一	どいりゅういち	民主党	兵庫03区	衆1-738号室	電話03-3508-7288	FAX03-3593-6266
道休誠一郎	どうきゅうせいいちろう	民主党	九州比例	衆2-633号室	電話03-3508-7633	FAX03-3508-3263
徳田毅	とくだたけし	自民党	鹿児島02区	衆1-340号室	電話03-3508-7340	FAX03-3508-3340
富岡芳忠	とみおかよしただ	民主党	北関東比例	衆1-236号室	電話03-3508-7236	FAX03-3508-3399
富田茂之	とみたしげゆき	公明党	南関東比例	衆2-302号室	電話03-3508-7052	FAX03-3508-3852
豊田潤多郎	とよだじゅんたろう	民主党	近畿比例	衆2-218号室	電話03-3508-7018	FAX03-3508-3818
中井洽	なかいひろし	民主党	三重01区	衆1-533号室	電話03-3508-7263	FAX03-3592-9044
永江孝子	ながえたかこ	民主党	四国比例	衆1-612号室	電話03-3508-7263	FAX03-3508-3612
長尾敬	ながおたかし	民主党	大阪14区	衆2-230号室	電話03-3508-7030	FAX03-3508-3830
永岡桂子	ながおかけいこ	自民党	北関比例	衆1-724号室	電話03-3508-7274	FAX03-3508-7274
中川治	なかがわおさむ	民主党	大阪18区	衆2-430号室	電話03-3508-7430	FAX03-3508-3910
中川秀直	なかがわひでなお	自民党	中国比例	衆1-505号室	電話03-3508-7295	FAX03-3508-3505
中川正春	なかがわまさはる	民主党	三重02区	衆1-428号室	電話03-3508-7128	FAX03-3508-3428
長島昭久	ながしまあきひさ	民主党	東京23区	衆2-714号室	電話03-3508-7464	FAX03-3508-3294
長島一由	ながしまかずよし	民主党	神奈川04区	衆2-704号室	電話03-3508-7454	FAX03-3508-3284
中島隆利	なかじまたかとし	社民党	九州比例	衆1-418号室	電話03-3508-7118	FAX03-3508-3418
長島忠美	ながしまただよし	自民党	北陸信越比例	衆2-640号室	電話03-3508-7640	FAX03-3508-3270
中島政希	なかじままさき	民主党	北関東比例	衆1-733号室	電話03-3508-7343	FAX03-3508-3733
中島正純	なかじままさずみ	民主党	大阪03区	衆2-713号室	電話03-3508-7463	FAX03-3508-3293
長勢甚遠	ながせじんえん	自民党	北陸信越比例	衆1-407号室	電話03-3508-7107	FAX03-3592-9048
中谷元	なかたにげん	自民党	高知02区	衆2-736号室	電話03-3508-7486	FAX03-3592-9032
中塚一宏	なかつかいっこう	民主党	神奈川102区	衆2-708号室	電話03-3508-7458	FAX03-3508-3288
中津川博郷	なかつがわひろさと	民主党	東京比例	衆2-414号室	電話03-3508-7414	FAX03-3508-3894
長妻昭	ながつまあきら	民主党	東京07区	衆2-706号室	電話03-3508-7456	FAX03-3508-3286
中根康浩	なかねやすひろ	民主党	愛知12区	衆2-534号室	電話03-3508-7527	FAX03-3508-3973
中野寛成	なかのかんせい	民主党	大阪08区	衆2-411号室	電話03-3508-7411	FAX03-3508-3891
中野譲	なかのじょう	民主党	埼玉14区	衆1-541号室	電話03-3508-7271	FAX03-3508-3541
仲野博子	なかのひろこ	民主党	北海道比例	衆1-237号室	電話03-3508-7237	FAX03-3508-3237
中野渡詔子	なかのわたりのりこ	民主党	東北比例	衆1-638号室	電話03-3508-7148	FAX03-3508-3638
中林美恵子	なかばやしみえこ	民主党	神奈川01区	衆1-616号室	電話03-3581-5111	FAX03-3508-3616
中村喜四郎	なかむらきしろう	改革クラブ	茨城07区	衆2-501号室	電話03-3508-7501	FAX03-3508-3931
長安豊	ながやすたかし	民主党	大阪19区	衆1-630号室	電話03-3508-7455	FAX03-3508-3630
中山義活	なかやまよしかつ	民主党	東京02区	衆1-529号室	電話03-3508-7188	FAX03-3508-3618
二階俊博	にかいとしひろ	自民党	和歌山03区	衆2-223号室	電話03-3508-7023	FAX03-3502-5037
仁木博文	にきひろぶみ	民主党	四国比例	衆1-434号室	電話03-3508-7134	FAX03-3508-3434
西博義	にしひろよし	公明党	近畿比例	衆1-509号室	電話03-3508-7389	FAX03-3508-3509
西野陽	にしのあきら	自民党	大阪13区	衆2-203号室	電話03-3508-7003	FAX03-3597-2708
西村智奈美	にしむらちなみ	民主党	新潟01区	衆2-404号室	電話03-3508-7404	FAX03-3508-3884
西村康稔	にしむらやすとし	自民党	兵庫09区	衆1-401号室	電話03-3508-7101	FAX03-3508-3401
額賀福志郎	ぬかがふくしろう	自民党	北関東比例	衆2-537号室	電話03-3508-7447	FAX03-3592-0468
野木実	のぎみのる	民主党	北関東比例	衆2-417号室	電話03-3508-7417	FAX03-3508-3897
野田国義	のだくによし	民主党	九州比例	衆1-718号室	電話03-3508-7388	FAX03-3508-3718
野田聖子	のだせいこ	自民党	東海比例	衆1-711号室	電話03-3508-7161	FAX03-3591-2143
野田毅	のだたけし	自民党	九州比例	衆2-415号室	電話03-3508-7415	FAX03-3501-7538
野田佳彦	のだよしひこ	民主党	千葉04区	衆1-441号室	電話03-3508-7141	FAX03-3508-3441
萩原仁	はぎはらひとし	民主党	大阪02区	衆2-228号室	電話03-3508-7028	FAX03-3508-3828
橋本清仁	はしもときよひと	民主党	宮城03区	衆1-643号室	電話03-3508-7903	FAX03-3508-3643
橋本博明	はしもとひろあき	民主党	広島03区	衆1-430号室	電話03-3508-7130	FAX03-3508-3430
橋本勉	はしもとべん	民主党	東海比例	衆2-714号室	電話03-3508-7464	FAX03-3508-3294
馳浩	はせひろし	自民党	北陸信越比例	衆1-609号室	電話03-3508-7179	FAX03-3508-3609
畑浩治	はたこうじ	民主党	岩手02区	衆2-314号室	電話03-3508-7064	FAX03-3508-3844
羽田孜	はたつとむ	民主党	長野03区	衆1-324号室	電話03-3508-7324	FAX03-3502-5080
鉢呂吉雄	はちろよしお	民主党	北海道04区	衆1-207号室	電話03-3508-7704	FAX03-3593-7272
初鹿明博	はつしかあきひろ	民主党	東京16区	衆1-337号室	電話03-3508-7337	FAX03-3508-3337
服部良一	はっとりりょういち	社民党	近畿比例	衆2-306号室	電話03-3508-7056	FAX03-3508-3856
鳩山邦夫	はとやまくにお	自民党	福岡06区	衆2-243号室	電話03-3508-7905	FAX03-3580-8001
鳩山由紀夫	はとやまゆきお	民主党	北海道09区	衆1-334号室	電話03-3508-7334	FAX03-3502-5295
花咲宏基	はなさきひろき	民主党	中国比例	衆2-728号室	電話03-3508-7478	FAX03-3508-3358
浜田靖一	はまだやすかず	自民党	千葉12区	衆2-220号室	電話03-3508-7020	FAX03-3508-7644
浜本宏	はまもとひろし	民主党	近畿比例	衆1-332号室	電話03-3508-7082	FAX03-3508-3862
早川久美子	はやかわくみこ	民主党	東京比例	衆2-729号室	電話03-3508-7479	FAX03-3508-3359
林幹雄	はやしもとお	自民党	南関東比例	衆1-641号室	電話03-3508-7151	FAX03-3502-5016
原口一博	はらぐちかずひろ	民主党	佐賀01区	衆1-238号室	電話03-3508-7238	FAX03-3508-3238
伴野豊	ばんのゆたか	民主党	愛知08区	衆1-621号室	電話03-3508-7191	FAX03-3508-3621
東順治	ひがしじゅんじ	公明党	九州比例	衆1-519号室	電話03-3508-7249	FAX03-3508-3519
樋口俊一	ひぐちとしかず	民主党	近畿比例	衆2-732号室	電話03-3508-7482	FAX03-3508-3362
樋高剛	ひだかたけし	民主党	神奈川18区	衆1-604号室	電話03-3508-7174	FAX03-3508-3604
平井卓也	ひらいたくや	自民党	四国比例	衆1-307号室	電話03-3508-7307	FAX03-3508-3307
平岡秀夫	ひらおかひでお	民主党	山口02区	衆2-341号室	電話03-3508-7091	FAX03-3508-1055
平沢勝栄	ひらさわかつえい	自民党	東京17区	衆1-527号室	電話03-3508-7257	FAX03-3508-3527
平沼赳夫	ひらぬまたけお	無所属	岡山03区	衆1-310号室	電話03-3508-7310	FAX03-3502-5084
平野博文	ひらのひろふみ	民主党	大阪11区	衆2-330号室	電話03-3508-7080	FAX03-3502-5025
平山泰朗	ひらやまたいろう	民主党	東京13区	衆2-735号室	電話03-3508-7485	FAX03-3508-3365
福井照	ふくいてる	自民党	高知01区	衆2-523号室	電話03-3508-7523	FAX03-3519-7713
福嶋健一郎	ふくしまけんいちろう	民主党	熊本02区	衆1-721号室	電話03-3508-7207	FAX03-3508-3721
福島伸享	ふくしまのぶゆき	民主党	茨城01区	衆1-338号室	電話03-3508-7338	FAX03-3508-7766
福田昭夫	ふくだあきお	民主党	栃木02区	衆1-739号室	電話03-3508-7289	FAX03-3508-3729
福田衣里子	ふくだえりこ	民主党	長崎02区	衆1-208号室	電話03-3508-7208	FAX03-3509-3208
福田康夫	ふくだやすお	自民党	群馬04区	衆1-611号室	電話03-3508-7181	FAX03-3508-3611
藤井裕久	ふじいひろひさ	民主党	南関東比例	衆1-427号室	電話03-3508-7127	FAX03-3508-3427
藤田一枝	ふじたかずえ	民主党	福岡03区	衆2-416号室	電話03-3508-7416	FAX03-3508-3896
藤田大助	ふじただいすけ	民主党	東海比例	衆2-737号室	電話03-3508-7487	FAX03-3508-3367
藤田憲彦	ふじたのりひこ	民主党	東京4区	衆2-405号室	電話03-3508-7405	FAX03-3508-3885
藤村修	ふじむらおさむ	民主党	大阪07区	衆2-324号室	電話03-3508-7074	FAX03-3591-2608
古川元久	ふるかわもとひさ	民主党	愛知02区	衆2-328号室	電話03-3508-7078	FAX03-3597-2758
古川禎久	ふるかわよしひさ	自民党	宮崎03区	衆2-612号室	電話03-3508-7612	FAX03-3506-2503
古本伸一郎	ふるもとしんいちろう	民主党	愛知11区	衆1-532号室	電話03-3508-7262	FAX03-3502-5075
古屋圭司	ふるやけいじ	自民党	東海比例	衆2-440号室	電話03-3508-7440	FAX03-3592-9040
古屋範子	ふるやのりこ	公明党	南関東比例	衆2-629号室	電話03-3508-7629	FAX03-3508-3259
細川律夫	ほそかわりつお	民主党	埼玉03区	衆2-513号室	電話03-3508-7513	FAX03-3593-7148
細田博之	ほそだひろゆき	自民党	島根01区	衆2-533号室	電話03-3508-7443	FAX03-3503-7530
細野豪志	ほそのごうし	民主党	静岡05区	衆1-416号室	電話03-3508-7116	FAX03-3508-3416
保利耕輔	ほりこうすけ	自民党	佐賀03区	衆1-311号室	電話03-3508-7311	FAX03-5251-7130
本多平直	ほんだひらなお	民主党	埼玉12区	衆2-622号室	電話03-3508-7622	FAX03-3508-3252
前原誠司	まえはらせいじ	民主党	京都02区	衆1-601号室	電話03-3508-7171	FAX03-3592-6696
牧義夫	まきよしお	民主党	愛知04区	衆1-433号室	電話03-3508-7133	FAX03-3508-3433
牧野聖修	まきのせいしゅう	民主党	静岡1区	衆1-701号室	電話03-3508-7387	FAX03-3508-3701
町村信孝	まちむらのぶたか	自民党	北海道比例	衆1-417号室	電話03-3508-7117	FAX03-3502-5061
松岡広隆	まつおかひろたか	民主党	近畿比例	衆2-238号室	電話03-3508-7038	FAX03-3508-3838
松木謙公	まつきけんこう	民主党	北海道12区	衆1-306号室	電話03-3508-7306	FAX03-3508-9033
松崎公昭	まつざききみあき	民主党	千葉08区	衆1-239号室	電話03-3508-7239	FAX03-3508-3239
松崎哲久	まつざきてつひさ	民主党	埼玉10区	衆2-434号室	電話03-3508-7434	FAX03-3508-3914
松下忠洋	まつしたただひろ	国民新党	鹿児島03区	衆1-636号室	電話03-3508-7146	FAX03-3508-7546
松浪健太	まつなみけんた	自民党	近畿比例	衆1-536号室	電話03-3508-7266	FAX03-3508-3536
松野博一	まつのひろかず	自民党	南関東比例	衆1-329号室	電話03-3508-7329	FAX03-3508-3329
松野頼久	まつのよりひさ	民主党	熊本01区	衆2-240号室	電話03-3508-7040	FAX03-3508-8989
松原仁	まつばらじん	民主党	東京03区	衆2-702号室	電話03-3508-7452	FAX03-3580-7336
松宮勲	まつみやいさお	民主党	北陸信越比例	衆2-608号室	電話03-3508-7608	FAX03-3508-3988
松本純	まつもとじゅん	自民党	南関東比例	衆1-209号室	電話03-3508-7705	FAX03-3508-3455
松本大輔	まつもとだいすけ	民主党	広島02区	衆2-725号室	電話03-3508-7475	FAX03-3508-3355
松本剛明	まつもとたけあき	民主党	兵庫11区	衆1-214号室	電話03-3508-7214	FAX03-3508-3214
松本龍	まつもとりゅう	民主党	福岡01区	衆2-616号室	電話03-3508-7616	FAX03-3593-7266
馬淵澄夫	まぶちすみお	民主党	奈良01区	衆1-437号室	電話03-3508-7137	FAX03-3506-3572
三日月大造	みかづきたいぞう	民主党	滋賀03区	衆2-419号室	電話03-3508-7419	FAX03-3508-3899
水野智彦	みずのともひこ	民主党	南関東比例	衆1-523号室	電話03-3508-7253	FAX03-3508-3523
三谷光男	みたにみつお	民主党	広島5区	衆2-726号室	電話03-3508-7476	FAX03-3508-3356
三井辨雄	みついわきお	民主党	北海道02区	衆1-705号室	電話03-3508-7155	FAX03-3508-3705
三ツ矢憲生	みつやのりお	自民党	三重05区	衆1-634号室	電話03-3508-7144	FAX03-3508-5210
皆吉稲生	みなよしいなお	民主党	九州比例	衆1-709号室	電話03-3508-7159	FAX03-3508-3709
三村和也	みむらかずや	民主党	南関東比例	衆2-738号室	電話03-3508-7488	FAX03-3508-3368
三宅雪子	みやけゆきこ	民主党	北関東比例	衆1-613室	電話03-3508-7643	FAX03-3508-3613
宮腰光寛	みやこしみつひろ	自民党	富山02区	衆2-311号室	電話03-3508-7061	FAX03-5251-0866
宮崎岳志	みやざきたけし	民主党	群馬01区	衆2-739号室	電話03-3508-7489	FAX03-3508-3369
宮島大典	みやじまだいすけ	民主党	長崎4区	衆1-719号室	電話03-3508-3719	FAX03-3508-8819
宮本岳志	みやもとたけし	共産党	近畿比例	衆1-624号室	電話03-3508-7194	FAX03-3508-3624
三輪信昭	みわのぶあき	民主党	東海比例	衆2-343号室	電話03-3508-7906	FAX03-3508-3873
向山好一	むこやまこういち	民主党	兵庫02区	衆1-217号室	電話03-3508-7702	FAX03-3508-3452
村井宗明	むらいむねあき	民主党	富山01区	衆1-627号室	電話03-3508-7197	FAX03-3508-3627
村上誠一郎	むらかみせいいちろう	自民党	愛媛02区	衆1-741号室	電話03-3508-7291	FAX03-3502-5172
村上史好	むらかみふみよし	民主党	大阪06区	衆2-229号室	電話03-3508-7029	FAX03-3508-3829
村越祐民	むらこしひろたみ	民主党	千葉05区	衆1-312号室	電話03-3508-7312	FAX03-3508-3312
村田吉隆	むらたよしたか	自民党	中国比例	衆1-540号室	電話03-3508-7270	FAX03-3593-7145
室井秀子	むろいひでこ	民主党	近畿比例	衆2-237号室	電話03-3508-7037	FAX03-3508-3837
茂木敏充	もてぎとしみつ	自民党	栃木05区	衆2-639号室	電話03-3508-7639	FAX03-3508-3269
本村賢太郎	もとむらけんたろう	民主党	神奈川14区	衆2-710号室	電話03-3508-7460	FAX03-3508-3290
森英介	もりえいすけ	自民党	千葉11区	衆1-712号室	電話03-3508-7162	FAX03-3592-9036
森喜朗	もりよしろう	自民党	石川02区	衆2-309号室	電話03-3508-7059	FAX03-3580-8904
森岡洋一郎	もりおかよういちろう	民主党	埼玉13区	衆2-435号室	電話03-3508-7435	FAX03-3508-3915
森本和義	もりもとかずよし	民主党	愛知15区	衆1-409号室	電話03-3508-7901	FAX03-3508-3409
森本哲生	もりもとてつお	民主党	三重04区	衆2-401号室	電話03-3508-7401	FAX03-3508-3881
森山裕	もりやまひろし	自民党	鹿児島05区	衆1-714号室	電話03-3508-7164	FAX03-3508-3714
森山浩行	もりやまひろゆき	民主党	大阪16区	衆2-232号室	電話03-3508-7032	FAX03-3508-3832
矢崎公二	やざきこうじ	民主党	長野04区	衆1-326号室	電話03-3508-7326	FAX03-3508-3326
谷田川元	やたがわはじめ	民主党	千葉10区	衆1-423号室	電話03-3508-7123	FAX03-3508-3423
柳田和己	やなぎたかずみ	民主党	北関東比例	衆2-504号室	電話03-3508-7504	FAX03-3508-3934
柳本卓治	やなぎもとたくじ	自民党	近畿比	衆1-717号室	電話03-3508-7167	FAX03-3597-2801
山内康一	やまうちこういち	みんなの党	北関東比例	衆1-520号室	電話03-3508-7250	FAX03-3508-3520
山尾志桜里	やまおしおり	民主党	愛知07区	衆1-614号室	電話03-3508-7636	FAX03-3508-3024
山岡賢次	やまおかけんじ	民主党	栃木04区	衆1-606号室	電話03-3508-7176	FAX03-3502-8855
山岡達丸	やまおかたつまる	民主党	北海道比例	衆2-301号室	電話03-3508-7051	FAX03-3508-3851
山口和之	やまぐちかずゆき	民主党	東北比例	衆2-320号室	電話03-3508-7070	FAX03-3508-3850
山口俊一	やまぐちしゅんいち	自民党	四国比例	衆2-304号室	電話03-3508-7054	FAX03-3503-2138
山口壮	やまぐちつよし	民主党	兵庫12区	衆2-521号室	電話03-3508-7521	FAX03-3508-3951
山崎誠	やまざきまこと	民主党	南関東比例	衆2-741号室	電話03-3508-7741	FAX03-3508-3061
山崎摩耶	やまざきまや	民主党	北海道比例	衆1-716号室	電話03-3508-7166	FAX03-3508-3716
山田正彦	やまだまさひこ	民主党	長崎03区	衆2-602号室	電話03-3508-7602	FAX03-3519-5116
山田良司	やまだりょうじ	民主党	東海比例	衆2-715号室	電話03-3508-7465	FAX03-3508-3295
山井和則	やまのいかずのり	民主党	京都06区	衆1-240号室	電話03-3508-7240	FAX03-3508-8882
山花郁夫	やまはないくお	民主党	東京22区	衆1-314号室	電話03-3508-7314	FAX03-3508-3314
山本公一	やまもとこういち	自民党	愛媛04区	衆2-703号室	電話03-3508-7453	FAX03-3502-5056
山本剛正	やまもとごうせい	民主党	九州比例	衆1-203号室	電話03-3508-7707	FAX03-3508-3203
山本幸三	やまもとこうぞう	自民党	九州比例	衆2-335号室	電話03-3508-7085	FAX03-3501-9303
山本拓	やまもとたく	自民党	福井02区	衆1-732号室	電話03-3508-7282	FAX03-3508-3290
山本有二	やまもとゆうじ	自民党	高知03区	衆1-232号室	電話03-3508-7232	FAX03-3592-9069
柚木道義	ゆのきみちよし	民主党	岡山04区	衆1-301号室	電話03-3508-7301	FAX03-3508-3301
湯原俊二	ゆはらしゅんじ	民主党	中国比例	衆1-501号室	電話03-3508-7381	FAX03-3508-3501
横粂勝仁	よこくめかつひと	民主党	南関東比例	衆2-705号室	電話03-3508-7910	FAX03-3508-7565
横路孝弘	よこみちたかひろ	民主党	北海道01区	衆2-516号室	電話03-3508-7516	FAX03-3508-3946
横光克彦	よこみつかつひこ	民主党	大分03区	衆2-233号室	電話03-3508-7033	FAX03-3508-3833
横山北斗	よこやまほくと	民主党	青森01区	衆2-226号室	電話03-3508-7026	FAX03-3508-3826
与謝野馨	よさのかおる	自民党	東京比例	衆1-222号室	電話03-3508-7222	FAX03-3508-3222
吉井英勝	よしいひでかつ	共産党	近畿比例	衆2-437号室	電話03-3508-7437	FAX03-3508-3917
吉泉秀男	よしいずみひでお	社民党	東北比例	衆1-304号室	電話03-3508-7304	FAX03-3508-3304
吉川政重	よしかわまさしげ	民主党	奈良03区	衆2-519号室	電話03-3508-7519	FAX03-3508-3949
吉田泉	よしだいずみ	民主党	福島05区	衆1-530号室	電話03-3508-7260	FAX03-3508-3530
吉田治	よしだおさむ	民主党	大阪04区	衆2-643号室	電話03-3508-7909	FAX03-3508-7600
吉田公一	よしだこういち	民主党	東京比例	衆1-325号室	電話03-3508-7325	FAX03-3508-3325
吉田統彦	よしだつねひこ	民主党	東海比例	衆1-425号室	電話03-3508-7125	FAX03-3508-3425
吉野正芳	よしのまさよし	自民党	東北比例	衆1-633号室	電話03-3508-7143	FAX03-3595-4546
笠浩史	りゅうひろふみ	民主党	神奈川09区	衆1-420号室	電話03-3508-7120	FAX03-3508-7120
若井康彦	わかいやすひこ	民主党	千葉13区	衆1-525号室	電話03-3508-7255	FAX03-3508-3525
若泉征三	わかいずみせいぞう	民主党	北陸信越比例	衆2-613号室	電話03-3508-7711	FAX03-3508-3300
鷲尾英一郎	わしおえいいちろう	民主党	新潟02区	衆2-323号室	電話03-3508-7650	FAX03-3508-3062
和嶋未希	わじまみき	民主党	東北比例	衆1-206号室	電話03-3508-7206	FAX03-3508-3206
和田隆志	わだたかし	民主党	広島07区	衆1-707号室	電話03-3508-7157	FAX03-3508-7157
渡辺浩一郎	わたなべこういちろう	民主党	東京比例	衆2-409号室	電話03-3508-7409	FAX03-3508-3889
渡部恒三	わたなべこうぞう	民主党	福島04区	衆2-202号室	電話03-3508-7002	FAX03-3502-5029
渡辺周	わたなべしゅう	民主党	静岡06区	衆2-327号室	電話03-3508-7077	FAX03-3508-3767
渡辺義彦	わたなべよしひこ	民主党	近畿比例	衆2-221号室	電話03-3508-7021	FAX03-3508-3821
渡辺喜美	わたなべよしみ	みんなの党	栃木03区	衆2-426号室	電話03-3508-7426	FAX03-3508-3906
愛知治郎	あいちじろう	自民党	宮城	参-636号室	電話03-3508-8636	FAX03-5512-2636
相原久美子	あいはらくみこ	民主党	比例	参-621号室	電話03-3508-8621	FAX03-5512-2621
青木幹雄	あおきみきお	自民党	島根	参-534号室	電話03-3508-8534	FAX03-3502-8825
秋元司	あきもとつかさ	自民党	比例	参-311号室	電話03-3508-8311	FAX03-5512-2311
浅野勝人	あさのかつひと	自民党	愛知	参-724号室	電話03-3508-8724	FAX03-3508-9724
足立信也	あだちしんや	民主党	大分	参-425号室	電話03-3508-8425	FAX03-5512-2425
荒井広幸	あらいひろゆき	改革クラブ	比例	参-221号室	電話03-3508-8221	FAX03-3508-9677
荒木清寛	あらききよひろ	公明党	比例	参-427号室	電話03-3508-8427	FAX03-3508-8427
有村治子	ありむらはるこ	自民党	比例	参-229号室	電話03-3508-8229	FAX03-5512-2229
家西悟	いえにしさとる	民主党	比例	参-715号室	電話03-3508-8715	FAX03-3508-9150
池口修次	いけぐちしゅうじ	民主党	比例	参-732号室	電話03-3508-8732	FAX03-5512-2732
石井準一	いしいじゅんいち	自民党	千葉	参-606号室	電話03-3508-8606	FAX03-5512-2606
石井一	いしいはじめ	民主党	比例	参-242号室	電話03-3508-8242	FAX03-5512-2242
石井みどり	いしいみどり	自民党	比例	参-206号室	電話03-3508-8206	FAX03-5512-2206
泉信也	いずみしんや	自民党	比例	参-220号室	電話03-3508-8220	FAX03-3503-5589
礒崎陽輔	いそざきようすけ	自民党	大分	参-610号室	電話03-3508-8610	FAX03-5512-2610
市川一朗	いちかわいちろう	自民党	宮城	参-308号室	電話03-3508-8308	FAX03-5512-2610
一川保夫	いちかわやすお	民主党	石川	参-438号室	電話03-3508-8438	FAX03-3508-8438
市田忠義	いちだただよし	共産党	比例	参-617号室	電話03-3508-8617	FAX03-3508-8617
糸数慶子	いとかずけいこ	無所属	沖縄	参-609号室	電話03-3508-8609	FAX03-098-862-3638
犬塚直史	いぬづかただし	民主党	長崎	参-318号室	電話03-3508-8318	FAX03-5512-2318
井上哲士	いのうえさとし	共産党	比例	参-710号室	電話03-3508-8710	FAX03-5512-2710
岩城光英	いわきみつひで	自民党	福島	参-321号室	電話03-3508-8321	FAX03-3593-2030
岩永浩美	いわながひろみ	自民党	佐賀	参-401号室	電話03-3508-8401	FAX03-3503-9399
岩本司	いわもとつかさ	民主党	福岡	参-231号室	電話03-3508-8231	FAX03-5512-2231
植松恵美子	うえまつえみこ	民主党	香川	参-441号室	電話03-3508-8441	FAX03-5512-2441
魚住裕一郎	うおずみゆういちろう	公明党	比例	参-625号室	電話03-3508-8625	FAX03-5512-2625
浮島智子	うきしまともこ	公明党	比例	参-627号室	電話03-3508-8627	FAX03-5512-2627
梅村聡	うめむらさとし	民主党	大阪	参-435号室	電話03-3508-8435	FAX03-3508-8435
江田五月	えださつき	民主党	岡山	参-608号室	電話03-3508-8608	FAX03-5512-2608
衛藤晟一	えとうせいいち	自民党	比例	参-233号室	電話03-3508-8233	FAX03-5512-2233
大石尚子	おおいしひさこ	民主党	比例	参-431号室	電話03-3508-8431	FAX03-3581-7610
大石正光	おおいしまさみつ	民主党	比例	参-342号室	電話03-3508-8342	FAX03-5512-2342
大江康弘	おおえやすひろ	改革クラブ	比例	参-511号室	電話03-3508-8511	FAX03-5512-2511
大河原雅子	おおかわらまさこ	民主党	東京	参-309号室	電話03-3508-8309	FAX03-5512-2309
大久保勉	おおくぼつとむ	民主党	福岡	参-432号室	電話03-3508-8432	FAX03-5512-2432
大久保潔重	おおくぼゆきしげ	民主党	長崎	参-514号室	電話03-3508-8514	FAX03-5512-2514
大島九州男	おおしまくすお	民主党	比例	参-320号室	電話03-3508-8320	FAX03-5512-2320
大塚耕平	おおつかこうへい	民主党	愛知	参-705号室	電話03-3508-8705	FAX03-5512-2705
岡崎トミ子	おかざきとみこ	民主党	宮城	参-314号室	電話03-3508-8314	FAX03-5512-2314
岡田直樹	おかだなおき	自民党	石川	参-225号室	電話03-3508-8225	FAX03-5512-2225
岡田広	おかだひろし	自民党	茨城	参-410号室	電話03-3508-8410	FAX03-5512-2410
小川勝也	おがわかつや	民主党	北海道	参-226号室	電話03-3508-8226	FAX03-5512-2226
小川敏夫	おがわとしお	民主党	東京	参-628号室	電話03-3508-8628	FAX03-3593-0577
荻原健司	おぎわらけんじ	自民党	比例	参-629号室	電話03-3508-8629	FAX03-5512-2629
尾立源幸	おだちもとゆき	民主党	大阪	参-430号室	電話03-3508-8430	FAX03-5512-2430
尾辻秀久	おつじひでひさ	自民党	比例	参-530号室	電話03-3508-8530	FAX03-3595-1127
加賀谷健	かがやけん	民主党	千葉	参-539号室	電話03-3508-8539	FAX03-3581-6922
風間直樹	かざまなおき	民主党	比例	参-521号室	電話03-3508-8521	FAX03-5512-2521
風間昶	かざまひさし	公明党	比例	参-240号室	電話03-3508-8240	FAX03-5512-2240
加治屋義人	かじやよしと	自民党	鹿児島	参-623号室	電話03-3508-8623	FAX03-5512-2623
加藤修一	かとうしゅういち	公明党	比例	参-515号室	電話03-3508-8515	FAX03-5512-2515
加藤敏幸	かとうとしゆき	民主党	比例	参-223号室	電話03-3508-8223	FAX03-5512-2223
金子恵美	かねこえみ	民主党	福島	参-509号室	電話03-3508-8509	FAX03-5512-2509
金子洋一	かねこよういち	民主党	神奈川	参-523号室	電話03-3508-8523	FAX03-5512-2523
加納時男	かのうときお	自民党	比例	参-737号室	電話03-3508-8737	FAX03-5512-2737
紙智子	かみともこ	共産党	比例	参-303号室	電話03-3508-8303	FAX03-5512-2303
神本美恵子	かみもとみえこ	民主党	比例	参-421号室	電話03-3508-8421	FAX03-3508-0010
亀井亜紀子	かめいあきこ	国民新党	島根	参-417号室	電話03-3508-8417	FAX03-5512-2417
亀井郁夫	かめいいくお	国民新党	広島	参-634号室	電話03-3508-8634	FAX03-5512-2634
川合孝典	かわいたかのり	民主党	比例	参-330号室	電話03-3508-8330	FAX03-5512-2330
河合常則	かわいつねのり	自民党	富山	参-213号室	電話03-3508-8213	FAX03-5512-2213
川上義博	かわかみよしひろ	民主党	鳥取	参-701号室	電話03-3508-8701	FAX03-5512-2701
川口順子	かわぐちよりこ	自民党	比例	参-418号室	電話03-3508-8418	FAX03-5512-2418
川崎稔	かわさきみのる	民主党	佐賀	参-624号室	電話03-3508-8624	FAX03-5512-2624
川田龍平	かわだりゅうへい	無所属	東京	参-202号室	電話03-3508-8202	FAX03-5512-2202
神取忍	かんどりしのぶ	自民党	比例	参-717号室	電話03-3508-8717	FAX03-5512-2717
岸宏一	きしこういち	自民党	山形	参-227号室	電話03-3508-8227	FAX03-3502-8827
岸信夫	きしのぶお	自民党	山口	参-207号室	電話03-3508-8207	FAX03-5512-2207
北川イッセイ	きたがわいっせい	自民党	大阪	参-529号室	電話03-3508-8529	FAX03-5512-2529
北澤俊美	きたざわとしみ	民主党	長野	参-510号室	電話03-3508-8510	FAX03-3503-3889
喜納昌吉	きなしょうきち	民主党	比例	参-407号室	電話03-3508-8407	FAX03-5512-2407
木俣佳丈	きまたよしたけ	民主党	愛知	参-317号室	電話03-3508-8317	FAX03-5512-2317
木村仁	きむらひとし	自民党	熊本	参-620号室	電話03-3508-8620	FAX03-5512-2620
草川昭三	くさかわしょうぞう	公明党	比例	参-203号室	電話03-3508-8203	FAX03-5512-5400
工藤堅太郎	くどうけんたろう	民主党	比例	参-405号室	電話03-3508-8405	FAX03-5512-2405
郡司彰	ぐんじあきら	民主党	茨城	参-626号室	電話03-3508-8626	FAX03-5512-2626
小池晃	こいけあきら	共産党	比例	参-725号室	電話03-3508-8725	FAX03-3508-8725
小池正勝	こいけまさかつ	自民党	徳島	参-516号室	電話03-3508-8516	FAX03-5512-2516
小泉昭男	こいずみあきお	自民党	神奈川	参-426号室	電話03-3508-8426	FAX03-5512-2426
行田邦子	こうだくにこ	民主党	埼玉	参-618号室	電話03-3508-8618	FAX03-5512-2618
鴻池祥肇	こうのいけよしただ	自民党	兵庫	参-741号室	電話03-3508-8741	FAX03-3502-7009
輿石東	こしいしあずま	民主党	山梨	参-215号室	電話03-3508-8215	FAX03-3593-6710
木庭健太郎	こばけんたろう	公明党	比例	参-723号室	電話03-3508-8723	FAX03-5512-2723
小林正夫	こばやしまさお	民主党	比例	参-204号室	電話03-3508-8204	FAX03-5512-2204
近藤正道	こんどうまさみち	社民党	新潟	参-740号室	電話03-3508-8704	FAX03-5512-2740
今野東	こんのあずま	民主党	比例	参-708号室	電話03-3508-8708	FAX03-5512-2708
坂本由紀子	さかもとゆきこ	自民党	静岡	参-523号室	電話03-3508-8523	FAX03-5512-2523
櫻井充	さくらいみつる	民主党	宮城	参-324号室	電話03-3508-8324	FAX03-5512-2324
佐藤昭郎	さとうあきお	自民党	比例	参-316号室	電話03-3508-8316	FAX03-5512-2316
佐藤公治	さとうこうじ	民主党	広島	参-305号室	電話03-3508-8305	FAX03-5512-2305
佐藤泰介	さとうたいすけ	民主党	愛知	参-411号室	電話03-3508-8411	FAX03-5512-2411
佐藤信秋	さとうのぶあき	自民党	比例	参-503号室	電話03-3508-8503	FAX03-3262-1900
佐藤正久	さとうまさひさ	自民党	比例	参-507号室	電話03-3508-8507	FAX03-5512-2507
澤雄二	さわゆうじ	公明党	東京	参-730号室	電話03-3508-8730	FAX03-
山東昭子	さんとうあきこ	自民党	比例	参-224号室	電話03-3508-8224	FAX03-5512-2224
椎名一保	しいなかずやす	自民党	千葉	参-513号室	電話03-3508-8513	FAX03-3508-8160
芝博一	しばひろかず	民主党	三重	参-230号室	電話03-3508-8230	FAX03-5512-2230
島尻安伊子	しまじりあいこ	自民党	沖縄	参-336号室	電話03-3508-8336	FAX03-5512-2336
島田智哉子	しまだちやこ	民主党	埼玉	参-718号室	電話03-3508-8718	FAX03-5512-2718
自見庄三郎	じみしょうざぶろう	国民新党	比例	参-236号室	電話03-3508-8236	FAX03-
下田敦子	しもだあつこ	民主党	比例	参-532号室	電話03-3508-8532	FAX03-5512-2532
主濱了	しゅはまりょう	民主党	岩手	参-209号室	電話03-3508-8209	FAX03-5512-2209
白浜一良	しらはまかずよし	公明党	大阪	参-704号室	電話03-3508-8704	FAX03-5512-2704
榛葉賀津也	しんばかづや	民主党	静岡	参-742号室	電話03-3508-8742	FAX03-5512-2790
末松信介	すえまつしんすけ	自民党	兵庫	参-616号室	電話03-3508-8616	FAX03-5512-2616
鈴木寛	すずきかん	民主党	東京	参-635号室	電話03-3508-8635	FAX03-5512-2635
鈴木政二	すずきせいじ	自民党	愛知	参-234号室	電話03-3508-8234	FAX03-5512-2234
鈴木陽悦	すずきようえつ	無所属	秋田	参-612号室	電話03-3508-8612	FAX03-5512-2612
関口昌一	せきぐちまさかず	自民党	埼玉	参-211号室	電話03-3508-8211	FAX03-5512-2211
世耕弘成	せこうひろしげ	自民党	和歌山	参-409号室	電話03-3508-8409	FAX03-3519-4788
大門実紀史	だいもんみきし	共産党	比例	参-414号室	電話03-3508-8414	FAX03-3508-8414
高嶋良充	たかしまよしみつ	民主党	比例	参-428号室	電話03-3508-8428	FAX03-5512-2428
高橋千秋	たかはしちあき	民主党	三重	参-540号室	電話03-3508-8540	FAX03-5512-2540
武内則男	たけうちのりお	民主党	高知	参-434号室	電話03-3508-8434	FAX03-5512-2434
伊達忠一	だてちゅういち	自民党	北海道	参-413号室	電話03-3508-8413	FAX03-5512-2413
田中直紀	たなかなおき	自民党	新潟	参-322号室	電話03-3508-8322	FAX03-5512-2322
田名部匡省	たなぶまさみ	民主党	青森	参-504号室	電話03-3508-8504	FAX03-3593-0341
谷博之	たにひろゆき	民主党	栃木	参-331号室	電話03-3508-8331	FAX03-5512-2331
谷合正明	たにあいまさあき	公明党	比例	参-208号室	電話03-3508-8208	FAX03-5512-2208
谷岡郁子	たにおかくにこ	民主党	愛知	参-406号室	電話03-3508-8406	FAX03-5512-2406
谷川秀善	たにがわしゅうぜん	自民党	大阪	参-440号室	電話03-3508-8440	FAX03-5512-2440
田村耕太郎	たむらこうたろう	自民党	鳥取	参-335号室	電話03-3508-8335	FAX03-3580-6500
千葉景子	ちばけいこ	民主党	神奈川	参-412号室	電話03-3508-8412	FAX03-5512-2412
塚田一郎	つかだいちろう	自民党	新潟	参-727号室	電話03-3508-8727	FAX03-5512-2727
辻泰弘	つじやすひろ	民主党	兵庫	参-402号室	電話03-3508-8402	FAX03-5512-2402
津田弥太郎	つだやたろう	民主党	比例	参-505号室	電話03-3508-8505	FAX03-3508-9160
土田博和	つちだひろかず	民主党	静岡	参-■号室	電話03-3■	FAX03-■
ツルネンマルテイ	つるねんまるてい	民主党	比例	参-235号室	電話03-3508-8235	FAX03-5512-2235
鶴保庸介	つるほようすけ	自民党	和歌山	参-313号室	電話03-3508-8313	FAX03-5512-2313
遠山清彦	とおやまきよひこ	公明党	比例	参-203号室	電話03-3508-8203	FAX03-5512-2203
徳永久志	とくながひさし	民主党	滋賀	参-619号室	電話03-3508-8619	FAX03-5512-2619
轟木利治	とどろきとしはる	民主党	比例	参-518号室	電話03-3508-8518	FAX03-5512-2518
富岡由紀夫	とみおかゆきお	民主党	群馬	参-615号室	電話03-3508-8615	FAX03-5512-2615
友近聡朗	ともちかとしろう	民主党	愛媛	参-706号室	電話03-3508-8706	FAX03-5512-2706
外山斎	とやまいつき	無所属	宮崎	参-638号室	電話03-3508-8638	FAX03-5512-2638
内藤正光	ないとうまさみつ	民主党	比例	参-424号室	電話03-3508-8424	FAX03-5512-2424
直嶋正行	なおしままさゆき	民主党	比例	参-736号室	電話03-3508-8736	FAX03-3503-2669
中川雅治	なかがわまさはる	自民党	東京	参-709号室	電話03-3508-8709	FAX03-5512-2709
中川義雄	なかがわよしお	自民党	北海道	参-420号室	電話03-3508-8420	FAX03-3593-2010
中曽根弘文	なかそねひろふみ	自民党	群馬	参-630号室	電話03-3508-8630	FAX03-3592-2424
中谷智司	なかたにともじ	民主党	徳島	参-315号室	電話03-3508-8315	FAX03-5512-2315
長浜博行	ながはまひろゆき	民主党	千葉	参-642号室	電話03-3508-8642	FAX03-5512-2642
中村哲治	なかむらてつじ	民主党	奈良	参-201号室	電話03-3508-8201	FAX03-5512-2201
中村博彦	なかむらひろひこ	自民党	比例	参-408号室	電話03-3508-8408	FAX03-5512-2408
中山恭子	なかやまきょうこ	自民党	比例	参-519号室	電話03-3508-8519	FAX03-03-5412-2460
那谷屋正義	なたにやまさよし	民主党	比例	参-216号室	電話03-3508-8216	FAX03-5512-2216
西岡武夫	にしおかたけお	民主党	比例	参-542号室	電話03-3508-8542	FAX03-5512-2542
西島英利	にしじまひでとし	自民党	比例	参-726号室	電話03-3508-8726	FAX03-3508-5726
西田昌司	にしだしょうじ	自民党	京都	参-512号室	電話03-3508-8512	FAX03-3502-8897
西田実仁	にしだまこと	公明党	埼玉	参-535号室	電話03-3508-8535	FAX03-5512-2535
二之湯智	にのゆさとし	自民党	京都	参-632号室	電話03-3508-8632	FAX03-5512-2632
仁比聡平	にひそうへい	共産党	比例	参-333号室	電話03-3508-8333	FAX03-5512-2333
南野知恵子	のおのちえこ	自民党	比例	参-341号室	電話03-3508-8341	FAX03-3503-6887
野村哲郎	のむらてつろう	自民党	鹿児島	参-429号室	電話03-3508-8429	FAX03-5512-2429
白真勲	はくしんくん	民主党	比例	参-329号室	電話03-3508-8329	FAX03-5512-2329
橋本聖子	はしもとせいこ	自民党	比例	参-302号室	電話03-3508-8302	FAX03-5512-2302
長谷川憲正	はせがわけんせい	国民新党	比例	参-640号室	電話03-3508-8640	FAX03-5512-2640
長谷川大紋	はせがわたもん	自民党	茨城	参-719号室	電話03-3508-8719	FAX03-5512-2719
羽田雄一郎	はたゆういちろう	民主党	長野	参-525号室	電話03-3508-8525	FAX03-3507-0066
浜田昌良	はまだまさよし	公明党	比例	参-731号室	電話03-3508-8731	FAX03-5512-2731
浜四津敏子	はまよつとしこ	公明党	比例	参-306号室	電話03-3508-8306	FAX03-3593-0134
林久美子	はやしくみこ	民主党	滋賀	参-639号室	電話03-3508-8639	FAX03-5512-2639
林芳正	はやしよしまさ	自民党	山口	参-735号室	電話03-3508-8735	FAX03-3508-2375
姫井由美子	ひめいゆみこ	民主党	岡山	参-528号室	電話03-3508-8528	FAX03-5512-2528
平田健二	ひらたけんじ	民主党	岐阜	参-332号室	電話03-3508-8332	FAX03-5512-2332
平野達男	ひらのたつお	民主党	岩手	参-237号室	電話03-3508-8237	FAX03-5512-2237
平山幸司	ひらやまこうじ	民主党	青森	参-436号室	電話03-3508-8436	FAX03-5512-2436
平山誠	ひらやままこと	新党日本	比例	参-3508-8416号室	電話03-3508-8416	FAX03-■
広田一	ひろたはじめ	無所属	高知	参-520号室	電話03-3508-8520	FAX03-5512-2520
弘友和夫	ひろともかずお	公明党	比例	参-442号室	電話03-3508-8442	FAX03-5512-2442
広中和歌子	ひろなかわかこ	民主党	千葉	参-403号室	電話03-3508-8403	FAX03-3502-8817
広野允士	ひろのただし	民主党	比例	参-711号室	電話03-3508-8711	FAX03-5512-2711
福島瑞穂	ふくしまみずほ	社民党	比例	参-506号室	電話03-3508-8506	FAX03-3500-4640
福山哲郎	ふくやまてつろう	民主党	京都	参-614号室	電話03-3508-8614	FAX03-5512-2614
藤井孝男	ふじいたかお	自民党	岐阜	参-212号室	電話03-3508-8212	FAX03-03-5211-5627
藤末健三	ふじすえけんぞう	民主党	比例	参-637号室	電話03-3508-8637	FAX03-5512-2637
藤田幸久	ふじたゆきひさ	民主党	茨城	参-205号室	電話03-3508-8205	FAX03-5512-2205
藤谷光信	ふじたにこうしん	民主党	比例	参-716号室	電話03-3508-8716	FAX03-5512-2716
藤本祐司	ふじもとゆうじ	民主党	静岡	参-508号室	電話03-3508-8508	FAX03-5512-2508
藤原正司	ふじわらまさし	民主党	比例	参-238号室	電話03-3508-8238	FAX03-5512-2238
藤原良信	ふじわらよしのぶ	民主党	比例	参-713号室	電話03-3508-8713	FAX03-5512-2222
渕上貞雄	ふちがみさだお	社民党	比例	参-337号室	電話03-3508-8337	FAX03-3503-8889
舟山康江	ふなやまやすえ	民主党	山形	参-526号室	電話03-3508-8526	FAX03-5512-2526
古川俊治	ふるかわとしはる	自民党	埼玉	参-531号室	電話03-3508-8531	FAX03-5512-2531
前川清成	まえかわきよしげ	民主党	奈良	参-712号室	電話03-3508-8712	FAX03-5512-2712
前田武志	まえだたけし	民主党	比例	参-228号室	電話03-3508-8228	FAX03-5512-2228
牧野京夫	まきのたかお	自民党	静岡	参-415号室	電話03-3508-8415	FAX03-5512-2415
牧山弘恵	まきやまひろえ	民主党	神奈川	参-217号室	電話03-3508-8217	FAX03-5512-2217
増子輝彦	ましこてるひこ	民主党	福島	参-702号室	電話03-3508-8702	FAX03-5512-2702
舛添要一	ますぞえよういち	自民党	比例	参-219号室	電話03-3508-8219	FAX03-5512-2219
又市征治	またいちせいじ	社民党	比例	参-537号室	電話03-3508-8537	FAX03-5512-2537
松あきら	まつあきら	公明党	神奈川	参-312号室	電話03-3508-8312	FAX03-5512-2312
松井孝治	まついこうじ	民主党	京都	参-613号室	電話03-3508-8613	FAX03-5512-2613
松浦大悟	まつうらだいご	民主党	秋田	参-517号室	電話03-3508-8517	FAX03-5512-2517
松岡徹	まつおかとおる	民主党	比例	参-734号室	電話03-3508-8734	FAX03-5512-2734
松下新平	まつしたしんぺい	改革クラブ	宮崎	参-433号室	電話03-3508-8433	FAX03-5512-2433
松田岩夫	まつだいわお	自民党	岐阜	参-605号室	電話03-3508-8605	FAX03-3508-0588
松野信夫	まつののぶお	民主党	熊本	参-721号室	電話03-3508-8721	FAX03-5512-2721
松村祥史	まつむらよしふみ	自民党	比例	参-728号室	電話03-3508-8728	FAX03-5512-2728
松村龍二	まつむらりゅうじ	自民党	福井	参-304号室	電話03-3508-8304	FAX03-5512-2304
松山政司	まつやままさじ	自民党	福岡	参-739号室	電話03-3508-8739	FAX03-5512-2739
円より子	まどかよりこ	民主党	比例	参-738号室	電話03-3508-8738	FAX03-5512-2738
丸川珠代	まるかわたまよ	自民党	東京	参-328号室	電話03-3508-8328	FAX03-03-3572-0405
丸山和也	まるやまかずや	自民党	比例	参-536号室	電話03-3508-8536	FAX03-03-5561-0915
水岡俊一	みずおかしゅんいち	民主党	兵庫	参-502号室	電話03-3508-8502	FAX03-3591-0510
水落敏栄	みずおちとしえい	自民党	比例	参-631号室	電話03-3508-8631	FAX03-
溝手顕正	みぞてけんせい	自民党	広島	参-533号室	電話03-3508-8533	FAX03-3593-3539
水戸将史	みとまさし	民主党	神奈川	参-607号室	電話03-3508-8607	FAX03-5512-2607
峰崎直樹	みねざきなおき	民主党	北海道	参-703号室	電話03-3508-8703	FAX03-3503-3870
室井邦彦	むろいくにひこ	民主党	比例	参-222号室	電話03-3508-8222	FAX03-5512-2222
森雅子	もりまさこ	自民党	福島	参-404号室	電話03-3508-8404	FAX03-5512-2404
森裕子	もりゆうこ	民主党	新潟	参-524号室	電話03-3508-8524	FAX03-5512-2524
森田高	もりたたかし	国民新党	富山	参-326号室	電話03-3508-8326	FAX03-5512-2326
柳澤光美	やなぎさわみつよし	民主党	比例	参-327号室	電話03-3508-8327	FAX03-5512-2327
柳田稔	やなぎだみのる	民主党	広島	参-232号室	電話03-3508-8232	FAX03-5512-2232
簗瀬進	やなせすすむ	民主党	栃木	参-334号室	電話03-3508-8334	FAX03-3593-8567
矢野哲朗	やのてつろう	自民党	栃木	参-729号室	電話03-3508-8729	FAX03-3503-3802
山内徳信	やまうちとくしん	社民党	比例	参-239号室	電話03-3508-8239	FAX03-098-896-1819
山内俊夫	やまうちとしお	自民党	香川	参-338号室	電話03-3508-8338	FAX03-5512-2338
山口那津男	やまぐちなつお	公明党	東京	参-310号室	電話03-3508-8310	FAX03-5512-2310
山崎正昭	やまざきまさあき	自民党	福井	参-419号室	電話03-3508-8419	FAX03-3508-9419
山下栄一	やましたえいいち	公明党	大阪	参-622号室	電話03-3508-8622	FAX03-5512-2622
山下八洲夫	やましたやすお	民主党	岐阜	参-218号室	電話03-3508-8218	FAX03-5512-2218
山下芳生	やましたよしき	共産党	比例	参-522号室	電話03-3508-8522	FAX03-5512-2522
山田俊男	やまだとしお	自民党	比例	参-323号室	電話03-3508-8323	FAX03-5512-2323
山谷えり子	やまたにえりこ	自民党	比例	参-611号室	電話03-3508-8611	FAX03-5512-2611
山根隆治	やまねりゅうじ	民主党	埼玉	参-707号室	電話03-3508-8707	FAX03-5512-2707
山本一太	やまもといちた	自民党	群馬	参-604号室	電話03-3508-8604	FAX03-3508-2281
山本香苗	やまもとかなえ	公明党	比例	参-319号室	電話03-3508-8319	FAX03-5512-2319
山本順三	やまもとじゅんぞう	自民党	愛媛	参-714号室	電話03-3508-8714	FAX03-5512-2714
山本博司	やまもとひろし	公明党	比例	参-439号室	電話03-3508-8439	FAX03-
横峯良郎	よこみねよしろう	民主党	比例	参-210号室	電話03-3508-8210	FAX03-5512-2210
義家弘介	よしいえひろゆき	自民党	比例	参-325号室	電話03-3508-8325	FAX03-5512-2325
吉川沙織	よしかわさおり	民主党	比例	参-340号室	電話03-3508-8340	FAX03-5512-2340
吉田博美	よしだひろみ	自民党	長野	参-603号室	電話03-3508-8603	FAX03-5512-2603
吉村剛太郎	よしむらごうたろう	自民党	福岡	参-527号室	電話03-3508-8527	FAX03-5512-2527
米長晴信	よねながはるのぶ	民主党	山梨	参-437号室	電話03-3508-8437	FAX03-5512-2437
蓮舫	れんほう	民主党	東京	参-214号室	電話03-3508-8214	FAX03-5512-2214
若林正俊	わかばやしまさとし	自民党	長野	参-633号室	電話03-3508-8633	FAX03-5512-2633
脇雅史	わきまさし	自民党	比例	参-501号室	電話03-3508-8501	FAX03-3580-2701
渡辺孝男	わたなべたかお	公明党	比例	参-733号室	電話03-3508-8733	FAX03-5512-2733
渡辺秀央	わたなべひでお	改革クラブ	比例	参-722号室	電話03-3508-8722	FAX03-3593-0671
鰐淵洋子	わにぶちようこ	公明党	比例	参-307号室	電話03-3508-8307	FAX03-5512-2307
__DATA__

print $out_index encode_utf8($data);

system("LC_ALL=C sort $index_path > $index_path.sort");
system("mv $index_path.sort $index_path");

close ($out_index);
{
    my $is_there_file = 0;
    my $file_path = $index_path;
    my $file_name = "sample data file";
    if( -f $file_path ) { $is_there_file = 1; }
    is($is_there_file, 1, "write $file_name to /tmp");
    my $file_size = -s $file_path;
    isnt($file_size, 0, "$file_name has data entity");
}

system("apporo_indexer -i $index_path -bt");
{
    my $is_there_file = 0;
    my $file_path = $index_path.".ary";
    my $file_name = "apporo UTF-8 ary index for first colmun of sample data file";
    if( -f $file_path ) { $is_there_file = 1; }
    is($is_there_file, 1, "write $file_name to /tmp");
    my $file_size = -s $file_path;
    isnt($file_size, 0, "$file_name has data entity");
}

system("apporo_indexer -i $index_path -d");
{
    my $is_there_file = 0;
    my $file_path = $index_path.".did";
    my $file_name = "apporo UTF-8 did index for sample data file";
    if( -f $file_path ) { $is_there_file = 1; }
    is($is_there_file, 1, "write $file_name to /tmp");
    my $file_size = -s $file_path;
    isnt($file_size, 0, "$file_name has data entity");
}

my $conf_path = "/tmp/p5_apporo_conf_05.tsv";
my $out_conf;
open ($out_conf, "> $conf_path");

my $conf = << "__CONF__";
ngram_length	2
is_pre	true
is_suf	true
is_utf8	true
dist_threshold	0.0
index_path	/tmp/p5_apporo_index_05.tsv
dist_func	edit
entry_buf_len	1024
engine	tsubomi
result_num	10
bucket_size	2000
is_surface	true
is_kana	false
is_roman	false
is_mecab	false
is_juman	false
is_kytea	false
__CONF__

print $out_conf $conf;

close ($out_conf);

{
    my $is_there_file = 0;
    my $file_path = $conf_path;
    my $file_name = "configure file(UTF-8, 2-gram, insert dummy character to head and tail of query e.t.c.) of apporo search";
    if( -f $file_path ) { $is_there_file = 1; }
    is($is_there_file, 1, "write $file_name to /tmp");
    my $file_size = -s $file_path;
    isnt($file_size, 0, "$file_name has data entity");
}

my $app = Apporo->new($conf_path);

{
    my $query = "佐藤";
    my @arr = @{$app->retrieve($query)};
    my @res = (
        "0.666667	佐藤勉	さとうつとむ	自民党	北関東比例	衆2-408号室	電話03-3508-7408	FAX03-3597-2740",
        "0.5	佐藤公治	さとうこうじ	民主党	広島	参-305号室	電話03-3508-8305	FAX03-5512-2305",
        "0.5	佐藤夕子	さとうゆうこ	民主党	愛知01区	衆1-537号室	電話03-3508-7902	FAX03-3508-3537",
        "0.5	佐藤昭郎	さとうあきお	自民党	比例	参-316号室	電話03-3508-8316	FAX03-5512-2316",
        "0.5	佐藤信秋	さとうのぶあき	自民党	比例	参-503号室	電話03-3508-8503	FAX03-3262-1900",
        "0.5	佐藤茂樹	さとうしげき	公明党	近畿比例	衆1-510号室	電話03-3508-7200	FAX03-3508-3510",
        "0.5	佐藤正久	さとうまさひさ	自民党	比例	参-507号室	電話03-3508-8507	FAX03-5512-2507",
        "0.5	佐藤泰介	さとうたいすけ	民主党	愛知	参-411号室	電話03-3508-8411	FAX03-5512-2411",
        "0.2	佐々木憲昭	ささきけんしょう	共産党	東海比例	衆1-730号室	電話03-3508-3730	FAX03-3508-7280",
        "0.2	佐々木隆博	ささきたかひろ	民主党	北海道06区	衆2-325号室	電話03-3508-7075	FAX03-3508-3765",
    );
    my %hash_res = ();
    for (my $i = 0; $i <= $#res; $i++) {
        $res[$i] = encode_utf8($res[$i]);
        my @cels = split /\t/, $res[$i];
        my $key = $cels[0].$cels[1].$cels[6];
        $hash_res{$key} = $res[$i];
    }
    my %hash_arr = ();
    for (my $i = 0; $i <= $#arr; $i++) {
        my @cels = split /\t/, $arr[$i];
        my $key = $cels[0].$cels[1].$cels[6];
        $hash_arr{$key} = $arr[$i];
    }
    is_deeply(\%hash_arr, \%hash_res, "get the result from the indexes whose index points are all charactors of first column using ".encode_utf8($query)." query");
}

{
    my $query = "自民党";
    my @arr = @{$app->retrieve($query)};
    my @res = ();
    my %hash_res = ();
    for (my $i = 0; $i <= $#res; $i++) {
        $res[$i] = encode_utf8($res[$i]);
        my @cels = split /\t/, $res[$i];
        my $key = $cels[0].$cels[1].$cels[6];
        $hash_res{$key} = $res[$i];
    }
    my %hash_arr = ();
    for (my $i = 0; $i <= $#arr; $i++) {
        my @cels = split /\t/, $arr[$i];
        my $key = $cels[0].$cels[1].$cels[6];
        $hash_arr{$key} = $arr[$i];
    }
    is_deeply(\%hash_arr, \%hash_res, encode_utf8($query)." is not included in first colmun of target data");
}
