#!/usr/bin/env perl
use strictures;
use Test::More tests => 4;
use Git::Wrapper::More;

my $test_msg = 'test warning message';

{
    my $label = "Without verbose option";

    # hides warning messages we're going to test
    close(STDERR);
    my $hide_stderr;
    open( STDERR, ">>", \$hide_stderr );

    my $hide_stdout;
    open( my $fh, ">>", \$hide_stdout ) or die "Couldn't open \$hide_stdout: $!";
    select($fh);

    my $gwm = Git::Wrapper::More->new( dir => '/dummy/dir', verbose => 0 );

    $gwm->_print_warn($test_msg);

    # reopen STDOUT as normal
    select(STDOUT);

    like( $hide_stdout, qr/$test_msg/, "$label: test warning message was printed in STDOUT" );
    unlike( $hide_stderr, qr/$test_msg/, "$label: test warning message was NOT printed in STDERR" );

    # cleanup
    close(STDERR);
}

{
    my $label = "With verbose option";

    # hides warning messages we're going to test
    close(STDERR);
    my $hide_stderr;
    open( STDERR, ">>", \$hide_stderr );

    my $hide_stdout;
    open( my $fh, ">>", \$hide_stdout ) or die "Couldn't open \$hide_stdout: $!";
    select($fh);

    my $gwm = Git::Wrapper::More->new( dir => '/dummy/dir', verbose => 1 );

    $gwm->_print_warn($test_msg);

    # reopen STDOUT as normal
    select(STDOUT);

    unlike( $hide_stdout, qr/$test_msg/, "$label: test warning message was NOT printed in STDOUT" );
    like( $hide_stderr, qr/$test_msg/, "$label: test warning message was printed in STDERR" );

    # cleanup
    close(STDERR);
}

done_testing();

__END__
