use strict;
use ExtUtils::MakeMaker;

my $is_devel_host = defined $ENV{USER} && $ENV{USER} eq 'eserte' && $^O =~ /bsd/i && -f "../../perl.release.mk";
my $eumm_recent_enough = $ExtUtils::MakeMaker::VERSION >= 6.54;

if (!$eumm_recent_enough) {
    *MY::dist_core = sub {
	<<'EOF';
dist :
	$(NOECHO) $(ECHO) "Sorry, use a newer EUMM!"

EOF
    };
}

WriteMakefile(
    NAME              => 'App::psort',
    VERSION_FROM      => 'bin/psort',
    PREREQ_PM         => {
	'Sort::Naturally'	=> 0, # but may also work without, sans the -N switch
	'CPAN::Version'		=> 0, # but may also work without, sans the -V switch
    },
    EXE_FILES         => ['bin/psort'],
    LICENSE	      => 'perl',
    ($] >= 5.005 ?
      (ABSTRACT	      => 'a perl-enhanced sort',
       AUTHOR         => 'Slaven Rezic <srezic@cpan.org>') : ()),
    ($eumm_recent_enough ?
      (META_ADD => { resources => { repository => 'git://github.com/eserte/app-psort.git' } }) : ()),
);

sub MY::postamble {
    my $postamble = '';

    if ($is_devel_host) {
	$postamble .= <<'EOF';

.include "../../perl.release.mk"
.include "../../perl.git.mk"

EOF
    }

    $postamble;
}
