/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hsmf.datatypes;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.poi.hsmf.datatypes.Chunk;
import org.apache.poi.hsmf.datatypes.StringChunk;
import org.apache.poi.util.IOUtils;

public class ByteChunk
extends Chunk {
    private byte[] value;

    public ByteChunk(String namePrefix, int chunkId, int type) {
        super(namePrefix, chunkId, type);
    }

    public ByteChunk(int chunkId, int type) {
        super(chunkId, type);
    }

    public void readValue(InputStream value) throws IOException {
        this.value = IOUtils.toByteArray(value);
    }

    public void writeValue(OutputStream out) throws IOException {
        out.write(this.value);
    }

    public byte[] getValue() {
        return this.value;
    }

    public void setValue(byte[] value) {
        this.value = value;
    }

    public String getAs7bitString() {
        return StringChunk.parseAs7BitData(this.value);
    }
}

