/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.batch.builders;

import java.util.Locale;
import java.util.Map;
import org.apache.tika.batch.DigestingAutoDetectParserFactory;
import org.apache.tika.batch.ParserFactory;
import org.apache.tika.batch.builders.IParserFactoryBuilder;
import org.apache.tika.parser.DigestingParser;
import org.apache.tika.parser.utils.BouncyCastleDigester;
import org.apache.tika.parser.utils.CommonsDigester;
import org.apache.tika.util.ClassLoaderUtil;
import org.apache.tika.util.XMLDOMUtil;
import org.w3c.dom.Node;

public class AppParserFactoryBuilder
implements IParserFactoryBuilder {
    @Override
    public ParserFactory build(Node node, Map<String, String> runtimeAttrs) {
        Map<String, String> localAttrs = XMLDOMUtil.mapifyAttrs(node, runtimeAttrs);
        String className = localAttrs.get("class");
        ParserFactory pf = ClassLoaderUtil.buildClass(ParserFactory.class, className);
        if (localAttrs.containsKey("parseRecursively")) {
            String bString = localAttrs.get("parseRecursively").toLowerCase(Locale.ENGLISH);
            if (bString.equals("true")) {
                pf.setParseRecursively(true);
            } else if (bString.equals("false")) {
                pf.setParseRecursively(false);
            } else {
                throw new RuntimeException("parseRecursively must have value of \"true\" or \"false\": " + bString);
            }
        }
        if (pf instanceof DigestingAutoDetectParserFactory) {
            DigestingParser.Digester d = this.buildDigester(localAttrs);
            ((DigestingAutoDetectParserFactory)pf).setDigester(d);
        }
        return pf;
    }

    private DigestingParser.Digester buildDigester(Map<String, String> localAttrs) {
        String readLimitString = localAttrs.get("digestMarkLimit");
        if (readLimitString == null) {
            throw new IllegalArgumentException("Must specify \"digestMarkLimit\" for the DigestingAutoDetectParserFactory");
        }
        int readLimit = -1;
        try {
            readLimit = Integer.parseInt(readLimitString);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Parameter \"digestMarkLimit\" must be a parseable int: " + readLimitString);
        }
        String digestString = localAttrs.get("digest");
        try {
            return new CommonsDigester(readLimit, digestString);
        }
        catch (IllegalArgumentException commonsException) {
            try {
                return new BouncyCastleDigester(readLimit, digestString);
            }
            catch (IllegalArgumentException bcException) {
                throw new IllegalArgumentException("Tried both CommonsDigester (" + commonsException.getMessage() + ") and BouncyCastleDigester (" + bcException.getMessage() + ")", bcException);
            }
        }
    }
}

