/*
 * Decompiled with CFR 0.152.
 */
package org.maltparser.parser.algorithm.nivre;

import org.maltparser.core.exception.MaltChainedException;
import org.maltparser.core.feature.function.Function;
import org.maltparser.parser.AbstractParserFactory;
import org.maltparser.parser.Algorithm;
import org.maltparser.parser.DependencyParserConfig;
import org.maltparser.parser.ParserConfiguration;
import org.maltparser.parser.algorithm.nivre.NivreAddressFunction;
import org.maltparser.parser.algorithm.nivre.NivreConfig;

public abstract class NivreFactory
implements AbstractParserFactory {
    protected Algorithm algorithm;
    protected DependencyParserConfig manager;

    public NivreFactory(Algorithm algorithm) {
        this.setAlgorithm(algorithm);
        this.setManager(algorithm.getManager());
    }

    public ParserConfiguration makeParserConfiguration() throws MaltChainedException {
        if (this.manager.getConfigLogger().isInfoEnabled()) {
            this.manager.getConfigLogger().info("  Parser configuration : Nivre with " + this.manager.getOptionValue("nivre", "root_handling").toString().toUpperCase() + " root handling\n");
        }
        return new NivreConfig(this.manager.getSymbolTables(), this.manager.getOptionValue("nivre", "root_handling").toString());
    }

    public Function makeFunction(String subFunctionName) throws MaltChainedException {
        return new NivreAddressFunction(subFunctionName, this.algorithm);
    }

    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(Algorithm algorithm) {
        this.algorithm = algorithm;
    }

    public DependencyParserConfig getManager() {
        return this.manager;
    }

    public void setManager(DependencyParserConfig manager) {
        this.manager = manager;
    }
}

