#!/usr/bin/perl

package eBay::API::XML::DataType::BusinessSellerDetailsType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. BusinessSellerDetailsType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::BusinessSellerDetailsType

=head1 DESCRIPTION

Displays the seller's information (in a business card format) 
as part of the data returned in the GetItem call if the seller's SellerBusinessCodeType is set to 'Commercial'. Note that this 
option is only available for sites that have Business Seller 
options enabled.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::BusinessSellerDetailsType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::AddressType;
use eBay::API::XML::DataType::VATDetailsType;


my @gaProperties = ( [ 'AdditionalContactInformation', 'xs:string', '', '', '' ]
	, [ 'Address', 'ns:AddressType', ''
	     ,'eBay::API::XML::DataType::AddressType', '1' ]
	, [ 'Email', 'xs:string', '', '', '' ]
	, [ 'Fax', 'xs:string', '', '', '' ]
	, [ 'LegalInvoice', 'xs:boolean', '', '', '' ]
	, [ 'TermsAndConditions', 'xs:string', '', '', '' ]
	, [ 'TradeRegistrationNumber', 'xs:string', '', '', '' ]
	, [ 'VATDetails', 'ns:VATDetailsType', ''
	     ,'eBay::API::XML::DataType::VATDetailsType', '1' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setAdditionalContactInformation()

Displays the AdditionalContactInformation of the seller 
(in a business card format) as part of the data returned 
in the GetItem call if the seller's SellerBusinessCodeType 
is set to 'Commercial'.

#    Argument: 'xs:string'

=cut

sub setAdditionalContactInformation {
  my $self = shift;
  $self->{'AdditionalContactInformation'} = shift
}

=head2 getAdditionalContactInformation()

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

#    Returns: 'xs:string'

=cut

sub getAdditionalContactInformation {
  my $self = shift;
  return $self->{'AdditionalContactInformation'};
}


=head2 setAddress()

Displays the Address of the seller (in a business card 
format) as part of the data returned in the GetItem 
call if the seller's SellerBusinessCodeType is set 
to 'Commercial'.

#    Argument: 'ns:AddressType'

=cut

sub setAddress {
  my $self = shift;
  $self->{'Address'} = shift
}

=head2 getAddress()

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

#    Returns: 'ns:AddressType'

=cut

sub getAddress {
  my $self = shift;
  return $self->_getDataTypeInstance( 'Address'
		,'eBay::API::XML::DataType::AddressType');
}


=head2 setEmail()

Displays the email address of the seller (in a business 
card format) as part of the data returned in the GetItem 
call if the seller's SellerBusinessCodeType is set to 
'Commercial'.

#    Argument: 'xs:string'

=cut

sub setEmail {
  my $self = shift;
  $self->{'Email'} = shift
}

=head2 getEmail()

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

#    Returns: 'xs:string'

=cut

sub getEmail {
  my $self = shift;
  return $self->{'Email'};
}


=head2 setFax()

Displays the fax number of the seller (in a business 
card format) as part of the data returned in the 
GetItem call if the seller's SellerBusinessCodeType 
is set to 'Commercial'.

#    Argument: 'xs:string'

=cut

sub setFax {
  my $self = shift;
  $self->{'Fax'} = shift
}

=head2 getFax()

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

#    Returns: 'xs:string'

=cut

sub getFax {
  my $self = shift;
  return $self->{'Fax'};
}


=head2 setLegalInvoice()

Displays the LegalInvoice of the seller (in a business 
card format) as part of the data returned in the GetItem 
call if the seller's SellerBusinessCodeType is set to 
'Commercial'.

#    Argument: 'xs:boolean'

=cut

sub setLegalInvoice {
  my $self = shift;
  $self->{'LegalInvoice'} = shift
}

=head2 isLegalInvoice()

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isLegalInvoice {
  my $self = shift;
  return $self->{'LegalInvoice'};
}


=head2 setTermsAndConditions()

Displays the TermsAndConditions of the seller (in a business 
card format) as part of the data returned in the GetItem 
call if the seller's SellerBusinessCodeType is set to 
'Commercial'.

#    Argument: 'xs:string'

=cut

sub setTermsAndConditions {
  my $self = shift;
  $self->{'TermsAndConditions'} = shift
}

=head2 getTermsAndConditions()

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

#    Returns: 'xs:string'

=cut

sub getTermsAndConditions {
  my $self = shift;
  return $self->{'TermsAndConditions'};
}


=head2 setTradeRegistrationNumber()

Displays the TradeRegistrationNumber of the seller (in a business 
card format) as part of the data returned in the GetItem call if 
the seller's SellerBusinessCodeType is set to 'Commercial'.

#    Argument: 'xs:string'

=cut

sub setTradeRegistrationNumber {
  my $self = shift;
  $self->{'TradeRegistrationNumber'} = shift
}

=head2 getTradeRegistrationNumber()

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

#    Returns: 'xs:string'

=cut

sub getTradeRegistrationNumber {
  my $self = shift;
  return $self->{'TradeRegistrationNumber'};
}


=head2 setVATDetails()

Displays the VATDetails of the seller (in a business 
card format) as part of the data returned in the 
GetItem call if the seller's SellerBusinessCodeType 
is set to 'Commercial'.

#    Argument: 'ns:VATDetailsType'

=cut

sub setVATDetails {
  my $self = shift;
  $self->{'VATDetails'} = shift
}

=head2 getVATDetails()

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

#    Returns: 'ns:VATDetailsType'

=cut

sub getVATDetails {
  my $self = shift;
  return $self->_getDataTypeInstance( 'VATDetails'
		,'eBay::API::XML::DataType::VATDetailsType');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
