#!/usr/bin/perl

package eBay::API::XML::DataType::Enum::AccountDetailEntryCodeType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. AccountDetailEntryCodeType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::Enum::AccountDetailEntryCodeType

=head1 DESCRIPTION

Specifies values that describe a transaction on an account. Details of
the transaction are returned in AccountEntry. The transaction can
be a debit or credit to the account.



=head1 SYNOPSIS

=cut



=head1 Enums:

=cut


=head2 Unknown

(out) The reason for the charge is unknown.



=cut


use constant Unknown => scalar('Unknown');


=head2 FeeInsertion

(out) The fee for listing an item for sale on eBay.



=cut


use constant FeeInsertion => scalar('FeeInsertion');


=head2 FeeBold

(out) The fee for a listing title in boldface font.



=cut


use constant FeeBold => scalar('FeeBold');


=head2 FeeFeatured

(out) The fee for adding an optional feature to a listing,
such as a reserve fee or a listing upgrade fee.



=cut


use constant FeeFeatured => scalar('FeeFeatured');


=head2 FeeCategoryFeatured

(out)



=cut


use constant FeeCategoryFeatured => scalar('FeeCategoryFeatured');


=head2 FeeFinalValue

(out) The fee charged when a listed item sells. The fee
is a percentage of the final sale price.



=cut


use constant FeeFinalValue => scalar('FeeFinalValue');


=head2 PaymentCheck

(out) A payment by check made by a seller to eBay.



=cut


use constant PaymentCheck => scalar('PaymentCheck');


=head2 PaymentCC

(out) A payment by credit card made by a seller to eBay.



=cut


use constant PaymentCC => scalar('PaymentCC');


=head2 CreditCourtesy

(out)



=cut


use constant CreditCourtesy => scalar('CreditCourtesy');


=head2 CreditNoSale

(out)



=cut


use constant CreditNoSale => scalar('CreditNoSale');


=head2 CreditPartialSale

(out)



=cut


use constant CreditPartialSale => scalar('CreditPartialSale');


=head2 RefundCC

(out) A refund made by eBay to the seller's credit card.



=cut


use constant RefundCC => scalar('RefundCC');


=head2 RefundCheck

(out) A refund made by eBay to the seller by check.



=cut


use constant RefundCheck => scalar('RefundCheck');


=head2 FinanceCharge

(out) A finance charge made to the seller's account, for example,
the monthly finance charge added to an account whose balance has not been
paid.



=cut


use constant FinanceCharge => scalar('FinanceCharge');


=head2 AWDebit

(out)



=cut


use constant AWDebit => scalar('AWDebit');


=head2 AWCredit

(out)



=cut


use constant AWCredit => scalar('AWCredit');


=head2 AWMemo

(out)



=cut


use constant AWMemo => scalar('AWMemo');


=head2 CreditDuplicateListing

(out) A credit made by eBay for a duplicate listing.



=cut


use constant CreditDuplicateListing => scalar('CreditDuplicateListing');


=head2 FeePartialSale

(out) A fee charged by eBay for a partial sale.



=cut


use constant FeePartialSale => scalar('FeePartialSale');


=head2 PaymentElectronicTransferReversal

(out) A reversal of an electronic transfer payment.



=cut


use constant PaymentElectronicTransferReversal => scalar('PaymentElectronicTransferReversal');


=head2 PaymentCCOnce

(out) A one-time payment to the account made by
credit card.



=cut


use constant PaymentCCOnce => scalar('PaymentCCOnce');


=head2 FeeReturnedCheck

(out) A fee charged by eBay for a returned check.



=cut


use constant FeeReturnedCheck => scalar('FeeReturnedCheck');


=head2 FeeRedepositCheck

(out) A fee charged by eBay when a check must be redeposited
to collect funds.



=cut


use constant FeeRedepositCheck => scalar('FeeRedepositCheck');


=head2 PaymentCash

(out) A cash payment made on the seller's account.



=cut


use constant PaymentCash => scalar('PaymentCash');


=head2 CreditInsertion

(out) A credit issued by eBay for an insertion fee.
If a listed item does not sell or results in an
Unpaid Item (UPI) dispute, the seller can relist
the item. If the item sells the second time, eBay
credits the insertion fee.



=cut


use constant CreditInsertion => scalar('CreditInsertion');


=head2 CreditBold

(out) A credit issued by eBay for the Bold listing fee.



=cut


use constant CreditBold => scalar('CreditBold');


=head2 CreditFeatured

(out) A credit issued by eBay for the Featured listing fee.



=cut


use constant CreditFeatured => scalar('CreditFeatured');


=head2 CreditCategoryFeatured

(out)



=cut


use constant CreditCategoryFeatured => scalar('CreditCategoryFeatured');


=head2 CreditFinalValue

(out) A credit issued by eBay for the Final Value Fee.
Issued as a result of an Unpaid Item dispute, under
some circumstances.



=cut


use constant CreditFinalValue => scalar('CreditFinalValue');


=head2 FeeNSFCheck

(out) A fee charged by eBay when the seller's check does not clear
due to insufficient funds.



=cut


use constant FeeNSFCheck => scalar('FeeNSFCheck');


=head2 FeeReturnCheckClose

(out) A fee charged by eBay when the seller's check does not clear
because the account has been closed.



=cut


use constant FeeReturnCheckClose => scalar('FeeReturnCheckClose');


=head2 Memo

(out)



=cut


use constant Memo => scalar('Memo');


=head2 PaymentMoneyOrder

(out) A payment made to the account by money order.



=cut


use constant PaymentMoneyOrder => scalar('PaymentMoneyOrder');


=head2 CreditCardOnFile

(out) An automatic monthly charge of the seller's invoice
amount made by eBay to a credit card the seller has placed
on file.



=cut


use constant CreditCardOnFile => scalar('CreditCardOnFile');


=head2 CreditCardNotOnFile

(out) A one-time payment made by a credit card
that is not on file with eBay for automatic monthly
payments.



=cut


use constant CreditCardNotOnFile => scalar('CreditCardNotOnFile');


=head2 Invoiced

(out)



=cut


use constant Invoiced => scalar('Invoiced');


=head2 InvoicedCreditCard

(out)



=cut


use constant InvoicedCreditCard => scalar('InvoicedCreditCard');


=head2 CreditTransferFrom

(out) A transfer from another account to this account,
resulting in a credit to this account.



=cut


use constant CreditTransferFrom => scalar('CreditTransferFrom');


=head2 DebitTransferTo

(out) A transfer from this account to another account,
resulting in a debit to this account.



=cut


use constant DebitTransferTo => scalar('DebitTransferTo');


=head2 InvoiceCreditBalance

(out) A credit balance for an account's invoice period,
meaning that the seller should not pay.



=cut


use constant InvoiceCreditBalance => scalar('InvoiceCreditBalance');


=head2 eBayDebit

(out) An all-purpose code for debits that are manually applied to auctions,
for example, when the credit cannot be applied to an item number



=cut


use constant eBayDebit => scalar('eBayDebit');


=head2 eBayCredit

(out) An all-purpose code for credits that are manually applied to auctions,
for example, when the credit cannot be applied to an item number



=cut


use constant eBayCredit => scalar('eBayCredit');


=head2 PromotionalCredit

(out)



=cut


use constant PromotionalCredit => scalar('PromotionalCredit');


=head2 CCNotOnFilePerCustReq

(out) A note that the credit card is not
on file at the customer's request.



=cut


use constant CCNotOnFilePerCustReq => scalar('CCNotOnFilePerCustReq');


=head2 CreditInsertionFee

(out) A credit issued by eBay for an insertion
fee when an item is relisted.



=cut


use constant CreditInsertionFee => scalar('CreditInsertionFee');


=head2 CCPaymentRejected

(out)



=cut


use constant CCPaymentRejected => scalar('CCPaymentRejected');


=head2 FeeGiftIcon

(out) A fee charged by eBay for adding a gift icon to
a listing. The gift icon highlights the item as a good
gift and might offer gift services, such as wrapping
or shipping.



=cut


use constant FeeGiftIcon => scalar('FeeGiftIcon');


=head2 CreditGiftIcon

(out) A credit issued by eBay for the gift item
fee.



=cut


use constant CreditGiftIcon => scalar('CreditGiftIcon');


=head2 FeeGallery

(out) A fee charged by eBay for listing an item
in the Picture Gallery. A buyer sees a picture of
the item when browsing a category, before moving to
the item's listing page.



=cut


use constant FeeGallery => scalar('FeeGallery');


=head2 FeeFeaturedGallery

(out) A fee charged by eBay for listing an item
in the Featured section at the top of the Picture Gallery
page.



=cut


use constant FeeFeaturedGallery => scalar('FeeFeaturedGallery');


=head2 CreditGallery

(out) A credit issued by eBay for the Gallery fee
charged when the item was listed.



=cut


use constant CreditGallery => scalar('CreditGallery');


=head2 CreditFeaturedGallery

(out) A credit issued by eBay for the Featured Gallery
fee charged when the item was listed.



=cut


use constant CreditFeaturedGallery => scalar('CreditFeaturedGallery');


=head2 ItemMoveFee

(out)



=cut


use constant ItemMoveFee => scalar('ItemMoveFee');


=head2 OutageCredit

(out) A credit issued by eBay when listings are not available
due to system downtime. The downtime can be a title search
outage or a hard outage. See the online help for details.



=cut


use constant OutageCredit => scalar('OutageCredit');


=head2 CreditPSA

(out)



=cut


use constant CreditPSA => scalar('CreditPSA');


=head2 CreditPCGS

(out)



=cut


use constant CreditPCGS => scalar('CreditPCGS');


=head2 FeeReserve

(out) A fee charged by eBay when an item is listed with
a reserve price. The fee is credited when the auction
completes successfully.



=cut


use constant FeeReserve => scalar('FeeReserve');


=head2 CreditReserve

(out) A credit issued by eBay for a reserve price auction
when the auction completes successfully.



=cut


use constant CreditReserve => scalar('CreditReserve');


=head2 eBayVISACredit

(out)



=cut


use constant eBayVISACredit => scalar('eBayVISACredit');


=head2 BBAdminCredit

(out)



=cut


use constant BBAdminCredit => scalar('BBAdminCredit');


=head2 BBAdminDebit

(out)



=cut


use constant BBAdminDebit => scalar('BBAdminDebit');


=head2 ReferrerCredit

(out) A credit issued by eBay to a Store owner
who has promoted items outside of eBay.



=cut


use constant ReferrerCredit => scalar('ReferrerCredit');


=head2 ReferrerDebit

(out)



=cut


use constant ReferrerDebit => scalar('ReferrerDebit');


=head2 SwitchCurrency

(out) A switch from one billing currency to another.
The billing currency can be USD, EUR, CAD, GBP, AUD,
JPY, or TWD.



=cut


use constant SwitchCurrency => scalar('SwitchCurrency');


=head2 PaymentGiftCertificate

(out) A payment made to the account by gift certificate.



=cut


use constant PaymentGiftCertificate => scalar('PaymentGiftCertificate');


=head2 PaymentWireTransfer

(out) A payment made to the account by wire transfer.



=cut


use constant PaymentWireTransfer => scalar('PaymentWireTransfer');


=head2 PaymentHomeBanking

(out)



=cut


use constant PaymentHomeBanking => scalar('PaymentHomeBanking');


=head2 PaymentElectronicTransfer

(out) A one-time payment made to the account by electronic
transfer.



=cut


use constant PaymentElectronicTransfer => scalar('PaymentElectronicTransfer');


=head2 PaymentAdjustmentCredit

(out) A credit (addition) made by eBay to the seller's account
when a payment needs to be adjusted.



=cut


use constant PaymentAdjustmentCredit => scalar('PaymentAdjustmentCredit');


=head2 PaymentAdjustmentDebit

(out) A debit (deduction) made by eBay to the seller's account
when a payment needs to be adjusted.



=cut


use constant PaymentAdjustmentDebit => scalar('PaymentAdjustmentDebit');


=head2 Chargeoff

(out)



=cut


use constant Chargeoff => scalar('Chargeoff');


=head2 ChargeoffRecovery

(out)



=cut


use constant ChargeoffRecovery => scalar('ChargeoffRecovery');


=head2 ChargeoffBankruptcy

(out) A writeoff of the account charge by eBay
because the seller has declared bankruptcy.



=cut


use constant ChargeoffBankruptcy => scalar('ChargeoffBankruptcy');


=head2 ChargeoffSuspended

(out)



=cut


use constant ChargeoffSuspended => scalar('ChargeoffSuspended');


=head2 ChargeoffDeceased

(out) A writeoff of the account charge by eBay
because the seller is deceased.



=cut


use constant ChargeoffDeceased => scalar('ChargeoffDeceased');


=head2 ChargeoffOther

(out)



=cut


use constant ChargeoffOther => scalar('ChargeoffOther');


=head2 ChargeoffWacko

(out)



=cut


use constant ChargeoffWacko => scalar('ChargeoffWacko');


=head2 FinanceChargeReversal

(out) A reversal of a finance charge, made by eBay.
The finance charge is added if the seller does not pay
the monthly account balance on time.



=cut


use constant FinanceChargeReversal => scalar('FinanceChargeReversal');


=head2 FVFCreditReversal

(out) A reversal of a Final Value Fee credit, resulting
in the fee being charged to the seller. The Final Value
Fee can be credited as a result of an Unpaid Item Dispute.
If the buyer later pays, the seller can request a reversal.



=cut


use constant FVFCreditReversal => scalar('FVFCreditReversal');


=head2 ForeignFundsConvert

(out) A fee charged for currency conversion.



=cut


use constant ForeignFundsConvert => scalar('ForeignFundsConvert');


=head2 ForeignFundsCheckReversal

(out)



=cut


use constant ForeignFundsCheckReversal => scalar('ForeignFundsCheckReversal');


=head2 EOMRestriction

(out)



=cut


use constant EOMRestriction => scalar('EOMRestriction');


=head2 AllFeesCredit

(out)



=cut


use constant AllFeesCredit => scalar('AllFeesCredit');


=head2 SetOnHold

(out)



=cut


use constant SetOnHold => scalar('SetOnHold');


=head2 RevertUserState

(out)



=cut


use constant RevertUserState => scalar('RevertUserState');


=head2 DirectDebitOnFile

(out) A monthly payment made by automatic direct debit to the
seller's checking account, when the account information
is on file.



=cut


use constant DirectDebitOnFile => scalar('DirectDebitOnFile');


=head2 DirectDebitNotOnFile

(out) A one-time payment made by direct debit to the seller's
checking account, when the account information is not on file,
but is provided for this payment.



=cut


use constant DirectDebitNotOnFile => scalar('DirectDebitNotOnFile');


=head2 PaymentDirectDebit

(out) A payment made by direct debit from the seller's
checking account when the seller has requested automatic
monthly invoice payments.



=cut


use constant PaymentDirectDebit => scalar('PaymentDirectDebit');


=head2 DirectDebitReversal

(out) A reversal of a payment made by direct debit
from the seller's checking account.



=cut


use constant DirectDebitReversal => scalar('DirectDebitReversal');


=head2 DirectDebitReturnedItem

(out) A reversal of a payment made by direct debit
from a seller's checking account when an item is returned
by the buyer.



=cut


use constant DirectDebitReturnedItem => scalar('DirectDebitReturnedItem');


=head2 FeeHighlight

(out) A fee charged by eBay for adding a colored band to
emphasize a listing.



=cut


use constant FeeHighlight => scalar('FeeHighlight');


=head2 CreditHighlight

(out) A credit issued by eBay for a highlight fee on an
item's listing.



=cut


use constant CreditHighlight => scalar('CreditHighlight');


=head2 BulkUserSuspension

(out)



=cut


use constant BulkUserSuspension => scalar('BulkUserSuspension');


=head2 FeeRealEstate30DaysListing

(out) A fee charged for a 30-day real estate
listing.



=cut


use constant FeeRealEstate30DaysListing => scalar('FeeRealEstate30DaysListing');


=head2 CreditRealEstate30DaysListing

(out) A credit for a 30-day real estate listing.



=cut


use constant CreditRealEstate30DaysListing => scalar('CreditRealEstate30DaysListing');


=head2 TradingLimitOverrideOn

(out)



=cut


use constant TradingLimitOverrideOn => scalar('TradingLimitOverrideOn');


=head2 TradingLimitOverrideOff

(out)



=cut


use constant TradingLimitOverrideOff => scalar('TradingLimitOverrideOff');


=head2 EquifaxRealtimeFee

(out) A fee charged to sellers who do not provide a credit card
or checking account number to verify identify.



=cut


use constant EquifaxRealtimeFee => scalar('EquifaxRealtimeFee');


=head2 CreditEquifaxRealtimeFee

(out) A credit granted for an EquifaxRealtimeFee.



=cut


use constant CreditEquifaxRealtimeFee => scalar('CreditEquifaxRealtimeFee');


=head2 PaymentEquifaxDebit

(out)



=cut


use constant PaymentEquifaxDebit => scalar('PaymentEquifaxDebit');


=head2 PaymentEquifaxCredit

(out)



=cut


use constant PaymentEquifaxCredit => scalar('PaymentEquifaxCredit');


=head2 Merged

(out) Two accounts with the same owner but different user IDs
have been merged into one.



=cut


use constant Merged => scalar('Merged');


=head2 AutoTraderOn

(out)



=cut


use constant AutoTraderOn => scalar('AutoTraderOn');


=head2 AutoTraderOff

(out)



=cut


use constant AutoTraderOff => scalar('AutoTraderOff');


=head2 PaperInvoiceOn

(out) The option to send the seller paper invoices
has been turned on.



=cut


use constant PaperInvoiceOn => scalar('PaperInvoiceOn');


=head2 PaperInvoiceOff

(out) The option to send the seller paper invoices
has been turned off.



=cut


use constant PaperInvoiceOff => scalar('PaperInvoiceOff');


=head2 AccountStateSwitch

(out)



=cut


use constant AccountStateSwitch => scalar('AccountStateSwitch');


=head2 FVFCreditReversalAutomatic

(out) An automatic reversal of a Final Value Fee
credit.



=cut


use constant FVFCreditReversalAutomatic => scalar('FVFCreditReversalAutomatic');


=head2 CreditSoftOutage

(out) A credit granted by eBay when a title search
outage of one hour or longer occurs on the site.



=cut


use constant CreditSoftOutage => scalar('CreditSoftOutage');


=head2 LACatalogFee

(out) A fee charged for listing a lot (one or more items) in a
Live Auction catalog.



=cut


use constant LACatalogFee => scalar('LACatalogFee');


=head2 LAExtraItem

(out) A fee charged for listing an extra item in a Live Auction.



=cut


use constant LAExtraItem => scalar('LAExtraItem');


=head2 LACatalogItemFeeRefund

(out)



=cut


use constant LACatalogItemFeeRefund => scalar('LACatalogItemFeeRefund');


=head2 LACatalogInsertionRefund

(out) A credit for listing an item in a Live Auction catalog.



=cut


use constant LACatalogInsertionRefund => scalar('LACatalogInsertionRefund');


=head2 LAFinalValueFee

(out) A Final Value Fee charged by eBay when a lot listed
on a Live Auction is sold.



=cut


use constant LAFinalValueFee => scalar('LAFinalValueFee');


=head2 LAFinalValueFeeRefund

(out) A refund of a Final Value Fee that was charged
when a Live Auction lot was sold.



=cut


use constant LAFinalValueFeeRefund => scalar('LAFinalValueFeeRefund');


=head2 LABuyerPremiumPercentageFee

(out) A fee paid by the buyer to the auction house for
a purchase in a Live Auction.



=cut


use constant LABuyerPremiumPercentageFee => scalar('LABuyerPremiumPercentageFee');


=head2 LABuyerPremiumPercentageFeeRefund

(out) A refund of the fee paid by a buyer to the auction
house for a purchase in a Live Auction.



=cut


use constant LABuyerPremiumPercentageFeeRefund => scalar('LABuyerPremiumPercentageFeeRefund');


=head2 LAAudioVideoFee

(out) A fee charged for audio or video services provided
during the sale of lots at a Live Auction.



=cut


use constant LAAudioVideoFee => scalar('LAAudioVideoFee');


=head2 LAAudioVideoFeeRefund

(out) A refund for audio or video services provided at
a Live Auction.



=cut


use constant LAAudioVideoFeeRefund => scalar('LAAudioVideoFeeRefund');


=head2 FeeIPIXPhoto

(out) A fee charged for a panoramic 360-degree photo
in a listing.



=cut


use constant FeeIPIXPhoto => scalar('FeeIPIXPhoto');


=head2 FeeIPIXSlideShow

(out) A fee charged for a slide show of panoramic 360-degree
photos.



=cut


use constant FeeIPIXSlideShow => scalar('FeeIPIXSlideShow');


=head2 CreditIPIXPhoto

(out) A credit granted to reverse an IPIX photo fee.



=cut


use constant CreditIPIXPhoto => scalar('CreditIPIXPhoto');


=head2 CreditIPIXSlideShow

(out) A credit granted to reverse an IPIX slideshow fee.



=cut


use constant CreditIPIXSlideShow => scalar('CreditIPIXSlideShow');


=head2 FeeTenDayAuction

(out) A fee charged for listing an item for 10 days,
rather than one, three, five, or seven days.



=cut


use constant FeeTenDayAuction => scalar('FeeTenDayAuction');


=head2 CreditTenDayAuction

(out) A credit granted to reverse a 10-day auction
fee.



=cut


use constant CreditTenDayAuction => scalar('CreditTenDayAuction');


=head2 TemporaryCredit

(out)



=cut


use constant TemporaryCredit => scalar('TemporaryCredit');


=head2 TemporaryCreditReversal

(out)



=cut


use constant TemporaryCreditReversal => scalar('TemporaryCreditReversal');


=head2 SubscriptionAABasic

(out) A fee charged for a subscription to Auction Assistant Basic.



=cut


use constant SubscriptionAABasic => scalar('SubscriptionAABasic');


=head2 SubscriptionAAPro

(out) A fee charged for a subscription to Auction Assistant Pro.



=cut


use constant SubscriptionAAPro => scalar('SubscriptionAAPro');


=head2 CreditAABasic

(out) A credit granted for a subscription fee charged for Auction Assistant Basic.



=cut


use constant CreditAABasic => scalar('CreditAABasic');


=head2 CreditAAPro

(out) A credit granted for a subscription fee charged for Auction Assistant Pro.



=cut


use constant CreditAAPro => scalar('CreditAAPro');


=head2 FeeLargePicture

(out) A fee charged by eBay for a supersized picture
in a listing.



=cut


use constant FeeLargePicture => scalar('FeeLargePicture');


=head2 CreditLargePicture

(out) A credit issued by eBay for a supersized picture.



=cut


use constant CreditLargePicture => scalar('CreditLargePicture');


=head2 FeePicturePack

(out) A fee charged by eBay for the Picture Pack feature.
The fee differs according to the number of pictures you
use. See the online help for details.



=cut


use constant FeePicturePack => scalar('FeePicturePack');


=head2 CreditPicturePackPartial

(out) A partial credit issued by eBay for the Picture Pack fee.



=cut


use constant CreditPicturePackPartial => scalar('CreditPicturePackPartial');


=head2 CreditPicturePackFull

(out) A full credit issued by eBay for the Picture Pack fee.



=cut


use constant CreditPicturePackFull => scalar('CreditPicturePackFull');


=head2 SubscriptioneBayStores

(out) A monthly subscription fee charged for an eBay Store.
The fee can be Basic, Featured, or Anchor.



=cut


use constant SubscriptioneBayStores => scalar('SubscriptioneBayStores');


=head2 CrediteBayStores

(out) A credit issued by eBay for the monthly fee charged
for an eBay store.



=cut


use constant CrediteBayStores => scalar('CrediteBayStores');


=head2 FeeInsertionFixedPrice

(out) The fee charged by eBay for listing a Fixed Price item.



=cut


use constant FeeInsertionFixedPrice => scalar('FeeInsertionFixedPrice');


=head2 CreditInsertionFixedPrice

(out) A credit issued by eBay for listing a Fixed Price item.



=cut


use constant CreditInsertionFixedPrice => scalar('CreditInsertionFixedPrice');


=head2 FeeFinalValueFixedPrice

(out) The Final Value Fee credit charged by eBay when
a fixed price item sells.



=cut


use constant FeeFinalValueFixedPrice => scalar('FeeFinalValueFixedPrice');


=head2 CreditFinalValueFixedPrice

(out) A credit issued by eBay for the Final Value Fee
for a fixed price item.



=cut


use constant CreditFinalValueFixedPrice => scalar('CreditFinalValueFixedPrice');


=head2 ElectronicInvoiceOn

(out)



=cut


use constant ElectronicInvoiceOn => scalar('ElectronicInvoiceOn');


=head2 ElectronicInvoiceOff

(out)



=cut


use constant ElectronicInvoiceOff => scalar('ElectronicInvoiceOff');


=head2 FlagDDDDPending

(out)



=cut


use constant FlagDDDDPending => scalar('FlagDDDDPending');


=head2 FlagDDPaymentConfirmed

(out)



=cut


use constant FlagDDPaymentConfirmed => scalar('FlagDDPaymentConfirmed');


=head2 FixedPriceDurationFee

(out) The fee charged by eBay for creating a Fixed Price
listing with a 10-day duration. Fixed Price listings
of 1, 3, 5, and 7 days are not charged this fee.



=cut


use constant FixedPriceDurationFee => scalar('FixedPriceDurationFee');


=head2 FixedPriceDurationCredit

(out) A credit issued by eBay for a Fixed Price listing
with a 10-day duration.



=cut


use constant FixedPriceDurationCredit => scalar('FixedPriceDurationCredit');


=head2 BuyItNowFee

(out) A fee charged by eBay for listing a Buy It Now item.



=cut


use constant BuyItNowFee => scalar('BuyItNowFee');


=head2 BuyItNowCredit

(out) A credit issued by eBay for the fee charged for a
Buy It Now listing.



=cut


use constant BuyItNowCredit => scalar('BuyItNowCredit');


=head2 FeeSchedule

(out) A fee for scheduling a listing to start at some
later time, up to 3 weeks after the listing is created.



=cut


use constant FeeSchedule => scalar('FeeSchedule');


=head2 CreditSchedule

(out) A credit made by eBay for the fee charged for
scheduling a listing to start after the listing is created.



=cut


use constant CreditSchedule => scalar('CreditSchedule');


=head2 SubscriptionSMBasic

(out) The monthly subscription fee charged for
Selling Manager Basic. The monthly charge is billed
in advance.



=cut


use constant SubscriptionSMBasic => scalar('SubscriptionSMBasic');


=head2 SubscriptionSMBasicPro

(out) The monthly subscription fee charged for
Selling Manager Pro. The monthly charge is billed
in advance.



=cut


use constant SubscriptionSMBasicPro => scalar('SubscriptionSMBasicPro');


=head2 CreditSMBasic

(out) A one-time credit for a free one-month
trial of Selling Manager Basic.



=cut


use constant CreditSMBasic => scalar('CreditSMBasic');


=head2 CreditSMBasicPro

(out) A one-time credit for a free one-month
trial of Selling Manager Pro.



=cut


use constant CreditSMBasicPro => scalar('CreditSMBasicPro');


=head2 StoresGTCFee

(out) The fee charged for a Good-Til-Cancelled
listing in an eBay Store. The charge is made once
each 30 days, until the listing ends.



=cut


use constant StoresGTCFee => scalar('StoresGTCFee');


=head2 StoresGTCCredit

(out) A credit for the fee charged for a Good-Til-Cancelled
listing in an eBay Store.



=cut


use constant StoresGTCCredit => scalar('StoresGTCCredit');


=head2 ListingDesignerFee

(out) The fee charged for using a Listing Designer theme and layout
template for a listing. The fee is displayed to the seller during
the listing process.



=cut


use constant ListingDesignerFee => scalar('ListingDesignerFee');


=head2 ListingDesignerCredit

(out) A credit issued by eBay for a Listing Designer fee.



=cut


use constant ListingDesignerCredit => scalar('ListingDesignerCredit');


=head2 ExtendedAuctionFee

(out) The fee charged for listing an auction item
for 10 days.



=cut


use constant ExtendedAuctionFee => scalar('ExtendedAuctionFee');


=head2 ExtendedAcutionCredit

(out) A credit for the fee charged for listing an
auction item for 10 days.



=cut


use constant ExtendedAcutionCredit => scalar('ExtendedAcutionCredit');


=head2 PayPalOTPSucc

(out)



=cut


use constant PayPalOTPSucc => scalar('PayPalOTPSucc');


=head2 PayPalOTPPend

(out)



=cut


use constant PayPalOTPPend => scalar('PayPalOTPPend');


=head2 PayPalFailed

(out)



=cut


use constant PayPalFailed => scalar('PayPalFailed');


=head2 PayPalChargeBack

(out)



=cut


use constant PayPalChargeBack => scalar('PayPalChargeBack');


=head2 ChargeBack

(out)



=cut


use constant ChargeBack => scalar('ChargeBack');


=head2 ChargeBackReversal

(out)



=cut


use constant ChargeBackReversal => scalar('ChargeBackReversal');


=head2 PayPalRefund

(out)



=cut


use constant PayPalRefund => scalar('PayPalRefund');


=head2 BonusPointsAddition

(out) An addition to the seller's eBay
Anything Points account. Each point is
equivalent to $0.01.



=cut


use constant BonusPointsAddition => scalar('BonusPointsAddition');


=head2 BonusPointsReduction

(out) A reduction to the seller's eBay
Anything Points account. Each point is
equivalent to $0.01.



=cut


use constant BonusPointsReduction => scalar('BonusPointsReduction');


=head2 BonusPointsPaymentAutomatic

(out) An automatic payment of seller fees
from the seller's eBay Anything Points account.



=cut


use constant BonusPointsPaymentAutomatic => scalar('BonusPointsPaymentAutomatic');


=head2 BonusPointsPaymentManual

(out) A one-time payment of seller fees from
the seller's eBay Anything Points account.



=cut


use constant BonusPointsPaymentManual => scalar('BonusPointsPaymentManual');


=head2 BonusPointsPaymentReversal

(out) A reversal of a seller fee payment made
from the seller's eBay Anything Points account.



=cut


use constant BonusPointsPaymentReversal => scalar('BonusPointsPaymentReversal');


=head2 BonusPointsCashPayout

(out) A cash payment made from the seller's eBay
Anything Points account and credited to the seller's
account.



=cut


use constant BonusPointsCashPayout => scalar('BonusPointsCashPayout');


=head2 VATCredit

(out) A credit (return) to your account of Value-Added Tax
previously paid.



=cut


use constant VATCredit => scalar('VATCredit');


=head2 VATDebit

(out) A debit to your account for a Value-Added Tax charge.



=cut


use constant VATDebit => scalar('VATDebit');


=head2 VATStatusChangePending

(out)



=cut


use constant VATStatusChangePending => scalar('VATStatusChangePending');


=head2 VATStatusChangeApproved

(out)



=cut


use constant VATStatusChangeApproved => scalar('VATStatusChangeApproved');


=head2 VATStatusChange_Denied

(out)



=cut


use constant VATStatusChange_Denied => scalar('VATStatusChange_Denied');


=head2 VATStatusDeletedByCSR

(out)



=cut


use constant VATStatusDeletedByCSR => scalar('VATStatusDeletedByCSR');


=head2 VATStatusDeletedByUser

(out)



=cut


use constant VATStatusDeletedByUser => scalar('VATStatusDeletedByUser');


=head2 SMProListingDesignerFee

(out)



=cut


use constant SMProListingDesignerFee => scalar('SMProListingDesignerFee');


=head2 SMProListingDesignerCredit

(out)



=cut


use constant SMProListingDesignerCredit => scalar('SMProListingDesignerCredit');


=head2 StoresSuccessfulListingFee

(out) A fee charged for the difference between an eBay Store inventory listing
fee and an auction listing fee if a Store inventory item sells.



=cut


use constant StoresSuccessfulListingFee => scalar('StoresSuccessfulListingFee');


=head2 StoresSuccessfulListingFeeCredit

(out) A credit for a StoresSuccessfulListingFee.



=cut


use constant StoresSuccessfulListingFeeCredit => scalar('StoresSuccessfulListingFeeCredit');


=head2 StoresReferralFee

(out)



=cut


use constant StoresReferralFee => scalar('StoresReferralFee');


=head2 StoresReferralCredit

(out) A credit posted to a seller's account
for sale of Stores Inventory items by buyers
referred to the seller's Store by printed materials
and emails outside eBay.



=cut


use constant StoresReferralCredit => scalar('StoresReferralCredit');


=head2 SubtitleFee

(out) The fee charged for adding a subtitle
to a listing. The subtitle adds information
to the title.



=cut


use constant SubtitleFee => scalar('SubtitleFee');


=head2 SubtitleFeeCredit

(out) A credit of the fee charged for adding a
subtitle to a listing.



=cut


use constant SubtitleFeeCredit => scalar('SubtitleFeeCredit');


=head2 eBayStoreInventorySubscriptionCredit

(out)



=cut


use constant eBayStoreInventorySubscriptionCredit => scalar('eBayStoreInventorySubscriptionCredit');


=head2 AutoPmntReqExempt

(out)



=cut


use constant AutoPmntReqExempt => scalar('AutoPmntReqExempt');


=head2 AutoPmntReqRein

(out)



=cut


use constant AutoPmntReqRein => scalar('AutoPmntReqRein');


=head2 PictureManagerSubscriptionFee

(out) The monthly fee charged for subscribing to
Picture Manager. The fee varies according to
the level of subscription.



=cut


use constant PictureManagerSubscriptionFee => scalar('PictureManagerSubscriptionFee');


=head2 PictureManagerSubscriptionFeeCredit

(out) A credit granted for a Picture Manageer subscription
fee.



=cut


use constant PictureManagerSubscriptionFeeCredit => scalar('PictureManagerSubscriptionFeeCredit');


=head2 SellerReportsBasicFee

(out) A fee charged for a basic subscription to Seller Reports.



=cut


use constant SellerReportsBasicFee => scalar('SellerReportsBasicFee');


=head2 SellerReportsBasicCredit

(out) A credit granted for a basic subscription to Seller Reports.



=cut


use constant SellerReportsBasicCredit => scalar('SellerReportsBasicCredit');


=head2 SellerReportsPlusFee

(out) A fee charged for a subscription to Seller Reports Plus.



=cut


use constant SellerReportsPlusFee => scalar('SellerReportsPlusFee');


=head2 SellerReportsPlusCredit

(out) A credit granted for a subscription to Seller Reports Plus.



=cut


use constant SellerReportsPlusCredit => scalar('SellerReportsPlusCredit');


=head2 PaypalOnFile

(out)



=cut


use constant PaypalOnFile => scalar('PaypalOnFile');


=head2 PaypalOnFileByCSR

(out)



=cut


use constant PaypalOnFileByCSR => scalar('PaypalOnFileByCSR');


=head2 PaypalOffFile

(out)



=cut


use constant PaypalOffFile => scalar('PaypalOffFile');


=head2 BorderFee

(out) The fee for adding a border that outlines a listing with a frame.



=cut


use constant BorderFee => scalar('BorderFee');


=head2 BorderFeeCredit

(out) A credit for the border fee charged for a listing.



=cut


use constant BorderFeeCredit => scalar('BorderFeeCredit');


=head2 FeeSearchableMobileDE

(out) A fee charged to a seller for upgrading
a listing from eBay Germany's Car, Motorcycle,
and Special Vehicle categories so that it is also
searchable on the mobile.de classifieds site.



=cut


use constant FeeSearchableMobileDE => scalar('FeeSearchableMobileDE');


=head2 SalesReportsPlusFee

(out) A monthly subscription fee charged for
Sales Reports Plus.



=cut


use constant SalesReportsPlusFee => scalar('SalesReportsPlusFee');


=head2 SalesReportsPlusCredit

(out) A credit granted for a Sales Reports Plus
monthly subscription fee.



=cut


use constant SalesReportsPlusCredit => scalar('SalesReportsPlusCredit');


=head2 CreditSearchableMobileDE

(out) A credit granted for upgrading a listing
to make it searchable on the mobile.de platform.



=cut


use constant CreditSearchableMobileDE => scalar('CreditSearchableMobileDE');


=head2 EmailMarketingFee

(out) A fee charged to owners of eBay Stores
who have a sent a marketing email to buyers,
for the number of email recipients over
the Store's monthly free allocation. The
monthly allocation varies according to the type
of Store.



=cut


use constant EmailMarketingFee => scalar('EmailMarketingFee');


=head2 EmailMarketingCredit

(out) A credit granted for an email marketing fee.



=cut


use constant EmailMarketingCredit => scalar('EmailMarketingCredit');


=head2 FeePictureShow

(out) A fee charged for the Picture Show
service, which lets buyers browse or see a slide
show of 2 or more pictures at the top of the
item page.



=cut


use constant FeePictureShow => scalar('FeePictureShow');


=head2 CreditPictureShow

(out) A credit granted for a Picture Show fee.



=cut


use constant CreditPictureShow => scalar('CreditPictureShow');


=head2 ProPackBundleFee

(out) A fee charged for the ProPackBundle feature pack (currently available to US and Canada eBay motor vehicle sellers).



=cut


use constant ProPackBundleFee => scalar('ProPackBundleFee');


=head2 ProPackBundleFeeCredit

(out) A credit granted by eBay for the ProPackBundle feature pack (currently available to US and Canada eBay motor vehicle sellers).



=cut


use constant ProPackBundleFeeCredit => scalar('ProPackBundleFeeCredit');


=head2 BasicUpgradePackBundleFee

(out) A fee charged by eBay for the BasicUpgradePackBundle feature pack. 
No longer applicable to any sites (but formerly applicable to the
Australia site, site ID 15).



=cut


use constant BasicUpgradePackBundleFee => scalar('BasicUpgradePackBundleFee');


=head2 BasicUpgradePackBundleFeeCredit

(out) A credit granted by eBay for the BasicUpgradePackBundle feature pack.
No longer applicable to any sites (but formerly applicable to the
Australia site, site ID 15).



=cut


use constant BasicUpgradePackBundleFeeCredit => scalar('BasicUpgradePackBundleFeeCredit');


=head2 ValuePackBundleFee

(out) A fee charged by eBay for the ValuePackBundle feature pack.



=cut


use constant ValuePackBundleFee => scalar('ValuePackBundleFee');


=head2 ValuePackBundleFeeCredit

(out) A credit granted by eBay for the ValuePackBundle feature pack.



=cut


use constant ValuePackBundleFeeCredit => scalar('ValuePackBundleFeeCredit');


=head2 ProPackPlusBundleFee

(out) A fee charged by eBay for the ProPackPlusBundle feature pack.



=cut


use constant ProPackPlusBundleFee => scalar('ProPackPlusBundleFee');


=head2 ProPackPlusBundleFeeCredit

(out) A credit granted by eBay for the ProPackPlusBundle feature pack.



=cut


use constant ProPackPlusBundleFeeCredit => scalar('ProPackPlusBundleFeeCredit');


=head2 FinalEntry

(out) The final entry in an account before it is closed
or merged with another account.



=cut


use constant FinalEntry => scalar('FinalEntry');


=head2 CustomCode

(out) Reserved for future use.



=cut


use constant CustomCode => scalar('CustomCode');


=head2 ExtendedDurationFee

(out) A fee charged for extended listing duration.



=cut


use constant ExtendedDurationFee => scalar('ExtendedDurationFee');


=head2 ExtendedDurationFeeCredit

(out) A credit granted by eBay for extended listing duration.



=cut


use constant ExtendedDurationFeeCredit => scalar('ExtendedDurationFeeCredit');


=head2 InternationalListingFee

(out) The fee for an international listing.



=cut


use constant InternationalListingFee => scalar('InternationalListingFee');


=head2 InternationalListingCredit

(out) A credit issued by eBay for an international listing.



=cut


use constant InternationalListingCredit => scalar('InternationalListingCredit');


=head2 MarketplaceResearchExpiredSubscriptionFee

(out) A MarketPlace Research fee for expired subscriptions.



=cut


use constant MarketplaceResearchExpiredSubscriptionFee => scalar('MarketplaceResearchExpiredSubscriptionFee');


=head2 MarketplaceResearchExpiredSubscriptionFeeCredit

(out) A MarketPlace Research credit for expired subscriptions.



=cut


use constant MarketplaceResearchExpiredSubscriptionFeeCredit => scalar('MarketplaceResearchExpiredSubscriptionFeeCredit');


=head2 MarketplaceResearchBasicSubscriptionFee

(out) A MarketPlace Research basic subscription fee.



=cut


use constant MarketplaceResearchBasicSubscriptionFee => scalar('MarketplaceResearchBasicSubscriptionFee');


=head2 MarketplaceResearchBasicSubscriptionFeeCredit

(out) A MarketPlace Research basic subscription credit.



=cut


use constant MarketplaceResearchBasicSubscriptionFeeCredit => scalar('MarketplaceResearchBasicSubscriptionFeeCredit');


=head2 MarketplaceResearchProSubscriptionFee

(out) A MarketPlace Research pro subscription fee.



=cut


use constant MarketplaceResearchProSubscriptionFee => scalar('MarketplaceResearchProSubscriptionFee');


=head2 BasicBundleFee

(out) Basic bundle fee.



=cut


use constant BasicBundleFee => scalar('BasicBundleFee');


=head2 BasicBundleFeeCredit

(out) Basic bundle fee credit.



=cut


use constant BasicBundleFeeCredit => scalar('BasicBundleFeeCredit');


=head2 MarketplaceResearchProSubscriptionFeeCredit

(out) A MarketPlace Research pro subscription fee credit.



=cut


use constant MarketplaceResearchProSubscriptionFeeCredit => scalar('MarketplaceResearchProSubscriptionFeeCredit');


=head2 VehicleLocalSubscriptionFee

(out) A Vehicle Local subscription fee.



=cut


use constant VehicleLocalSubscriptionFee => scalar('VehicleLocalSubscriptionFee');


=head2 VehicleLocalSubscriptionFeeCredit

(out) A Vehicle Local subscription fee credit.



=cut


use constant VehicleLocalSubscriptionFeeCredit => scalar('VehicleLocalSubscriptionFeeCredit');


=head2 VehicleLocalInsertionFee

(out) A Vehicle Local insertion fee.



=cut


use constant VehicleLocalInsertionFee => scalar('VehicleLocalInsertionFee');


=head2 VehicleLocalInsertionFeeCredit

(out) A Vehicle Local insertion fee credit.



=cut


use constant VehicleLocalInsertionFeeCredit => scalar('VehicleLocalInsertionFeeCredit');


=head2 VehicleLocalFinalValueFee

(out) A Vehicle Local final value fee.



=cut


use constant VehicleLocalFinalValueFee => scalar('VehicleLocalFinalValueFee');


=head2 VehicleLocalFinalValueFeeCredit

(out) A Vehicle Local final value fee credit.



=cut


use constant VehicleLocalFinalValueFeeCredit => scalar('VehicleLocalFinalValueFeeCredit');


=head2 VehicleLocalGTCFee

(out) A Vehicle Local GTC fee.



=cut


use constant VehicleLocalGTCFee => scalar('VehicleLocalGTCFee');


=head2 VehicleLocalGTCFeeCredit

(out) A Vehicle Local GTC fee credit.



=cut


use constant VehicleLocalGTCFeeCredit => scalar('VehicleLocalGTCFeeCredit');


=head2 eBayMotorsProFee

(out) eBay Motors Pro fee. Applies to eBay Motors Pro registered dealer
applications only.



=cut


use constant eBayMotorsProFee => scalar('eBayMotorsProFee');


=head2 CrediteBayMotorsProFee

(out) eBay Motors Pro fee credit. Applies to eBay Motors Pro registered
dealer applications only.



=cut


use constant CrediteBayMotorsProFee => scalar('CrediteBayMotorsProFee');


=head2 eBayMotorsProFeatureFee

(out) eBay Motors Pro feature fee. Applies to eBay Motors Pro registered
dealer applications only.



=cut


use constant eBayMotorsProFeatureFee => scalar('eBayMotorsProFeatureFee');


=head2 CrediteBayMotorsProFeatureFee

(out) eBay Motors Pro feature fee credit. Applies to eBay Motors Pro
registered dealer applications only.



=cut


use constant CrediteBayMotorsProFeatureFee => scalar('CrediteBayMotorsProFeatureFee');


=head2 FeeGalleryPlus

(out) A fee charged by eBay for listing an item with the
Gallery Plus feature enabled. This feature cannot be removed
with ReviseItem or RelistItem. However, if the feature is
upgraded, for example, to Gallery Featured, the fee for
Gallery Plus is refunded and a fee for Gallery Feature is
charged instead.



=cut


use constant FeeGalleryPlus => scalar('FeeGalleryPlus');


=head2 CreditGalleryPlus

(out) A credit issued by eBay when refunding the fee for
enabling the Gallery Plus feature. A Gallery Plus credit may
be issued if, for example, a user upgrades their feature
with ReviseItem or RelistItem to Gallery Featured. In this
case, the original Gallery Plus fee is refunded and a
Gallery Featured fee is charged instead.



=cut


use constant CreditGalleryPlus => scalar('CreditGalleryPlus');


=head2 PrivateListing

=cut


use constant PrivateListing => scalar('PrivateListing');


=head2 CreditPrivateListing

=cut


use constant CreditPrivateListing => scalar('CreditPrivateListing');


=head2 ImmoProFee

eBay ImmoPro Fee



=cut


use constant ImmoProFee => scalar('ImmoProFee');


=head2 CreditImmoProFee

Credit eBay ImmoPro Fee



=cut


use constant CreditImmoProFee => scalar('CreditImmoProFee');


=head2 ImmoProFeatureFee

eBay ImmoPro Feature Fee



=cut


use constant ImmoProFeatureFee => scalar('ImmoProFeatureFee');


=head2 CreditImmoProFeatureFee

Credit eBay ImmoPro Feature Fee



=cut


use constant CreditImmoProFeatureFee => scalar('CreditImmoProFeatureFee');


=head2 RealEstateProFee

eBay Real Estate Pro Fee



=cut


use constant RealEstateProFee => scalar('RealEstateProFee');


=head2 CreditRealEstateProFee

Credit eBay Real Estate Pro Fee



=cut


use constant CreditRealEstateProFee => scalar('CreditRealEstateProFee');


=head2 RealEstateProFeatureFee

eBay Real Estate Pro Feature Fee



=cut


use constant RealEstateProFeatureFee => scalar('RealEstateProFeatureFee');


=head2 CreditRealEstateProFeatureFee

Credit eBay Real Estate Pro Feature Fee



=cut


use constant CreditRealEstateProFeatureFee => scalar('CreditRealEstateProFeatureFee');







1;   
