# -*- cperl -*-
# ABSTRACT: LaTeX function (math) object


use strict;
use warnings;
package SpeL::Object::Function;

use parent 'Exporter';
use Carp;

use SpeL::I18n;
use Data::Dumper;

use SpeL::Object::Squareroot;




sub read {
  my $self = shift;
  my ( $level ) = @_;

  # say STDERR Data::Dumper->Dump( [ $self ] , [qw(self)] );

  exists $self->{Sqrt} and return $self->{Sqrt}->read( $level + 1 );
  my $power = '';

  if( exists $self->{Power} ) {
    $power = $self->{Power}->read( $level + 1 );
  }
    
  exists $self->{Trig} and do {
    $self->{Trig} =~ s/^\\//;
    return $SpeL::I18n::lh->maketext( "Function",
				      $SpeL::I18n::lh->maketext( $self->{Trig} ) . $power,
				      $self->{Argument}->read( $level + 1 ) ) . ', ';
  };
  return
    $SpeL::I18n::lh->maketext( "Function",
			       $self->{Name}->read()
			       . $power,
			       $self->{Argument}->read( $level + 1 ) )
    . ', ';
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

SpeL::Object::Function - LaTeX function (math) object

=head1 VERSION

version 20240616

=head1 METHODS

=head2 new()

We keep the default method, as the object is generated by the parser.

=head2 read( level )

returns a string with the spoken version of the node

=over 4

=item level: parsing level

=back

=head1 SYNOPSYS

Represents a LaTeX math function

=head1 AUTHOR

Walter Daems <wdaems@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2024 by Walter Daems.

This is free software, licensed under:

  The GNU General Public License, Version 3, June 2007

=head1 CONTRIBUTOR

=for stopwords Paul Levrie

Paul Levrie

=cut
