# -*- cperl -*-
# ABSTRACT: LaTeX  environment object


use strict;
use warnings;
package SpeL::Object::Environment;

use SpeL::Object::Option;
use SpeL::Object::ElementList;

use parent 'Exporter';
use Carp;

use Data::Dumper;

our $environmenthash = {};




sub read {
  my $self = shift;
  my ( $level ) = @_;

  $self->{'tag'} =~ /^center$/ and do { return $self->{ElementList}->read( $level + 1 ); };

  return "Error: unknown environment";
}


1;

__END__

=pod

=encoding UTF-8

=head1 NAME

SpeL::Object::Environment - LaTeX  environment object

=head1 VERSION

version 20240617.1739

=head1 METHODS

=head2 new()

We keep the default method, as the object is generated by the parser.

=head2 read( level )

returns a string with the spoken version of the node

=over 4

=item level: parsing level

=back

=head1 SYNOPSYS

Represents a LaTeX  environment

=head1 AUTHOR

Walter Daems <wdaems@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2024 by Walter Daems.

This is free software, licensed under:

  The GNU General Public License, Version 3, June 2007

=head1 CONTRIBUTOR

=for stopwords Paul Levrie

Paul Levrie

=cut
