#!/usr/bin/perl
use RDF::Query;
  use RDF::Trine;
  
  my $store = RDF::Trine::Store::Memory->new();
  my $model = RDF::Trine::Model->new($store);
  
  # parse some web data into the model, and print the count of resulting RDF statements
#  RDF::Trine::Parser->parse_file_into_model( './foaf.xrdf', $model );
#  RDF::Trine::Parser->parse_url_into_model( 'http://kasei.us/about/foaf.xrdf', './foaf.xrdf', $model );
  RDF::Trine::Parser->parse_url_into_model( 'http://kasei.us/about/foaf.xrdf', $model );
  print $model->size . " RDF statements parsed\n";
  
  # Create a namespace object for the foaf vocabulary
  my $foaf = RDF::Trine::Namespace->new( 'http://xmlns.com/foaf/0.1/' );
  
  # Create a node object for the FOAF name property
  my $pred = $foaf->name;
  # alternatively:
   my $pred = RDF::Trine::Node::Resource->new('http://xmlns.com/foaf/0.1/name');
  
  # Create an iterator for all the statements in the model with foaf:name as the predicate
  my $iter = $model->get_statements(undef, $pred, undef);
  
  # Now print the results
  print "Names of things:\n";
  while (my $st = $iter->next) {
	print Data::Dumper->Dump([$st]);
    my $s = $st->subject;
    my $name = $st->object;
    
    # $s and $name have string overloading, so will print correctly
    print "The name of $s is $name\n";
  }
# my $query = RDF::Query->new( 'PREFIX : <http://aabs.purl.org/music#>
#SELECT ?instrument
#WHERE {
# :andrew :playsInstrument ?instrument .
#}' );
# my $query = RDF::Query->new( 'PREFIX foaf:   <http://xmlns.com/foaf/0.1/> SELECT ?x ?name WHERE  { [?x foaf:name ?name .] }' );
#   my $sparql = 'PREFIX foaf: <http://xmlns.com/foaf/0.1/#>  SELECT ?name ?homepage WHERE { [ foaf:name ?name ?name . ] }';
#             my $query = RDF::Query->new( $sparql );
#             my $iterator = $query->execute( $model );
#             while (my $row = $iterator->()) {
#               my ($name, $homepage) = @$row;
               # ...
#		print "$name,$homepage\n";
#             }

use Data::Dumper;



 my $query = RDF::Query->new( 'PREFIX foaf: <http://xmlns.com/foaf/0.1/> SELECT ?x ?p  WHERE { ?x  foaf:name "Brenda Gillis"  . ?p  foaf:name  "Kronos Quartet"}' );
 #my $query = RDF::Query->new( 'PREFIX foaf: <http://xmlns.com/foaf/0.1/#> SELECT * WHERE { ?name a foaf:name .}' );
        my $iterator = $query->execute( $model );
        while (my $row = $iterator->next) {
          # $row is a HASHref containing variable name -> RDF Term bindings
	print Data::Dumper->Dump([$row]);
        #  print $row->{ 'var' },"---\n";
        }

