### base class of e.g. functor algorithms derived

sub new {
    my $class = shift;

    $self = { bitmap => undef, componentsbag => undef };
    
    bless $self, $class;
}

sub init {
    my ($self, $bitmap) = @_;

    $self->{bitmap} = $bitmap;
    $self->{componentsbag} = OnePassBitmapAlgorithmComponentsBag->new;
}

### NOTE : see pass function below
sub getBitmap {
  my $self = shift;

  return $self->{bitmap};
}

sub getBag {
  my $self = shift;

  return $self->{componentsbag};
}

sub pass {
    my ($self, $onepasssystem) = @_;

    $onepasssystem->run($self);
}

1;
