package Shipment::FedEx::WSDL::TrackTypes::TrackStatusDetail;
$Shipment::FedEx::WSDL::TrackTypes::TrackStatusDetail::VERSION = '3.08';
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns {'http://fedex.com/ws/track/v9'}

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{    # BLOCK to scope variables

    my %CreationTime_of : ATTR(:get<CreationTime>);
    my %Code_of : ATTR(:get<Code>);
    my %Description_of : ATTR(:get<Description>);
    my %Location_of : ATTR(:get<Location>);
    my %AncillaryDetails_of : ATTR(:get<AncillaryDetails>);

    __PACKAGE__->_factory(
        [   qw(        CreationTime
              Code
              Description
              Location
              AncillaryDetails

            )
        ],
        {   'CreationTime'     => \%CreationTime_of,
            'Code'             => \%Code_of,
            'Description'      => \%Description_of,
            'Location'         => \%Location_of,
            'AncillaryDetails' => \%AncillaryDetails_of,
        },
        {   'CreationTime' => 'SOAP::WSDL::XSD::Typelib::Builtin::dateTime',
            'Code'         => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
            'Description'  => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
            'Location'     => 'Shipment::FedEx::WSDL::TrackTypes::Address',
            'AncillaryDetails' =>
              'Shipment::FedEx::WSDL::TrackTypes::TrackStatusAncillaryDetail',
        },
        {

            'CreationTime'     => 'CreationTime',
            'Code'             => 'Code',
            'Description'      => 'Description',
            'Location'         => 'Location',
            'AncillaryDetails' => 'AncillaryDetails',
        }
    );

}    # end BLOCK


1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Shipment::FedEx::WSDL::TrackTypes::TrackStatusDetail

=head1 VERSION

version 3.08

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
TrackStatusDetail from the namespace http://fedex.com/ws/track/v9.

Specifies the details about the status of the track information for the shipments being tracked.

=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * CreationTime

=item * Code

=item * Description

=item * Location

=item * AncillaryDetails

=back

=head1 NAME

Shipment::FedEx::WSDL::TrackTypes::TrackStatusDetail

=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # Shipment::FedEx::WSDL::TrackTypes::TrackStatusDetail
   CreationTime =>  $some_value, # dateTime
   Code =>  $some_value, # string
   Description =>  $some_value, # string
   Location =>  { # Shipment::FedEx::WSDL::TrackTypes::Address
     StreetLines =>  $some_value, # string
     City =>  $some_value, # string
     StateOrProvinceCode =>  $some_value, # string
     PostalCode =>  $some_value, # string
     UrbanizationCode =>  $some_value, # string
     CountryCode =>  $some_value, # string
     CountryName =>  $some_value, # string
     Residential =>  $some_value, # boolean
   },
   AncillaryDetails =>  { # Shipment::FedEx::WSDL::TrackTypes::TrackStatusAncillaryDetail
     Reason =>  $some_value, # string
     ReasonDescription =>  $some_value, # string
     Action =>  $some_value, # string
     ActionDescription =>  $some_value, # string
   },
 },

=head1 AUTHOR

Generated by SOAP::WSDL

=head1 AUTHOR

Andrew Baerg <baergaj@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2018 by Andrew Baerg.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
