# Generated by default/object.tt
package Paws::DMS::KinesisSettings;
  use Moose;
  has IncludeControlDetails => (is => 'ro', isa => 'Bool');
  has IncludeNullAndEmpty => (is => 'ro', isa => 'Bool');
  has IncludePartitionValue => (is => 'ro', isa => 'Bool');
  has IncludeTableAlterOperations => (is => 'ro', isa => 'Bool');
  has IncludeTransactionDetails => (is => 'ro', isa => 'Bool');
  has MessageFormat => (is => 'ro', isa => 'Str');
  has PartitionIncludeSchemaTable => (is => 'ro', isa => 'Bool');
  has ServiceAccessRoleArn => (is => 'ro', isa => 'Str');
  has StreamArn => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::DMS::KinesisSettings

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::DMS::KinesisSettings object:

  $service_obj->Method(Att1 => { IncludeControlDetails => $value, ..., StreamArn => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::DMS::KinesisSettings object:

  $result = $service_obj->Method(...);
  $result->Att1->IncludeControlDetails

=head1 DESCRIPTION

Provides information that describes an Amazon Kinesis Data Stream
endpoint. This information includes the output format of records
applied to the endpoint and details of transaction and control table
data information.

=head1 ATTRIBUTES


=head2 IncludeControlDetails => Bool

Shows detailed control information for table definition, column
definition, and table and column changes in the Kinesis message output.
The default is C<false>.


=head2 IncludeNullAndEmpty => Bool

Include NULL and empty columns for records migrated to the endpoint.
The default is C<false>.


=head2 IncludePartitionValue => Bool

Shows the partition value within the Kinesis message output, unless the
partition type is C<schema-table-type>. The default is C<false>.


=head2 IncludeTableAlterOperations => Bool

Includes any data definition language (DDL) operations that change the
table in the control data, such as C<rename-table>, C<drop-table>,
C<add-column>, C<drop-column>, and C<rename-column>. The default is
C<false>.


=head2 IncludeTransactionDetails => Bool

Provides detailed transaction information from the source database.
This information includes a commit timestamp, a log position, and
values for C<transaction_id>, previous C<transaction_id>, and
C<transaction_record_id> (the record offset within a transaction). The
default is C<false>.


=head2 MessageFormat => Str

The output format for the records created on the endpoint. The message
format is C<JSON> (default) or C<JSON_UNFORMATTED> (a single line with
no tab).


=head2 PartitionIncludeSchemaTable => Bool

Prefixes schema and table names to partition values, when the partition
type is C<primary-key-type>. Doing this increases data distribution
among Kinesis shards. For example, suppose that a SysBench schema has
thousands of tables and each table has only limited range for a primary
key. In this case, the same primary key is sent from thousands of
tables to the same shard, which causes throttling. The default is
C<false>.


=head2 ServiceAccessRoleArn => Str

The Amazon Resource Name (ARN) for the AWS Identity and Access
Management (IAM) role that AWS DMS uses to write to the Kinesis data
stream.


=head2 StreamArn => Str

The Amazon Resource Name (ARN) for the Amazon Kinesis Data Streams
endpoint.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::DMS>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

