# Generated by default/object.tt
package Paws::ElastiCache::PendingLogDeliveryConfiguration;
  use Moose;
  has DestinationDetails => (is => 'ro', isa => 'Paws::ElastiCache::DestinationDetails');
  has DestinationType => (is => 'ro', isa => 'Str');
  has LogFormat => (is => 'ro', isa => 'Str');
  has LogType => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::ElastiCache::PendingLogDeliveryConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ElastiCache::PendingLogDeliveryConfiguration object:

  $service_obj->Method(Att1 => { DestinationDetails => $value, ..., LogType => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ElastiCache::PendingLogDeliveryConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->DestinationDetails

=head1 DESCRIPTION

The log delivery configurations being modified

=head1 ATTRIBUTES


=head2 DestinationDetails => L<Paws::ElastiCache::DestinationDetails>

Configuration details of either a CloudWatch Logs destination or
Kinesis Data Firehose destination.


=head2 DestinationType => Str

Returns the destination type, either CloudWatch Logs or Kinesis Data
Firehose.


=head2 LogFormat => Str

Returns the log format, either JSON or TEXT


=head2 LogType => Str

Refers to slow-log (https://redis.io/commands/slowlog).



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ElastiCache>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

