# Generated by default/object.tt
package Paws::FSX::Alias;
  use Moose;
  has Lifecycle => (is => 'ro', isa => 'Str');
  has Name => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::FSX::Alias

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::FSX::Alias object:

  $service_obj->Method(Att1 => { Lifecycle => $value, ..., Name => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::FSX::Alias object:

  $result = $service_obj->Method(...);
  $result->Att1->Lifecycle

=head1 DESCRIPTION

A DNS alias that is associated with the file system. You can use a DNS
alias to access a file system using user-defined DNS names, in addition
to the default DNS name that Amazon FSx assigns to the file system. For
more information, see DNS aliases
(https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-dns-aliases.html)
in the I<FSx for Windows File Server User Guide>.

=head1 ATTRIBUTES


=head2 Lifecycle => Str

Describes the state of the DNS alias.

=over

=item *

AVAILABLE - The DNS alias is associated with an Amazon FSx file system.

=item *

CREATING - Amazon FSx is creating the DNS alias and associating it with
the file system.

=item *

CREATE_FAILED - Amazon FSx was unable to associate the DNS alias with
the file system.

=item *

DELETING - Amazon FSx is disassociating the DNS alias from the file
system and deleting it.

=item *

DELETE_FAILED - Amazon FSx was unable to disassocate the DNS alias from
the file system.

=back



=head2 Name => Str

The name of the DNS alias. The alias name has to meet the following
requirements:

=over

=item *

Formatted as a fully-qualified domain name (FQDN), C<hostname.domain>,
for example, C<accounting.example.com>.

=item *

Can contain alphanumeric characters, the underscore (_), and the hyphen
(-).

=item *

Cannot start or end with a hyphen.

=item *

Can start with a numeric.

=back

For DNS names, Amazon FSx stores alphabetic characters as lowercase
letters (a-z), regardless of how you specify them: as uppercase
letters, lowercase letters, or the corresponding letters in escape
codes.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::FSX>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

