=pod

=head1 NAME

examples/keyselector.pl - interactive key selection and storage

=head1 FEATURES

Contains an example how to use the standard key selection and conversion
features of Prima::KeySelector. A typical program with interactively
configurable key shortcuts reflects the changes in the menu hot-keys and in the
initialization file. In the example, changes are stored in ~/.prima/keyselector
INI-file.

=cut

use strict;
use Prima qw(Application KeySelector IniFile );

my $w = Prima::MainWindow-> new(
		text => 'Key selector',
		packPropagate => 0,
		menuItems => [
			[ File => [
				['FileExit' => "~Exit and save changes" => '' , '@X', => sub { $_[0]-> close } ],
				['FileQuit' => "Exit and ~discard changes", '', km::Alt|km::Shift|ord('X') => sub {
					$_[0]-> {saveOnExit} = 0;
					$_[0]-> close;
				}],
			]],
			[ Edit => [
				[ 'EditApply'    => "~Apply changes", '', '^A' => sub {
					shift-> Editor-> apply;
				}],
				[ 'EditDefault'  => "~Restore to defaults" => sub {
					shift-> Editor-> reset_to_defaults;
				}],
			]],
			[],
			[ Help => sub { $::application-> open_help("file://$0") } ],
		],
		onClose => sub { $_[0]-> menu-> keys_save( $_[0]-> {iniFile}-> section('Options')) if $_[0]-> {saveOnExit}},
);
$w-> {saveOnExit} = 1;

$w-> {iniFile} = Prima::IniFile-> new(
	file => Prima::Utils::path('keyselector'),
);
$w-> menu-> keys_load($w-> {iniFile}-> section( 'Options'), 1); # 1 is because we're lazy and want menu accels to be autogenerated

$w-> insert( 'Prima::KeySelector::MenuEditor' =>
	name         => 'Editor',
	pack         => { expand => 1, fill => 'both'},
	menu         => $w-> menu,
);

Prima->run;
