/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.commandhandler;

import com.google.common.collect.ImmutableMap;
import com.google.common.net.MediaType;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.openqa.selenium.grid.web.CommandHandler;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

public class NoHandler
implements CommandHandler {
    private final Json json;

    public NoHandler(Json json) {
        this.json = Objects.requireNonNull(json);
    }

    @Override
    public void execute(HttpRequest req, HttpResponse resp) throws IOException {
        Map<String, Serializable> responseMap = new HashMap<String, Serializable>();
        responseMap.put("sessionId", null);
        responseMap.put("status", Integer.valueOf(9));
        responseMap.put("value", ImmutableMap.of("error", "unknown command", "message", String.format("Unable to find command matching %s to %s", new Object[]{req.getMethod(), req.getUri()}), "stacktrace", ""));
        responseMap = Collections.unmodifiableMap(responseMap);
        byte[] payload = this.json.toJson(responseMap).getBytes(StandardCharsets.UTF_8);
        resp.setStatus(404);
        resp.setHeader("Content-Type", MediaType.JSON_UTF_8.toString());
        resp.setHeader("Content-Length", String.valueOf(payload.length));
        resp.setContent(payload);
    }
}

