package OpenInteract::Handler::ObjectActivity;

# $Id: ObjectActivity.pm,v 1.5 2002/12/13 22:16:29 lachoy Exp $

use strict;
use OpenInteract::Handler::GenericDispatcher qw( DEFAULT_SECURITY_KEY );
use SPOPS::Secure qw( :level );

@OpenInteract::Handler::ObjectActivity::ISA     = qw(
   OpenInteract::Handler::GenericDispatcher  SPOPS::Secure
);
$OpenInteract::Handler::ObjectActivity::VERSION           = sprintf("%d.%02d", q$Revision: 1.5 $ =~ /(\d+)\.(\d+)/);
$OpenInteract::Handler::ObjectActivity::author            = 'chris@cwinters.com';
$OpenInteract::Handler::ObjectActivity::default_method    = 'search_form';
@OpenInteract::Handler::ObjectActivity::forbidden_methods = ();
%OpenInteract::Handler::ObjectActivity::security          = ( DEFAULT_SECURITY_KEY() => SEC_LEVEL_READ );


sub search_form {
    my ( $class, $p ) = @_;
    my $R = OpenInteract::Request->instance;
    my %params = ();
    my $spops_conf = $R->CONFIG->{SPOPS};
    foreach my $object_key ( sort keys %{ $spops_conf } ) {
        push @{ $params{class_name_list} }, $object_key;
        push @{ $params{class_list} }, $spops_conf->{ $object_key }{class};
    }
    $R->{page}{title} = 'Search for Object Activity Records';
    return $R->template->handler( {}, \%params,
                                  { name => 'object_activity::search_form' } );
}


sub search {
    my ( $class, $p ) = @_;
    my $R   = OpenInteract::Request->instance;
    my $apr = $R->apache;

    my %params = ();

    my @where = ();
    my @value = ();

    # Do the easy criteria

    my @SEARCH_FIELDS = qw( class object_id action action_by action_on );
    foreach my $field ( @SEARCH_FIELDS ) {
        my $this_value = $p->{ $field } || $apr->param( $field );
        next unless $this_value;
        push @where, " $field = ? ";
        push @value, $this_value;
        $R->DEBUG && $R->scrib( 1, "Setting criteria [$field] to [$this_value]" );
    }

    # Now the dates...

    my $exact_date = $class->_read_date( 'action_on', $p );
    my $date_fmt = '%Y-%m-%d';
    if ( $exact_date ) {
        push @where, " ( action_on > ? AND action_on < ? ) ";
        my $date_before = $exact_date - '1D';
        my $date_after  = $exact_date + '1D';
        push @value, $date_before->strftime( $date_fmt ), $date_after->strftime( $date_fmt );
        $R->DEBUG && $R->scrib( 1, "Setting criteria action_on to between ",
                                   "[$date_before] and [$date_after] (no format)" );
    }

    else {
        my $start_date = $class->_read_date( 'action_on_start', $p );
        my $end_date   = $class->_read_date( 'action_on_end', $p );
        if ( $start_date ) {
            push @where, " action_on >= ? ";
            push @value, $start_date->strftime( $date_fmt );
            $R->DEBUG && $R->scrib( 1, "Setting criteria action_on to after",
                                       "[$start_date]" );
        }
        if ( $end_date ) {
            push @where, " action_on <= ?";
            push @value, $end_date->strftime( $date_fmt );
            $R->DEBUG && $R->scrib( 1, "Setting criteria action_on to before",
                                       "[$end_date]" );
        }
    }

    my $order = $p->{order} || $apr->param( 'order' ) || 'action_on DESC';

    my $activity_list = $R->object_action->fetch_group({
                                   where => join( ' AND ', @where ),
                                   value => \@value,
                                   order => $order });
    $params{activity_list} = $class->_set_object_info( $activity_list );
    $R->{page}{title} = 'Object Activity Search Results';
    return $R->template->handler( {}, \%params,
                                  { name => 'object_activity::search_results' } );
}

sub _set_object_info {
    my ( $class, $activity_list ) = @_;
    my $R = OpenInteract::Request->instance;

    my @new_activity = ();

    my ( %user_cache );
    foreach my $rec ( @{ $activity_list } ) {
        my %info = %{ $rec };
        my $object_class = $rec->{class};

        unless ( $user_cache{ $rec->{action_by} } ) {
            my $user = eval { $R->user->fetch( $rec->{action_by} ) };
            if ( $@ or ! $user ) {
                $info{login_name} = 'unknown';
            }
            else {
                $user_cache{ $rec->{action_by} } = $user->object_description;
            }
        }
        if ( my $user = $user_cache{ $rec->{action_by} } ) {
            $info{login_name}       = $user->{title};
            $info{user_display_url} = $user->{url};
        }

        $info{object_type} = $object_class->CONFIG->{object_name};

        if ( $info{action} eq 'remove' ) {
            $info{title} = $info{object_id};
        }
        else {
            my $object = eval { $object_class->fetch( $rec->{object_id} ) };
            if ( $@ or ! $object ) {
                $info{title}       = 'n/a';
            }
            else {
                my $object_info = $object->object_description;
                $info{title}       = $object_info->{title};
                $info{display_url} = $object_info->{url};
            }
        }

        push @new_activity, \%info;
    }
    return \@new_activity;
}


# Blech - when we switch to using ::CommonHandler we won't need this
# anymore

sub _read_date {
    my ( $class, $field, $p ) = @_;
    if ( $p->{ $field } ) {
        my $date_string = $p->{ $field };
        return Class::Date::date( $date_string );
    }
    my $apr = OpenInteract::Request->instance->apache;
    my ( $y, $m, $d ) = ( $apr->param( "${field}_year" ),
                          $apr->param( "${field}_month" ),
                          $apr->param( "${field}_day" ) );
    return undef unless ( $y and $m and $d );
    return Class::Date->new([ $y, $m, $d ]);
}

1;
