package OpenInteract::Handler::SiteTemplate;

# $Id: SiteTemplate.pm,v 1.10 2002/08/25 00:04:07 lachoy Exp $

use strict;
use SPOPS::Secure qw( :level );

@OpenInteract::Handler::SiteTemplate::ISA     = qw( OpenInteract::Handler::GenericDispatcher  SPOPS::Secure );
$OpenInteract::Handler::SiteTemplate::VERSION = substr(q$Revision: 1.10 $, 10);

$OpenInteract::Handler::SiteTemplate::author            = 'chris@cwinters.com';
$OpenInteract::Handler::SiteTemplate::default_method    = 'listing';
%OpenInteract::Handler::SiteTemplate::security          = (
 listing => SEC_LEVEL_READ,  show   => SEC_LEVEL_READ,
 edit    => SEC_LEVEL_WRITE, remove => SEC_LEVEL_WRITE,
);



sub listing {
    my ( $class, $p ) = @_;
    my $R = OpenInteract::Request->instance;
    my %params = ( error_msg  => $p->{error_msg},
                   status_msg => $p->{status_msg} );

    my $website_dir = $R->CONFIG->{dir}{base};
    my $repository  = $R->repository->fetch(
                                       undef, { directory => $website_dir } );
    my $packages = $repository->fetch_all_packages();
    my $tmpl_class = $R->site_template;
    eval {
        foreach my $pkg ( @{ $packages } ) {
            $params{package_templates}->{ $pkg->{name} } =
                                   $tmpl_class->fetch_by_package( $pkg->{name} );
        }
        $params{package_templates}->{ '' } = $tmpl_class->fetch_by_package( '' );
    };
    if ( $@ ) {
        $params{error_msg} = "$@";
        OpenInteract::Error->set( SPOPS::Error->get );
        $R->throw( { code => 403 } );
        $params{template_list} = [];
    }

    $R->{page}{title} = 'Template Listing By Package';
    return $R->template->handler( {}, \%params,
                                  { name => 'base_template::template_list' } );
}


sub show {
    my ( $class, $p ) = @_;
    my $R = OpenInteract::Request->instance;
    my $apr = $R->apache;
    my %params = ( error_msg    => $p->{error_msg},
                   status_msg   => $p->{error_msg},
                   package_list => $R->CONFIG->{package_list} );
    $params{labels} = [ @{ $params{package_list} } ];
    unshift @{ $params{package_list} }, '';
    unshift @{ $params{package_labels} }, 'Global Templates';

    my $template = $p->{template};
    unless ( $template ) {
        my $package = $p->{package} || $apr->param( 'package' );
        my $name    = $p->{name}    || $apr->param( 'name' );
        if ( $name ) {
            my $fq_name = $R->site_template->create_name( $package, $name );
            $template = eval { $R->site_template->fetch( $fq_name ) };
        }
    }
    if ( $@ ) {
        $params{error_msg} = "$@";
        OpenInteract::Error->set( SPOPS::Error->get );
        $R->throw( { code => 404 } );
    }

    # If the user has less than WRITE access to module and there is no
    # template_id or template object, there's no reason to continue

    if ( ! $template and $p->{level} < SEC_LEVEL_WRITE ) {
        my $user_msg = 'Sorry, you do not have access to create a new template object. Returning to listing.';
        return $class->listing({ error_msg => $user_msg });
    }

    my $show_template_name = 'base_template::template_form';

    my $do_edit = $p->{edit} || $apr->param( 'edit' );
    if ( $do_edit and $p->{level} < SEC_LEVEL_WRITE ) {
        my $user_msg = 'Sorry, you cannot edit a template object. Displaying static format.';
        $params{error_msg} = ( $params{error_msg} )
                               ? "$params{error_msg}<br>$user_msg"
                               : $user_msg;
        $show_template_name = 'base_template::template_display';
    }

    $params{tmpl} = $template || $R->site_template->new;
    $R->{page}{title} = 'Detail of Template Item';
    return $R->template->handler( {}, \%params, { name => $show_template_name } );
}


sub edit {
    my ( $class, $p ) = @_;
    my $R   = OpenInteract::Request->instance;
    my $apr = $R->apache;
    my $tmpl_class = $R->site_template;
    $R->{page}{return_url} = '/SiteTemplate/';
    my $package = $apr->param( 'package_original' );
    my $name    = $apr->param( 'name_original' );

    my $template = $tmpl_class->fetch( $tmpl_class->create_name( $package, $name ) );
    my ( $original_filename );
    if ( $template ) {
        $original_filename = $template->full_filename;
    }
    else {
        $template = $tmpl_class->new();
    }

    $template->package( $apr->param( 'package' ) );
    $template->name( $apr->param( 'name' ) );
    $template->set_contents( $apr->param( 'contents' ) );
    eval { $template->save };
    if ( $@ ) {
        return $class->listing({
                    error_msg => "Failed to save template. Error: $@" });
    }
    return $class->listing({
                    status_msg => "Template " . $template->create_name . " saved ok" });
}


sub remove {
    my ( $class, $p ) = @_;
    my $R = OpenInteract::Request->instance;
    my $apr = $R->apache;
    my $package = $p->{package} || $apr->param( 'package' );
    my $name    = $p->{name}    || $apr->param( 'name' );
    my $tmpl_class = $R->site_template;
    my $fq_name = $tmpl_class->create_name( $package, $name );
    my $template = $tmpl_class->fetch( $fq_name );
    unless ( $template ) {
        return $class->listing({
                    error_msg => "Template $fq_name does not seem to exist" });
    }
    eval { $template->remove };
    if ( $@ ) {
        return $class->listing({
                    error_msg => "Error removing $fq_name: $@" });
    }
    return $class->listing({ status_msg => "Template $fq_name removed ok" });
}

1;
