/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.boxes.cenc;

import com.googlecode.mp4parser.authoring.Sample;
import com.googlecode.mp4parser.util.CastUtils;
import com.googlecode.mp4parser.util.RangeStartMap;
import com.mp4parser.iso23001.part7.CencSampleAuxiliaryDataFormat;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.AbstractList;
import java.util.List;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CencEncryptingSampleList
extends AbstractList<Sample> {
    private final String encryptionAlgo;
    Cipher cipher;
    List<CencSampleAuxiliaryDataFormat> auxiliaryDataFormats;
    RangeStartMap<Integer, SecretKey> ceks;
    List<Sample> parent;

    public CencEncryptingSampleList(SecretKey defaultCek, List<Sample> parent, List<CencSampleAuxiliaryDataFormat> auxiliaryDataFormats) {
        this(new RangeStartMap<Integer, SecretKey>(0, defaultCek), parent, auxiliaryDataFormats, "cenc");
    }

    public CencEncryptingSampleList(RangeStartMap<Integer, SecretKey> ceks, List<Sample> parent, List<CencSampleAuxiliaryDataFormat> auxiliaryDataFormats, String encryptionAlgo) {
        block5: {
            this.ceks = new RangeStartMap();
            this.auxiliaryDataFormats = auxiliaryDataFormats;
            this.ceks = ceks;
            this.encryptionAlgo = encryptionAlgo;
            this.parent = parent;
            try {
                if ("cenc".equals(encryptionAlgo)) {
                    this.cipher = Cipher.getInstance("AES/CTR/NoPadding");
                    break block5;
                }
                if ("cbc1".equals(encryptionAlgo)) {
                    this.cipher = Cipher.getInstance("AES/CBC/NoPadding");
                    break block5;
                }
                throw new RuntimeException("Only cenc & cbc1 is supported as encryptionAlgo");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchPaddingException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public Sample get(int index) {
        Sample clearSample = this.parent.get(index);
        if (this.ceks.get(index) != null) {
            CencSampleAuxiliaryDataFormat entry = this.auxiliaryDataFormats.get(index);
            return new EncryptedSampleImpl(clearSample, entry, this.cipher, this.ceks.get(index));
        }
        return clearSample;
    }

    protected void initCipher(byte[] iv, SecretKey cek) {
        try {
            byte[] fullIv = new byte[16];
            System.arraycopy(iv, 0, fullIv, 0, iv.length);
            this.cipher.init(1, (Key)cek, new IvParameterSpec(fullIv));
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int size() {
        return this.parent.size();
    }

    private class EncryptedSampleImpl
    implements Sample {
        private final Sample clearSample;
        private final CencSampleAuxiliaryDataFormat cencSampleAuxiliaryDataFormat;
        private final Cipher cipher;
        private final SecretKey cek;

        private EncryptedSampleImpl(Sample clearSample, CencSampleAuxiliaryDataFormat cencSampleAuxiliaryDataFormat, Cipher cipher, SecretKey cek) {
            this.clearSample = clearSample;
            this.cencSampleAuxiliaryDataFormat = cencSampleAuxiliaryDataFormat;
            this.cipher = cipher;
            this.cek = cek;
        }

        public void writeTo(WritableByteChannel channel) throws IOException {
            ByteBuffer sample = (ByteBuffer)this.clearSample.asByteBuffer().rewind();
            CencEncryptingSampleList.this.initCipher(this.cencSampleAuxiliaryDataFormat.iv, this.cek);
            try {
                if (this.cencSampleAuxiliaryDataFormat.pairs != null && this.cencSampleAuxiliaryDataFormat.pairs.length > 0) {
                    byte[] fullSample = new byte[sample.limit()];
                    sample.get(fullSample);
                    int offset = 0;
                    CencSampleAuxiliaryDataFormat.Pair[] pairArray = this.cencSampleAuxiliaryDataFormat.pairs;
                    int n = this.cencSampleAuxiliaryDataFormat.pairs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        CencSampleAuxiliaryDataFormat.Pair pair = pairArray[n2];
                        offset += pair.clear();
                        if (pair.encrypted() > 0L) {
                            this.cipher.update(fullSample, offset, CastUtils.l2i(pair.encrypted()), fullSample, offset);
                            offset = (int)((long)offset + pair.encrypted());
                        }
                        ++n2;
                    }
                    channel.write(ByteBuffer.wrap(fullSample));
                } else {
                    byte[] fullyEncryptedSample = new byte[sample.limit()];
                    sample.get(fullyEncryptedSample);
                    if ("cbc1".equals(CencEncryptingSampleList.this.encryptionAlgo)) {
                        int encryptedLength = fullyEncryptedSample.length / 16 * 16;
                        channel.write(ByteBuffer.wrap(this.cipher.doFinal(fullyEncryptedSample, 0, encryptedLength)));
                        channel.write(ByteBuffer.wrap(fullyEncryptedSample, encryptedLength, fullyEncryptedSample.length - encryptedLength));
                    } else if ("cenc".equals(CencEncryptingSampleList.this.encryptionAlgo)) {
                        channel.write(ByteBuffer.wrap(this.cipher.doFinal(fullyEncryptedSample)));
                    }
                }
                sample.rewind();
            }
            catch (IllegalBlockSizeException e) {
                throw new RuntimeException(e);
            }
            catch (BadPaddingException e) {
                throw new RuntimeException(e);
            }
            catch (ShortBufferException e) {
                throw new RuntimeException(e);
            }
        }

        public long getSize() {
            return this.clearSample.getSize();
        }

        public ByteBuffer asByteBuffer() {
            ByteBuffer sample = (ByteBuffer)this.clearSample.asByteBuffer().rewind();
            ByteBuffer encSample = ByteBuffer.allocate(sample.limit());
            CencSampleAuxiliaryDataFormat entry = this.cencSampleAuxiliaryDataFormat;
            CencEncryptingSampleList.this.initCipher(this.cencSampleAuxiliaryDataFormat.iv, this.cek);
            try {
                if (entry.pairs != null) {
                    CencSampleAuxiliaryDataFormat.Pair[] pairArray = entry.pairs;
                    int n = entry.pairs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        CencSampleAuxiliaryDataFormat.Pair pair = pairArray[n2];
                        byte[] clears = new byte[pair.clear()];
                        sample.get(clears);
                        encSample.put(clears);
                        if (pair.encrypted() > 0L) {
                            byte[] toBeEncrypted = new byte[CastUtils.l2i(pair.encrypted())];
                            sample.get(toBeEncrypted);
                            assert (toBeEncrypted.length % 16 == 0);
                            byte[] encrypted = this.cipher.update(toBeEncrypted);
                            assert (encrypted.length == toBeEncrypted.length);
                            encSample.put(encrypted);
                        }
                        ++n2;
                    }
                } else {
                    byte[] fullyEncryptedSample = new byte[sample.limit()];
                    sample.get(fullyEncryptedSample);
                    if ("cbc1".equals(CencEncryptingSampleList.this.encryptionAlgo)) {
                        int encryptedLength = fullyEncryptedSample.length / 16 * 16;
                        encSample.put(this.cipher.doFinal(fullyEncryptedSample, 0, encryptedLength));
                        encSample.put(fullyEncryptedSample, encryptedLength, fullyEncryptedSample.length - encryptedLength);
                    } else if ("cenc".equals(CencEncryptingSampleList.this.encryptionAlgo)) {
                        encSample.put(this.cipher.doFinal(fullyEncryptedSample));
                    }
                }
                sample.rewind();
            }
            catch (IllegalBlockSizeException e) {
                throw new RuntimeException(e);
            }
            catch (BadPaddingException e) {
                throw new RuntimeException(e);
            }
            encSample.rewind();
            return encSample;
        }
    }
}

