/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.server.resource;

import java.io.IOException;
import java.io.InputStream;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.apache.tika.language.detect.LanguageHandler;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.server.resource.TikaResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/meta")
public class MetadataResource {
    private static final Logger LOG = LoggerFactory.getLogger(MetadataResource.class);

    @POST
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"text/csv", "application/json", "application/rdf+xml"})
    @Path(value="form")
    public Response getMetadataFromMultipart(Attachment att, @Context UriInfo info) throws Exception {
        return Response.ok(this.parseMetadata(att.getObject(InputStream.class), att.getHeaders(), info)).build();
    }

    @PUT
    @Produces(value={"text/csv", "application/json", "application/rdf+xml"})
    public Response getMetadata(InputStream is, @Context HttpHeaders httpHeaders, @Context UriInfo info) throws Exception {
        return Response.ok(this.parseMetadata(TikaResource.getInputStream(is, httpHeaders), httpHeaders.getRequestHeaders(), info)).build();
    }

    @PUT
    @Path(value="{field}")
    @Produces(value={"text/csv", "application/json", "application/rdf+xml", "text/plain"})
    public Response getMetadataField(InputStream is, @Context HttpHeaders httpHeaders, @Context UriInfo info, @PathParam(value="field") String field) throws Exception {
        Response.Status defaultErrorResponse = Response.Status.BAD_REQUEST;
        Metadata metadata = null;
        try {
            metadata = this.parseMetadata(TikaResource.getInputStream(is, httpHeaders), httpHeaders.getRequestHeaders(), info);
            defaultErrorResponse = Response.Status.NOT_FOUND;
        }
        catch (Exception e) {
            LOG.info("Failed to process field {}", (Object)field, (Object)e);
        }
        if (metadata == null || metadata.get(field) == null) {
            return Response.status(defaultErrorResponse).entity("Failed to get metadata field " + field).build();
        }
        for (String name : metadata.names()) {
            if (field.equals(name)) continue;
            metadata.remove(name);
        }
        return Response.ok(metadata).build();
    }

    private Metadata parseMetadata(InputStream is, MultivaluedMap<String, String> httpHeaders, UriInfo info) throws IOException {
        final Metadata metadata = new Metadata();
        ParseContext context = new ParseContext();
        Parser parser = TikaResource.createParser();
        TikaResource.fillMetadata(parser, metadata, context, httpHeaders);
        TikaResource.fillParseContext(context, httpHeaders, null);
        TikaResource.logRequest(LOG, info, metadata);
        TikaResource.parse(parser, LOG, info.getPath(), is, new LanguageHandler(){

            @Override
            public void endDocument() {
                metadata.set("language", this.getLanguage().getLanguage());
            }
        }, metadata, context);
        return metadata;
    }
}

