#!/usr/bin/perl

package eBay::API::XML::Call::CompleteSale;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. CompleteSale.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::CompleteSale

=head1 DESCRIPTION



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::CompleteSale inherits from the L<eBay::API::XML::BaseCall> class

=cut

use eBay::API::XML::BaseCall;
our @ISA = ("eBay::API::XML::BaseCall");

use eBay::API::XML::Call::CompleteSale::CompleteSaleRequestType;
use eBay::API::XML::Call::CompleteSale::CompleteSaleResponseType;


=head1 Subroutines:

=cut

sub getApiCallName {
   return 'CompleteSale';
}
sub getRequestDataTypeFullPackage {
   return 'eBay::API::XML::Call::CompleteSale::CompleteSaleRequestType';
}
sub getResponseDataTypeFullPackage {
   return 'eBay::API::XML::Call::CompleteSale::CompleteSaleResponseType';
}

#
# input properties
#

=head2 setFeedbackInfo()

Specifies feedback the seller is leaving for the buyer.
For a given transaction, the seller can leave feedback once,
and no further modifications can be made to that feedback entry.
If feedback has already been left, FeedbackInfo is not allowed.
Call GetFeedback to determine whether feedback has already been left.

  RequiredInput: No
#    Argument: 'ns:FeedbackInfoType'

=cut
       
sub setFeedbackInfo {
   my $self   = shift;
   my $pFeedbackInfo = shift;
   $self->getRequestDataType()->setFeedbackInfo($pFeedbackInfo);
}

=head2 setItemID()

ID of the listing associated with the transaction that the
seller is completing.

MaxLength: 19 (Note: The eBay database specifies 38. Currently, Item IDs are usually 9 to 12 digits)

  RequiredInput: Yes
#    Argument: 'ns:ItemIDType'

=cut
       
sub setItemID {
   my $self   = shift;
   my $pItemID = shift;
   $self->getRequestDataType()->setItemID($pItemID);
}

=head2 setListingType()

If included in the request, and with a value of
ListingType = Half, indicates that the given ItemID and
TransactionID values are for Half.com. ListingType is
required input for Half.com items.

  RequiredInput: Conditionally
  OnlyTheseValues: Half
#    Argument: 'ns:ListingTypeCodeType'

=cut
       
sub setListingType {
   my $self   = shift;
   my $sListingType = shift;
   $self->getRequestDataType()->setListingType($sListingType);
}

=head2 setOrderID()

Unique ID for a multi-item order. ItemID and TransactionID are
ignored if a call includes OrderID. CompleteSale applies to the
specified order as a whole (and thus the child transactions
associated with the order).
<br>
This tag does not apply to half.com items.

  RequiredInput: No
#    Argument: 'xs:string'

=cut
       
sub setOrderID {
   my $self   = shift;
   my $sOrderID = shift;
   $self->getRequestDataType()->setOrderID($sOrderID);
}

=head2 setPaid()

If true, the transaction is marked as paid in My eBay.
If false, the transaction is marked as not paid in My eBay.
If not specified, the paid status in My eBay is not modified.

  RequiredInput: No
#    Argument: 'xs:boolean'

=cut
       
sub setPaid {
   my $self   = shift;
   my $sPaid = shift;
   $self->getRequestDataType()->setPaid($sPaid);
}

=head2 setShipment()

Details about the shipment. Setting the tracking number and carrier
automatically marks the item as shipped (sets Shipped to true).

  RequiredInput: No
#    Argument: 'ns:ShipmentType'

=cut
       
sub setShipment {
   my $self   = shift;
   my $pShipment = shift;
   $self->getRequestDataType()->setShipment($pShipment);
}

=head2 setShipped()

If true, the transaction is marked as shipped in My eBay
(applicable for Selling Manager Pro users).
If false, the transaction is marked as not shipped in My eBay.
If not specified, the shipped status in My eBay is not modified.

  RequiredInput: No
#    Argument: 'xs:boolean'

=cut
       
sub setShipped {
   my $self   = shift;
   my $sShipped = shift;
   $self->getRequestDataType()->setShipped($sShipped);
}

=head2 setTransactionID()

Unique identifier for a transaction from the listing indicated by ItemID.
Call GetItemTransactions or GetSellerTransactions to determine
the appropriate transaction ID.
Required for all listing types (pass 0 for Chinese auctions).

MaxLength: 19 (Note: The eBay database specifies 38. Currently, transaction IDs are usually 9 to 12 digits.)

  RequiredInput: Yes
#    Argument: 'xs:string'

=cut
       
sub setTransactionID {
   my $self   = shift;
   my $sTransactionID = shift;
   $self->getRequestDataType()->setTransactionID($sTransactionID);
}



#
# output properties
#





1;   
