#!/usr/bin/perl

package eBay::API::XML::DataType::ASQPreferencesType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. ASQPreferencesType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::ASQPreferencesType

=head1 DESCRIPTION

Enables a seller to add custom Ask Seller a Question (ASQ)
subjects to display on the seller's Ask a Question page, or reset
the custom subjects to the default values.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::ASQPreferencesType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");



my @gaProperties = ( [ 'ResetDefaultSubjects', 'xs:boolean', '', '', '' ]
	, [ 'Subject', 'xs:string', '1', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setResetDefaultSubjects()

Used to reset custom subjects to their default values. For
SetMessagePreferences, either ResetDefaultSubjects or Subject
is required in the request, but not both.

  Calls: SetMessagePreferences
  RequiredInput: Conditionally

#    Argument: 'xs:boolean'

=cut

sub setResetDefaultSubjects {
  my $self = shift;
  $self->{'ResetDefaultSubjects'} = shift
}

=head2 isResetDefaultSubjects()

#    Returns: 'xs:boolean'

=cut

sub isResetDefaultSubjects {
  my $self = shift;
  return $self->{'ResetDefaultSubjects'};
}


=head2 setSubject()

Contains the ASQ subjects to display on the seller's
Ask a Question page, with one subject per Subject node up to a
maximum of nine. The tenth subject, "General question about
this item," cannot be edited. An error wil be returned if subjects are duplicated.
<br><br>
For SetMessagePreferences, either ResetDefaultSubjects or
Subject is required in the request, but not both. Subjects are
displayed on the ASQ drop-down list in same order as the
request.
<br><br>
Note that the default ASQ subjects will display in the site's
language if retrieved from a site other than the seller's own.
For example, if if a US seller sells on the DE and the FR
sites, the default subjects will display in German and French
respectively. However, if the seller adds custom questions,
all questions will display only in the seller's language. In
the example case, FR and DE buyers would see custom subjects
in English only. Use ResetDefaultSubjects to restore the
default subjects and the default language display behavior.

MaxLength: 60

  Calls: SetMessagePreferences
  RequiredInput: Conditionally

#    Argument: reference to an array  
                      of 'xs:string'

=cut

sub setSubject {
  my $self = shift;
  $self->{'Subject'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getSubject()

  Calls: GetMessagePreferences
  Returned: Conditionally

#    Returns: reference to an array  
                      of 'xs:string'

=cut

sub getSubject {
  my $self = shift;
  return $self->_getDataTypeArray('Subject');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
