# Generated by default/object.tt
package Paws::WAFV2::Filter;
  use Moose;
  has Behavior => (is => 'ro', isa => 'Str', required => 1);
  has Conditions => (is => 'ro', isa => 'ArrayRef[Paws::WAFV2::Condition]', required => 1);
  has Requirement => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::WAFV2::Filter

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::WAFV2::Filter object:

  $service_obj->Method(Att1 => { Behavior => $value, ..., Requirement => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::WAFV2::Filter object:

  $result = $service_obj->Method(...);
  $result->Att1->Behavior

=head1 DESCRIPTION

A single logging filter, used in LoggingFilter.

=head1 ATTRIBUTES


=head2 B<REQUIRED> Behavior => Str

How to handle logs that satisfy the filter's conditions and
requirement.


=head2 B<REQUIRED> Conditions => ArrayRef[L<Paws::WAFV2::Condition>]

Match conditions for the filter.


=head2 B<REQUIRED> Requirement => Str

Logic to apply to the filtering conditions. You can specify that, in
order to satisfy the filter, a log must match all conditions or must
match at least one condition.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::WAFV2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

